/*
 * Decompiled with CFR 0.152.
 */
package pl.syntaxdevteam.punisher.players;

import com.maxmind.geoip2.DatabaseReader;
import com.maxmind.geoip2.exception.AddressNotFoundException;
import com.maxmind.geoip2.model.CityResponse;
import java.io.Closeable;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.InetAddress;
import java.net.URI;
import java.net.URLConnection;
import java.net.UnknownHostException;
import java.util.concurrent.CompletableFuture;
import java.util.zip.GZIPInputStream;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.io.ByteStreamsKt;
import kotlin.io.CloseableKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.apache.tools.tar.TarEntry;
import org.apache.tools.tar.TarInputStream;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import pl.syntaxdevteam.punisher.PunisherX;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\b\u0006\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\b\u0010\u0011\u001a\u00020\u0010H\u0002J\b\u0010\u0012\u001a\u00020\u0010H\u0002J\u0010\u0010\u0013\u001a\u0004\u0018\u00010\u00072\u0006\u0010\u0014\u001a\u00020\u0007J\u0010\u0010\u0015\u001a\u0004\u0018\u00010\u00072\u0006\u0010\u0014\u001a\u00020\u0007R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0013\u0010\u0006\u001a\u00070\u0007\u00a2\u0006\u0002\b\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\f\u001a\u0004\u0018\u00010\rX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00100\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0016"}, d2={"Lpl/syntaxdevteam/punisher/players/GeoIPHandler;", "", "plugin", "Lpl/syntaxdevteam/punisher/PunisherX;", "<init>", "(Lpl/syntaxdevteam/punisher/PunisherX;)V", "licenseKey", "", "Lorg/jetbrains/annotations/Nullable;", "pluginFolder", "cityDatabaseFile", "Ljava/io/File;", "databaseReader", "Lcom/maxmind/geoip2/DatabaseReader;", "initializationFuture", "Ljava/util/concurrent/CompletableFuture;", "", "prepareDatabase", "downloadAndExtractDatabase", "getCountry", "ip", "getCity", "PunisherX"})
public final class GeoIPHandler {
    @NotNull
    private final PunisherX plugin;
    @NotNull
    private final String licenseKey;
    @NotNull
    private final String pluginFolder;
    @NotNull
    private final File cityDatabaseFile;
    @Nullable
    private volatile DatabaseReader databaseReader;
    @NotNull
    private final CompletableFuture<Unit> initializationFuture;

    public GeoIPHandler(@NotNull PunisherX plugin) {
        Intrinsics.checkNotNullParameter((Object)plugin, "plugin");
        this.plugin = plugin;
        String string = this.plugin.getConfig().getString("geoDatabase.licenseKey");
        if (string == null) {
            throw new IllegalArgumentException("License key not found in config.yml. GeoIP functionality will be disabled.");
        }
        this.licenseKey = string;
        this.pluginFolder = this.plugin.getDataFolder().getPath() + "/geodata/";
        this.cityDatabaseFile = new File(this.pluginFolder, "GeoLite2-City.mmdb");
        this.initializationFuture = new CompletableFuture();
        File folder = new File(this.pluginFolder);
        if (!folder.exists()) {
            folder.mkdirs();
        }
        this.plugin.getSchedulerAdapter().runAsync(() -> GeoIPHandler._init_$lambda$0(this));
    }

    private final void prepareDatabase() {
        if (!this.cityDatabaseFile.exists()) {
            this.downloadAndExtractDatabase();
        }
        if (!this.cityDatabaseFile.exists()) {
            this.plugin.getLogger().severe("GeoIP database file is missing after initialization.");
            return;
        }
        this.databaseReader = new DatabaseReader.Builder(this.cityDatabaseFile).build();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void downloadAndExtractDatabase() {
        if (this.cityDatabaseFile.exists()) {
            return;
        }
        URI cityUri = new URI("https://download.maxmind.com/app/geoip_download?edition_id=GeoLite2-City&license_key=" + this.licenseKey + "&suffix=tar.gz");
        URLConnection uRLConnection = cityUri.toURL().openConnection();
        Intrinsics.checkNotNull(uRLConnection, "null cannot be cast to non-null type java.net.HttpURLConnection");
        HttpURLConnection connection = (HttpURLConnection)uRLConnection;
        try {
            Closeable closeable = connection.getInputStream();
            Throwable throwable = null;
            try {
                InputStream input = (InputStream)closeable;
                boolean bl = false;
                Closeable closeable2 = new GZIPInputStream(input);
                Throwable throwable2 = null;
                try {
                    GZIPInputStream gzip = (GZIPInputStream)closeable2;
                    boolean bl2 = false;
                    Closeable closeable3 = (Closeable)new TarInputStream((InputStream)gzip);
                    Throwable throwable3 = null;
                    try {
                        TarInputStream tar = (TarInputStream)closeable3;
                        boolean bl3 = false;
                        TarEntry entry = tar.getNextEntry();
                        while (entry != null) {
                            this.plugin.getLogger().debug("Found entry: " + entry.getName());
                            String string = entry.getName();
                            Intrinsics.checkNotNullExpressionValue(string, "getName(...)");
                            if (StringsKt.endsWith$default(string, ".mmdb", false, 2, null)) {
                                this.plugin.getLogger().debug("Extracting MMDB file: " + entry.getName());
                                if (!this.cityDatabaseFile.getParentFile().exists()) {
                                    this.plugin.getLogger().debug("Creating directories: " + this.cityDatabaseFile.getParentFile().getAbsolutePath());
                                    this.cityDatabaseFile.getParentFile().mkdirs();
                                }
                                try {
                                    Closeable closeable4 = new FileOutputStream(this.cityDatabaseFile);
                                    Throwable throwable4 = null;
                                    try {
                                        FileOutputStream output = (FileOutputStream)closeable4;
                                        boolean bl4 = false;
                                        long l = ByteStreamsKt.copyTo$default((InputStream)tar, output, 0, 2, null);
                                    }
                                    catch (Throwable throwable5) {
                                        throwable4 = throwable5;
                                        throw throwable5;
                                    }
                                    finally {
                                        CloseableKt.closeFinally(closeable4, throwable4);
                                    }
                                    this.plugin.getLogger().debug("Extracted file size: " + this.cityDatabaseFile.length() + " bytes");
                                    if (this.cityDatabaseFile.length() == 0L) {
                                        this.plugin.getLogger().severe("[GeoLite2] Extracted MMDB file is empty!");
                                    } else {
                                        this.plugin.getLogger().debug("MMDB file saved successfully.");
                                    }
                                }
                                catch (IOException e) {
                                    this.plugin.getLogger().severe("[GeoLite2] Failed to write MMDB file: " + e.getMessage());
                                    throw e;
                                }
                            }
                            entry = tar.getNextEntry();
                        }
                        Unit unit = Unit.INSTANCE;
                    }
                    catch (Throwable throwable6) {
                        throwable3 = throwable6;
                        throw throwable6;
                    }
                    finally {
                        CloseableKt.closeFinally(closeable3, throwable3);
                    }
                    Unit unit = Unit.INSTANCE;
                }
                catch (Throwable throwable7) {
                    throwable2 = throwable7;
                    throw throwable7;
                }
                finally {
                    CloseableKt.closeFinally(closeable2, throwable2);
                }
                Unit unit = Unit.INSTANCE;
            }
            catch (Throwable throwable8) {
                throwable = throwable8;
                throw throwable8;
            }
            finally {
                CloseableKt.closeFinally(closeable, throwable);
            }
        }
        catch (IOException e) {
            if (connection.getResponseCode() == 401) {
                this.plugin.getLogger().severe("[GeoLite2] Unauthorized access. Please check your license key.");
            }
            this.plugin.getLogger().severe("[GeoLite2] Failed to download GeoIP database: " + e.getMessage());
            throw e;
        }
    }

    @Nullable
    public final String getCountry(@NotNull String ip) {
        String string;
        Intrinsics.checkNotNullParameter(ip, "ip");
        if (!this.initializationFuture.isDone()) {
            return "Unknown country";
        }
        DatabaseReader databaseReader = this.databaseReader;
        if (databaseReader == null) {
            return "Unknown country";
        }
        DatabaseReader reader = databaseReader;
        try {
            CityResponse response = reader.city(InetAddress.getByName(ip));
            Object object = response.country();
            string = object != null && (object = object.names()) != null ? (String)object.get("en") : null;
        }
        catch (AddressNotFoundException e) {
            string = "Unknown country";
        }
        catch (Exception e) {
            this.plugin.getLogger().severe("Failed to get country for IP " + ip + ": " + e.getMessage() + " [Exception]");
            string = "Unknown country";
        }
        catch (UnknownHostException e) {
            this.plugin.getLogger().severe("Failed to get country for IP " + ip + ": " + e.getMessage() + " [UnknownHostException]");
            string = "Unknown country";
        }
        return string;
    }

    @Nullable
    public final String getCity(@NotNull String ip) {
        String string;
        Intrinsics.checkNotNullParameter(ip, "ip");
        if (!this.initializationFuture.isDone()) {
            return "Unknown city";
        }
        DatabaseReader databaseReader = this.databaseReader;
        if (databaseReader == null) {
            return "Unknown city";
        }
        DatabaseReader reader = databaseReader;
        try {
            CityResponse response = reader.city(InetAddress.getByName(ip));
            Object object = response.city();
            string = object != null && (object = object.names()) != null ? (String)object.get("en") : null;
        }
        catch (AddressNotFoundException e) {
            string = "Unknown city";
        }
        catch (Exception e) {
            this.plugin.getLogger().severe("Failed to get city for IP " + ip + ": " + e.getMessage() + " [Exception]");
            string = "Unknown city";
        }
        catch (UnknownHostException e) {
            this.plugin.getLogger().severe("Failed to get city for IP " + ip + ": " + e.getMessage() + " [UnknownHostException]");
            string = "Unknown city";
        }
        return string;
    }

    private static final void _init_$lambda$0(GeoIPHandler this$0) {
        try {
            this$0.prepareDatabase();
            this$0.initializationFuture.complete(Unit.INSTANCE);
        }
        catch (Exception e) {
            this$0.plugin.getLogger().severe("Failed to prepare GeoIP database: " + e.getMessage());
            this$0.initializationFuture.completeExceptionally(e);
        }
    }
}

