/*
 * Decompiled with CFR 0.152.
 */
package pl.syntaxdevteam.punisher.platform;

import io.papermc.paper.threadedregions.scheduler.ScheduledTask;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.bukkit.Location;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitTask;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import pl.syntaxdevteam.core.platform.ServerEnvironment;
import pl.syntaxdevteam.punisher.platform.SchedulerAdapter;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u001b\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\n\b\u0002\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0010\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0016J\u0010\u0010\r\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0016J\u0018\u0010\u000e\u001a\u00020\n2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u000b\u001a\u00020\fH\u0016J\u0018\u0010\u0011\u001a\u00020\n2\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u000b\u001a\u00020\fH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0014"}, d2={"Lpl/syntaxdevteam/punisher/platform/BukkitSchedulerAdapter;", "Lpl/syntaxdevteam/punisher/platform/SchedulerAdapter;", "plugin", "Lorg/bukkit/plugin/Plugin;", "foliaBasedOverride", "", "<init>", "(Lorg/bukkit/plugin/Plugin;Ljava/lang/Boolean;)V", "foliaBased", "runAsync", "", "task", "Ljava/lang/Runnable;", "runSync", "runSyncLater", "delayTicks", "", "runRegionally", "location", "Lorg/bukkit/Location;", "PunisherX"})
public final class BukkitSchedulerAdapter
implements SchedulerAdapter {
    @NotNull
    private final Plugin plugin;
    private final boolean foliaBased;

    public BukkitSchedulerAdapter(@NotNull Plugin plugin, @Nullable Boolean foliaBasedOverride) {
        Intrinsics.checkNotNullParameter(plugin, "plugin");
        this.plugin = plugin;
        Boolean bl = foliaBasedOverride;
        this.foliaBased = bl != null ? bl.booleanValue() : ServerEnvironment.INSTANCE.isFoliaBased();
    }

    public /* synthetic */ BukkitSchedulerAdapter(Plugin plugin, Boolean bl, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            bl = null;
        }
        this(plugin, bl);
    }

    @Override
    public void runAsync(@NotNull Runnable task) {
        Intrinsics.checkNotNullParameter(task, "task");
        if (this.foliaBased) {
            this.plugin.getServer().getGlobalRegionScheduler().execute(this.plugin, task);
        } else {
            BukkitTask bukkitTask = this.plugin.getServer().getScheduler().runTaskAsynchronously(this.plugin, task);
            Intrinsics.checkNotNull(bukkitTask);
        }
    }

    @Override
    public void runSync(@NotNull Runnable task) {
        Intrinsics.checkNotNullParameter(task, "task");
        if (this.foliaBased) {
            this.plugin.getServer().getGlobalRegionScheduler().execute(this.plugin, () -> BukkitSchedulerAdapter.runSync$lambda$0(task));
        } else {
            BukkitTask bukkitTask = this.plugin.getServer().getScheduler().runTask(this.plugin, task);
            Intrinsics.checkNotNull(bukkitTask);
        }
    }

    @Override
    public void runSyncLater(long delayTicks, @NotNull Runnable task) {
        Intrinsics.checkNotNullParameter(task, "task");
        if (this.foliaBased) {
            ScheduledTask scheduledTask = this.plugin.getServer().getGlobalRegionScheduler().runDelayed(this.plugin, arg_0 -> BukkitSchedulerAdapter.runSyncLater$lambda$0(task, arg_0), delayTicks);
            Intrinsics.checkNotNull(scheduledTask);
        } else {
            BukkitTask bukkitTask = this.plugin.getServer().getScheduler().runTaskLater(this.plugin, task, delayTicks);
            Intrinsics.checkNotNull(bukkitTask);
        }
    }

    @Override
    public void runRegionally(@NotNull Location location, @NotNull Runnable task) {
        Intrinsics.checkNotNullParameter(location, "location");
        Intrinsics.checkNotNullParameter(task, "task");
        if (this.foliaBased) {
            this.plugin.getServer().getRegionScheduler().execute(this.plugin, location, task);
        } else {
            this.runSync(task);
        }
    }

    private static final void runSync$lambda$0(Runnable $task) {
        $task.run();
    }

    private static final void runSyncLater$lambda$0(Runnable $task, ScheduledTask it) {
        $task.run();
    }
}

