/*
 * Decompiled with CFR 0.152.
 */
package pl.syntaxdevteam.punisher.placeholders;

import java.util.List;
import java.util.UUID;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import me.clip.placeholderapi.expansion.PlaceholderExpansion;
import org.bukkit.entity.Player;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import pl.syntaxdevteam.message.MessageHandler;
import pl.syntaxdevteam.punisher.PunisherX;
import pl.syntaxdevteam.punisher.databases.DatabaseHandler;
import pl.syntaxdevteam.punisher.databases.PunishmentData;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0006\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\b\u0010\u0006\u001a\u00020\u0007H\u0016J\b\u0010\b\u001a\u00020\u0007H\u0016J\b\u0010\t\u001a\u00020\u0007H\u0016J\u001c\u0010\n\u001a\u0004\u0018\u00010\u00072\b\u0010\u000b\u001a\u0004\u0018\u00010\f2\u0006\u0010\r\u001a\u00020\u0007H\u0016J\u001a\u0010\u000e\u001a\u0004\u0018\u00010\u00072\u0006\u0010\u000b\u001a\u00020\u00072\u0006\u0010\u000f\u001a\u00020\u0007H\u0002J\n\u0010\u0010\u001a\u0004\u0018\u00010\u0007H\u0002J\n\u0010\u0011\u001a\u0004\u0018\u00010\u0007H\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0012"}, d2={"Lpl/syntaxdevteam/punisher/placeholders/PlaceholderHandler;", "Lme/clip/placeholderapi/expansion/PlaceholderExpansion;", "plugin", "Lpl/syntaxdevteam/punisher/PunisherX;", "<init>", "(Lpl/syntaxdevteam/punisher/PunisherX;)V", "getIdentifier", "", "getAuthor", "getVersion", "onPlaceholderRequest", "player", "Lorg/bukkit/entity/Player;", "params", "getPunishmentEndTime", "punishType", "getAllPunishments", "getAllPunishmentHistory", "PunisherX"})
@SourceDebugExtension(value={"SMAP\nPlaceholderHandler.kt\nKotlin\n*S Kotlin\n*F\n+ 1 PlaceholderHandler.kt\npl/syntaxdevteam/punisher/placeholders/PlaceholderHandler\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,79:1\n1#2:80\n*E\n"})
public final class PlaceholderHandler
extends PlaceholderExpansion {
    @NotNull
    private final PunisherX plugin;

    public PlaceholderHandler(@NotNull PunisherX plugin) {
        Intrinsics.checkNotNullParameter((Object)plugin, "plugin");
        this.plugin = plugin;
    }

    @NotNull
    public String getIdentifier() {
        return "prx";
    }

    @NotNull
    public String getAuthor() {
        List list = this.plugin.getPluginMeta().getAuthors();
        Intrinsics.checkNotNullExpressionValue(list, "getAuthors(...)");
        return CollectionsKt.joinToString$default(list, null, null, null, 0, null, null, 63, null);
    }

    @NotNull
    public String getVersion() {
        String string = this.plugin.getPluginMeta().getVersion();
        Intrinsics.checkNotNullExpressionValue(string, "getVersion(...)");
        return string;
    }

    @Nullable
    public String onPlaceholderRequest(@Nullable Player player, @NotNull String params) {
        String string;
        Intrinsics.checkNotNullParameter(params, "params");
        if (player == null) {
            return "";
        }
        switch (params) {
            case "mute_remaining_time": {
                String string2 = player.getName();
                Intrinsics.checkNotNullExpressionValue(string2, "getName(...)");
                string = this.getPunishmentEndTime(string2, "MUTE");
                if (string != null) break;
                string = "";
                break;
            }
            case "warn_remaining_time": {
                String string3 = player.getName();
                Intrinsics.checkNotNullExpressionValue(string3, "getName(...)");
                string = this.getPunishmentEndTime(string3, "WARN");
                if (string != null) break;
                string = "";
                break;
            }
            case "jail_remaining_time": {
                String string4 = player.getName();
                Intrinsics.checkNotNullExpressionValue(string4, "getName(...)");
                string = this.getPunishmentEndTime(string4, "JAIL");
                if (string != null) break;
                string = "";
                break;
            }
            case "total_active_punishments": {
                string = this.getAllPunishments();
                if (string != null) break;
                string = "";
                break;
            }
            case "total_punishments": {
                string = this.getAllPunishmentHistory();
                if (string != null) break;
                string = "";
                break;
            }
            default: {
                string = null;
            }
        }
        return string;
    }

    private final String getPunishmentEndTime(String player, String punishType) {
        String string;
        Object v2;
        block15: {
            UUID uuid = this.plugin.resolvePlayerUuid(player);
            DatabaseHandler databaseHandler = this.plugin.getDatabaseHandler();
            String string2 = uuid.toString();
            Intrinsics.checkNotNullExpressionValue(string2, "toString(...)");
            List punishments = DatabaseHandler.getPunishments$default(databaseHandler, string2, null, null, 6, null);
            Iterable iterable = punishments;
            for (Object t : iterable) {
                PunishmentData it = (PunishmentData)t;
                boolean bl = false;
                if (!(Intrinsics.areEqual(it.getType(), punishType) && it.getEnd() > System.currentTimeMillis())) continue;
                v2 = t;
                break block15;
            }
            v2 = null;
        }
        PunishmentData punishmentData = v2;
        if (punishmentData == null) {
            return null;
        }
        PunishmentData punishData = punishmentData;
        switch (punishType) {
            case "MUTE": {
                string = "mute_remaining_time";
                break;
            }
            case "WARN": {
                string = "warn_remaining_time";
                break;
            }
            case "JAIL": {
                string = "jail_remaining_time";
                break;
            }
            default: {
                return null;
            }
        }
        String punishment = string;
        long remainingTime = (punishData.getEnd() - System.currentTimeMillis()) / (long)1000;
        return remainingTime > 0L ? MessageHandler.stringMessageToStringNoPrefix$default((MessageHandler)this.plugin.getMessageHandler(), (String)"placeholders", (String)punishment, null, (int)4, null) + this.plugin.getTimeHandler().formatTime(String.valueOf(remainingTime)) : null;
    }

    private final String getAllPunishments() {
        String string;
        int totalPunishments = this.plugin.getDatabaseHandler().countAllPunishments();
        if (totalPunishments > 0) {
            this.plugin.getLogger().debug("Total active punishments: " + totalPunishments);
            this.plugin.getLogger().debug("Formatting message for total active punishments: " + MessageHandler.stringMessageToStringNoPrefix$default((MessageHandler)this.plugin.getMessageHandler(), (String)"placeholders", (String)"total_active_punishments", null, (int)4, null));
            string = MessageHandler.stringMessageToStringNoPrefix$default((MessageHandler)this.plugin.getMessageHandler(), (String)"placeholders", (String)"total_active_punishments", null, (int)4, null) + totalPunishments;
        } else {
            string = null;
        }
        return string;
    }

    private final String getAllPunishmentHistory() {
        String string;
        int totalPunishmentHistory = this.plugin.getDatabaseHandler().countAllPunishmentHistory();
        if (totalPunishmentHistory > 0) {
            this.plugin.getLogger().debug("Total punishments: " + totalPunishmentHistory);
            this.plugin.getLogger().debug("Formatting message for total punishments: " + MessageHandler.stringMessageToStringNoPrefix$default((MessageHandler)this.plugin.getMessageHandler(), (String)"placeholders", (String)"total_punishments", null, (int)4, null));
            String it = MessageHandler.stringMessageToStringNoPrefix$default((MessageHandler)this.plugin.getMessageHandler(), (String)"placeholders", (String)"total_punishments", null, (int)4, null);
            boolean bl = false;
            string = it + totalPunishmentHistory;
        } else {
            string = null;
        }
        return string;
    }
}

