/*
 * Decompiled with CFR 0.152.
 */
package pl.syntaxdevteam.punisher.loader;

import io.papermc.paper.threadedregions.scheduler.ScheduledTask;
import java.io.File;
import java.util.List;
import java.util.Locale;
import kotlin.Metadata;
import kotlin.Result;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.io.FilesKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.Charsets;
import kotlin.text.Regex;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.event.Listener;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.ServicePriority;
import org.bukkit.plugin.java.JavaPlugin;
import org.bukkit.scheduler.BukkitRunnable;
import org.bukkit.scheduler.BukkitTask;
import org.jetbrains.annotations.NotNull;
import pl.syntaxdevteam.core.SyntaxCore;
import pl.syntaxdevteam.core.platform.ServerEnvironment;
import pl.syntaxdevteam.message.SyntaxMessages;
import pl.syntaxdevteam.punisher.PunisherX;
import pl.syntaxdevteam.punisher.api.PunisherXApi;
import pl.syntaxdevteam.punisher.api.PunisherXApiImpl;
import pl.syntaxdevteam.punisher.basic.PunishmentActionBarNotifier;
import pl.syntaxdevteam.punisher.basic.PunishmentCache;
import pl.syntaxdevteam.punisher.basic.PunishmentChecker;
import pl.syntaxdevteam.punisher.basic.PunishmentManager;
import pl.syntaxdevteam.punisher.basic.TimeHandler;
import pl.syntaxdevteam.punisher.bridge.OnlinePunishmentWatcher;
import pl.syntaxdevteam.punisher.bridge.ProxyBridgeMessenger;
import pl.syntaxdevteam.punisher.commands.CommandManager;
import pl.syntaxdevteam.punisher.common.CommandLoggerPlugin;
import pl.syntaxdevteam.punisher.common.ConfigManager;
import pl.syntaxdevteam.punisher.common.PunishmentActionExecutor;
import pl.syntaxdevteam.punisher.compatibility.VersionCompatibility;
import pl.syntaxdevteam.punisher.databases.DatabaseHandler;
import pl.syntaxdevteam.punisher.gui.interfaces.GUIHandler;
import pl.syntaxdevteam.punisher.gui.materials.GuiMaterialResolver;
import pl.syntaxdevteam.punisher.hooks.DiscordWebhook;
import pl.syntaxdevteam.punisher.hooks.HookHandler;
import pl.syntaxdevteam.punisher.listeners.LegacyLoginListener;
import pl.syntaxdevteam.punisher.listeners.ModernLoginListener;
import pl.syntaxdevteam.punisher.listeners.PlayerJoinListener;
import pl.syntaxdevteam.punisher.loader.VersionChecker;
import pl.syntaxdevteam.punisher.placeholders.PlaceholderHandler;
import pl.syntaxdevteam.punisher.platform.BukkitSchedulerAdapter;
import pl.syntaxdevteam.punisher.players.GeoIPHandler;
import pl.syntaxdevteam.punisher.players.PlayerIPManager;
import pl.syntaxdevteam.punisher.teleport.SafeTeleportService;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\n\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0006\u0010\u0006\u001a\u00020\u0007J\u0006\u0010\b\u001a\u00020\u0007J\b\u0010\t\u001a\u00020\u0007H\u0002J\u0006\u0010\n\u001a\u00020\u0007J\b\u0010\u000b\u001a\u00020\u0007H\u0002J\b\u0010\f\u001a\u00020\u0007H\u0002J\b\u0010\r\u001a\u00020\u0007H\u0002J\b\u0010\u000e\u001a\u00020\u0007H\u0002J\b\u0010\u000f\u001a\u00020\u0007H\u0002J\b\u0010\u0010\u001a\u00020\u0007H\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0011"}, d2={"Lpl/syntaxdevteam/punisher/loader/PluginInitializer;", "", "plugin", "Lpl/syntaxdevteam/punisher/PunisherX;", "<init>", "(Lpl/syntaxdevteam/punisher/PunisherX;)V", "onEnable", "", "onDisable", "setUpLogger", "setupConfig", "setupDatabase", "setupHandlers", "registerCommands", "registerEvents", "checkForUpdates", "checkLegacyPlaceholders", "PunisherX"})
@SourceDebugExtension(value={"SMAP\nPluginInitializer.kt\nKotlin\n*S Kotlin\n*F\n+ 1 PluginInitializer.kt\npl/syntaxdevteam/punisher/loader/PluginInitializer\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,227:1\n1#2:228\n295#3,2:229\n*S KotlinDebug\n*F\n+ 1 PluginInitializer.kt\npl/syntaxdevteam/punisher/loader/PluginInitializer\n*L\n178#1:229,2\n*E\n"})
public final class PluginInitializer {
    @NotNull
    private final PunisherX plugin;

    public PluginInitializer(@NotNull PunisherX plugin) {
        Intrinsics.checkNotNullParameter((Object)plugin, "plugin");
        this.plugin = plugin;
    }

    public final void onEnable() {
        this.setUpLogger();
        this.setupConfig();
        this.setupDatabase();
        this.setupHandlers();
        this.registerEvents();
        this.registerCommands();
        this.checkForUpdates();
    }

    public final void onDisable() {
        Object object;
        Object $this$onDisable_u24lambda_u240;
        PluginInitializer pluginInitializer = this;
        try {
            $this$onDisable_u24lambda_u240 = pluginInitializer;
            boolean bl = false;
            ((PluginInitializer)$this$onDisable_u24lambda_u240).plugin.getOnlinePunishmentWatcher().stop();
            $this$onDisable_u24lambda_u240 = Result.constructor-impl(Unit.INSTANCE);
        }
        catch (Throwable bl) {
            $this$onDisable_u24lambda_u240 = Result.constructor-impl(ResultKt.createFailure(bl));
        }
        pluginInitializer = this;
        try {
            PluginInitializer $this$onDisable_u24lambda_u241 = pluginInitializer;
            boolean bl = false;
            $this$onDisable_u24lambda_u241.plugin.getPunishmentActionBarNotifier().stop();
            object = Result.constructor-impl(Unit.INSTANCE);
        }
        catch (Throwable throwable) {
            object = Result.constructor-impl(ResultKt.createFailure(throwable));
        }
        this.plugin.getDatabaseHandler().closeConnection();
        this.plugin.getLogger().err(this.plugin.getPluginMeta().getName() + " " + this.plugin.getPluginMeta().getVersion() + " has been disabled \u2639\ufe0f");
    }

    private final void setUpLogger() {
        FileConfiguration fileConfiguration = this.plugin.getConfig();
        Intrinsics.checkNotNullExpressionValue(fileConfiguration, "getConfig(...)");
        this.plugin.setPluginConfig(fileConfiguration);
        this.plugin.setLogger(SyntaxCore.INSTANCE.getLogger());
    }

    public final void setupConfig() {
        this.plugin.setCfg(new ConfigManager(this.plugin));
        this.plugin.getCfg().load();
    }

    private final void setupDatabase() {
        this.plugin.setDatabaseHandler(new DatabaseHandler(this.plugin));
        Runnable databaseSetupTask = () -> PluginInitializer.setupDatabase$lambda$0(this);
        this.plugin.getLogger().debug("Detected server: " + ServerEnvironment.INSTANCE.getPlatformName());
        if (ServerEnvironment.INSTANCE.isFoliaBased()) {
            this.plugin.getLogger().debug("Detected Folia server, using async database connection handling.");
            this.plugin.getServer().getGlobalRegionScheduler().execute((Plugin)this.plugin, databaseSetupTask);
        } else if (ServerEnvironment.INSTANCE.isPaperBased()) {
            this.plugin.getLogger().debug("Detected Paper server, using async database connection handling.");
            BukkitTask bukkitTask = this.plugin.getServer().getScheduler().runTaskAsynchronously((Plugin)this.plugin, databaseSetupTask);
            Intrinsics.checkNotNull(bukkitTask);
        } else {
            this.plugin.getLogger().debug("Running sync database setup for non-Paper server.");
            databaseSetupTask.run();
        }
    }

    private final void setupHandlers() {
        Object it;
        SyntaxMessages.initialize$default((JavaPlugin)this.plugin, null, (int)2, null);
        this.plugin.setMessageHandler(SyntaxMessages.INSTANCE.getMessages());
        this.plugin.setPluginsManager(SyntaxCore.INSTANCE.getPluginManagerx());
        this.plugin.setTimeHandler(new TimeHandler(this.plugin));
        this.plugin.setPunishmentManager(new PunishmentManager());
        this.plugin.setSchedulerAdapter(new BukkitSchedulerAdapter((Plugin)this.plugin, null, 2, null));
        this.plugin.setSafeTeleportService(new SafeTeleportService(this.plugin.getSchedulerAdapter(), null, null, null, 14, null));
        this.plugin.setGeoIPHandler(new GeoIPHandler(this.plugin));
        this.plugin.setCache(new PunishmentCache(this.plugin));
        Object object = new PunishmentActionBarNotifier(this.plugin);
        PunishmentActionBarNotifier punishmentActionBarNotifier = object;
        PunisherX punisherX = this.plugin;
        boolean bl = false;
        ((PunishmentActionBarNotifier)it).start();
        punisherX.setPunishmentActionBarNotifier((PunishmentActionBarNotifier)object);
        this.plugin.setPunisherXApi(new PunisherXApiImpl(this.plugin.getDatabaseHandler()));
        this.plugin.setHookHandler(new HookHandler(this.plugin));
        this.plugin.setDiscordWebhook(new DiscordWebhook(this.plugin));
        this.plugin.setPlayerIPManager(new PlayerIPManager(this.plugin, this.plugin.getGeoIPHandler()));
        this.plugin.setPunishmentChecker(new PunishmentChecker(this.plugin));
        this.plugin.setVersionChecker(new VersionChecker(this.plugin));
        this.plugin.setVersionCompatibility(new VersionCompatibility(this.plugin.getVersionChecker(), null, 2, null));
        this.plugin.setGuiMaterialResolver(new GuiMaterialResolver(this.plugin.getVersionChecker().getSemanticVersion(), null, null, 6, null));
        this.plugin.setActionExecutor(new PunishmentActionExecutor(this.plugin));
        it = object = new ProxyBridgeMessenger(this.plugin);
        punisherX = this.plugin;
        boolean bl2 = false;
        ((ProxyBridgeMessenger)it).registerChannel();
        punisherX.setProxyBridgeMessenger((ProxyBridgeMessenger)object);
        it = object = new OnlinePunishmentWatcher(this.plugin);
        punisherX = this.plugin;
        boolean bl3 = false;
        ((OnlinePunishmentWatcher)it).start();
        punisherX.setOnlinePunishmentWatcher((OnlinePunishmentWatcher)object);
        this.checkLegacyPlaceholders();
    }

    private final void registerCommands() {
        this.plugin.setCommandLoggerPlugin(new CommandLoggerPlugin(this.plugin));
        this.plugin.setCommandManager(new CommandManager(this.plugin));
        this.plugin.getCommandManager().registerCommands();
    }

    private final void registerEvents() {
        Object object;
        Object $this$registerEvents_u24lambda_u240;
        Object object2 = this;
        try {
            $this$registerEvents_u24lambda_u240 = object2;
            boolean bl = false;
            $this$registerEvents_u24lambda_u240 = Result.constructor-impl(((PluginInitializer)$this$registerEvents_u24lambda_u240).plugin.getVersionChecker());
        }
        catch (Throwable bl) {
            $this$registerEvents_u24lambda_u240 = Result.constructor-impl(ResultKt.createFailure(bl));
        }
        object2 = $this$registerEvents_u24lambda_u240;
        Throwable throwable = Result.exceptionOrNull-impl(object2);
        if (throwable == null) {
            object = object2;
        } else {
            VersionChecker versionChecker;
            Throwable it = throwable;
            boolean bl = false;
            VersionChecker it2 = versionChecker = new VersionChecker(this.plugin);
            boolean bl2 = false;
            this.plugin.setVersionChecker(it2);
            object = versionChecker;
        }
        VersionChecker versionChecker = (VersionChecker)object;
        this.plugin.setPlayerJoinListener(new PlayerJoinListener(this.plugin.getPlayerIPManager(), this.plugin.getPunishmentChecker()));
        this.plugin.getServer().getPluginManager().registerEvents((Listener)this.plugin.getPlayerJoinListener(), (Plugin)this.plugin);
        this.plugin.getServer().getPluginManager().registerEvents((Listener)this.plugin.getPunishmentChecker(), (Plugin)this.plugin);
        if (versionChecker.isAtLeast("1.21.7")) {
            this.plugin.getServer().getPluginManager().registerEvents((Listener)new ModernLoginListener(this.plugin), (Plugin)this.plugin);
            this.plugin.getLogger().debug("Registered ModernLoginListener for 1.21.7+");
        } else {
            this.plugin.getServer().getPluginManager().registerEvents((Listener)new LegacyLoginListener(this.plugin), (Plugin)this.plugin);
            this.plugin.getLogger().debug("Registered LegacyLoginListener for pre-1.21.7");
        }
        this.plugin.getServer().getServicesManager().register(PunisherXApi.class, (Object)this.plugin.getPunisherXApi(), (Plugin)this.plugin, ServicePriority.Normal);
        if (this.plugin.getHookHandler().checkPlaceholderAPI()) {
            new PlaceholderHandler(this.plugin).register();
        }
        this.plugin.getServer().getPluginManager().registerEvents((Listener)new GUIHandler(this.plugin), (Plugin)this.plugin);
    }

    private final void checkForUpdates() {
        this.plugin.setStatsCollector(SyntaxCore.INSTANCE.getStatsCollector());
        SyntaxCore.INSTANCE.getUpdateChecker().checkAsync();
    }

    private final void checkLegacyPlaceholders() {
        Object v3;
        block11: {
            File[] fileArray;
            File[] fileArray2;
            block13: {
                block12: {
                    fileArray2 = this.plugin.getConfig().getString("language");
                    if (fileArray2 == null) break block12;
                    fileArray = fileArray2;
                    Locale locale = Locale.getDefault();
                    Intrinsics.checkNotNullExpressionValue(locale, "getDefault(...)");
                    String string = fileArray.toLowerCase(locale);
                    Intrinsics.checkNotNullExpressionValue(string, "toLowerCase(...)");
                    fileArray2 = string;
                    if (string != null) break block13;
                }
                fileArray2 = "en";
            }
            File[] lang = fileArray2;
            File langDir = new File(this.plugin.getDataFolder(), "lang");
            fileArray = new File[]{new File(langDir, "messages_" + (String)lang + ".yml"), new File(langDir, "message_" + (String)lang + ".yml")};
            List<File> candidates = CollectionsKt.listOf(fileArray);
            Iterable $this$firstOrNull$iv = candidates;
            boolean $i$f$firstOrNull = false;
            for (Object element$iv : $this$firstOrNull$iv) {
                File it = (File)element$iv;
                boolean bl = false;
                if (!it.exists()) continue;
                v3 = element$iv;
                break block11;
            }
            v3 = null;
        }
        File file = v3;
        if (file == null) {
            return;
        }
        File langFile = file;
        Regex legacyPattern = new Regex("\\{\\w+}");
        String warnMsg = "Language file " + langFile.getName() + " uses legacy placeholders with {}. Run /langfix or delete the file to regenerate.";
        try {
            String content = FilesKt.readText(langFile, Charsets.UTF_8);
            if (!legacyPattern.containsMatchIn(content)) {
                return;
            }
        }
        catch (Exception e) {
            this.plugin.getLogger().warning("Could not check language file placeholders: " + e.getMessage());
            return;
        }
        this.plugin.getLogger().warning(warnMsg);
        long delay = 200L;
        if (ServerEnvironment.INSTANCE.isFoliaBased()) {
            var9_11 = this.plugin.getServer().getGlobalRegionScheduler().runAtFixedRate((Plugin)this.plugin, arg_0 -> PluginInitializer.checkLegacyPlaceholders$lambda$1(langFile, legacyPattern, this, warnMsg, arg_0), delay, delay);
            Intrinsics.checkNotNull(var9_11);
        } else {
            var9_11 = new BukkitRunnable(langFile, legacyPattern, this, warnMsg){
                final /* synthetic */ File $langFile;
                final /* synthetic */ Regex $legacyPattern;
                final /* synthetic */ PluginInitializer this$0;
                final /* synthetic */ String $warnMsg;
                {
                    this.$langFile = $langFile;
                    this.$legacyPattern = $legacyPattern;
                    this.this$0 = $receiver;
                    this.$warnMsg = $warnMsg;
                }

                public void run() {
                    try {
                        String content = FilesKt.readText(this.$langFile, Charsets.UTF_8);
                        if (this.$legacyPattern.containsMatchIn(content)) {
                            PluginInitializer.access$getPlugin$p(this.this$0).getLogger().warning(this.$warnMsg);
                        } else {
                            this.cancel();
                        }
                    }
                    catch (Exception e) {
                        PluginInitializer.access$getPlugin$p(this.this$0).getLogger().warning("Could not check language file placeholders: " + e.getMessage());
                        this.cancel();
                    }
                }
            }.runTaskTimer((Plugin)this.plugin, delay, delay);
            Intrinsics.checkNotNull(var9_11);
        }
    }

    private static final void setupDatabase$lambda$0(PluginInitializer this$0) {
        this$0.plugin.getDatabaseHandler().openConnection();
        this$0.plugin.getDatabaseHandler().createTables();
    }

    private static final void checkLegacyPlaceholders$lambda$1(File $langFile, Regex $legacyPattern, PluginInitializer this$0, String $warnMsg, ScheduledTask task) {
        try {
            String content = FilesKt.readText($langFile, Charsets.UTF_8);
            if ($legacyPattern.containsMatchIn(content)) {
                this$0.plugin.getLogger().warning($warnMsg);
            } else {
                ScheduledTask.CancelledState cancelledState = task.cancel();
                Intrinsics.checkNotNull(cancelledState);
            }
        }
        catch (Exception e) {
            this$0.plugin.getLogger().warning("Could not check language file placeholders: " + e.getMessage());
            ScheduledTask.CancelledState cancelledState = task.cancel();
            Intrinsics.checkNotNull(cancelledState);
        }
    }

    public static final /* synthetic */ PunisherX access$getPlugin$p(PluginInitializer $this) {
        return $this.plugin;
    }
}

