/*
 * Decompiled with CFR 0.152.
 */
package pl.syntaxdevteam.punisher.listeners;

import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.TextComponent;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.player.PlayerLoginEvent;
import org.jetbrains.annotations.NotNull;
import pl.syntaxdevteam.punisher.PunisherX;
import pl.syntaxdevteam.punisher.databases.DatabaseHandler;
import pl.syntaxdevteam.punisher.databases.PunishmentData;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0010\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0007R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\n"}, d2={"Lpl/syntaxdevteam/punisher/listeners/LegacyLoginListener;", "Lorg/bukkit/event/Listener;", "plugin", "Lpl/syntaxdevteam/punisher/PunisherX;", "<init>", "(Lpl/syntaxdevteam/punisher/PunisherX;)V", "onPlayerLogin", "", "event", "Lorg/bukkit/event/player/PlayerLoginEvent;", "PunisherX"})
@SourceDebugExtension(value={"SMAP\nLegacyLoginListener.kt\nKotlin\n*S Kotlin\n*F\n+ 1 LegacyLoginListener.kt\npl/syntaxdevteam/punisher/listeners/LegacyLoginListener\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,68:1\n1869#2:69\n1869#2,2:70\n1870#2:72\n*S KotlinDebug\n*F\n+ 1 LegacyLoginListener.kt\npl/syntaxdevteam/punisher/listeners/LegacyLoginListener\n*L\n29#1:69\n50#1:70,2\n29#1:72\n*E\n"})
public final class LegacyLoginListener
implements Listener {
    @NotNull
    private final PunisherX plugin;

    public LegacyLoginListener(@NotNull PunisherX plugin) {
        Intrinsics.checkNotNullParameter((Object)plugin, "plugin");
        this.plugin = plugin;
    }

    @EventHandler(priority=EventPriority.HIGHEST, ignoreCancelled=true)
    public final void onPlayerLogin(@NotNull PlayerLoginEvent event) {
        Intrinsics.checkNotNullParameter(event, "event");
        Player player = event.getPlayer();
        Intrinsics.checkNotNullExpressionValue(player, "getPlayer(...)");
        Player player2 = player;
        try {
            this.plugin.getLogger().debug("Checking punishment for player: " + player2.getName());
            String string = player2.getUniqueId().toString();
            Intrinsics.checkNotNullExpressionValue(string, "toString(...)");
            String uuid = string;
            String ip = event.getAddress().getHostAddress();
            Collection collection = DatabaseHandler.getPunishments$default(this.plugin.getDatabaseHandler(), uuid, null, null, 6, null);
            DatabaseHandler databaseHandler = this.plugin.getDatabaseHandler();
            Intrinsics.checkNotNull(ip);
            List punishments = CollectionsKt.plus(collection, (Iterable)databaseHandler.getPunishmentsByIP(ip));
            if (punishments.isEmpty()) {
                this.plugin.getLogger().debug("No punishments found for player: " + event.getPlayer().getName());
                return;
            }
            Iterable $this$forEach$iv = punishments;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                PunishmentData punishment = (PunishmentData)element$iv;
                boolean bl = false;
                if (this.plugin.getPunishmentManager().isPunishmentActive(punishment)) {
                    TextComponent.Builder kickMessage;
                    List list;
                    if (!Intrinsics.areEqual(punishment.getType(), "BAN") && !Intrinsics.areEqual(punishment.getType(), "BANIP")) continue;
                    long endTime = punishment.getEnd();
                    long remainingTime = (endTime - System.currentTimeMillis()) / (long)1000;
                    String duration = endTime == -1L ? "permanent" : this.plugin.getTimeHandler().formatTime(String.valueOf(remainingTime));
                    String reason = punishment.getReason();
                    String string2 = punishment.getType();
                    if (Intrinsics.areEqual(string2, "BAN")) {
                        var19_18 = new Pair[]{TuplesKt.to("reason", reason), TuplesKt.to("time", duration)};
                        list = this.plugin.getMessageHandler().getSmartMessage("ban", "kick_message", MapsKt.mapOf(var19_18));
                    } else if (Intrinsics.areEqual(string2, "BANIP")) {
                        var19_18 = new Pair[]{TuplesKt.to("reason", reason), TuplesKt.to("time", duration)};
                        list = this.plugin.getMessageHandler().getSmartMessage("banip", "kick_message", MapsKt.mapOf(var19_18));
                    } else {
                        list = CollectionsKt.emptyList();
                    }
                    List kickMessages = list;
                    Intrinsics.checkNotNullExpressionValue(Component.text(), "text(...)");
                    Iterable $this$forEach$iv2 = kickMessages;
                    boolean $i$f$forEach2 = false;
                    for (Object element$iv2 : $this$forEach$iv2) {
                        Component line = (Component)element$iv2;
                        boolean bl2 = false;
                        kickMessage.append(line);
                        kickMessage.append((Component)Component.newline());
                    }
                    event.disallow(PlayerLoginEvent.Result.KICK_BANNED, (Component)kickMessage.build());
                    this.plugin.getLogger().debug("Player " + event.getPlayer().getName() + " was kicked for: " + reason);
                    continue;
                }
                this.plugin.getDatabaseHandler().removePunishment(uuid, punishment.getType(), true);
                this.plugin.getLogger().debug("Punishment for UUID: " + uuid + " has expired and has been removed");
            }
        }
        catch (Exception e) {
            this.plugin.getLogger().severe("Error in onPlayerPreLogin, report it urgently to the plugin author with the message: " + event.getPlayer().getName() + ": " + e.getMessage());
            e.printStackTrace();
        }
    }
}

