/*
 * Decompiled with CFR 0.152.
 */
package pl.syntaxdevteam.punisher.hooks;

import com.earth2me.essentials.spawn.IEssentialsSpawn;
import kotlin.Metadata;
import kotlin.Result;
import kotlin.ResultKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import net.luckperms.api.LuckPerms;
import net.luckperms.api.cacheddata.CachedMetaData;
import net.luckperms.api.model.user.User;
import net.milkbowl.vault.chat.Chat;
import net.milkbowl.vault.permission.Permission;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.PluginManager;
import org.bukkit.plugin.RegisteredServiceProvider;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import pl.syntaxdevteam.punisher.PunisherX;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000V\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0006\u0010\u000e\u001a\u00020\u000fJ\b\u0010\u0010\u001a\u00020\u000fH\u0002J\b\u0010\u0011\u001a\u00020\u000fH\u0002J\b\u0010\u0012\u001a\u00020\u000fH\u0002J\u0006\u0010\u0013\u001a\u00020\u0014J\u0006\u0010\u0015\u001a\u00020\u0014J\u000e\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u0019J\u000e\u0010\u001a\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u0019J\u000e\u0010\u001b\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u0019J\u0018\u0010\u001c\u001a\u0004\u0018\u00010\u00172\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001d\u001a\u00020\u0017J\u0010\u0010\u001e\u001a\u0004\u0018\u00010\u001f2\u0006\u0010\u0018\u001a\u00020\u0019J\u0012\u0010 \u001a\u0004\u0018\u00010!2\b\b\u0002\u0010\"\u001a\u00020\u0017R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0006\u001a\u0004\u0018\u00010\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\b\u001a\u0004\u0018\u00010\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\n\u001a\u0004\u0018\u00010\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\f\u001a\u0004\u0018\u00010\rX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006#"}, d2={"Lpl/syntaxdevteam/punisher/hooks/HookHandler;", "", "plugin", "Lpl/syntaxdevteam/punisher/PunisherX;", "<init>", "(Lpl/syntaxdevteam/punisher/PunisherX;)V", "luckPerms", "Lnet/luckperms/api/LuckPerms;", "chat", "Lnet/milkbowl/vault/chat/Chat;", "permission", "Lnet/milkbowl/vault/permission/Permission;", "essentialsSpawn", "Lcom/earth2me/essentials/spawn/IEssentialsSpawn;", "checkLuckPerms", "", "checkVault", "checkVaultUnlocked", "checkEssentialsX", "checkPlaceholderAPI", "", "checkMiniPlaceholderAPI", "getPrimaryGroup", "", "player", "Lorg/bukkit/entity/Player;", "getPlayerPrefix", "getPlayerSuffix", "getLuckPermsMetaValue", "key", "getAllLuckPermsMetData", "Lnet/luckperms/api/cacheddata/CachedMetaData;", "getEssentialsSpawnLocation", "Lorg/bukkit/Location;", "group", "PunisherX"})
@SourceDebugExtension(value={"SMAP\nHookHandler.kt\nKotlin\n*S Kotlin\n*F\n+ 1 HookHandler.kt\npl/syntaxdevteam/punisher/hooks/HookHandler\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,233:1\n1#2:234\n*E\n"})
public final class HookHandler {
    @NotNull
    private final PunisherX plugin;
    @Nullable
    private LuckPerms luckPerms;
    @Nullable
    private Chat chat;
    @Nullable
    private Permission permission;
    @Nullable
    private IEssentialsSpawn essentialsSpawn;

    public HookHandler(@NotNull PunisherX plugin) {
        Intrinsics.checkNotNullParameter((Object)plugin, "plugin");
        this.plugin = plugin;
        this.checkPlaceholderAPI();
        this.checkEssentialsX();
    }

    public final void checkLuckPerms() {
        if (Bukkit.getPluginManager().isPluginEnabled("LuckPerms")) {
            RegisteredServiceProvider provider = Bukkit.getServicesManager().getRegistration(LuckPerms.class);
            if (provider != null) {
                this.luckPerms = (LuckPerms)provider.getProvider();
                this.plugin.getLogger().debug("Hooked into LuckPerms!");
            }
        } else {
            this.plugin.getLogger().debug("LuckPerms plugin not found on server!");
        }
    }

    private final void checkVault() {
        if (Bukkit.getPluginManager().isPluginEnabled("Vault")) {
            RegisteredServiceProvider chatProvider = Bukkit.getServicesManager().getRegistration(Chat.class);
            RegisteredServiceProvider permProvider = Bukkit.getServicesManager().getRegistration(Permission.class);
            if (chatProvider != null && permProvider != null) {
                this.chat = (Chat)chatProvider.getProvider();
                this.permission = (Permission)permProvider.getProvider();
                this.plugin.getLogger().debug("Hooked into Vault!");
            }
        } else {
            this.plugin.getLogger().debug("Vault plugin not found on server!");
        }
    }

    private final void checkVaultUnlocked() {
        if (Bukkit.getPluginManager().isPluginEnabled("VaultUnlocked")) {
            RegisteredServiceProvider chatProvider = Bukkit.getServicesManager().getRegistration(Chat.class);
            RegisteredServiceProvider permProvider = Bukkit.getServicesManager().getRegistration(Permission.class);
            if (chatProvider != null && permProvider != null) {
                this.chat = (Chat)chatProvider.getProvider();
                this.permission = (Permission)permProvider.getProvider();
                this.plugin.getLogger().debug("Hooked into VaultUnlocked!");
            }
        } else {
            this.plugin.getLogger().debug("VaultUnlocked plugin not found on server!");
        }
    }

    private final void checkEssentialsX() {
        PluginManager pluginManager = Bukkit.getPluginManager();
        Intrinsics.checkNotNullExpressionValue(pluginManager, "getPluginManager(...)");
        PluginManager pluginManager2 = pluginManager;
        if (!pluginManager2.isPluginEnabled("Essentials")) {
            this.plugin.getLogger().warning("EssentialsX plugin not found on server!");
            return;
        }
        Plugin spawnPlugin = pluginManager2.getPlugin("EssentialsSpawn");
        if (spawnPlugin instanceof IEssentialsSpawn && ((IEssentialsSpawn)spawnPlugin).isEnabled()) {
            this.essentialsSpawn = (IEssentialsSpawn)spawnPlugin;
            this.plugin.getLogger().debug("Hooked into EssentialsX Spawn!");
        } else {
            this.plugin.getLogger().warning("EssentialsX Spawn plugin not found or not enabled on server!");
        }
    }

    public final boolean checkPlaceholderAPI() {
        if (Bukkit.getPluginManager().isPluginEnabled("PlaceholderAPI")) {
            this.plugin.getLogger().debug("Hooked into PlaceholderAPI!");
            return true;
        }
        this.plugin.getLogger().warning("PlaceholderAPI plugin not found on server!");
        return false;
    }

    public final boolean checkMiniPlaceholderAPI() {
        if (Bukkit.getPluginManager().isPluginEnabled("MiniPlaceholders")) {
            this.plugin.getLogger().debug("Hooked into MiniPlaceholders!");
            return true;
        }
        this.plugin.getLogger().warning("MiniPlaceholders plugin not found on server!");
        return false;
    }

    @NotNull
    public final String getPrimaryGroup(@NotNull Player player) {
        String lpGroup;
        Intrinsics.checkNotNullParameter(player, "player");
        LuckPerms luckPerms = this.luckPerms;
        String string = luckPerms != null && (luckPerms = luckPerms.getPlayerAdapter(Player.class)) != null && (luckPerms = luckPerms.getMetaData((Object)player)) != null ? luckPerms.getPrimaryGroup() : (lpGroup = null);
        if (lpGroup != null) {
            this.plugin.getLogger().debug("LuckPerms primary group for " + player.getName() + ": " + lpGroup);
            return lpGroup;
        }
        Permission permission = this.permission;
        String groups2 = permission != null ? permission.getPrimaryGroup(player) : null;
        CharSequence charSequence = groups2;
        if (!(charSequence == null || charSequence.length() == 0)) {
            this.plugin.getLogger().debug("Vault groups for " + player.getName() + ": " + groups2);
            return groups2;
        }
        return "default";
    }

    @NotNull
    public final String getPlayerPrefix(@NotNull Player player) {
        Intrinsics.checkNotNullParameter(player, "player");
        Object object = this.luckPerms;
        if (object == null || (object = object.getPlayerAdapter(Player.class)) == null || (object = object.getMetaData((Object)player)) == null || (object = object.getPrefix()) == null) {
            Chat chat = this.chat;
            object = chat != null ? chat.getPlayerPrefix(player) : null;
            if (object == null) {
                object = "";
            }
        }
        return object;
    }

    @NotNull
    public final String getPlayerSuffix(@NotNull Player player) {
        Intrinsics.checkNotNullParameter(player, "player");
        Object object = this.luckPerms;
        if (object == null || (object = object.getPlayerAdapter(Player.class)) == null || (object = object.getMetaData((Object)player)) == null || (object = object.getSuffix()) == null) {
            Chat chat = this.chat;
            object = chat != null ? chat.getPlayerSuffix(player) : null;
            if (object == null) {
                object = "";
            }
        }
        return object;
    }

    @Nullable
    public final String getLuckPermsMetaValue(@NotNull Player player, @NotNull String key) {
        Intrinsics.checkNotNullParameter(player, "player");
        Intrinsics.checkNotNullParameter(key, "key");
        LuckPerms luckPerms = this.luckPerms;
        User user = luckPerms != null && (luckPerms = luckPerms.getUserManager()) != null ? luckPerms.getUser(player.getUniqueId()) : null;
        User user2 = user;
        return user2 != null && (user2 = user2.getCachedData()) != null && (user2 = user2.getMetaData()) != null ? user2.getMetaValue(key) : null;
    }

    @Nullable
    public final CachedMetaData getAllLuckPermsMetData(@NotNull Player player) {
        Intrinsics.checkNotNullParameter(player, "player");
        LuckPerms luckPerms = this.luckPerms;
        return luckPerms != null && (luckPerms = luckPerms.getPlayerAdapter(Player.class)) != null ? luckPerms.getMetaData((Object)player) : null;
    }

    @Nullable
    public final Location getEssentialsSpawnLocation(@NotNull String group) {
        Object object;
        block3: {
            Object object2;
            Intrinsics.checkNotNullParameter(group, "group");
            IEssentialsSpawn spawn = this.essentialsSpawn;
            if (spawn == null) {
                this.plugin.getLogger().warning("EssentialsX Spawn hook is not available while attempting to fetch spawn location.");
                return null;
            }
            object = this;
            try {
                HookHandler $this$getEssentialsSpawnLocation_u24lambda_u240 = object;
                boolean bl = false;
                Location location = spawn.getSpawn(group);
                object2 = Result.constructor-impl(location != null ? location.clone() : null);
            }
            catch (Throwable bl) {
                object2 = Result.constructor-impl(ResultKt.createFailure(bl));
            }
            object = object2;
            Throwable throwable = Result.exceptionOrNull-impl(object);
            if (throwable == null) break block3;
            Object it = object2 = throwable;
            boolean bl = false;
            this.plugin.getLogger().warning("Failed to obtain EssentialsX spawn location: " + ((Throwable)it).getMessage());
        }
        return (Location)(Result.isFailure-impl(object) ? null : object);
    }

    public static /* synthetic */ Location getEssentialsSpawnLocation$default(HookHandler hookHandler, String string, int n, Object object) {
        if ((n & 1) != 0) {
            string = "default";
        }
        return hookHandler.getEssentialsSpawnLocation(string);
    }
}

