/*
 * Decompiled with CFR 0.152.
 */
package pl.syntaxdevteam.punisher.gui.stats;

import com.google.gson.Gson;
import com.google.gson.JsonObject;
import java.io.File;
import java.time.Duration;
import java.time.Instant;
import java.time.ZoneId;
import java.time.format.DateTimeFormatter;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.io.FilesKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import net.kyori.adventure.nbt.BinaryTagIO;
import net.kyori.adventure.nbt.BinaryTagTypes;
import net.kyori.adventure.nbt.CompoundBinaryTag;
import net.kyori.adventure.nbt.ListBinaryTag;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.NamespacedKey;
import org.bukkit.OfflinePlayer;
import org.bukkit.World;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001:\u0001\u001bB\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0012\u0010\n\u001a\u0004\u0018\u00010\u000b2\u0006\u0010\f\u001a\u00020\bH\u0002J\u0010\u0010\r\u001a\u0004\u0018\u00010\u000e2\u0006\u0010\f\u001a\u00020\bJ\u0010\u0010\u000f\u001a\u0004\u0018\u00010\u000e2\u0006\u0010\f\u001a\u00020\bJ\u001a\u0010\u0010\u001a\u0004\u0018\u00010\u000e2\u0006\u0010\f\u001a\u00020\b2\b\b\u0002\u0010\u0011\u001a\u00020\u0012J\u001a\u0010\u0013\u001a\u0004\u0018\u00010\u000e2\u0006\u0010\f\u001a\u00020\b2\b\b\u0002\u0010\u0011\u001a\u00020\u0012J\u001a\u0010\u0014\u001a\u0004\u0018\u00010\u000e2\u0006\u0010\f\u001a\u00020\b2\b\b\u0002\u0010\u0011\u001a\u00020\u0012J\u0010\u0010\u0015\u001a\u0004\u0018\u00010\u000e2\u0006\u0010\f\u001a\u00020\bJ\u0010\u0010\u0016\u001a\u0004\u0018\u00010\u00172\u0006\u0010\f\u001a\u00020\bJ\u0010\u0010\u0018\u001a\u00020\u000e2\u0006\u0010\u0019\u001a\u00020\u001aH\u0002R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0006\u001a\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\t0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001c"}, d2={"Lpl/syntaxdevteam/punisher/gui/stats/PlayerStatsService;", "", "<init>", "()V", "gson", "Lcom/google/gson/Gson;", "cache", "", "Ljava/util/UUID;", "Lpl/syntaxdevteam/punisher/gui/stats/PlayerStatsService$Cached;", "loadJson", "Lcom/google/gson/JsonObject;", "uuid", "getTotalPlaytimeString", "", "getCurrentOnlineString", "getLastLoginDate", "zone", "Ljava/time/ZoneId;", "getLastSeenDate", "getLastActiveString", "getLastLocationString", "getLastLocation", "Lorg/bukkit/Location;", "formatDuration", "d", "Ljava/time/Duration;", "Cached", "PunisherX"})
@SourceDebugExtension(value={"SMAP\nPlayerStats.kt\nKotlin\n*S Kotlin\n*F\n+ 1 PlayerStats.kt\npl/syntaxdevteam/punisher/gui/stats/PlayerStatsService\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,159:1\n1#2:160\n*E\n"})
public final class PlayerStatsService {
    @NotNull
    public static final PlayerStatsService INSTANCE = new PlayerStatsService();
    @NotNull
    private static final Gson gson = new Gson();
    @NotNull
    private static final Map<UUID, Cached> cache = new LinkedHashMap();

    private PlayerStatsService() {
    }

    private final JsonObject loadJson(UUID uuid) {
        File f = new File("world/stats/" + uuid + ".json");
        if (!f.exists()) {
            return null;
        }
        long lm = f.lastModified();
        Cached cached = cache.get(uuid);
        if (cached != null && cached.getLastModified() == lm) {
            return cached.getJson();
        }
        JsonObject json = (JsonObject)gson.fromJson(FilesKt.readText$default(f, null, 1, null), JsonObject.class);
        Intrinsics.checkNotNull(json);
        cache.put(uuid, new Cached(json, lm));
        return json;
    }

    @Nullable
    public final String getTotalPlaytimeString(@NotNull UUID uuid) {
        long l;
        Intrinsics.checkNotNullParameter(uuid, "uuid");
        JsonObject jsonObject = this.loadJson(uuid);
        if (jsonObject == null) {
            return null;
        }
        JsonObject json = jsonObject;
        JsonObject jsonObject2 = json.getAsJsonObject("stats");
        if (jsonObject2 == null) {
            return null;
        }
        JsonObject stats = jsonObject2;
        JsonObject jsonObject3 = stats.getAsJsonObject("minecraft:custom");
        if (jsonObject3 == null) {
            return null;
        }
        JsonObject custom = jsonObject3;
        if (custom.has("minecraft:play_time")) {
            l = custom.get("minecraft:play_time").getAsLong();
        } else if (custom.has("minecraft:play_one_minute")) {
            l = custom.get("minecraft:play_one_minute").getAsLong();
        } else {
            return null;
        }
        long ticks = l;
        Duration duration = Duration.ofSeconds(ticks / (long)20);
        Intrinsics.checkNotNullExpressionValue(duration, "ofSeconds(...)");
        return this.formatDuration(duration);
    }

    @Nullable
    public final String getCurrentOnlineString(@NotNull UUID uuid) {
        String string;
        Intrinsics.checkNotNullParameter(uuid, "uuid");
        OfflinePlayer offlinePlayer = Bukkit.getOfflinePlayer((UUID)uuid);
        Intrinsics.checkNotNullExpressionValue(offlinePlayer, "getOfflinePlayer(...)");
        OfflinePlayer off = offlinePlayer;
        long now = System.currentTimeMillis();
        if (off.isOnline()) {
            long start = off.getLastLogin();
            if (start <= 0L) {
                return null;
            }
            Duration duration = Duration.ofMillis(now - start);
            Intrinsics.checkNotNullExpressionValue(duration, "ofMillis(...)");
            string = this.formatDuration(duration);
        } else {
            long login = off.getLastLogin();
            long seen = off.getLastSeen();
            if (login > 0L && seen > 0L && seen >= login) {
                Duration duration = Duration.ofMillis(seen - login);
                Intrinsics.checkNotNullExpressionValue(duration, "ofMillis(...)");
                string = this.formatDuration(duration);
            } else {
                string = null;
            }
        }
        return string;
    }

    @Nullable
    public final String getLastLoginDate(@NotNull UUID uuid, @NotNull ZoneId zone) {
        Intrinsics.checkNotNullParameter(uuid, "uuid");
        Intrinsics.checkNotNullParameter(zone, "zone");
        OfflinePlayer offlinePlayer = Bukkit.getOfflinePlayer((UUID)uuid);
        Intrinsics.checkNotNullExpressionValue(offlinePlayer, "getOfflinePlayer(...)");
        OfflinePlayer off = offlinePlayer;
        long ts = off.getLastLogin();
        if (ts <= 0L) {
            return null;
        }
        return Instant.ofEpochMilli(ts).atZone(zone).format(DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss"));
    }

    public static /* synthetic */ String getLastLoginDate$default(PlayerStatsService playerStatsService, UUID uUID, ZoneId zoneId, int n, Object object) {
        if ((n & 2) != 0) {
            ZoneId zoneId2 = ZoneId.systemDefault();
            Intrinsics.checkNotNullExpressionValue(zoneId2, "systemDefault(...)");
            zoneId = zoneId2;
        }
        return playerStatsService.getLastLoginDate(uUID, zoneId);
    }

    @Nullable
    public final String getLastSeenDate(@NotNull UUID uuid, @NotNull ZoneId zone) {
        Intrinsics.checkNotNullParameter(uuid, "uuid");
        Intrinsics.checkNotNullParameter(zone, "zone");
        OfflinePlayer offlinePlayer = Bukkit.getOfflinePlayer((UUID)uuid);
        Intrinsics.checkNotNullExpressionValue(offlinePlayer, "getOfflinePlayer(...)");
        OfflinePlayer off = offlinePlayer;
        long ts = off.getLastSeen();
        if (ts <= 0L) {
            return null;
        }
        return Instant.ofEpochMilli(ts).atZone(zone).format(DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss"));
    }

    public static /* synthetic */ String getLastSeenDate$default(PlayerStatsService playerStatsService, UUID uUID, ZoneId zoneId, int n, Object object) {
        if ((n & 2) != 0) {
            ZoneId zoneId2 = ZoneId.systemDefault();
            Intrinsics.checkNotNullExpressionValue(zoneId2, "systemDefault(...)");
            zoneId = zoneId2;
        }
        return playerStatsService.getLastSeenDate(uUID, zoneId);
    }

    @Nullable
    public final String getLastActiveString(@NotNull UUID uuid, @NotNull ZoneId zone) {
        long ts;
        Intrinsics.checkNotNullParameter(uuid, "uuid");
        Intrinsics.checkNotNullParameter(zone, "zone");
        OfflinePlayer offlinePlayer = Bukkit.getOfflinePlayer((UUID)uuid);
        Intrinsics.checkNotNullExpressionValue(offlinePlayer, "getOfflinePlayer(...)");
        OfflinePlayer off = offlinePlayer;
        long l = ts = off.isOnline() ? off.getLastLogin() : off.getLastSeen();
        if (ts <= 0L) {
            return null;
        }
        return Instant.ofEpochMilli(ts).atZone(zone).format(DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss"));
    }

    public static /* synthetic */ String getLastActiveString$default(PlayerStatsService playerStatsService, UUID uUID, ZoneId zoneId, int n, Object object) {
        if ((n & 2) != 0) {
            ZoneId zoneId2 = ZoneId.systemDefault();
            Intrinsics.checkNotNullExpressionValue(zoneId2, "systemDefault(...)");
            zoneId = zoneId2;
        }
        return playerStatsService.getLastActiveString(uUID, zoneId);
    }

    @Nullable
    public final String getLastLocationString(@NotNull UUID uuid) {
        String string;
        Intrinsics.checkNotNullParameter(uuid, "uuid");
        try {
            Object object;
            double z;
            double y;
            double x;
            block8: {
                CompoundBinaryTag tag;
                block7: {
                    List list = Bukkit.getWorlds();
                    Intrinsics.checkNotNullExpressionValue(list, "getWorlds(...)");
                    Object object2 = (World)CollectionsKt.firstOrNull(list);
                    if (object2 == null || (object2 = object2.getWorldFolder()) == null) {
                        return null;
                    }
                    Object worldFolder = object2;
                    File dataFile = new File((File)worldFolder, "playerdata/" + uuid + ".dat");
                    if (!dataFile.exists()) {
                        return null;
                    }
                    CompoundBinaryTag compoundBinaryTag = BinaryTagIO.reader().read(dataFile.toPath(), BinaryTagIO.Compression.GZIP);
                    Intrinsics.checkNotNullExpressionValue(compoundBinaryTag, "read(...)");
                    tag = compoundBinaryTag;
                    ListBinaryTag listBinaryTag = tag.getList("Pos", BinaryTagTypes.DOUBLE);
                    Intrinsics.checkNotNullExpressionValue(listBinaryTag, "getList(...)");
                    ListBinaryTag pos = listBinaryTag;
                    x = pos.getDouble(0);
                    y = pos.getDouble(1);
                    z = pos.getDouble(2);
                    NamespacedKey worldKey = NamespacedKey.fromString((String)tag.getString("Dimension"));
                    object = worldKey;
                    if (object == null) break block7;
                    NamespacedKey it = object;
                    boolean bl = false;
                    World world = Bukkit.getWorld((NamespacedKey)it);
                    String string2 = world != null ? world.getName() : null;
                    object = string2;
                    if (string2 != null) break block8;
                }
                String string3 = tag.getString("Dimension");
                object = string3;
                Intrinsics.checkNotNullExpressionValue(string3, "getString(...)");
            }
            Object worldName = object;
            string = (String)worldName + ": " + (int)x + ", " + (int)y + ", " + (int)z;
        }
        catch (Exception ex) {
            Bukkit.getLogger().fine("Failed to load last location for " + uuid + ": " + ex);
            string = null;
        }
        return string;
    }

    @Nullable
    public final Location getLastLocation(@NotNull UUID uuid) {
        Location location;
        Intrinsics.checkNotNullParameter(uuid, "uuid");
        try {
            Location location2;
            NamespacedKey world;
            NamespacedKey namespacedKey;
            double z;
            double y;
            double x;
            block10: {
                CompoundBinaryTag tag;
                block9: {
                    List list = Bukkit.getWorlds();
                    Intrinsics.checkNotNullExpressionValue(list, "getWorlds(...)");
                    Object object = (World)CollectionsKt.firstOrNull(list);
                    if (object == null || (object = object.getWorldFolder()) == null) {
                        return null;
                    }
                    Object worldFolder = object;
                    File dataFile = new File((File)worldFolder, "playerdata/" + uuid + ".dat");
                    if (!dataFile.exists()) {
                        return null;
                    }
                    CompoundBinaryTag compoundBinaryTag = BinaryTagIO.reader().read(dataFile.toPath(), BinaryTagIO.Compression.GZIP);
                    Intrinsics.checkNotNullExpressionValue(compoundBinaryTag, "read(...)");
                    tag = compoundBinaryTag;
                    ListBinaryTag listBinaryTag = tag.getList("Pos", BinaryTagTypes.DOUBLE);
                    Intrinsics.checkNotNullExpressionValue(listBinaryTag, "getList(...)");
                    ListBinaryTag pos = listBinaryTag;
                    x = pos.getDouble(0);
                    y = pos.getDouble(1);
                    z = pos.getDouble(2);
                    NamespacedKey worldKey = NamespacedKey.fromString((String)tag.getString("Dimension"));
                    namespacedKey = worldKey;
                    if (namespacedKey == null) break block9;
                    NamespacedKey it = namespacedKey;
                    boolean bl = false;
                    World world2 = Bukkit.getWorld((NamespacedKey)it);
                    namespacedKey = world2;
                    if (world2 != null) break block10;
                }
                namespacedKey = Bukkit.getWorld((String)tag.getString("Dimension"));
            }
            NamespacedKey namespacedKey2 = world = namespacedKey;
            if (namespacedKey2 != null) {
                NamespacedKey it = namespacedKey2;
                boolean bl = false;
                location2 = new Location((World)it, x, y, z);
            } else {
                location2 = null;
            }
            location = location2;
        }
        catch (Exception ex) {
            Bukkit.getLogger().fine("Failed to load last location for " + uuid + ": " + ex);
            location = null;
        }
        return location;
    }

    private final String formatDuration(Duration d) {
        long h = d.toHours();
        int m = d.toMinutesPart();
        int s = d.toSecondsPart();
        String string = "%dh %02dm %02ds";
        Object[] objectArray = new Object[]{h, m, s};
        String string2 = String.format(string, Arrays.copyOf(objectArray, objectArray.length));
        Intrinsics.checkNotNullExpressionValue(string2, "format(...)");
        return string2;
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\n\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0082\b\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\t\u0010\f\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\r\u001a\u00020\u0005H\u00c6\u0003J\u001d\u0010\u000e\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u0005H\u00c6\u0001J\u0013\u0010\u000f\u001a\u00020\u00102\b\u0010\u0011\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0012\u001a\u00020\u0013H\u00d6\u0001J\t\u0010\u0014\u001a\u00020\u0015H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\u0016"}, d2={"Lpl/syntaxdevteam/punisher/gui/stats/PlayerStatsService$Cached;", "", "json", "Lcom/google/gson/JsonObject;", "lastModified", "", "<init>", "(Lcom/google/gson/JsonObject;J)V", "getJson", "()Lcom/google/gson/JsonObject;", "getLastModified", "()J", "component1", "component2", "copy", "equals", "", "other", "hashCode", "", "toString", "", "PunisherX"})
    private static final class Cached {
        @NotNull
        private final JsonObject json;
        private final long lastModified;

        public Cached(@NotNull JsonObject json, long lastModified) {
            Intrinsics.checkNotNullParameter(json, "json");
            this.json = json;
            this.lastModified = lastModified;
        }

        @NotNull
        public final JsonObject getJson() {
            return this.json;
        }

        public final long getLastModified() {
            return this.lastModified;
        }

        @NotNull
        public final JsonObject component1() {
            return this.json;
        }

        public final long component2() {
            return this.lastModified;
        }

        @NotNull
        public final Cached copy(@NotNull JsonObject json, long lastModified) {
            Intrinsics.checkNotNullParameter(json, "json");
            return new Cached(json, lastModified);
        }

        public static /* synthetic */ Cached copy$default(Cached cached, JsonObject jsonObject, long l, int n, Object object) {
            if ((n & 1) != 0) {
                jsonObject = cached.json;
            }
            if ((n & 2) != 0) {
                l = cached.lastModified;
            }
            return cached.copy(jsonObject, l);
        }

        @NotNull
        public String toString() {
            return "Cached(json=" + this.json + ", lastModified=" + this.lastModified + ")";
        }

        public int hashCode() {
            int result = this.json.hashCode();
            result = result * 31 + Long.hashCode(this.lastModified);
            return result;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof Cached)) {
                return false;
            }
            Cached cached = (Cached)other;
            if (!Intrinsics.areEqual(this.json, cached.json)) {
                return false;
            }
            return this.lastModified == cached.lastModified;
        }
    }
}

