/*
 * Decompiled with CFR 0.152.
 */
package pl.syntaxdevteam.punisher.gui.report;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.UUID;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import kotlin.text.StringsKt;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.minimessage.tag.resolver.TagResolver;
import org.bukkit.Bukkit;
import org.bukkit.Material;
import org.bukkit.OfflinePlayer;
import org.bukkit.command.CommandSender;
import org.bukkit.enchantments.Enchantment;
import org.bukkit.entity.HumanEntity;
import org.bukkit.entity.Player;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.InventoryHolder;
import org.bukkit.inventory.ItemFlag;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.jetbrains.annotations.NotNull;
import pl.syntaxdevteam.message.MessageHandler;
import pl.syntaxdevteam.punisher.PunisherX;
import pl.syntaxdevteam.punisher.databases.DatabaseHandler;
import pl.syntaxdevteam.punisher.gui.interfaces.BaseGUI;
import pl.syntaxdevteam.punisher.gui.report.ReportSelectorGUI;
import pl.syntaxdevteam.punisher.permissions.PermissionChecker;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0015\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001:\u0001\u0019B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0016\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rJ.\u0010\u000e\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000f\u001a\u00020\u00102\f\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00130\u0012H\u0002J\u0010\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016J\u0010\u0010\u0014\u001a\u00020\t2\u0006\u0010\u0015\u001a\u00020\u0016H\u0016J\b\u0010\u0017\u001a\u00020\u0018H\u0016R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001a"}, d2={"Lpl/syntaxdevteam/punisher/gui/report/ReportReasonGUI;", "Lpl/syntaxdevteam/punisher/gui/interfaces/BaseGUI;", "plugin", "Lpl/syntaxdevteam/punisher/PunisherX;", "<init>", "(Lpl/syntaxdevteam/punisher/PunisherX;)V", "centerSlots", "", "open", "", "player", "Lorg/bukkit/entity/Player;", "target", "Lorg/bukkit/OfflinePlayer;", "openPaged", "page", "", "reasons", "", "", "handleClick", "event", "Lorg/bukkit/event/inventory/InventoryClickEvent;", "getTitle", "Lnet/kyori/adventure/text/Component;", "Holder", "PunisherX"})
@SourceDebugExtension(value={"SMAP\nReportReasonGUI.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ReportReasonGUI.kt\npl/syntaxdevteam/punisher/gui/report/ReportReasonGUI\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,149:1\n1#2:150\n1878#3,3:151\n774#3:154\n865#3,2:155\n1869#3,2:157\n*S KotlinDebug\n*F\n+ 1 ReportReasonGUI.kt\npl/syntaxdevteam/punisher/gui/report/ReportReasonGUI\n*L\n54#1:151,3\n115#1:154\n115#1:155,2\n116#1:157,2\n*E\n"})
public final class ReportReasonGUI
extends BaseGUI {
    @NotNull
    private final int[] centerSlots;

    public ReportReasonGUI(@NotNull PunisherX plugin) {
        Intrinsics.checkNotNullParameter((Object)plugin, "plugin");
        super(plugin);
        int[] nArray = new int[]{10, 11, 12, 13, 14, 15, 16, 19, 20, 21, 22, 23, 24, 25, 28, 29, 30, 31, 32, 33, 34};
        this.centerSlots = nArray;
    }

    public final void open(@NotNull Player player, @NotNull OfflinePlayer target) {
        List<String> list;
        Intrinsics.checkNotNullParameter(player, "player");
        Intrinsics.checkNotNullParameter(target, "target");
        List<String> list2 = this.getPlugin().getConfig().getStringList("gui.punish.reasons");
        if (list2.isEmpty()) {
            boolean bl = false;
            String[] stringArray = new String[]{"Cheating", "Griefing", "Spamming"};
            list = CollectionsKt.listOf(stringArray);
        } else {
            list = list2;
        }
        List reasons = list;
        this.openPaged(player, target, 0, reasons);
    }

    /*
     * WARNING - void declaration
     */
    private final void openPaged(Player player, OfflinePlayer target, int page, List<String> reasons) {
        int perPage = 27;
        int totalPages = reasons.isEmpty() ? 1 : (reasons.size() - 1) / perPage + 1;
        int currentPage = RangesKt.coerceIn(page, 0, totalPages - 1);
        int startIndex = currentPage * perPage;
        List pageReasons = CollectionsKt.take(CollectionsKt.drop((Iterable)reasons, startIndex), perPage);
        UUID uUID = target.getUniqueId();
        Intrinsics.checkNotNullExpressionValue(uUID, "getUniqueId(...)");
        Holder holder = new Holder(uUID, currentPage, reasons);
        Inventory inventory = Bukkit.createInventory((InventoryHolder)holder, (int)45, (Component)this.getTitle());
        Intrinsics.checkNotNullExpressionValue(inventory, "createInventory(...)");
        Inventory inventory2 = inventory;
        holder.setInv(inventory2);
        this.fillWithFiller(inventory2);
        Iterable $this$forEachIndexed$iv = pageReasons;
        boolean $i$f$forEachIndexed = false;
        int index$iv = 0;
        for (Object item$iv : $this$forEachIndexed$iv) {
            ItemMeta meta;
            String string;
            void reason;
            int n;
            if ((n = index$iv++) < 0) {
                CollectionsKt.throwIndexOverflow();
            }
            String string2 = (String)item$iv;
            int idx = n;
            boolean bl = false;
            int slot = idx < this.centerSlots.length ? this.centerSlots[idx] : idx;
            Intrinsics.checkNotNullExpressionValue(((Object)StringsKt.trim((CharSequence)reason)).toString().toLowerCase(Locale.ROOT), "toLowerCase(...)");
            int n2 = -1;
            switch (string.hashCode()) {
                case 929607227: {
                    if (string.equals("offensive language")) {
                        n2 = 1;
                    }
                    break;
                }
                case 2056933150: {
                    if (string.equals("spamming")) {
                        n2 = 2;
                    }
                    break;
                }
                case -1270874246: {
                    if (string.equals("offensive_language")) {
                        n2 = 1;
                    }
                    break;
                }
                case 319522179: {
                    if (string.equals("griefing")) {
                        n2 = 3;
                    }
                    break;
                }
                case 1535319599: {
                    if (string.equals("cheating")) {
                        n2 = 4;
                    }
                    break;
                }
                case 205005575: {
                    if (string.equals("greefing")) {
                        n2 = 3;
                    }
                    break;
                }
            }
            Material material = switch (n2) {
                case 4 -> Material.FISHING_ROD;
                case 3 -> Material.NETHERITE_AXE;
                case 2 -> Material.BOOK;
                case 1 -> Material.PAPER;
                default -> Material.BOOK;
            };
            ItemStack item = new ItemStack(material);
            Intrinsics.checkNotNullExpressionValue(item.getItemMeta(), "getItemMeta(...)");
            meta.displayName(this.getMH().formatMixedTextToMiniMessage("<gold><b>" + (String)reason + "</b></gold>", TagResolver.empty()));
            String loreText = MessageHandler.stringMessageToStringNoPrefix$default((MessageHandler)this.getMH(), (String)"GUI", (String)"Report.lore.clickToChoose", null, (int)4, null);
            meta.lore(CollectionsKt.listOf(this.getMH().formatMixedTextToMiniMessage(loreText, TagResolver.empty())));
            meta.addEnchant(Enchantment.UNBREAKING, 1, true);
            ItemFlag[] itemFlagArray = new ItemFlag[]{ItemFlag.HIDE_ENCHANTS, ItemFlag.HIDE_ATTRIBUTES};
            meta.addItemFlags(itemFlagArray);
            item.setItemMeta(meta);
            inventory2.setItem(slot, item);
        }
        if (currentPage > 0) {
            inventory2.setItem(36, this.createNavItem(Material.PAPER, MessageHandler.stringMessageToStringNoPrefix$default((MessageHandler)this.getMH(), (String)"GUI", (String)"Nav.previous", null, (int)4, null)));
        }
        inventory2.setItem(40, this.createNavItem(Material.BARRIER, MessageHandler.stringMessageToStringNoPrefix$default((MessageHandler)this.getMH(), (String)"GUI", (String)"Nav.back", null, (int)4, null)));
        if (currentPage < totalPages - 1) {
            inventory2.setItem(44, this.createNavItem(Material.BOOK, MessageHandler.stringMessageToStringNoPrefix$default((MessageHandler)this.getMH(), (String)"GUI", (String)"Nav.next", null, (int)4, null)));
        }
        player.openInventory(inventory2);
    }

    @Override
    public void open(@NotNull Player player) {
        Intrinsics.checkNotNullParameter(player, "player");
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void handleClick(@NotNull InventoryClickEvent event) {
        int index;
        Intrinsics.checkNotNullParameter(event, "event");
        event.setCancelled(true);
        InventoryHolder inventoryHolder = event.getView().getTopInventory().getHolder();
        Holder holder = inventoryHolder instanceof Holder ? (Holder)inventoryHolder : null;
        if (holder == null) {
            return;
        }
        Holder holder2 = holder;
        HumanEntity humanEntity = event.getWhoClicked();
        Player player = humanEntity instanceof Player ? (Player)humanEntity : null;
        if (player == null) {
            return;
        }
        Player reporter = player;
        OfflinePlayer offlinePlayer = Bukkit.getOfflinePlayer((UUID)holder2.getTarget());
        Intrinsics.checkNotNullExpressionValue(offlinePlayer, "getOfflinePlayer(...)");
        OfflinePlayer target = offlinePlayer;
        List<String> reasons = holder2.getReasons();
        int slot = event.getRawSlot();
        int localIndex = ArraysKt.indexOf(this.centerSlots, slot);
        if (localIndex >= 0 && (index = holder2.getPage() * 27 + localIndex) < reasons.size()) {
            String reason = reasons.get(index);
            reporter.closeInventory();
            DatabaseHandler databaseHandler = this.getPlugin().getDatabaseHandler();
            UUID uUID = reporter.getUniqueId();
            Intrinsics.checkNotNullExpressionValue(uUID, "getUniqueId(...)");
            UUID uUID2 = target.getUniqueId();
            Intrinsics.checkNotNullExpressionValue(uUID2, "getUniqueId(...)");
            boolean success = databaseHandler.addReport(uUID, uUID2, reason);
            if (success) {
                void $this$forEach$iv;
                void $this$filterTo$iv$iv;
                Iterable $this$filter$iv;
                MessageHandler messageHandler = this.getMH();
                Object object = new Pair[2];
                String string = target.getName();
                if (string == null) {
                    String string2 = target.getUniqueId().toString();
                    string = string2;
                    Intrinsics.checkNotNullExpressionValue(string2, "toString(...)");
                }
                object[0] = TuplesKt.to("target", string);
                object[1] = TuplesKt.to("reason", reason);
                reporter.sendMessage(messageHandler.stringMessageToComponent("reports", "report-sent", MapsKt.mapOf(object)));
                Collection collection = this.getPlugin().getServer().getOnlinePlayers();
                Intrinsics.checkNotNullExpressionValue(collection, "getOnlinePlayers(...)");
                object = collection;
                boolean $i$f$filter = false;
                Iterator iterator2 = $this$filter$iv;
                Collection destination$iv$iv = new ArrayList();
                boolean $i$f$filterTo = false;
                for (Object element$iv$iv : $this$filterTo$iv$iv) {
                    Player it = (Player)element$iv$iv;
                    boolean bl = false;
                    Intrinsics.checkNotNull(it);
                    if (!PermissionChecker.INSTANCE.hasWithSee((CommandSender)it, PermissionChecker.PermissionKey.SEE_REPORTS)) continue;
                    destination$iv$iv.add(element$iv$iv);
                }
                $this$filter$iv = (List)destination$iv$iv;
                boolean $i$f$forEach = false;
                for (Object element$iv : $this$forEach$iv) {
                    Player staff = (Player)element$iv;
                    boolean bl = false;
                    MessageHandler messageHandler2 = this.getMH();
                    Pair[] pairArray = new Pair[3];
                    pairArray[0] = TuplesKt.to("reporter", reporter.getName());
                    String string3 = target.getName();
                    if (string3 == null) {
                        String string4 = target.getUniqueId().toString();
                        string3 = string4;
                        Intrinsics.checkNotNullExpressionValue(string4, "toString(...)");
                    }
                    pairArray[1] = TuplesKt.to("target", string3);
                    pairArray[2] = TuplesKt.to("reason", reason);
                    staff.sendMessage(messageHandler2.stringMessageToComponentNoPrefix("reports", "admin-notify", MapsKt.mapOf(pairArray)));
                }
            } else {
                reporter.sendMessage(MessageHandler.stringMessageToComponentNoPrefix$default((MessageHandler)this.getMH(), (String)"error", (String)"db_error", null, (int)4, null));
            }
            return;
        }
        switch (slot) {
            case 36: {
                if (holder2.getPage() <= 0) break;
                this.openPaged(reporter, target, holder2.getPage() - 1, reasons);
                break;
            }
            case 40: {
                new ReportSelectorGUI(this.getPlugin()).open(reporter);
                break;
            }
            case 44: {
                int totalPages;
                int n = totalPages = reasons.isEmpty() ? 1 : (reasons.size() - 1) / 27 + 1;
                if (holder2.getPage() >= totalPages - 1) break;
                this.openPaged(reporter, target, holder2.getPage() + 1, reasons);
            }
        }
    }

    @Override
    @NotNull
    public Component getTitle() {
        return MessageHandler.stringMessageToComponentNoPrefix$default((MessageHandler)this.getMH(), (String)"GUI", (String)"Report.reason.title", null, (int)4, null);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0002\b\u000b\n\u0002\u0018\u0002\n\u0002\b\u0006\b\u0002\u0018\u00002\u00020\u0001B%\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007\u00a2\u0006\u0004\b\t\u0010\nJ\b\u0010\u0019\u001a\u00020\u0014H\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u001a\u0010\u0004\u001a\u00020\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\r\u0010\u000e\"\u0004\b\u000f\u0010\u0010R\u0017\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R\u001a\u0010\u0013\u001a\u00020\u0014X\u0086.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0015\u0010\u0016\"\u0004\b\u0017\u0010\u0018\u00a8\u0006\u001a"}, d2={"Lpl/syntaxdevteam/punisher/gui/report/ReportReasonGUI$Holder;", "Lorg/bukkit/inventory/InventoryHolder;", "target", "Ljava/util/UUID;", "page", "", "reasons", "", "", "<init>", "(Ljava/util/UUID;ILjava/util/List;)V", "getTarget", "()Ljava/util/UUID;", "getPage", "()I", "setPage", "(I)V", "getReasons", "()Ljava/util/List;", "inv", "Lorg/bukkit/inventory/Inventory;", "getInv", "()Lorg/bukkit/inventory/Inventory;", "setInv", "(Lorg/bukkit/inventory/Inventory;)V", "getInventory", "PunisherX"})
    private static final class Holder
    implements InventoryHolder {
        @NotNull
        private final UUID target;
        private int page;
        @NotNull
        private final List<String> reasons;
        public Inventory inv;

        public Holder(@NotNull UUID target, int page, @NotNull List<String> reasons) {
            Intrinsics.checkNotNullParameter(target, "target");
            Intrinsics.checkNotNullParameter(reasons, "reasons");
            this.target = target;
            this.page = page;
            this.reasons = reasons;
        }

        @NotNull
        public final UUID getTarget() {
            return this.target;
        }

        public final int getPage() {
            return this.page;
        }

        public final void setPage(int n) {
            this.page = n;
        }

        @NotNull
        public final List<String> getReasons() {
            return this.reasons;
        }

        @NotNull
        public final Inventory getInv() {
            Inventory inventory = this.inv;
            if (inventory != null) {
                return inventory;
            }
            Intrinsics.throwUninitializedPropertyAccessException("inv");
            return null;
        }

        public final void setInv(@NotNull Inventory inventory) {
            Intrinsics.checkNotNullParameter(inventory, "<set-?>");
            this.inv = inventory;
        }

        @NotNull
        public Inventory getInventory() {
            return this.getInv();
        }
    }
}

