/*
 * Decompiled with CFR 0.152.
 */
package pl.syntaxdevteam.punisher.gui.report;

import java.util.Comparator;
import java.util.List;
import java.util.Locale;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.StringsKt;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.minimessage.tag.resolver.TagResolver;
import org.bukkit.Bukkit;
import org.bukkit.Material;
import org.bukkit.OfflinePlayer;
import org.bukkit.enchantments.Enchantment;
import org.bukkit.entity.HumanEntity;
import org.bukkit.entity.Player;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.InventoryHolder;
import org.bukkit.inventory.ItemFlag;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.inventory.meta.SkullMeta;
import org.jetbrains.annotations.NotNull;
import pl.syntaxdevteam.message.MessageHandler;
import pl.syntaxdevteam.punisher.PunisherX;
import pl.syntaxdevteam.punisher.gui.interfaces.BaseGUI;
import pl.syntaxdevteam.punisher.gui.report.ReportReasonGUI;
import pl.syntaxdevteam.punisher.gui.report.ReportSelectorGUI;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0015\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001:\u0001\u0016B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0010\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016J&\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\f\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00100\u000fH\u0002J\u0010\u0010\u0011\u001a\u00020\t2\u0006\u0010\u0012\u001a\u00020\u0013H\u0016J\b\u0010\u0014\u001a\u00020\u0015H\u0016R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0017"}, d2={"Lpl/syntaxdevteam/punisher/gui/report/ReportOfflineGUI;", "Lpl/syntaxdevteam/punisher/gui/interfaces/BaseGUI;", "plugin", "Lpl/syntaxdevteam/punisher/PunisherX;", "<init>", "(Lpl/syntaxdevteam/punisher/PunisherX;)V", "centerSlots", "", "open", "", "player", "Lorg/bukkit/entity/Player;", "page", "", "list", "", "Lorg/bukkit/OfflinePlayer;", "handleClick", "event", "Lorg/bukkit/event/inventory/InventoryClickEvent;", "getTitle", "Lnet/kyori/adventure/text/Component;", "Holder", "PunisherX"})
@SourceDebugExtension(value={"SMAP\nReportOfflineGUI.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ReportOfflineGUI.kt\npl/syntaxdevteam/punisher/gui/report/ReportOfflineGUI\n+ 2 _Sequences.kt\nkotlin/sequences/SequencesKt___SequencesKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,134:1\n608#2:135\n1878#3,3:136\n*S KotlinDebug\n*F\n+ 1 ReportOfflineGUI.kt\npl/syntaxdevteam/punisher/gui/report/ReportOfflineGUI\n*L\n46#1:135\n72#1:136,3\n*E\n"})
public final class ReportOfflineGUI
extends BaseGUI {
    @NotNull
    private final int[] centerSlots;

    public ReportOfflineGUI(@NotNull PunisherX plugin) {
        Intrinsics.checkNotNullParameter((Object)plugin, "plugin");
        super(plugin);
        int[] nArray = new int[]{10, 11, 12, 13, 14, 15, 16, 19, 20, 21, 22, 23, 24, 25, 28, 29, 30, 31, 32, 33, 34};
        this.centerSlots = nArray;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void open(@NotNull Player player) {
        void $this$sortedBy$iv;
        Intrinsics.checkNotNullParameter(player, "player");
        long now = System.currentTimeMillis();
        long oneHourMs = 3600000L;
        OfflinePlayer[] offlinePlayerArray = Bukkit.getOfflinePlayers();
        Intrinsics.checkNotNullExpressionValue(offlinePlayerArray, "getOfflinePlayers(...)");
        Sequence<OfflinePlayer> sequence = SequencesKt.map(SequencesKt.filter(SequencesKt.map(SequencesKt.filter(SequencesKt.filter(ArraysKt.asSequence((Object[])offlinePlayerArray), ReportOfflineGUI::open$lambda$0), ReportOfflineGUI::open$lambda$1), ReportOfflineGUI::open$lambda$2), arg_0 -> ReportOfflineGUI.open$lambda$3(now, oneHourMs, arg_0)), ReportOfflineGUI::open$lambda$4);
        boolean $i$f$sortedBy = false;
        List recent = SequencesKt.toList(SequencesKt.sortedWith($this$sortedBy$iv, new Comparator(){

            public final int compare(T a, T b) {
                OfflinePlayer it = (OfflinePlayer)a;
                boolean bl = false;
                String string = it.getName();
                Intrinsics.checkNotNull(string);
                String string2 = string.toLowerCase(Locale.ROOT);
                Intrinsics.checkNotNullExpressionValue(string2, "toLowerCase(...)");
                it = (OfflinePlayer)b;
                Comparable comparable = (Comparable)((Object)string2);
                bl = false;
                String string3 = it.getName();
                Intrinsics.checkNotNull(string3);
                String string4 = string3.toLowerCase(Locale.ROOT);
                Intrinsics.checkNotNullExpressionValue(string4, "toLowerCase(...)");
                return ComparisonsKt.compareValues(comparable, (Comparable)((Object)string4));
            }
        }));
        this.open(player, 0, recent);
    }

    /*
     * WARNING - void declaration
     */
    private final void open(Player player, int page, List<? extends OfflinePlayer> list) {
        int playersPerPage = 27;
        int totalPages = list.isEmpty() ? 1 : (list.size() - 1) / playersPerPage + 1;
        int currentPage = RangesKt.coerceIn(page, 0, totalPages - 1);
        int startIndex = currentPage * playersPerPage;
        List pageItems = CollectionsKt.take(CollectionsKt.drop((Iterable)list, startIndex), playersPerPage);
        Holder holder = new Holder(list, currentPage);
        Inventory inventory = Bukkit.createInventory((InventoryHolder)holder, (int)45, (Component)this.getTitle());
        Intrinsics.checkNotNullExpressionValue(inventory, "createInventory(...)");
        Inventory inv = inventory;
        holder.setInv(inv);
        this.fillWithFiller(inv);
        if (pageItems.isEmpty()) {
            inv.setItem(22, this.createItem(Material.GRAY_DYE, "<gray>No recent offline players</gray>", CollectionsKt.listOf("<gray>Only players who left within the last hour are shown.</gray>")));
        } else {
            Iterable $this$forEachIndexed$iv = pageItems;
            boolean $i$f$forEachIndexed = false;
            int index$iv = 0;
            for (Object item$iv : $this$forEachIndexed$iv) {
                void target;
                int n;
                if ((n = index$iv++) < 0) {
                    CollectionsKt.throwIndexOverflow();
                }
                OfflinePlayer offlinePlayer = (OfflinePlayer)item$iv;
                int index = n;
                boolean bl = false;
                int slot = index < this.centerSlots.length ? this.centerSlots[index] : index;
                ItemStack head = new ItemStack(Material.PLAYER_HEAD);
                ItemMeta itemMeta = head.getItemMeta();
                Intrinsics.checkNotNull(itemMeta, "null cannot be cast to non-null type org.bukkit.inventory.meta.SkullMeta");
                SkullMeta meta = (SkullMeta)itemMeta;
                meta.setOwningPlayer((OfflinePlayer)target);
                meta.displayName(this.getMH().formatMixedTextToMiniMessage("<gold><b>" + target.getName() + "</b></gold>", TagResolver.empty()));
                String loreText = MessageHandler.stringMessageToStringNoPrefix$default((MessageHandler)this.getMH(), (String)"GUI", (String)"Report.lore.clickToReport", null, (int)4, null);
                meta.lore(CollectionsKt.listOf(this.getMH().formatMixedTextToMiniMessage(loreText, TagResolver.empty())));
                meta.addEnchant(Enchantment.UNBREAKING, 1, true);
                ItemFlag[] itemFlagArray = new ItemFlag[]{ItemFlag.HIDE_ENCHANTS, ItemFlag.HIDE_ATTRIBUTES};
                meta.addItemFlags(itemFlagArray);
                head.setItemMeta((ItemMeta)meta);
                inv.setItem(slot, head);
            }
        }
        if (currentPage > 0) {
            inv.setItem(36, this.createNavItem(Material.PAPER, MessageHandler.stringMessageToStringNoPrefix$default((MessageHandler)this.getMH(), (String)"GUI", (String)"Nav.previous", null, (int)4, null)));
        }
        inv.setItem(40, this.createNavItem(Material.BARRIER, MessageHandler.stringMessageToStringNoPrefix$default((MessageHandler)this.getMH(), (String)"GUI", (String)"Nav.back", null, (int)4, null)));
        if (currentPage < totalPages - 1) {
            inv.setItem(44, this.createNavItem(Material.BOOK, MessageHandler.stringMessageToStringNoPrefix$default((MessageHandler)this.getMH(), (String)"GUI", (String)"Nav.next", null, (int)4, null)));
        }
        player.openInventory(inv);
    }

    @Override
    public void handleClick(@NotNull InventoryClickEvent event) {
        Intrinsics.checkNotNullParameter(event, "event");
        event.setCancelled(true);
        InventoryHolder inventoryHolder = event.getView().getTopInventory().getHolder();
        Holder holder = inventoryHolder instanceof Holder ? (Holder)inventoryHolder : null;
        if (holder == null) {
            return;
        }
        Holder holder2 = holder;
        HumanEntity humanEntity = event.getWhoClicked();
        Player player = humanEntity instanceof Player ? (Player)humanEntity : null;
        if (player == null) {
            return;
        }
        Player player2 = player;
        int slot = event.getRawSlot();
        int playersPerPage = 27;
        int localIndex = ArraysKt.indexOf(this.centerSlots, slot);
        if (localIndex >= 0) {
            int index = holder2.getPage() * playersPerPage + localIndex;
            if (index < holder2.getPlayers().size()) {
                OfflinePlayer target = holder2.getPlayers().get(index);
                if (Intrinsics.areEqual(target.getUniqueId(), player2.getUniqueId())) {
                    player2.sendMessage(MessageHandler.stringMessageToComponent$default((MessageHandler)this.getMH(), (String)"error", (String)"cannot-report-self", null, (int)4, null));
                    return;
                }
                new ReportReasonGUI(this.getPlugin()).open(player2, target);
            }
            return;
        }
        switch (slot) {
            case 36: {
                if (holder2.getPage() <= 0) break;
                this.open(player2, holder2.getPage() - 1, holder2.getPlayers());
                break;
            }
            case 40: {
                new ReportSelectorGUI(this.getPlugin()).open(player2);
                break;
            }
            case 44: {
                int totalPages;
                int n = totalPages = holder2.getPlayers().isEmpty() ? 1 : (holder2.getPlayers().size() - 1) / playersPerPage + 1;
                if (holder2.getPage() >= totalPages - 1) break;
                this.open(player2, holder2.getPage() + 1, holder2.getPlayers());
            }
        }
    }

    @Override
    @NotNull
    public Component getTitle() {
        return MessageHandler.stringMessageToComponentNoPrefix$default((MessageHandler)this.getMH(), (String)"GUI", (String)"Report.offline.title", null, (int)4, null);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static final boolean open$lambda$0(OfflinePlayer it) {
        Intrinsics.checkNotNullParameter(it, "it");
        if (it.getName() == null) return false;
        String string = it.getName();
        Intrinsics.checkNotNull(string);
        if (StringsKt.isBlank(string)) return false;
        return true;
    }

    private static final boolean open$lambda$1(OfflinePlayer it) {
        Intrinsics.checkNotNullParameter(it, "it");
        return !it.isOnline();
    }

    private static final Pair open$lambda$2(OfflinePlayer player) {
        Intrinsics.checkNotNullParameter(player, "player");
        return TuplesKt.to(player, player.getLastSeen());
    }

    private static final boolean open$lambda$3(long $now, long $oneHourMs, Pair pair) {
        Intrinsics.checkNotNullParameter(pair, "<destruct>");
        long lastSeen = ((Number)pair.component2()).longValue();
        return lastSeen > 0L && $now - lastSeen <= $oneHourMs;
    }

    private static final OfflinePlayer open$lambda$4(Pair pair) {
        Intrinsics.checkNotNullParameter(pair, "<destruct>");
        Object a = pair.component1();
        Intrinsics.checkNotNullExpressionValue(a, "component1(...)");
        OfflinePlayer player = (OfflinePlayer)a;
        return player;
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\u0006\b\u0002\u0018\u00002\u00020\u0001B\u001d\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0004\b\u0007\u0010\bJ\b\u0010\u0015\u001a\u00020\u0010H\u0016R\u0017\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u001a\u0010\u0005\u001a\u00020\u0006X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000b\u0010\f\"\u0004\b\r\u0010\u000eR\u001a\u0010\u000f\u001a\u00020\u0010X\u0086.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0011\u0010\u0012\"\u0004\b\u0013\u0010\u0014\u00a8\u0006\u0016"}, d2={"Lpl/syntaxdevteam/punisher/gui/report/ReportOfflineGUI$Holder;", "Lorg/bukkit/inventory/InventoryHolder;", "players", "", "Lorg/bukkit/OfflinePlayer;", "page", "", "<init>", "(Ljava/util/List;I)V", "getPlayers", "()Ljava/util/List;", "getPage", "()I", "setPage", "(I)V", "inv", "Lorg/bukkit/inventory/Inventory;", "getInv", "()Lorg/bukkit/inventory/Inventory;", "setInv", "(Lorg/bukkit/inventory/Inventory;)V", "getInventory", "PunisherX"})
    private static final class Holder
    implements InventoryHolder {
        @NotNull
        private final List<OfflinePlayer> players;
        private int page;
        public Inventory inv;

        public Holder(@NotNull List<? extends OfflinePlayer> players, int page) {
            Intrinsics.checkNotNullParameter(players, "players");
            this.players = players;
            this.page = page;
        }

        @NotNull
        public final List<OfflinePlayer> getPlayers() {
            return this.players;
        }

        public final int getPage() {
            return this.page;
        }

        public final void setPage(int n) {
            this.page = n;
        }

        @NotNull
        public final Inventory getInv() {
            Inventory inventory = this.inv;
            if (inventory != null) {
                return inventory;
            }
            Intrinsics.throwUninitializedPropertyAccessException("inv");
            return null;
        }

        public final void setInv(@NotNull Inventory inventory) {
            Intrinsics.checkNotNullParameter(inventory, "<set-?>");
            this.inv = inventory;
        }

        @NotNull
        public Inventory getInventory() {
            return this.getInv();
        }
    }
}

