/*
 * Decompiled with CFR 0.152.
 */
package pl.syntaxdevteam.punisher.gui.punishments;

import java.text.SimpleDateFormat;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import kotlin.Metadata;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.minimessage.tag.resolver.TagResolver;
import org.bukkit.Bukkit;
import org.bukkit.Material;
import org.bukkit.OfflinePlayer;
import org.bukkit.entity.HumanEntity;
import org.bukkit.entity.Player;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.InventoryHolder;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.inventory.meta.SkullMeta;
import org.jetbrains.annotations.NotNull;
import pl.syntaxdevteam.message.MessageHandler;
import pl.syntaxdevteam.punisher.PunisherX;
import pl.syntaxdevteam.punisher.databases.PunishmentData;
import pl.syntaxdevteam.punisher.gui.interfaces.BaseGUI;
import pl.syntaxdevteam.punisher.gui.punishments.PunishedListGUI;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001:\u0001\u0017B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0010\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016J\u0018\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0002J\u0010\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0002J\u0010\u0010\u0012\u001a\u00020\t2\u0006\u0010\u0013\u001a\u00020\u0014H\u0016J\b\u0010\u0015\u001a\u00020\u0016H\u0016R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0018"}, d2={"Lpl/syntaxdevteam/punisher/gui/punishments/JailListGUI;", "Lpl/syntaxdevteam/punisher/gui/interfaces/BaseGUI;", "plugin", "Lpl/syntaxdevteam/punisher/PunisherX;", "<init>", "(Lpl/syntaxdevteam/punisher/PunisherX;)V", "dateFormat", "Ljava/text/SimpleDateFormat;", "open", "", "player", "Lorg/bukkit/entity/Player;", "page", "", "createHead", "Lorg/bukkit/inventory/ItemStack;", "punishment", "Lpl/syntaxdevteam/punisher/databases/PunishmentData;", "handleClick", "event", "Lorg/bukkit/event/inventory/InventoryClickEvent;", "getTitle", "Lnet/kyori/adventure/text/Component;", "Holder", "PunisherX"})
@SourceDebugExtension(value={"SMAP\nJailListGUI.kt\nKotlin\n*S Kotlin\n*F\n+ 1 JailListGUI.kt\npl/syntaxdevteam/punisher/gui/punishments/JailListGUI\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,99:1\n1878#2,3:100\n*S KotlinDebug\n*F\n+ 1 JailListGUI.kt\npl/syntaxdevteam/punisher/gui/punishments/JailListGUI\n*L\n44#1:100,3\n*E\n"})
public final class JailListGUI
extends BaseGUI {
    @NotNull
    private final SimpleDateFormat dateFormat;

    public JailListGUI(@NotNull PunisherX plugin) {
        Intrinsics.checkNotNullParameter((Object)plugin, "plugin");
        super(plugin);
        this.dateFormat = new SimpleDateFormat("yy-MM-dd HH:mm:ss");
    }

    @Override
    public void open(@NotNull Player player) {
        Intrinsics.checkNotNullParameter(player, "player");
        this.open(player, 0);
    }

    /*
     * WARNING - void declaration
     */
    private final void open(Player player, int page) {
        int limit = 27;
        int offset = page * limit;
        List<PunishmentData> punishments = this.getPlugin().getDatabaseHandler().getJailedPlayers(limit, offset);
        boolean hasNext = !((Collection)this.getPlugin().getDatabaseHandler().getJailedPlayers(1, offset + limit)).isEmpty();
        Holder holder = new Holder(page);
        Inventory inventory = Bukkit.createInventory((InventoryHolder)holder, (int)45, (Component)this.getTitle());
        Intrinsics.checkNotNullExpressionValue(inventory, "createInventory(...)");
        Inventory inventory2 = inventory;
        holder.setInv(inventory2);
        this.fillWithFiller(inventory2);
        Iterable $this$forEachIndexed$iv = punishments;
        boolean $i$f$forEachIndexed = false;
        int index$iv = 0;
        for (Object item$iv : $this$forEachIndexed$iv) {
            void punishment;
            int n;
            if ((n = index$iv++) < 0) {
                CollectionsKt.throwIndexOverflow();
            }
            PunishmentData punishmentData = (PunishmentData)item$iv;
            int index = n;
            boolean bl = false;
            inventory2.setItem(index, this.createHead((PunishmentData)punishment));
        }
        if (page > 0) {
            inventory2.setItem(36, this.createNavItem(Material.PAPER, MessageHandler.stringMessageToStringNoPrefix$default((MessageHandler)this.getMH(), (String)"GUI", (String)"Nav.previous", null, (int)4, null)));
        }
        inventory2.setItem(40, this.createNavItem(Material.BARRIER, MessageHandler.stringMessageToStringNoPrefix$default((MessageHandler)this.getMH(), (String)"GUI", (String)"Nav.back", null, (int)4, null)));
        if (hasNext) {
            inventory2.setItem(44, this.createNavItem(Material.BOOK, MessageHandler.stringMessageToStringNoPrefix$default((MessageHandler)this.getMH(), (String)"GUI", (String)"Nav.next", null, (int)4, null)));
        }
        player.openInventory(inventory2);
    }

    private final ItemStack createHead(PunishmentData punishment) {
        ItemStack head = new ItemStack(Material.PLAYER_HEAD);
        ItemMeta itemMeta = head.getItemMeta();
        Intrinsics.checkNotNull(itemMeta, "null cannot be cast to non-null type org.bukkit.inventory.meta.SkullMeta");
        SkullMeta meta = (SkullMeta)itemMeta;
        OfflinePlayer offlinePlayer = Bukkit.getOfflinePlayer((String)punishment.getName());
        Intrinsics.checkNotNullExpressionValue(offlinePlayer, "getOfflinePlayer(...)");
        OfflinePlayer offline = offlinePlayer;
        meta.setOwningPlayer(offline);
        meta.displayName(this.getMH().formatMixedTextToMiniMessage("<yellow>" + punishment.getName() + "</yellow>", TagResolver.empty()));
        String formattedDate = this.dateFormat.format(new Date(punishment.getStart()));
        String remaining = punishment.getEnd() == -1L ? MessageHandler.stringMessageToStringNoPrefix$default((MessageHandler)this.getMH(), (String)"GUI", (String)"JailList.permanent", null, (int)4, null) : this.getPlugin().getTimeHandler().formatTime(String.valueOf((punishment.getEnd() - System.currentTimeMillis()) / (long)1000));
        Component[] componentArray = new Component[]{this.getMH().stringMessageToComponentNoPrefix("GUI", "JailList.hover.id", MapsKt.mapOf(TuplesKt.to("id", String.valueOf(punishment.getId())))), this.getMH().stringMessageToComponentNoPrefix("GUI", "JailList.hover.date", MapsKt.mapOf(TuplesKt.to("date", formattedDate))), this.getMH().stringMessageToComponentNoPrefix("GUI", "JailList.hover.remaining", MapsKt.mapOf(TuplesKt.to("time", remaining))), this.getMH().stringMessageToComponentNoPrefix("GUI", "JailList.hover.operator", MapsKt.mapOf(TuplesKt.to("operator", punishment.getOperator()))), this.getMH().stringMessageToComponentNoPrefix("GUI", "JailList.hover.reason", MapsKt.mapOf(TuplesKt.to("reason", punishment.getReason())))};
        meta.lore(CollectionsKt.listOf(componentArray));
        head.setItemMeta((ItemMeta)meta);
        return head;
    }

    @Override
    public void handleClick(@NotNull InventoryClickEvent event) {
        Intrinsics.checkNotNullParameter(event, "event");
        event.setCancelled(true);
        InventoryHolder inventoryHolder = event.getView().getTopInventory().getHolder();
        Holder holder = inventoryHolder instanceof Holder ? (Holder)inventoryHolder : null;
        if (holder == null) {
            return;
        }
        Holder holder2 = holder;
        HumanEntity humanEntity = event.getWhoClicked();
        Player player = humanEntity instanceof Player ? (Player)humanEntity : null;
        if (player == null) {
            return;
        }
        Player player2 = player;
        int limit = 27;
        switch (event.getRawSlot()) {
            case 36: {
                if (holder2.getPage() <= 0) break;
                this.open(player2, holder2.getPage() - 1);
                break;
            }
            case 40: {
                new PunishedListGUI(this.getPlugin()).open(player2);
                break;
            }
            case 44: {
                if (!(!((Collection)this.getPlugin().getDatabaseHandler().getJailedPlayers(1, (holder2.getPage() + 1) * limit)).isEmpty())) break;
                this.open(player2, holder2.getPage() + 1);
            }
        }
    }

    @Override
    @NotNull
    public Component getTitle() {
        return MessageHandler.stringMessageToComponentNoPrefix$default((MessageHandler)this.getMH(), (String)"GUI", (String)"JailList.title", null, (int)4, null);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0006\b\u0002\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\b\u0010\u000f\u001a\u00020\nH\u0016R\u001a\u0010\u0002\u001a\u00020\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0006\u0010\u0007\"\u0004\b\b\u0010\u0005R\u001a\u0010\t\u001a\u00020\nX\u0086.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000b\u0010\f\"\u0004\b\r\u0010\u000e\u00a8\u0006\u0010"}, d2={"Lpl/syntaxdevteam/punisher/gui/punishments/JailListGUI$Holder;", "Lorg/bukkit/inventory/InventoryHolder;", "page", "", "<init>", "(I)V", "getPage", "()I", "setPage", "inv", "Lorg/bukkit/inventory/Inventory;", "getInv", "()Lorg/bukkit/inventory/Inventory;", "setInv", "(Lorg/bukkit/inventory/Inventory;)V", "getInventory", "PunisherX"})
    private static final class Holder
    implements InventoryHolder {
        private int page;
        public Inventory inv;

        public Holder(int page) {
            this.page = page;
        }

        public final int getPage() {
            return this.page;
        }

        public final void setPage(int n) {
            this.page = n;
        }

        @NotNull
        public final Inventory getInv() {
            Inventory inventory = this.inv;
            if (inventory != null) {
                return inventory;
            }
            Intrinsics.throwUninitializedPropertyAccessException("inv");
            return null;
        }

        public final void setInv(@NotNull Inventory inventory) {
            Intrinsics.checkNotNullParameter(inventory, "<set-?>");
            this.inv = inventory;
        }

        @NotNull
        public Inventory getInventory() {
            return this.getInv();
        }
    }
}

