/*
 * Decompiled with CFR 0.152.
 */
package pl.syntaxdevteam.punisher.gui.materials;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.bukkit.Material;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import pl.syntaxdevteam.punisher.loader.SemanticVersion;
import pl.syntaxdevteam.punisher.loader.SemanticVersionKt;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010$\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0011\n\u0002\b\u0003\u0018\u00002\u00020\u0001:\u0001\u0014B=\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0014\b\u0002\u0010\u0004\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00030\u0005\u0012\u0016\b\u0002\u0010\u0007\u001a\u0010\u0012\u0004\u0012\u00020\u0006\u0012\u0006\u0012\u0004\u0018\u00010\b0\u0005\u00a2\u0006\u0004\b\t\u0010\nJ'\u0010\u000f\u001a\u00020\b2\u0006\u0010\u0010\u001a\u00020\u00062\u0012\u0010\u0011\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00060\u0012\"\u00020\u0006\u00a2\u0006\u0002\u0010\u0013R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001c\u0010\u0007\u001a\u0010\u0012\u0004\u0012\u00020\u0006\u0012\u0006\u0012\u0004\u0018\u00010\b0\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R \u0010\u000b\u001a\u0014\u0012\u0004\u0012\u00020\u0006\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u000e0\r0\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0015"}, d2={"Lpl/syntaxdevteam/punisher/gui/materials/GuiMaterialResolver;", "", "currentVersion", "Lpl/syntaxdevteam/punisher/loader/SemanticVersion;", "parseVersion", "Lkotlin/Function1;", "", "materialMatcher", "Lorg/bukkit/Material;", "<init>", "(Lpl/syntaxdevteam/punisher/loader/SemanticVersion;Lkotlin/jvm/functions/Function1;Lkotlin/jvm/functions/Function1;)V", "materialTimeline", "", "", "Lpl/syntaxdevteam/punisher/gui/materials/GuiMaterialResolver$MaterialVariant;", "resolveMaterial", "key", "fallbacks", "", "(Ljava/lang/String;[Ljava/lang/String;)Lorg/bukkit/Material;", "MaterialVariant", "PunisherX"})
@SourceDebugExtension(value={"SMAP\nGuiMaterialResolver.kt\nKotlin\n*S Kotlin\n*F\n+ 1 GuiMaterialResolver.kt\npl/syntaxdevteam/punisher/gui/materials/GuiMaterialResolver\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n+ 4 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,84:1\n774#2:85\n865#2,2:86\n1634#2,3:88\n827#2:93\n855#2,2:94\n1634#2,3:96\n13805#3,2:91\n1#4:99\n*S KotlinDebug\n*F\n+ 1 GuiMaterialResolver.kt\npl/syntaxdevteam/punisher/gui/materials/GuiMaterialResolver\n*L\n66#1:85\n66#1:86,2\n67#1:88,3\n71#1:93\n71#1:94,2\n72#1:96,3\n69#1:91,2\n*E\n"})
public final class GuiMaterialResolver {
    @NotNull
    private final SemanticVersion currentVersion;
    @NotNull
    private final Function1<String, Material> materialMatcher;
    @NotNull
    private final Map<String, List<MaterialVariant>> materialTimeline;

    public GuiMaterialResolver(@NotNull SemanticVersion currentVersion, @NotNull Function1<? super String, SemanticVersion> parseVersion, @NotNull Function1<? super String, ? extends Material> materialMatcher) {
        Intrinsics.checkNotNullParameter(currentVersion, "currentVersion");
        Intrinsics.checkNotNullParameter(parseVersion, "parseVersion");
        Intrinsics.checkNotNullParameter(materialMatcher, "materialMatcher");
        this.currentVersion = currentVersion;
        this.materialMatcher = materialMatcher;
        Pair[] pairArray = new Pair[2];
        MaterialVariant[] materialVariantArray = new MaterialVariant[]{new MaterialVariant("CHAIN", parseVersion.invoke("1.16.0"), parseVersion.invoke("1.21.8")), new MaterialVariant("IRON_CHAIN", parseVersion.invoke("1.21.9"), null, 4, null)};
        pairArray[0] = TuplesKt.to("CHAIN", CollectionsKt.listOf(materialVariantArray));
        materialVariantArray = new MaterialVariant[]{new MaterialVariant("IRON_CHAIN", parseVersion.invoke("1.21.9"), null, 4, null), new MaterialVariant("CHAIN", parseVersion.invoke("1.16.0"), parseVersion.invoke("1.21.8"))};
        pairArray[1] = TuplesKt.to("IRON_CHAIN", CollectionsKt.listOf(materialVariantArray));
        this.materialTimeline = MapsKt.mapOf(pairArray);
    }

    public /* synthetic */ GuiMaterialResolver(SemanticVersion semanticVersion, Function1 function1, Function1 function12, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            function1 = GuiMaterialResolver::_init_$lambda$0;
        }
        if ((n & 4) != 0) {
            function12 = GuiMaterialResolver::_init_$lambda$1;
        }
        this(semanticVersion, function1, function12);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final Material resolveMaterial(@NotNull String key, String ... fallbacks) {
        MaterialVariant it;
        Collection collection;
        Object destination$iv$iv;
        Intrinsics.checkNotNullParameter(key, "key");
        Intrinsics.checkNotNullParameter(fallbacks, "fallbacks");
        List<String> list = CollectionsKt.createListBuilder();
        List<String> $this$resolveMaterial_u24lambda_u240 = list;
        boolean bl = false;
        List<MaterialVariant> list2 = this.materialTimeline.get(key);
        if (list2 != null) {
            void $this$mapTo$iv;
            void $this$filterTo$iv$iv;
            Iterable $this$filter$iv;
            Iterable iterable = list2;
            boolean $i$f$filter = false;
            void var10_17 = $this$filter$iv;
            destination$iv$iv = new ArrayList();
            boolean $i$f$filterTo = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv) {
                MaterialVariant it2 = (MaterialVariant)element$iv$iv;
                boolean bl2 = false;
                if (!it2.isApplicable(this.currentVersion)) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            $this$filter$iv = (List)destination$iv$iv;
            Collection destination$iv = $this$resolveMaterial_u24lambda_u240;
            boolean $i$f$mapTo = false;
            for (Object item$iv : $this$mapTo$iv) {
                MaterialVariant materialVariant = (MaterialVariant)item$iv;
                collection = destination$iv;
                boolean bl3 = false;
                collection.add(it.getMaterialName());
            }
            List cfr_ignored_0 = (List)destination$iv;
        }
        $this$resolveMaterial_u24lambda_u240.add(key);
        String[] $this$forEach$iv = fallbacks;
        boolean $i$f$forEach = false;
        int destination$iv = $this$forEach$iv.length;
        for (int $this$mapTo$iv = 0; $this$mapTo$iv < destination$iv; ++$this$mapTo$iv) {
            String element$iv;
            String it3 = element$iv = $this$forEach$iv[$this$mapTo$iv];
            boolean bl4 = false;
            $this$resolveMaterial_u24lambda_u240.add(it3);
        }
        list2 = this.materialTimeline.get(key);
        if (list2 != null) {
            void $this$filterNotTo$iv$iv;
            Iterable $this$filterNot$iv;
            Iterable $this$mapTo$iv = list2;
            boolean $i$f$filterNot = false;
            void element$iv = $this$filterNot$iv;
            destination$iv$iv = new ArrayList();
            boolean $i$f$filterNotTo = false;
            for (Object element$iv$iv : $this$filterNotTo$iv$iv) {
                MaterialVariant it2 = (MaterialVariant)element$iv$iv;
                boolean bl5 = false;
                if (it2.isApplicable(this.currentVersion)) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            $this$filterNot$iv = (List)destination$iv$iv;
            Collection destination$iv2 = $this$resolveMaterial_u24lambda_u240;
            boolean $i$f$mapTo = false;
            for (Object item$iv : $this$mapTo$iv) {
                it = (MaterialVariant)item$iv;
                collection = destination$iv2;
                boolean bl6 = false;
                collection.add(it.getMaterialName());
            }
            List cfr_ignored_1 = (List)destination$iv2;
        }
        List<String> candidates = CollectionsKt.distinct(CollectionsKt.build(list));
        for (String candidate : candidates) {
            Material material = this.materialMatcher.invoke(candidate);
            if (material == null) continue;
            Material it4 = material;
            boolean bl7 = false;
            return it4;
        }
        throw new IllegalArgumentException("No compatible material found for " + key + " on Minecraft " + this.currentVersion + " (candidates: " + CollectionsKt.joinToString$default(candidates, null, null, null, 0, null, null, 63, null) + ")");
    }

    private static final SemanticVersion _init_$lambda$0(String it) {
        Intrinsics.checkNotNullParameter(it, "it");
        return SemanticVersion.Companion.parse(it);
    }

    private static final Material _init_$lambda$1(String it) {
        Intrinsics.checkNotNullParameter(it, "it");
        return Material.matchMaterial((String)it);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010\u000b\n\u0002\b\b\n\u0002\u0010\b\n\u0002\b\u0002\b\u0082\b\u0018\u00002\u00020\u0001B#\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\n\b\u0002\u0010\u0006\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\u0004\b\u0007\u0010\bJ\u000e\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0005J\t\u0010\u0011\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0012\u001a\u00020\u0005H\u00c6\u0003J\u000b\u0010\u0013\u001a\u0004\u0018\u00010\u0005H\u00c6\u0003J)\u0010\u0014\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00052\n\b\u0002\u0010\u0006\u001a\u0004\u0018\u00010\u0005H\u00c6\u0001J\u0013\u0010\u0015\u001a\u00020\u000f2\b\u0010\u0016\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0017\u001a\u00020\u0018H\u00d6\u0001J\t\u0010\u0019\u001a\u00020\u0003H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0013\u0010\u0006\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\f\u00a8\u0006\u001a"}, d2={"Lpl/syntaxdevteam/punisher/gui/materials/GuiMaterialResolver$MaterialVariant;", "", "materialName", "", "fromVersion", "Lpl/syntaxdevteam/punisher/loader/SemanticVersion;", "untilVersion", "<init>", "(Ljava/lang/String;Lpl/syntaxdevteam/punisher/loader/SemanticVersion;Lpl/syntaxdevteam/punisher/loader/SemanticVersion;)V", "getMaterialName", "()Ljava/lang/String;", "getFromVersion", "()Lpl/syntaxdevteam/punisher/loader/SemanticVersion;", "getUntilVersion", "isApplicable", "", "version", "component1", "component2", "component3", "copy", "equals", "other", "hashCode", "", "toString", "PunisherX"})
    private static final class MaterialVariant {
        @NotNull
        private final String materialName;
        @NotNull
        private final SemanticVersion fromVersion;
        @Nullable
        private final SemanticVersion untilVersion;

        public MaterialVariant(@NotNull String materialName, @NotNull SemanticVersion fromVersion, @Nullable SemanticVersion untilVersion) {
            Intrinsics.checkNotNullParameter(materialName, "materialName");
            Intrinsics.checkNotNullParameter(fromVersion, "fromVersion");
            this.materialName = materialName;
            this.fromVersion = fromVersion;
            this.untilVersion = untilVersion;
        }

        public /* synthetic */ MaterialVariant(String string, SemanticVersion semanticVersion, SemanticVersion semanticVersion2, int n, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n & 4) != 0) {
                semanticVersion2 = null;
            }
            this(string, semanticVersion, semanticVersion2);
        }

        @NotNull
        public final String getMaterialName() {
            return this.materialName;
        }

        @NotNull
        public final SemanticVersion getFromVersion() {
            return this.fromVersion;
        }

        @Nullable
        public final SemanticVersion getUntilVersion() {
            return this.untilVersion;
        }

        public final boolean isApplicable(@NotNull SemanticVersion version) {
            Intrinsics.checkNotNullParameter(version, "version");
            return SemanticVersionKt.isBetween(version, this.fromVersion, this.untilVersion);
        }

        @NotNull
        public final String component1() {
            return this.materialName;
        }

        @NotNull
        public final SemanticVersion component2() {
            return this.fromVersion;
        }

        @Nullable
        public final SemanticVersion component3() {
            return this.untilVersion;
        }

        @NotNull
        public final MaterialVariant copy(@NotNull String materialName, @NotNull SemanticVersion fromVersion, @Nullable SemanticVersion untilVersion) {
            Intrinsics.checkNotNullParameter(materialName, "materialName");
            Intrinsics.checkNotNullParameter(fromVersion, "fromVersion");
            return new MaterialVariant(materialName, fromVersion, untilVersion);
        }

        public static /* synthetic */ MaterialVariant copy$default(MaterialVariant materialVariant, String string, SemanticVersion semanticVersion, SemanticVersion semanticVersion2, int n, Object object) {
            if ((n & 1) != 0) {
                string = materialVariant.materialName;
            }
            if ((n & 2) != 0) {
                semanticVersion = materialVariant.fromVersion;
            }
            if ((n & 4) != 0) {
                semanticVersion2 = materialVariant.untilVersion;
            }
            return materialVariant.copy(string, semanticVersion, semanticVersion2);
        }

        @NotNull
        public String toString() {
            return "MaterialVariant(materialName=" + this.materialName + ", fromVersion=" + this.fromVersion + ", untilVersion=" + this.untilVersion + ")";
        }

        public int hashCode() {
            int result = this.materialName.hashCode();
            result = result * 31 + this.fromVersion.hashCode();
            result = result * 31 + (this.untilVersion == null ? 0 : this.untilVersion.hashCode());
            return result;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof MaterialVariant)) {
                return false;
            }
            MaterialVariant materialVariant = (MaterialVariant)other;
            if (!Intrinsics.areEqual(this.materialName, materialVariant.materialName)) {
                return false;
            }
            if (!Intrinsics.areEqual(this.fromVersion, materialVariant.fromVersion)) {
                return false;
            }
            return Intrinsics.areEqual(this.untilVersion, materialVariant.untilVersion);
        }
    }
}

