/*
 * Decompiled with CFR 0.152.
 */
package pl.syntaxdevteam.punisher.databases;

import java.time.Instant;
import java.time.ZoneId;
import java.time.format.DateTimeFormatter;
import java.util.UUID;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\r\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u000b\n\u0002\b\u0005\b\u0086\b\u0018\u0000 &2\u00020\u0001:\u0001&B/\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0005\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\u0006\u0010\t\u001a\u00020\n\u00a2\u0006\u0004\b\u000b\u0010\fJ\u001a\u0010\u0016\u001a\u00020\b2\b\b\u0002\u0010\u0017\u001a\u00020\u00182\b\b\u0002\u0010\u0019\u001a\u00020\u001aJ\t\u0010\u001b\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u001c\u001a\u00020\u0005H\u00c6\u0003J\t\u0010\u001d\u001a\u00020\u0005H\u00c6\u0003J\t\u0010\u001e\u001a\u00020\bH\u00c6\u0003J\t\u0010\u001f\u001a\u00020\nH\u00c6\u0003J;\u0010 \u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00052\b\b\u0002\u0010\u0006\u001a\u00020\u00052\b\b\u0002\u0010\u0007\u001a\u00020\b2\b\b\u0002\u0010\t\u001a\u00020\nH\u00c6\u0001J\u0013\u0010!\u001a\u00020\"2\b\u0010#\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010$\u001a\u00020\u0003H\u00d6\u0001J\t\u0010%\u001a\u00020\bH\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u0011\u0010\u0006\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0010R\u0011\u0010\u0007\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013R\u0011\u0010\t\u001a\u00020\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0015\u00a8\u0006'"}, d2={"Lpl/syntaxdevteam/punisher/databases/ReportData;", "", "id", "", "player", "Ljava/util/UUID;", "suspect", "reason", "", "filedAt", "Ljava/time/Instant;", "<init>", "(ILjava/util/UUID;Ljava/util/UUID;Ljava/lang/String;Ljava/time/Instant;)V", "getId", "()I", "getPlayer", "()Ljava/util/UUID;", "getSuspect", "getReason", "()Ljava/lang/String;", "getFiledAt", "()Ljava/time/Instant;", "toSummary", "zoneId", "Ljava/time/ZoneId;", "formatter", "Ljava/time/format/DateTimeFormatter;", "component1", "component2", "component3", "component4", "component5", "copy", "equals", "", "other", "hashCode", "toString", "Companion", "PunisherX"})
public final class ReportData {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private final int id;
    @NotNull
    private final UUID player;
    @NotNull
    private final UUID suspect;
    @NotNull
    private final String reason;
    @NotNull
    private final Instant filedAt;
    @NotNull
    private static final DateTimeFormatter DEFAULT_FORMATTER;

    public ReportData(int id, @NotNull UUID player, @NotNull UUID suspect, @NotNull String reason, @NotNull Instant filedAt) {
        Intrinsics.checkNotNullParameter(player, "player");
        Intrinsics.checkNotNullParameter(suspect, "suspect");
        Intrinsics.checkNotNullParameter(reason, "reason");
        Intrinsics.checkNotNullParameter(filedAt, "filedAt");
        this.id = id;
        this.player = player;
        this.suspect = suspect;
        this.reason = reason;
        this.filedAt = filedAt;
    }

    public final int getId() {
        return this.id;
    }

    @NotNull
    public final UUID getPlayer() {
        return this.player;
    }

    @NotNull
    public final UUID getSuspect() {
        return this.suspect;
    }

    @NotNull
    public final String getReason() {
        return this.reason;
    }

    @NotNull
    public final Instant getFiledAt() {
        return this.filedAt;
    }

    @NotNull
    public final String toSummary(@NotNull ZoneId zoneId, @NotNull DateTimeFormatter formatter) {
        Intrinsics.checkNotNullParameter(zoneId, "zoneId");
        Intrinsics.checkNotNullParameter(formatter, "formatter");
        String timestamp = formatter.format(this.filedAt.atZone(zoneId));
        return "#" + this.id + " " + this.player + " -> " + this.suspect + " @ " + timestamp + ": " + this.reason;
    }

    public static /* synthetic */ String toSummary$default(ReportData reportData, ZoneId zoneId, DateTimeFormatter dateTimeFormatter, int n, Object object) {
        if ((n & 1) != 0) {
            ZoneId zoneId2 = ZoneId.systemDefault();
            Intrinsics.checkNotNullExpressionValue(zoneId2, "systemDefault(...)");
            zoneId = zoneId2;
        }
        if ((n & 2) != 0) {
            dateTimeFormatter = DEFAULT_FORMATTER;
        }
        return reportData.toSummary(zoneId, dateTimeFormatter);
    }

    public final int component1() {
        return this.id;
    }

    @NotNull
    public final UUID component2() {
        return this.player;
    }

    @NotNull
    public final UUID component3() {
        return this.suspect;
    }

    @NotNull
    public final String component4() {
        return this.reason;
    }

    @NotNull
    public final Instant component5() {
        return this.filedAt;
    }

    @NotNull
    public final ReportData copy(int id, @NotNull UUID player, @NotNull UUID suspect, @NotNull String reason, @NotNull Instant filedAt) {
        Intrinsics.checkNotNullParameter(player, "player");
        Intrinsics.checkNotNullParameter(suspect, "suspect");
        Intrinsics.checkNotNullParameter(reason, "reason");
        Intrinsics.checkNotNullParameter(filedAt, "filedAt");
        return new ReportData(id, player, suspect, reason, filedAt);
    }

    public static /* synthetic */ ReportData copy$default(ReportData reportData, int n, UUID uUID, UUID uUID2, String string, Instant instant, int n2, Object object) {
        if ((n2 & 1) != 0) {
            n = reportData.id;
        }
        if ((n2 & 2) != 0) {
            uUID = reportData.player;
        }
        if ((n2 & 4) != 0) {
            uUID2 = reportData.suspect;
        }
        if ((n2 & 8) != 0) {
            string = reportData.reason;
        }
        if ((n2 & 0x10) != 0) {
            instant = reportData.filedAt;
        }
        return reportData.copy(n, uUID, uUID2, string, instant);
    }

    @NotNull
    public String toString() {
        return "ReportData(id=" + this.id + ", player=" + this.player + ", suspect=" + this.suspect + ", reason=" + this.reason + ", filedAt=" + this.filedAt + ")";
    }

    public int hashCode() {
        int result = Integer.hashCode(this.id);
        result = result * 31 + this.player.hashCode();
        result = result * 31 + this.suspect.hashCode();
        result = result * 31 + this.reason.hashCode();
        result = result * 31 + this.filedAt.hashCode();
        return result;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof ReportData)) {
            return false;
        }
        ReportData reportData = (ReportData)other;
        if (this.id != reportData.id) {
            return false;
        }
        if (!Intrinsics.areEqual(this.player, reportData.player)) {
            return false;
        }
        if (!Intrinsics.areEqual(this.suspect, reportData.suspect)) {
            return false;
        }
        if (!Intrinsics.areEqual(this.reason, reportData.reason)) {
            return false;
        }
        return Intrinsics.areEqual(this.filedAt, reportData.filedAt);
    }

    static {
        DateTimeFormatter dateTimeFormatter = DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss");
        Intrinsics.checkNotNullExpressionValue(dateTimeFormatter, "ofPattern(...)");
        DEFAULT_FORMATTER = dateTimeFormatter;
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lpl/syntaxdevteam/punisher/databases/ReportData$Companion;", "", "<init>", "()V", "DEFAULT_FORMATTER", "Ljava/time/format/DateTimeFormatter;", "PunisherX"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

