/*
 * Decompiled with CFR 0.152.
 */
package pl.syntaxdevteam.punisher.databases;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.nio.charset.Charset;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.time.Instant;
import java.time.LocalDate;
import java.time.ZoneId;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.atomic.AtomicBoolean;
import kotlin.Metadata;
import kotlin.Result;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.io.FilesKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.Charsets;
import kotlin.text.StringsKt;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.plugin.Plugin;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import pl.syntaxdevteam.core.database.Column;
import pl.syntaxdevteam.core.database.DatabaseConfig;
import pl.syntaxdevteam.core.database.DatabaseManager;
import pl.syntaxdevteam.core.database.DatabaseType;
import pl.syntaxdevteam.core.database.TableSchema;
import pl.syntaxdevteam.core.logging.Logger;
import pl.syntaxdevteam.punisher.PunisherX;
import pl.syntaxdevteam.punisher.databases.DatabaseHealthCheckResult;
import pl.syntaxdevteam.punisher.databases.PunishmentData;
import pl.syntaxdevteam.punisher.databases.ReportData;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u00a4\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0010\u0011\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0002\b\u0006\n\u0002\u0010\t\n\u0002\b\u000b\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010!\n\u0002\b\f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u00002\u00020\u0001:\u0001eB\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0006\u0010\u0010\u001a\u00020\u0011J\u0006\u0010\u0012\u001a\u00020\tJ\u0006\u0010\u0013\u001a\u00020\u0014J\b\u0010\u0015\u001a\u00020\u0016H\u0002J\u0006\u0010\u0017\u001a\u00020\u0011J)\u0010\u0018\u001a\u00020\u00112\u0006\u0010\u0019\u001a\u00020\u00162\u0012\u0010\u001a\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00010\u001b\"\u00020\u0001H\u0002\u00a2\u0006\u0002\u0010\u001cJI\u0010\u001d\u001a\b\u0012\u0004\u0012\u0002H\u001f0\u001e\"\u0004\b\u0000\u0010\u001f2\u0006\u0010\u0019\u001a\u00020\u00162\u0012\u0010\u001a\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00010\u001b\"\u00020\u00012\u0012\u0010 \u001a\u000e\u0012\u0004\u0012\u00020\"\u0012\u0004\u0012\u0002H\u001f0!H\u0002\u00a2\u0006\u0002\u0010#J\b\u0010$\u001a\u00020\u0016H\u0002J\b\u0010%\u001a\u00020\u0016H\u0002J\b\u0010&\u001a\u00020\u0016H\u0002J\u0006\u0010'\u001a\u00020\u0011J>\u0010(\u001a\u00020)2\u0006\u0010*\u001a\u00020\u00162\u0006\u0010+\u001a\u00020\u00162\u0006\u0010,\u001a\u00020\u00162\u0006\u0010-\u001a\u00020\u00162\u0006\u0010.\u001a\u00020\u00162\u0006\u0010/\u001a\u0002002\u0006\u00101\u001a\u000200J&\u00102\u001a\u00020\u00112\u0006\u00103\u001a\u00020\u00162\u0006\u00104\u001a\u00020\u00162\u0006\u0010,\u001a\u00020\u00162\u0006\u00101\u001a\u000200J>\u00105\u001a\u00020\u00112\u0006\u0010*\u001a\u00020\u00162\u0006\u0010+\u001a\u00020\u00162\u0006\u0010,\u001a\u00020\u00162\u0006\u0010-\u001a\u00020\u00162\u0006\u0010.\u001a\u00020\u00162\u0006\u0010/\u001a\u0002002\u0006\u00101\u001a\u000200J \u00106\u001a\u00020\u00112\u0006\u00107\u001a\u00020\u00162\u0006\u0010.\u001a\u00020\u00162\b\b\u0002\u00108\u001a\u00020)J\u000e\u00109\u001a\u00020\u00112\u0006\u0010+\u001a\u00020\u0016J\u001e\u0010:\u001a\u00020)2\u0006\u0010;\u001a\u00020<2\u0006\u0010=\u001a\u00020<2\u0006\u0010,\u001a\u00020\u0016J\u000e\u0010>\u001a\u00020)2\u0006\u0010?\u001a\u00020@J)\u0010A\u001a\b\u0012\u0004\u0012\u00020B0\u001e2\n\b\u0002\u0010C\u001a\u0004\u0018\u00010@2\n\b\u0002\u0010D\u001a\u0004\u0018\u00010@\u00a2\u0006\u0002\u0010EJ\u0016\u0010F\u001a\u00020)2\u0006\u0010?\u001a\u00020@2\u0006\u0010G\u001a\u00020\u0016J\u000e\u0010H\u001a\u00020\u00112\u0006\u0010I\u001a\u00020\u0016J\f\u0010J\u001a\b\u0012\u0004\u0012\u00020\u00160\u001eJ\u0014\u0010K\u001a\u00020\u00112\f\u0010L\u001a\b\u0012\u0004\u0012\u00020\u00160\u001eJ1\u0010M\u001a\b\u0012\u0004\u0012\u00020N0\u001e2\u0006\u0010+\u001a\u00020\u00162\n\b\u0002\u0010C\u001a\u0004\u0018\u00010@2\n\b\u0002\u0010D\u001a\u0004\u0018\u00010@\u00a2\u0006\u0002\u0010OJ\u0010\u0010P\u001a\u0004\u0018\u00010\u00162\u0006\u0010+\u001a\u00020<J\u0014\u0010Q\u001a\b\u0012\u0004\u0012\u00020N0\u001e2\u0006\u0010R\u001a\u00020\u0016J1\u0010S\u001a\b\u0012\u0004\u0012\u00020N0T2\u0006\u0010+\u001a\u00020\u00162\n\b\u0002\u0010C\u001a\u0004\u0018\u00010@2\n\b\u0002\u0010D\u001a\u0004\u0018\u00010@\u00a2\u0006\u0002\u0010OJ\u001c\u0010U\u001a\b\u0012\u0004\u0012\u00020N0T2\u0006\u0010C\u001a\u00020@2\u0006\u0010D\u001a\u00020@J\u001c\u0010V\u001a\b\u0012\u0004\u0012\u00020N0T2\u0006\u0010C\u001a\u00020@2\u0006\u0010D\u001a\u00020@J\u001c\u0010W\u001a\b\u0012\u0004\u0012\u00020N0T2\u0006\u0010C\u001a\u00020@2\u0006\u0010D\u001a\u00020@J\u000e\u0010X\u001a\u00020@2\u0006\u0010+\u001a\u00020\u0016J\u0006\u0010Y\u001a\u00020@J\u0006\u0010Z\u001a\u00020@J\u0006\u0010[\u001a\u00020@J\u000e\u0010\\\u001a\u00020@2\u0006\u0010+\u001a\u00020<J\u0014\u0010]\u001a\b\u0012\u0004\u0012\u00020N0\u001e2\u0006\u0010+\u001a\u00020\u0016J\u0006\u0010^\u001a\u00020\u0011J\u0006\u0010_\u001a\u00020\u0011J\u001c\u0010`\u001a\b\u0012\u0004\u0012\u00020b0a2\u0006\u0010c\u001a\u00020\t2\u0006\u0010d\u001a\u00020\tR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006f"}, d2={"Lpl/syntaxdevteam/punisher/databases/DatabaseHandler;", "", "plugin", "Lpl/syntaxdevteam/punisher/PunisherX;", "<init>", "(Lpl/syntaxdevteam/punisher/PunisherX;)V", "logger", "Lpl/syntaxdevteam/core/logging/Logger;", "dbType", "Lpl/syntaxdevteam/core/database/DatabaseType;", "config", "Lpl/syntaxdevteam/core/database/DatabaseConfig;", "db", "Lpl/syntaxdevteam/core/database/DatabaseManager;", "migrationInProgress", "Ljava/util/concurrent/atomic/AtomicBoolean;", "openConnection", "", "databaseType", "runHealthCheck", "Lpl/syntaxdevteam/punisher/databases/DatabaseHealthCheckResult;", "resolveDatabaseName", "", "closeConnection", "execute", "sql", "params", "", "(Ljava/lang/String;[Ljava/lang/Object;)V", "query", "", "T", "mapper", "Lkotlin/Function1;", "Ljava/sql/ResultSet;", "(Ljava/lang/String;[Ljava/lang/Object;Lkotlin/jvm/functions/Function1;)Ljava/util/List;", "idDefinition", "reportReasonDefinition", "reportFiledAtDefinition", "createTables", "addPunishment", "", "name", "uuid", "reason", "operator", "punishmentType", "start", "", "end", "enqueueBridgeEvent", "action", "target", "addPunishmentHistory", "removePunishment", "uuidOrIp", "removeAll", "deletePlayerData", "addReport", "player", "Ljava/util/UUID;", "suspect", "deleteReport", "id", "", "getReports", "Lpl/syntaxdevteam/punisher/databases/ReportData;", "limit", "offset", "(Ljava/lang/Integer;Ljava/lang/Integer;)Ljava/util/List;", "updatePunishmentReason", "newReason", "savePlayerCacheLine", "data", "getPlayerCacheLines", "overwritePlayerCache", "lines", "getPunishments", "Lpl/syntaxdevteam/punisher/databases/PunishmentData;", "(Ljava/lang/String;Ljava/lang/Integer;Ljava/lang/Integer;)Ljava/util/List;", "getActivePunishmentsString", "getPunishmentsByIP", "ip", "getPunishmentHistory", "", "getBannedPlayers", "getHistoryBannedPlayers", "getJailedPlayers", "getActiveWarnCount", "countAllPunishments", "countAllPunishmentHistory", "countTodayPunishments", "countPlayerAllPunishmentHistory", "getLastTenPunishments", "exportDatabase", "importDatabase", "migrateDatabase", "Ljava/util/concurrent/CompletableFuture;", "Lpl/syntaxdevteam/punisher/databases/DatabaseHandler$MigrationResult;", "from", "to", "MigrationResult", "PunisherX"})
@SourceDebugExtension(value={"SMAP\nDatabaseHandler.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DatabaseHandler.kt\npl/syntaxdevteam/punisher/databases/DatabaseHandler\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n+ 4 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 5 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n*L\n1#1,886:1\n1#2:887\n37#3,2:888\n37#3,2:890\n37#3,2:894\n37#3,2:907\n37#3,2:909\n37#3,2:911\n37#3,2:913\n1869#4,2:892\n827#4:896\n855#4,2:897\n1869#4,2:899\n774#4:901\n865#4,2:902\n774#4:904\n865#4,2:905\n1869#4:915\n1878#4,2:916\n1880#4:921\n1870#4:922\n1869#4,2:923\n13870#5,3:918\n*S KotlinDebug\n*F\n+ 1 DatabaseHandler.kt\npl/syntaxdevteam/punisher/databases/DatabaseHandler\n*L\n266#1:888,2\n332#1:890,2\n419#1:894,2\n487#1:907,2\n522#1:909,2\n557#1:911,2\n592#1:913,2\n391#1:892,2\n431#1:896\n431#1:897,2\n432#1:899,2\n434#1:901\n434#1:902,2\n463#1:904\n463#1:905,2\n707#1:915\n717#1:916,2\n717#1:921\n707#1:922\n806#1:923,2\n720#1:918,3\n*E\n"})
public final class DatabaseHandler {
    @NotNull
    private final PunisherX plugin;
    @NotNull
    private final Logger logger;
    @NotNull
    private final DatabaseType dbType;
    @NotNull
    private final DatabaseConfig config;
    @NotNull
    private final DatabaseManager db;
    @NotNull
    private final AtomicBoolean migrationInProgress;

    /*
     * Unable to fully structure code
     */
    public DatabaseHandler(@NotNull PunisherX plugin) {
        Intrinsics.checkNotNullParameter((Object)plugin, "plugin");
        super();
        this.plugin = plugin;
        this.logger = this.plugin.getLogger();
        v0 = this;
        var2_2 = this.plugin.getConfig().getString("database.type");
        if (var2_2 == null) ** GOTO lbl-1000
        v1 = var2_2.toUpperCase(Locale.ROOT);
        Intrinsics.checkNotNullExpressionValue(v1, "toUpperCase(...)");
        var3_3 = v1;
        if (var3_3 == null) ** GOTO lbl-1000
        var6_4 = var3_3;
        var8_5 = v0;
        $i$a$-let-DatabaseHandler$dbType$1 = false;
        v0 = var8_5;
        var4_7 = DatabaseType.valueOf((String)it);
        if (var4_7 != null) {
            v2 = var4_7;
        } else lbl-1000:
        // 3 sources

        {
            v2 = v0.dbType = DatabaseType.SQLITE;
        }
        if ((v3 = this.plugin.getConfig().getString("database.sql.host")) == null) {
            v3 = "localhost";
        }
        var3_3 = this.plugin.getConfig().getInt("database.sql.port");
        var4_8 = ((Number)var3_3).intValue();
        var10_9 = v3;
        var9_10 = this.dbType;
        var8_5 = this;
        $i$a$-takeIf-DatabaseHandler$config$1 = false;
        var11_12 = it != false;
        v4 = var11_12 != false ? var3_3 : null;
        v5 = v4 != null ? v4.intValue() : 3306;
        v6 = this.resolveDatabaseName();
        v7 = this.plugin.getConfig().getString("database.sql.username");
        if (v7 == null) {
            v7 = "ROOT";
        }
        if ((v8 = this.plugin.getConfig().getString("database.sql.password")) == null) {
            v8 = "U5eV3ryStr0ngP4ssw0rd";
        }
        var12_13 = null;
        var13_14 = 64;
        var14_15 = null;
        var15_16 = v8;
        var16_17 = v7;
        var17_18 = v6;
        var18_19 = v5;
        var19_20 = var10_9;
        var20_21 = var9_10;
        var8_5.config = new DatabaseConfig(var20_21, var19_20, var18_19, var17_18, var16_17, var15_16, var14_15, var13_14, var12_13);
        this.db = new DatabaseManager(this.config, this.logger);
        this.migrationInProgress = new AtomicBoolean(false);
    }

    public final void openConnection() {
        this.db.connect();
    }

    @NotNull
    public final DatabaseType databaseType() {
        return this.dbType;
    }

    @NotNull
    public final DatabaseHealthCheckResult runHealthCheck() {
        DatabaseHealthCheckResult databaseHealthCheckResult;
        long start = System.currentTimeMillis();
        try {
            this.db.query("SELECT 1", new Object[0], DatabaseHandler::runHealthCheck$lambda$0);
            long duration = System.currentTimeMillis() - start;
            databaseHealthCheckResult = new DatabaseHealthCheckResult(this.dbType, true, "Connection and simple query succeeded.", duration);
        }
        catch (Exception exception) {
            long duration = System.currentTimeMillis() - start;
            String string = exception.getMessage();
            if (string == null) {
                string = "Unknown database error";
            }
            databaseHealthCheckResult = new DatabaseHealthCheckResult(this.dbType, false, string, duration);
        }
        return databaseHealthCheckResult;
    }

    private final String resolveDatabaseName() {
        String string = this.plugin.getConfig().getString("database.sql.dbname");
        if (string == null) {
            String string2 = this.plugin.getName();
            string = string2;
            Intrinsics.checkNotNullExpressionValue(string2, "getName(...)");
        }
        String configuredName = string;
        return switch (WhenMappings.$EnumSwitchMapping$0[this.dbType.ordinal()]) {
            case 1, 2 -> {
                File var4_2;
                File $this$resolveDatabaseName_u24lambda_u240 = var4_2 = this.plugin.getDataFolder();
                boolean $i$a$-apply-DatabaseHandler$resolveDatabaseName$dataFolder$1 = false;
                $this$resolveDatabaseName_u24lambda_u240.mkdirs();
                File v2 = var4_2;
                Intrinsics.checkNotNullExpressionValue(v2, "apply(...)");
                File dataFolder = v2;
                String var2_6 = new File(dataFolder, configuredName).getAbsolutePath();
                Intrinsics.checkNotNull(var2_6);
                yield var2_6;
            }
            default -> configuredName;
        };
    }

    public final void closeConnection() {
        this.db.close();
    }

    private final void execute(String sql, Object ... params) {
        this.db.execute(sql, Arrays.copyOf(params, params.length));
    }

    private final <T> List<T> query(String sql, Object[] params, Function1<? super ResultSet, ? extends T> mapper) {
        return this.db.query(sql, Arrays.copyOf(params, params.length), arg_0 -> DatabaseHandler.query$lambda$0(mapper, arg_0));
    }

    private final String idDefinition() {
        return switch (WhenMappings.$EnumSwitchMapping$0[this.dbType.ordinal()]) {
            case 2 -> "INTEGER PRIMARY KEY AUTOINCREMENT";
            case 3 -> "SERIAL PRIMARY KEY";
            default -> "INT AUTO_INCREMENT PRIMARY KEY";
        };
    }

    private final String reportReasonDefinition() {
        return switch (WhenMappings.$EnumSwitchMapping$0[this.dbType.ordinal()]) {
            case 1, 2, 3, 4, 5 -> "TEXT";
            default -> "NVARCHAR(MAX)";
        };
    }

    private final String reportFiledAtDefinition() {
        return switch (WhenMappings.$EnumSwitchMapping$0[this.dbType.ordinal()]) {
            case 2 -> "DATETIME DEFAULT CURRENT_TIMESTAMP";
            case 1, 3 -> "TIMESTAMP DEFAULT CURRENT_TIMESTAMP";
            case 4, 5 -> "TIMESTAMP DEFAULT CURRENT_TIMESTAMP";
            default -> "DATETIME2 DEFAULT SYSDATETIME()";
        };
    }

    public final void createTables() {
        Column[] columnArray = new Column[]{new Column("id", this.idDefinition()), new Column("name", "VARCHAR(32)"), new Column("uuid", "VARCHAR(36)"), new Column("reason", "VARCHAR(255)"), new Column("operator", "VARCHAR(16)"), new Column("punishmentType", "VARCHAR(16)"), new Column("start", "BIGINT"), new Column("endTime", "BIGINT")};
        TableSchema punishmentSchema = new TableSchema("punishments", CollectionsKt.listOf(columnArray));
        TableSchema historySchema = TableSchema.copy$default((TableSchema)punishmentSchema, (String)"punishmenthistory", null, (int)2, null);
        this.db.createTable(punishmentSchema);
        this.db.createTable(historySchema);
        Column[] columnArray2 = new Column[]{new Column("id", this.idDefinition()), new Column("data", "TEXT")};
        TableSchema playerCacheSchema = new TableSchema("playercache", CollectionsKt.listOf(columnArray2));
        this.db.createTable(playerCacheSchema);
        Column[] columnArray3 = new Column[]{new Column("id", this.idDefinition()), new Column("player", "VARCHAR(36)"), new Column("suspect", "VARCHAR(36)"), new Column("reason", this.reportReasonDefinition()), new Column("filedAt", this.reportFiledAtDefinition())};
        TableSchema reportsSchema = new TableSchema("reports", CollectionsKt.listOf(columnArray3));
        this.db.createTable(reportsSchema);
        Column[] columnArray4 = new Column[]{new Column("id", this.idDefinition()), new Column("action", "VARCHAR(16) NOT NULL"), new Column("target", "VARCHAR(64) NOT NULL"), new Column("reason", "TEXT"), new Column("endTime", "BIGINT NOT NULL"), new Column("processed", "TINYINT DEFAULT 0"), new Column("processedAt", "BIGINT")};
        TableSchema bridgeQueueSchema = new TableSchema("bridge_events", CollectionsKt.listOf(columnArray4));
        this.db.createTable(bridgeQueueSchema);
    }

    public final boolean addPunishment(@NotNull String name, @NotNull String uuid, @NotNull String reason, @NotNull String operator, @NotNull String punishmentType, long start, long end) {
        boolean bl;
        Intrinsics.checkNotNullParameter(name, "name");
        Intrinsics.checkNotNullParameter(uuid, "uuid");
        Intrinsics.checkNotNullParameter(reason, "reason");
        Intrinsics.checkNotNullParameter(operator, "operator");
        Intrinsics.checkNotNullParameter(punishmentType, "punishmentType");
        try {
            Object[] objectArray = new Object[]{name, uuid, reason, operator, punishmentType, start, end};
            this.execute("INSERT INTO punishments (name, uuid, reason, operator, punishmentType, start, endTime)\nVALUES (?, ?, ?, ?, ?, ?, ?)", objectArray);
            this.plugin.getDiscordWebhook().sendPunishmentWebhook(name, operator, reason, punishmentType, end);
            bl = true;
        }
        catch (Exception e) {
            this.logger.err("Failed to add punishment for player " + name + ". " + e.getMessage());
            bl = false;
        }
        return bl;
    }

    public final void enqueueBridgeEvent(@NotNull String action, @NotNull String target, @NotNull String reason, long end) {
        block2: {
            Object object;
            Intrinsics.checkNotNullParameter(action, "action");
            Intrinsics.checkNotNullParameter(target, "target");
            Intrinsics.checkNotNullParameter(reason, "reason");
            Object object2 = this;
            try {
                DatabaseHandler $this$enqueueBridgeEvent_u24lambda_u240 = object2;
                boolean bl = false;
                Object[] objectArray = new Object[4];
                Intrinsics.checkNotNullExpressionValue(action.toUpperCase(Locale.ROOT), "toUpperCase(...)");
                objectArray[1] = target;
                objectArray[2] = reason;
                objectArray[3] = end;
                $this$enqueueBridgeEvent_u24lambda_u240.execute("INSERT INTO bridge_events (action, target, reason, endTime, processed)\nVALUES (?, ?, ?, ?, 0)", objectArray);
                object = Result.constructor-impl(Unit.INSTANCE);
            }
            catch (Throwable bl) {
                object = Result.constructor-impl(ResultKt.createFailure(bl));
            }
            object2 = object;
            Throwable throwable = Result.exceptionOrNull-impl(object2);
            if (throwable == null) break block2;
            Object exception = object = throwable;
            boolean bl = false;
            this.logger.err("Failed to enqueue bridge event for " + action + " on " + target + ": " + ((Throwable)exception).getMessage());
        }
    }

    public final void addPunishmentHistory(@NotNull String name, @NotNull String uuid, @NotNull String reason, @NotNull String operator, @NotNull String punishmentType, long start, long end) {
        Intrinsics.checkNotNullParameter(name, "name");
        Intrinsics.checkNotNullParameter(uuid, "uuid");
        Intrinsics.checkNotNullParameter(reason, "reason");
        Intrinsics.checkNotNullParameter(operator, "operator");
        Intrinsics.checkNotNullParameter(punishmentType, "punishmentType");
        try {
            Object[] objectArray = new Object[]{name, uuid, reason, operator, punishmentType, start, end};
            this.execute("INSERT INTO punishmenthistory (name, uuid, reason, operator, punishmentType, start, endTime)\nVALUES (?, ?, ?, ?, ?, ?, ?)", objectArray);
        }
        catch (Exception e) {
            this.logger.err("Failed to add punishment history for player " + name + ". " + e.getMessage());
        }
    }

    public final void removePunishment(@NotNull String uuidOrIp, @NotNull String punishmentType, boolean removeAll) {
        Object object;
        Intrinsics.checkNotNullParameter(uuidOrIp, "uuidOrIp");
        Intrinsics.checkNotNullParameter(punishmentType, "punishmentType");
        String base = "DELETE FROM punishments WHERE uuid = ? AND punishmentType = ?";
        if (removeAll) {
            object = base;
        } else {
            switch (WhenMappings.$EnumSwitchMapping$0[this.dbType.ordinal()]) {
                case 1: 
                case 2: 
                case 3: {
                    object = base + " AND start = (SELECT start FROM punishments WHERE uuid = ? AND punishmentType = ? ORDER BY start DESC LIMIT 1)";
                    break;
                }
                default: {
                    object = base + " ORDER BY start DESC LIMIT 1";
                }
            }
        }
        String query = object;
        try {
            Object[] objectArray = new Object[]{uuidOrIp, punishmentType};
            List<Object> params = CollectionsKt.mutableListOf(objectArray);
            if (!(removeAll || this.dbType != DatabaseType.POSTGRESQL && this.dbType != DatabaseType.H2 && this.dbType != DatabaseType.SQLITE)) {
                params.add(uuidOrIp);
                params.add(punishmentType);
            }
            Collection $this$toTypedArray$iv = params;
            boolean $i$f$toTypedArray = false;
            Collection thisCollection$iv = $this$toTypedArray$iv;
            objectArray = thisCollection$iv.toArray(new Object[0]);
            this.execute(query, Arrays.copyOf(objectArray, objectArray.length));
        }
        catch (Exception e) {
            this.logger.err("Failed to remove punishment of type " + punishmentType + " for " + uuidOrIp + ". " + e.getMessage());
        }
    }

    public static /* synthetic */ void removePunishment$default(DatabaseHandler databaseHandler, String string, String string2, boolean bl, int n, Object object) {
        if ((n & 4) != 0) {
            bl = false;
        }
        databaseHandler.removePunishment(string, string2, bl);
    }

    public final void deletePlayerData(@NotNull String uuid) {
        Intrinsics.checkNotNullParameter(uuid, "uuid");
        try {
            Object[] objectArray = new Object[]{uuid};
            this.execute("DELETE FROM punishments WHERE uuid = ?", objectArray);
            objectArray = new Object[]{uuid};
            this.execute("DELETE FROM punishmenthistory WHERE uuid = ?", objectArray);
        }
        catch (Exception e) {
            this.logger.err("Failed to delete player data. " + e.getMessage());
        }
    }

    public final boolean addReport(@NotNull UUID player, @NotNull UUID suspect, @NotNull String reason) {
        boolean bl;
        Intrinsics.checkNotNullParameter(player, "player");
        Intrinsics.checkNotNullParameter(suspect, "suspect");
        Intrinsics.checkNotNullParameter(reason, "reason");
        try {
            Object[] objectArray = new Object[3];
            Intrinsics.checkNotNullExpressionValue(player.toString(), "toString(...)");
            Intrinsics.checkNotNullExpressionValue(suspect.toString(), "toString(...)");
            objectArray[2] = reason;
            this.execute("INSERT INTO reports (player, suspect, reason)\nVALUES (?, ?, ?)", objectArray);
            bl = true;
        }
        catch (Exception e) {
            this.logger.err("Failed to add report from " + player + " against " + suspect + ". " + e.getMessage());
            bl = false;
        }
        return bl;
    }

    public final boolean deleteReport(int id) {
        boolean bl;
        try {
            Object[] objectArray = new Object[]{id};
            this.execute("DELETE FROM reports WHERE id = ?", objectArray);
            bl = true;
        }
        catch (Exception e) {
            this.logger.err("Failed to delete report with ID " + id + ". " + e.getMessage());
            bl = false;
        }
        return bl;
    }

    @NotNull
    public final List<ReportData> getReports(@Nullable Integer limit, @Nullable Integer offset) {
        Object object;
        DatabaseType[] databaseTypeArray = new DatabaseType[]{DatabaseType.MYSQL, DatabaseType.MARIADB, DatabaseType.POSTGRESQL, DatabaseType.SQLITE};
        boolean supportsPagination = SetsKt.setOf(databaseTypeArray).contains(this.dbType);
        Object sql = "SELECT id, player, suspect, reason, filedAt FROM reports ORDER BY filedAt DESC, id DESC";
        List params = new ArrayList();
        if (supportsPagination && limit != null) {
            sql = (String)sql + " LIMIT ?";
            params.add(limit);
            if (offset != null) {
                sql = (String)sql + " OFFSET ?";
                params.add(offset);
            }
        } else if (!(supportsPagination || limit == null && offset == null)) {
            this.logger.warning("Pagination not supported for reports on database type " + this.dbType + ". Returning full result set.");
        }
        try {
            Collection $this$toTypedArray$iv = params;
            boolean $i$f$toTypedArray = false;
            Collection thisCollection$iv = $this$toTypedArray$iv;
            object = thisCollection$iv.toArray(new Object[0]);
            object = CollectionsKt.filterNotNull((Iterable)this.query((String)sql, Arrays.copyOf(object, ((Object[])object).length), arg_0 -> DatabaseHandler.getReports$lambda$0(this, arg_0)));
        }
        catch (Exception e) {
            this.logger.err("Failed to fetch reports. " + e.getMessage());
            object = CollectionsKt.emptyList();
        }
        return object;
    }

    public static /* synthetic */ List getReports$default(DatabaseHandler databaseHandler, Integer n, Integer n2, int n3, Object object) {
        if ((n3 & 1) != 0) {
            n = null;
        }
        if ((n3 & 2) != 0) {
            n2 = null;
        }
        return databaseHandler.getReports(n, n2);
    }

    public final boolean updatePunishmentReason(int id, @NotNull String newReason) {
        boolean bl;
        Intrinsics.checkNotNullParameter(newReason, "newReason");
        try {
            Object[] objectArray = new Object[]{newReason, id};
            this.execute("UPDATE punishmentHistory SET reason = ? WHERE id = ?", objectArray);
            bl = true;
        }
        catch (Exception e) {
            this.logger.err("Failed to update punishment reason for ID: " + id + ". " + e.getMessage());
            bl = false;
        }
        return bl;
    }

    public final void savePlayerCacheLine(@NotNull String data) {
        Intrinsics.checkNotNullParameter(data, "data");
        try {
            Object[] objectArray = new Object[]{data};
            this.execute("INSERT INTO playercache (data) VALUES (?)", objectArray);
        }
        catch (Exception e) {
            this.logger.err("Failed to save player cache line. " + e.getMessage());
        }
    }

    @NotNull
    public final List<String> getPlayerCacheLines() {
        List<String> list;
        try {
            list = this.query("SELECT data FROM playercache ORDER BY id ASC", new Object[0], DatabaseHandler::getPlayerCacheLines$lambda$0);
        }
        catch (Exception e) {
            this.logger.err("Failed to load player cache lines. " + e.getMessage());
            list = CollectionsKt.emptyList();
        }
        return list;
    }

    public final void overwritePlayerCache(@NotNull List<String> lines) {
        Intrinsics.checkNotNullParameter(lines, "lines");
        try {
            this.execute("DELETE FROM playercache", new Object[0]);
            Iterable $this$forEach$iv = lines;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                String it = (String)element$iv;
                boolean bl = false;
                Object[] objectArray = new Object[]{it};
                this.execute("INSERT INTO playercache (data) VALUES (?)", objectArray);
            }
        }
        catch (Exception e) {
            this.logger.err("Failed to overwrite player cache. " + e.getMessage());
        }
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final List<PunishmentData> getPunishments(@NotNull String uuid, @Nullable Integer limit, @Nullable Integer offset) {
        Intrinsics.checkNotNullParameter(uuid, "uuid");
        DatabaseType[] databaseTypeArray = new DatabaseType[]{DatabaseType.MYSQL, DatabaseType.MARIADB, DatabaseType.POSTGRESQL, DatabaseType.SQLITE};
        boolean supportsOrderAndLimit = SetsKt.setOf(databaseTypeArray).contains(this.dbType);
        Object sql = "SELECT * FROM punishments WHERE uuid = ?";
        Object object = new Object[]{uuid};
        List<Object> params = CollectionsKt.mutableListOf(object);
        if (supportsOrderAndLimit && limit != null && offset != null) {
            sql = (String)sql + " ORDER BY start DESC LIMIT ? OFFSET ?";
            params.add(limit);
            params.add(offset);
        }
        try {
            void $this$filterTo$iv$iv;
            PunishmentData it;
            Iterable $this$filterNotTo$iv$iv;
            Collection $this$toTypedArray$iv = params;
            boolean $i$f$toTypedArray = false;
            Iterable thisCollection$iv = $this$toTypedArray$iv;
            Object[] objectArray = thisCollection$iv.toArray(new Object[0]);
            List<PunishmentData> rows = this.query((String)sql, Arrays.copyOf(objectArray, objectArray.length), arg_0 -> DatabaseHandler.getPunishments$lambda$0(uuid, arg_0));
            Iterable $this$filterNot$iv = rows;
            boolean $i$f$filterNot = false;
            thisCollection$iv = $this$filterNot$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterNotTo = false;
            Iterator iterator2 = $this$filterNotTo$iv$iv.iterator();
            while (iterator2.hasNext()) {
                Object element$iv$iv = iterator2.next();
                it = (PunishmentData)element$iv$iv;
                boolean bl = false;
                if (this.plugin.getPunishmentManager().isPunishmentActive(it)) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            List punishmentsToRemove = (List)destination$iv$iv;
            Iterable $this$forEach$iv = punishmentsToRemove;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                PunishmentData it2 = (PunishmentData)element$iv;
                boolean bl = false;
                DatabaseHandler.removePunishment$default(this, it2.getUuid(), it2.getType(), false, 4, null);
            }
            Iterable $this$filter$iv = rows;
            boolean $i$f$filter = false;
            $this$filterNotTo$iv$iv = $this$filter$iv;
            destination$iv$iv = new ArrayList();
            boolean $i$f$filterTo = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv) {
                it = (PunishmentData)element$iv$iv;
                boolean bl = false;
                if (!this.plugin.getPunishmentManager().isPunishmentActive(it)) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            object = (List)destination$iv$iv;
        }
        catch (Exception e) {
            this.logger.err("Failed to get punishments for UUID: " + uuid + ". " + e.getMessage());
            object = CollectionsKt.emptyList();
        }
        return object;
    }

    public static /* synthetic */ List getPunishments$default(DatabaseHandler databaseHandler, String string, Integer n, Integer n2, int n3, Object object) {
        if ((n3 & 2) != 0) {
            n = null;
        }
        if ((n3 & 4) != 0) {
            n2 = null;
        }
        return databaseHandler.getPunishments(string, n, n2);
    }

    @Nullable
    public final String getActivePunishmentsString(@NotNull UUID uuid) {
        Intrinsics.checkNotNullParameter(uuid, "uuid");
        String string = uuid.toString();
        Intrinsics.checkNotNullExpressionValue(string, "toString(...)");
        List punishments = DatabaseHandler.getPunishments$default(this, string, null, null, 6, null);
        if (punishments.isEmpty()) {
            return null;
        }
        return CollectionsKt.joinToString$default(punishments, ", ", null, null, 0, null, DatabaseHandler::getActivePunishmentsString$lambda$0, 30, null);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final List<PunishmentData> getPunishmentsByIP(@NotNull String ip) {
        List list;
        Intrinsics.checkNotNullParameter(ip, "ip");
        try {
            void $this$filterTo$iv$iv;
            Object[] objectArray = new Object[]{ip};
            List<PunishmentData> rows = this.query("SELECT * FROM punishments WHERE uuid = ?", objectArray, arg_0 -> DatabaseHandler.getPunishmentsByIP$lambda$0(ip, arg_0));
            Iterable $this$filter$iv = rows;
            boolean $i$f$filter = false;
            Iterable iterable = $this$filter$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterTo = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv) {
                PunishmentData it = (PunishmentData)element$iv$iv;
                boolean bl = false;
                if (!this.plugin.getPunishmentManager().isPunishmentActive(it)) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            list = (List)destination$iv$iv;
        }
        catch (Exception e) {
            this.logger.err("Failed to get punishments for IP: " + ip + ". " + e.getMessage());
            list = CollectionsKt.emptyList();
        }
        return list;
    }

    @NotNull
    public final List<PunishmentData> getPunishmentHistory(@NotNull String uuid, @Nullable Integer limit, @Nullable Integer offset) {
        Intrinsics.checkNotNullParameter(uuid, "uuid");
        DatabaseType[] databaseTypeArray = new DatabaseType[]{DatabaseType.MYSQL, DatabaseType.MARIADB, DatabaseType.POSTGRESQL, DatabaseType.SQLITE};
        boolean supportsOrderAndLimit = SetsKt.setOf(databaseTypeArray).contains(this.dbType);
        Object sql = "SELECT * FROM punishmenthistory WHERE uuid = ?";
        Object object = new Object[]{uuid};
        List<Object> params = CollectionsKt.mutableListOf(object);
        if (supportsOrderAndLimit && limit != null && offset != null) {
            sql = (String)sql + " ORDER BY start DESC LIMIT ? OFFSET ?";
            params.add(limit);
            params.add(offset);
        }
        try {
            Collection $this$toTypedArray$iv = params;
            boolean $i$f$toTypedArray = false;
            Collection thisCollection$iv = $this$toTypedArray$iv;
            object = thisCollection$iv.toArray(new Object[0]);
            object = CollectionsKt.toMutableList((Collection)this.query((String)sql, Arrays.copyOf(object, ((Object[])object).length), arg_0 -> DatabaseHandler.getPunishmentHistory$lambda$0(uuid, arg_0)));
        }
        catch (Exception e) {
            this.logger.err("Failed to get punishment history for UUID: " + uuid + ". " + e.getMessage());
            object = new ArrayList();
        }
        return object;
    }

    public static /* synthetic */ List getPunishmentHistory$default(DatabaseHandler databaseHandler, String string, Integer n, Integer n2, int n3, Object object) {
        if ((n3 & 2) != 0) {
            n = null;
        }
        if ((n3 & 4) != 0) {
            n2 = null;
        }
        return databaseHandler.getPunishmentHistory(string, n, n2);
    }

    @NotNull
    public final List<PunishmentData> getBannedPlayers(int limit, int offset) {
        Object object;
        DatabaseType[] databaseTypeArray = new DatabaseType[]{DatabaseType.MYSQL, DatabaseType.MARIADB, DatabaseType.POSTGRESQL, DatabaseType.SQLITE};
        boolean supportsOrderAndLimit = SetsKt.setOf(databaseTypeArray).contains(this.dbType);
        Object sql = "SELECT * FROM punishments WHERE punishmentType IN ('BAN', 'BANIP')";
        List params = new ArrayList();
        if (supportsOrderAndLimit) {
            sql = (String)sql + " ORDER BY start DESC LIMIT ? OFFSET ?";
            params.add(limit);
            params.add(offset);
        }
        try {
            Collection $this$toTypedArray$iv = params;
            boolean $i$f$toTypedArray = false;
            Collection thisCollection$iv = $this$toTypedArray$iv;
            object = thisCollection$iv.toArray(new Object[0]);
            object = CollectionsKt.toMutableList((Collection)this.query((String)sql, Arrays.copyOf(object, ((Object[])object).length), DatabaseHandler::getBannedPlayers$lambda$0));
        }
        catch (Exception e) {
            this.logger.err("Failed to get banned players: " + e.getMessage());
            object = (Object[])new ArrayList();
        }
        return object;
    }

    @NotNull
    public final List<PunishmentData> getHistoryBannedPlayers(int limit, int offset) {
        Object object;
        DatabaseType[] databaseTypeArray = new DatabaseType[]{DatabaseType.MYSQL, DatabaseType.MARIADB, DatabaseType.POSTGRESQL, DatabaseType.SQLITE};
        boolean supportsOrderAndLimit = SetsKt.setOf(databaseTypeArray).contains(this.dbType);
        Object sql = "SELECT * FROM punishmenthistory WHERE punishmentType IN ('BAN', 'BANIP')";
        List params = new ArrayList();
        if (supportsOrderAndLimit) {
            sql = (String)sql + " ORDER BY start DESC LIMIT ? OFFSET ?";
            params.add(limit);
            params.add(offset);
        }
        try {
            Collection $this$toTypedArray$iv = params;
            boolean $i$f$toTypedArray = false;
            Collection thisCollection$iv = $this$toTypedArray$iv;
            object = thisCollection$iv.toArray(new Object[0]);
            object = CollectionsKt.toMutableList((Collection)this.query((String)sql, Arrays.copyOf(object, ((Object[])object).length), DatabaseHandler::getHistoryBannedPlayers$lambda$0));
        }
        catch (Exception e) {
            this.logger.err("Failed to get banned players: " + e.getMessage());
            object = (Object[])new ArrayList();
        }
        return object;
    }

    @NotNull
    public final List<PunishmentData> getJailedPlayers(int limit, int offset) {
        Object object;
        DatabaseType[] databaseTypeArray = new DatabaseType[]{DatabaseType.MYSQL, DatabaseType.MARIADB, DatabaseType.POSTGRESQL, DatabaseType.SQLITE};
        boolean supportsOrderAndLimit = SetsKt.setOf(databaseTypeArray).contains(this.dbType);
        Object sql = "SELECT * FROM punishments WHERE punishmentType = 'JAIL'";
        List params = new ArrayList();
        if (supportsOrderAndLimit) {
            sql = (String)sql + " ORDER BY start DESC LIMIT ? OFFSET ?";
            params.add(limit);
            params.add(offset);
        }
        try {
            Collection $this$toTypedArray$iv = params;
            boolean $i$f$toTypedArray = false;
            Collection thisCollection$iv = $this$toTypedArray$iv;
            object = thisCollection$iv.toArray(new Object[0]);
            object = CollectionsKt.toMutableList((Collection)this.query((String)sql, Arrays.copyOf(object, ((Object[])object).length), DatabaseHandler::getJailedPlayers$lambda$0));
        }
        catch (Exception e) {
            this.logger.err("Failed to get jailed players: " + e.getMessage());
            object = (Object[])new ArrayList();
        }
        return object;
    }

    public final int getActiveWarnCount(@NotNull String uuid) {
        int n;
        Intrinsics.checkNotNullParameter(uuid, "uuid");
        long currentTime = System.currentTimeMillis();
        try {
            Object[] objectArray = new Object[]{uuid, currentTime};
            Integer n2 = CollectionsKt.firstOrNull(this.query("SELECT COUNT(*) AS cnt FROM punishments WHERE uuid = ? AND punishmentType = 'WARN' AND (endTime = -1 OR endTime > ?)", objectArray, DatabaseHandler::getActiveWarnCount$lambda$0));
            n = n2 != null ? n2 : 0;
        }
        catch (Exception e) {
            this.logger.err("Failed to count active warns: " + e.getMessage());
            n = 0;
        }
        return n;
    }

    public final int countAllPunishments() {
        int n;
        try {
            Integer n2 = CollectionsKt.firstOrNull(this.query("SELECT COUNT(*) AS cnt FROM punishments", new Object[0], DatabaseHandler::countAllPunishments$lambda$0));
            n = n2 != null ? n2 : 0;
        }
        catch (Exception e) {
            this.logger.err("Failed to count punishments. " + e.getMessage());
            n = 0;
        }
        return n;
    }

    public final int countAllPunishmentHistory() {
        int n;
        try {
            Integer n2 = CollectionsKt.firstOrNull(this.query("SELECT COUNT(*) AS cnt FROM punishmenthistory", new Object[0], DatabaseHandler::countAllPunishmentHistory$lambda$0));
            n = n2 != null ? n2 : 0;
        }
        catch (Exception e) {
            this.logger.err("Failed to count punishment history. " + e.getMessage());
            n = 0;
        }
        return n;
    }

    public final int countTodayPunishments() {
        int n;
        long startOfDay = LocalDate.now().atStartOfDay(ZoneId.systemDefault()).toEpochSecond() * (long)1000;
        try {
            int count = 0;
            Object[] objectArray = new Object[]{startOfDay};
            Integer n2 = CollectionsKt.firstOrNull(this.query("SELECT COUNT(*) AS cnt FROM punishments WHERE start >= ?", objectArray, DatabaseHandler::countTodayPunishments$lambda$0));
            count += n2 != null ? n2 : 0;
            objectArray = new Object[]{startOfDay};
            Integer n3 = CollectionsKt.firstOrNull(this.query("SELECT COUNT(*) AS cnt FROM punishmenthistory WHERE start >= ?", objectArray, DatabaseHandler::countTodayPunishments$lambda$1));
            count += n3 != null ? n3 : 0;
        }
        catch (Exception e) {
            this.logger.err("Failed to count today's punishments. " + e.getMessage());
            n = 0;
        }
        return n;
    }

    public final int countPlayerAllPunishmentHistory(@NotNull UUID uuid) {
        int n;
        Intrinsics.checkNotNullParameter(uuid, "uuid");
        try {
            Object[] objectArray = new Object[1];
            Intrinsics.checkNotNullExpressionValue(uuid.toString(), "toString(...)");
            Integer n2 = CollectionsKt.firstOrNull(this.query("SELECT COUNT(*) AS cnt FROM punishmenthistory WHERE uuid = ?", objectArray, DatabaseHandler::countPlayerAllPunishmentHistory$lambda$0));
            n = n2 != null ? n2 : 0;
        }
        catch (Exception e) {
            this.logger.err("Failed to count punishment history. " + e.getMessage());
            n = 0;
        }
        return n;
    }

    @NotNull
    public final List<PunishmentData> getLastTenPunishments(@NotNull String uuid) {
        Object object;
        Intrinsics.checkNotNullParameter(uuid, "uuid");
        try {
            object = new Object[]{uuid};
            object = this.query("SELECT * FROM punishmenthistory WHERE uuid = ? ORDER BY start DESC LIMIT 10", (Object[])object, arg_0 -> DatabaseHandler.getLastTenPunishments$lambda$0(uuid, arg_0));
        }
        catch (Exception e) {
            this.logger.err("Failed to get last ten punishments for UUID: " + uuid + ". " + e.getMessage());
            object = CollectionsKt.emptyList();
        }
        return object;
    }

    /*
     * WARNING - void declaration
     */
    public final void exportDatabase() {
        String[] stringArray = new String[]{"punishments", "punishmenthistory"};
        List<String> tables = CollectionsKt.listOf(stringArray);
        try {
            File file;
            File $this$exportDatabase_u24lambda_u240 = file = new File(this.plugin.getDataFolder(), "dump");
            boolean $i$a$-apply-DatabaseHandler$exportDatabase$dumpDir$22 = false;
            $this$exportDatabase_u24lambda_u240.mkdirs();
            File dumpDir = file;
            $this$exportDatabase_u24lambda_u240 = new File(dumpDir, "backup.sql");
            Charset $i$a$-apply-DatabaseHandler$exportDatabase$dumpDir$22 = Charsets.UTF_8;
            int n = 8192;
            Object object = $this$exportDatabase_u24lambda_u240;
            object = new OutputStreamWriter((OutputStream)new FileOutputStream((File)object), $i$a$-apply-DatabaseHandler$exportDatabase$dumpDir$22);
            BufferedWriter writer = object instanceof BufferedWriter ? (BufferedWriter)object : new BufferedWriter((Writer)object, n);
            Iterable $this$forEach$iv = tables;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                String table = (String)element$iv;
                boolean bl = false;
                List<Object[]> rows = this.query("SELECT * FROM " + table, new Object[0], DatabaseHandler::exportDatabase$lambda$1$0);
                if (rows.isEmpty()) continue;
                writer.write("INSERT INTO " + table + " VALUES\n");
                Iterable $this$forEachIndexed$iv = rows;
                boolean $i$f$forEachIndexed = false;
                int index$iv = 0;
                for (Object item$iv : $this$forEachIndexed$iv) {
                    void row;
                    int n2;
                    if ((n2 = index$iv++) < 0) {
                        CollectionsKt.throwIndexOverflow();
                    }
                    Object[] objectArray = (Object[])item$iv;
                    int index = n2;
                    boolean bl2 = false;
                    if (index > 0) {
                        writer.write(",\n");
                    }
                    writer.write("(");
                    void $this$forEachIndexed$iv2 = row;
                    boolean $i$f$forEachIndexed2 = false;
                    int index$iv2 = 0;
                    for (void item$iv2 : $this$forEachIndexed$iv2) {
                        void value;
                        int n3 = index$iv2++;
                        void var26_30 = item$iv2;
                        int i = n3;
                        boolean bl3 = false;
                        if (value == null) {
                            writer.write("NULL");
                        } else {
                            writer.write("'" + StringsKt.replace$default(value.toString(), "'", "''", false, 4, null) + "'");
                        }
                        if (i >= ((void)row).length - 1) continue;
                        writer.write(", ");
                    }
                    writer.write(")");
                }
                writer.write(";\n");
            }
            writer.close();
            this.logger.success("Database exported to " + dumpDir + "/backup.sql");
        }
        catch (Exception e) {
            this.logger.err("Failed to export database. " + e.getMessage());
        }
    }

    public final void importDatabase() {
        String filePath = new File(this.plugin.getDataFolder(), "dump/backup.sql").getAbsolutePath();
        try {
            List lines = FilesKt.readLines$default(new File(filePath), null, 1, null);
            StringBuilder sql = new StringBuilder();
            for (String line : lines) {
                sql.append(line);
                if (!StringsKt.endsWith$default(((Object)StringsKt.trim((CharSequence)line)).toString(), ";", false, 2, null)) continue;
                String string = sql.toString();
                Intrinsics.checkNotNullExpressionValue(string, "toString(...)");
                this.execute(string, new Object[0]);
                sql.setLength(0);
            }
            this.logger.success("Database imported from " + filePath);
        }
        catch (IOException e) {
            this.logger.err("Failed to read from file. " + e.getMessage());
        }
        catch (Exception e) {
            this.logger.err("Failed to import database. " + e.getMessage());
        }
    }

    @NotNull
    public final CompletableFuture<MigrationResult> migrateDatabase(@NotNull DatabaseType from, @NotNull DatabaseType to) {
        Intrinsics.checkNotNullParameter(from, "from");
        Intrinsics.checkNotNullParameter(to, "to");
        CompletableFuture<MigrationResult> future = new CompletableFuture<MigrationResult>();
        if (!this.migrationInProgress.compareAndSet(false, true)) {
            future.complete(new MigrationResult(false, "Another migration task is already running."));
            return future;
        }
        this.plugin.getServer().getScheduler().runTaskAsynchronously((Plugin)this.plugin, () -> DatabaseHandler.migrateDatabase$lambda$0(from, this, future, to));
        return future;
    }

    private static final String runHealthCheck$lambda$0(ResultSet resultSet) {
        Intrinsics.checkNotNullParameter(resultSet, "resultSet");
        return resultSet.getString(1);
    }

    private static final Object query$lambda$0(Function1 $tmp0, ResultSet p0) {
        Intrinsics.checkNotNullParameter(p0, "p0");
        return $tmp0.invoke(p0);
    }

    private static final ReportData getReports$lambda$0(DatabaseHandler this$0, ResultSet rs) {
        Object $this$getReports_u24lambda_u240_u242;
        Object it;
        Object $this$getReports_u24lambda_u240_u240;
        Intrinsics.checkNotNullParameter(rs, "rs");
        int id = rs.getInt("id");
        Object object = this$0;
        try {
            $this$getReports_u24lambda_u240_u240 = object;
            boolean bl = false;
            $this$getReports_u24lambda_u240_u240 = Result.constructor-impl(UUID.fromString(rs.getString("player")));
        }
        catch (Throwable bl) {
            $this$getReports_u24lambda_u240_u240 = Result.constructor-impl(ResultKt.createFailure(bl));
        }
        object = $this$getReports_u24lambda_u240_u240;
        Throwable throwable = Result.exceptionOrNull-impl(object);
        if (throwable != null) {
            it = throwable;
            boolean bl = false;
            this$0.logger.warning("Skipping report " + id + " due to invalid reporter UUID: " + rs.getString("player"));
            return null;
        }
        UUID playerId = (UUID)object;
        it = this$0;
        try {
            $this$getReports_u24lambda_u240_u242 = it;
            boolean bl = false;
            $this$getReports_u24lambda_u240_u242 = Result.constructor-impl(UUID.fromString(rs.getString("suspect")));
        }
        catch (Throwable bl) {
            $this$getReports_u24lambda_u240_u242 = Result.constructor-impl(ResultKt.createFailure(bl));
        }
        it = $this$getReports_u24lambda_u240_u242;
        Throwable throwable2 = Result.exceptionOrNull-impl(it);
        if (throwable2 != null) {
            Throwable it2 = throwable2;
            boolean bl = false;
            this$0.logger.warning("Skipping report " + id + " due to invalid suspect UUID: " + rs.getString("suspect"));
            return null;
        }
        UUID suspectId = (UUID)it;
        Comparable<Date> comparable = rs.getTimestamp("filedAt");
        if (comparable == null || (comparable = comparable.toInstant()) == null) {
            comparable = Instant.EPOCH;
        }
        Comparable<Date> filedAt = comparable;
        Intrinsics.checkNotNull(playerId);
        Intrinsics.checkNotNull(suspectId);
        String string = rs.getString("reason");
        Intrinsics.checkNotNullExpressionValue(string, "getString(...)");
        Intrinsics.checkNotNull(filedAt);
        return new ReportData(id, playerId, suspectId, string, (Instant)filedAt);
    }

    private static final String getPlayerCacheLines$lambda$0(ResultSet rs) {
        Intrinsics.checkNotNullParameter(rs, "rs");
        return rs.getString("data");
    }

    private static final PunishmentData getPunishments$lambda$0(String $uuid, ResultSet rs) {
        Intrinsics.checkNotNullParameter(rs, "rs");
        int n = rs.getInt("id");
        String string = rs.getString("punishmentType");
        Intrinsics.checkNotNullExpressionValue(string, "getString(...)");
        String string2 = rs.getString("reason");
        Intrinsics.checkNotNullExpressionValue(string2, "getString(...)");
        long l = rs.getLong("start");
        long l2 = rs.getLong("endTime");
        String string3 = rs.getString("name");
        Intrinsics.checkNotNullExpressionValue(string3, "getString(...)");
        String string4 = rs.getString("operator");
        Intrinsics.checkNotNullExpressionValue(string4, "getString(...)");
        return new PunishmentData(n, $uuid, string, string2, l, l2, string3, string4);
    }

    private static final CharSequence getActivePunishmentsString$lambda$0(PunishmentData it) {
        Intrinsics.checkNotNullParameter(it, "it");
        return it.getType();
    }

    private static final PunishmentData getPunishmentsByIP$lambda$0(String $ip, ResultSet rs) {
        Intrinsics.checkNotNullParameter(rs, "rs");
        int n = rs.getInt("id");
        String string = rs.getString("punishmentType");
        Intrinsics.checkNotNullExpressionValue(string, "getString(...)");
        String string2 = rs.getString("reason");
        Intrinsics.checkNotNullExpressionValue(string2, "getString(...)");
        long l = rs.getLong("start");
        long l2 = rs.getLong("endTime");
        String string3 = rs.getString("name");
        Intrinsics.checkNotNullExpressionValue(string3, "getString(...)");
        String string4 = rs.getString("operator");
        Intrinsics.checkNotNullExpressionValue(string4, "getString(...)");
        return new PunishmentData(n, $ip, string, string2, l, l2, string3, string4);
    }

    private static final PunishmentData getPunishmentHistory$lambda$0(String $uuid, ResultSet rs) {
        Intrinsics.checkNotNullParameter(rs, "rs");
        int n = rs.getInt("id");
        String string = rs.getString("punishmentType");
        Intrinsics.checkNotNullExpressionValue(string, "getString(...)");
        String string2 = rs.getString("reason");
        Intrinsics.checkNotNullExpressionValue(string2, "getString(...)");
        long l = rs.getLong("start");
        long l2 = rs.getLong("endTime");
        String string3 = rs.getString("name");
        Intrinsics.checkNotNullExpressionValue(string3, "getString(...)");
        String string4 = rs.getString("operator");
        Intrinsics.checkNotNullExpressionValue(string4, "getString(...)");
        return new PunishmentData(n, $uuid, string, string2, l, l2, string3, string4);
    }

    private static final PunishmentData getBannedPlayers$lambda$0(ResultSet rs) {
        Intrinsics.checkNotNullParameter(rs, "rs");
        int n = rs.getInt("id");
        String string = rs.getString("uuid");
        Intrinsics.checkNotNullExpressionValue(string, "getString(...)");
        String string2 = rs.getString("punishmentType");
        Intrinsics.checkNotNullExpressionValue(string2, "getString(...)");
        String string3 = rs.getString("reason");
        Intrinsics.checkNotNullExpressionValue(string3, "getString(...)");
        long l = rs.getLong("start");
        long l2 = rs.getLong("endTime");
        String string4 = rs.getString("name");
        Intrinsics.checkNotNullExpressionValue(string4, "getString(...)");
        String string5 = rs.getString("operator");
        Intrinsics.checkNotNullExpressionValue(string5, "getString(...)");
        return new PunishmentData(n, string, string2, string3, l, l2, string4, string5);
    }

    private static final PunishmentData getHistoryBannedPlayers$lambda$0(ResultSet rs) {
        Intrinsics.checkNotNullParameter(rs, "rs");
        int n = rs.getInt("id");
        String string = rs.getString("uuid");
        Intrinsics.checkNotNullExpressionValue(string, "getString(...)");
        String string2 = rs.getString("punishmentType");
        Intrinsics.checkNotNullExpressionValue(string2, "getString(...)");
        String string3 = rs.getString("reason");
        Intrinsics.checkNotNullExpressionValue(string3, "getString(...)");
        long l = rs.getLong("start");
        long l2 = rs.getLong("endTime");
        String string4 = rs.getString("name");
        Intrinsics.checkNotNullExpressionValue(string4, "getString(...)");
        String string5 = rs.getString("operator");
        Intrinsics.checkNotNullExpressionValue(string5, "getString(...)");
        return new PunishmentData(n, string, string2, string3, l, l2, string4, string5);
    }

    private static final PunishmentData getJailedPlayers$lambda$0(ResultSet rs) {
        Intrinsics.checkNotNullParameter(rs, "rs");
        int n = rs.getInt("id");
        String string = rs.getString("uuid");
        Intrinsics.checkNotNullExpressionValue(string, "getString(...)");
        String string2 = rs.getString("punishmentType");
        Intrinsics.checkNotNullExpressionValue(string2, "getString(...)");
        String string3 = rs.getString("reason");
        Intrinsics.checkNotNullExpressionValue(string3, "getString(...)");
        long l = rs.getLong("start");
        long l2 = rs.getLong("endTime");
        String string4 = rs.getString("name");
        Intrinsics.checkNotNullExpressionValue(string4, "getString(...)");
        String string5 = rs.getString("operator");
        Intrinsics.checkNotNullExpressionValue(string5, "getString(...)");
        return new PunishmentData(n, string, string2, string3, l, l2, string4, string5);
    }

    private static final int getActiveWarnCount$lambda$0(ResultSet rs) {
        Intrinsics.checkNotNullParameter(rs, "rs");
        return rs.getInt("cnt");
    }

    private static final int countAllPunishments$lambda$0(ResultSet rs) {
        Intrinsics.checkNotNullParameter(rs, "rs");
        return rs.getInt("cnt");
    }

    private static final int countAllPunishmentHistory$lambda$0(ResultSet rs) {
        Intrinsics.checkNotNullParameter(rs, "rs");
        return rs.getInt("cnt");
    }

    private static final int countTodayPunishments$lambda$0(ResultSet rs) {
        Intrinsics.checkNotNullParameter(rs, "rs");
        return rs.getInt("cnt");
    }

    private static final int countTodayPunishments$lambda$1(ResultSet rs) {
        Intrinsics.checkNotNullParameter(rs, "rs");
        return rs.getInt("cnt");
    }

    private static final int countPlayerAllPunishmentHistory$lambda$0(ResultSet rs) {
        Intrinsics.checkNotNullParameter(rs, "rs");
        return rs.getInt("cnt");
    }

    private static final PunishmentData getLastTenPunishments$lambda$0(String $uuid, ResultSet rs) {
        Intrinsics.checkNotNullParameter(rs, "rs");
        int n = rs.getInt("id");
        String string = rs.getString("punishmentType");
        Intrinsics.checkNotNullExpressionValue(string, "getString(...)");
        String string2 = rs.getString("reason");
        Intrinsics.checkNotNullExpressionValue(string2, "getString(...)");
        long l = rs.getLong("start");
        long l2 = rs.getLong("endTime");
        String string3 = rs.getString("name");
        Intrinsics.checkNotNullExpressionValue(string3, "getString(...)");
        String string4 = rs.getString("operator");
        Intrinsics.checkNotNullExpressionValue(string4, "getString(...)");
        return new PunishmentData(n, $uuid, string, string2, l, l2, string3, string4);
    }

    private static final Object[] exportDatabase$lambda$1$0(ResultSet rs) {
        Intrinsics.checkNotNullParameter(rs, "rs");
        ResultSetMetaData meta = rs.getMetaData();
        int columnCount = meta.getColumnCount();
        int n = 0;
        Object[] objectArray = new Object[columnCount];
        while (n < columnCount) {
            int n2 = n++;
            objectArray[n2] = rs.getObject(n2 + 1);
        }
        Object[] values2 = objectArray;
        return values2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * WARNING - void declaration
     */
    private static final void migrateDatabase$lambda$0(DatabaseType $from, DatabaseHandler this$0, CompletableFuture $future, DatabaseType $to) {
        block37: {
            try {
                String configuredType;
                String string;
                String string2;
                void it;
                if ($from != this$0.dbType) {
                    String message = "Migration aborted: configured database type is " + this$0.dbType + " but received " + $from;
                    this$0.logger.err(message);
                    $future.complete(new MigrationResult(false, message));
                    return;
                }
                this$0.exportDatabase();
                File backupFile = new File(this$0.plugin.getDataFolder(), "dump/backup.sql");
                if (!backupFile.exists()) {
                    String message = "Backup file not found. Migration aborted.";
                    this$0.logger.err(message);
                    $future.complete(new MigrationResult(false, message));
                    return;
                }
                File configFile = new File(this$0.plugin.getDataFolder(), "config.yml");
                YamlConfiguration yamlConfiguration = YamlConfiguration.loadConfiguration((File)configFile);
                Intrinsics.checkNotNullExpressionValue(yamlConfiguration, "loadConfiguration(...)");
                YamlConfiguration yaml = yamlConfiguration;
                String string3 = yaml.getString("database.sql.host");
                if (string3 == null) {
                    string3 = "localhost";
                }
                Integer n = yaml.getInt("database.sql.port");
                int n2 = ((Number)n).intValue();
                String string4 = string3;
                DatabaseType databaseType = $to;
                boolean $i$a$-takeIf-DatabaseHandler$migrateDatabase$1$targetConfig$23332 = false;
                boolean bl = it != false;
                Integer n3 = bl ? n : null;
                int n4 = n3 != null ? n3 : 3306;
                String string5 = yaml.getString("database.sql.dbname");
                if (string5 == null) {
                    String string6 = this$0.plugin.getName();
                    string5 = string6;
                    Intrinsics.checkNotNullExpressionValue(string6, "getName(...)");
                }
                if ((string2 = yaml.getString("database.sql.username")) == null) {
                    string2 = "ROOT";
                }
                if ((string = yaml.getString("database.sql.password")) == null) {
                    string = "U5eV3ryStr0ngP4ssw0rd";
                }
                DefaultConstructorMarker defaultConstructorMarker = null;
                int n5 = 64;
                String string7 = null;
                String string8 = string;
                String string9 = string2;
                String string10 = string5;
                int n6 = n4;
                String string11 = string4;
                DatabaseType databaseType2 = databaseType;
                DatabaseConfig targetConfig = new DatabaseConfig(databaseType2, string11, n6, string10, string9, string8, string7, n5, defaultConstructorMarker);
                DatabaseManager targetDb = new DatabaseManager(targetConfig, this$0.logger);
                targetDb.connect();
                String idDef = switch (WhenMappings.$EnumSwitchMapping$0[$to.ordinal()]) {
                    case 2 -> "INTEGER PRIMARY KEY AUTOINCREMENT";
                    case 3 -> "SERIAL PRIMARY KEY";
                    default -> "INT AUTO_INCREMENT PRIMARY KEY";
                };
                String[] $i$a$-takeIf-DatabaseHandler$migrateDatabase$1$targetConfig$23332 = new String[]{"punishments", "punishmenthistory"};
                List<String> tables = CollectionsKt.listOf($i$a$-takeIf-DatabaseHandler$migrateDatabase$1$targetConfig$23332);
                Iterable $this$forEach$iv = tables;
                boolean $i$f$forEach23332 = false;
                for (Object element$iv : $this$forEach$iv) {
                    String table = (String)element$iv;
                    boolean bl2 = false;
                    try {
                        targetDb.execute("DROP TABLE IF EXISTS " + (String)table, new Object[0]);
                    }
                    catch (Exception dropError) {
                        this$0.logger.warning("Unable to drop table '" + (String)table + "' before migration: " + dropError.getMessage());
                    }
                }
                Column[] $i$f$forEach23332 = new Column[]{new Column("id", idDef), new Column("name", "VARCHAR(32)"), new Column("uuid", "VARCHAR(36)"), new Column("reason", "VARCHAR(255)"), new Column("operator", "VARCHAR(16)"), new Column("punishmentType", "VARCHAR(16)"), new Column("start", "BIGINT"), new Column("endTime", "BIGINT")};
                TableSchema punishmentSchema = new TableSchema("punishments", CollectionsKt.listOf($i$f$forEach23332));
                TableSchema historySchema = TableSchema.copy$default((TableSchema)punishmentSchema, (String)"punishmenthistory", null, (int)2, null);
                targetDb.createTable(punishmentSchema);
                targetDb.createTable(historySchema);
                List lines = FilesKt.readLines$default(backupFile, null, 1, null);
                StringBuilder sql = new StringBuilder();
                for (String line : lines) {
                    String trimmedLine = ((Object)StringsKt.trim((CharSequence)line)).toString();
                    if (((CharSequence)trimmedLine).length() == 0 || StringsKt.startsWith$default(trimmedLine, "--", false, 2, null)) continue;
                    sql.append(line);
                    if (!StringsKt.endsWith$default(trimmedLine, ";", false, 2, null)) continue;
                    String string12 = sql.toString();
                    Intrinsics.checkNotNullExpressionValue(string12, "toString(...)");
                    String statement = ((Object)StringsKt.trim((CharSequence)string12)).toString();
                    if (((CharSequence)statement).length() > 0) {
                        targetDb.execute(statement, new Object[0]);
                    }
                    sql.setLength(0);
                }
                String string13 = yaml.getString("database.type");
                if (string13 != null) {
                    String string14 = string13.toUpperCase(Locale.ROOT);
                    v12 = string14;
                    Intrinsics.checkNotNullExpressionValue(string14, "toUpperCase(...)");
                } else {
                    v12 = configuredType = null;
                }
                if (!Intrinsics.areEqual(configuredType, $to.name())) {
                    String string15 = $to.name().toLowerCase(Locale.ROOT);
                    Intrinsics.checkNotNullExpressionValue(string15, "toLowerCase(...)");
                    yaml.set("database.type", (Object)string15);
                    yaml.save(configFile);
                }
                this$0.logger.success("Database migrated from " + $from + " to " + $to);
                String string16 = $from.name().toLowerCase(Locale.ROOT);
                Intrinsics.checkNotNullExpressionValue(string16, "toLowerCase(...)");
                String string17 = $to.name().toLowerCase(Locale.ROOT);
                Intrinsics.checkNotNullExpressionValue(string17, "toLowerCase(...)");
                $future.complete(new MigrationResult(true, "Database migrated from " + string16 + " to " + string17));
                n = this$0.plugin.getServer().getScheduler().runTask((Plugin)this$0.plugin, () -> DatabaseHandler.migrateDatabase$lambda$0$2(this$0));
                try {
                    targetDb.close();
                }
                catch (Exception closeError) {
                    this$0.logger.warning("Failed to close target database: " + closeError.getMessage());
                }
                break block37;
                catch (Exception e) {
                    try {
                        String message = "Failed to migrate database. " + e.getMessage();
                        this$0.logger.err(message);
                        $future.complete(new MigrationResult(false, message));
                    }
                    catch (Throwable throwable) {
                        try {
                            try {
                                targetDb.close();
                            }
                            catch (Exception closeError) {
                                this$0.logger.warning("Failed to close target database: " + closeError.getMessage());
                            }
                            throw throwable;
                        }
                        catch (Exception e2) {
                            String message = "Failed to migrate database. " + e2.getMessage();
                            this$0.logger.err(message);
                            $future.complete(new MigrationResult(false, message));
                            return;
                        }
                        finally {
                        }
                    }
                    try {
                        targetDb.close();
                    }
                    catch (Exception closeError) {
                        this$0.logger.warning("Failed to close target database: " + closeError.getMessage());
                    }
                    this$0.migrationInProgress.set(false);
                    return;
                }
            }
            finally {
                this$0.migrationInProgress.set(false);
            }
        }
    }

    private static final void migrateDatabase$lambda$0$2(DatabaseHandler this$0) {
        this$0.plugin.onReload();
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\f\n\u0002\u0010\b\n\u0002\b\u0002\b\u0086\b\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\t\u0010\f\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\r\u001a\u00020\u0005H\u00c6\u0003J\u001d\u0010\u000e\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u0005H\u00c6\u0001J\u0013\u0010\u000f\u001a\u00020\u00032\b\u0010\u0010\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0011\u001a\u00020\u0012H\u00d6\u0001J\t\u0010\u0013\u001a\u00020\u0005H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\u0014"}, d2={"Lpl/syntaxdevteam/punisher/databases/DatabaseHandler$MigrationResult;", "", "success", "", "message", "", "<init>", "(ZLjava/lang/String;)V", "getSuccess", "()Z", "getMessage", "()Ljava/lang/String;", "component1", "component2", "copy", "equals", "other", "hashCode", "", "toString", "PunisherX"})
    public static final class MigrationResult {
        private final boolean success;
        @NotNull
        private final String message;

        public MigrationResult(boolean success, @NotNull String message) {
            Intrinsics.checkNotNullParameter(message, "message");
            this.success = success;
            this.message = message;
        }

        public final boolean getSuccess() {
            return this.success;
        }

        @NotNull
        public final String getMessage() {
            return this.message;
        }

        public final boolean component1() {
            return this.success;
        }

        @NotNull
        public final String component2() {
            return this.message;
        }

        @NotNull
        public final MigrationResult copy(boolean success, @NotNull String message) {
            Intrinsics.checkNotNullParameter(message, "message");
            return new MigrationResult(success, message);
        }

        public static /* synthetic */ MigrationResult copy$default(MigrationResult migrationResult, boolean bl, String string, int n, Object object) {
            if ((n & 1) != 0) {
                bl = migrationResult.success;
            }
            if ((n & 2) != 0) {
                string = migrationResult.message;
            }
            return migrationResult.copy(bl, string);
        }

        @NotNull
        public String toString() {
            return "MigrationResult(success=" + this.success + ", message=" + this.message + ")";
        }

        public int hashCode() {
            int result = Boolean.hashCode(this.success);
            result = result * 31 + this.message.hashCode();
            return result;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof MigrationResult)) {
                return false;
            }
            MigrationResult migrationResult = (MigrationResult)other;
            if (this.success != migrationResult.success) {
                return false;
            }
            return Intrinsics.areEqual(this.message, migrationResult.message);
        }
    }

    @Metadata(mv={2, 2, 0}, k=3, xi=48)
    public static final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[DatabaseType.values().length];
            try {
                nArray[DatabaseType.H2.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[DatabaseType.SQLITE.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[DatabaseType.POSTGRESQL.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[DatabaseType.MYSQL.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[DatabaseType.MARIADB.ordinal()] = 5;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

