/*
 * Decompiled with CFR 0.152.
 */
package pl.syntaxdevteam.punisher.common;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.bukkit.command.CommandSender;
import org.bukkit.configuration.ConfigurationSection;
import org.jetbrains.annotations.NotNull;
import pl.syntaxdevteam.punisher.PunisherX;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010$\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0016\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bJ,\u0010\f\u001a\u00020\u00072\u0006\u0010\r\u001a\u00020\t2\u0006\u0010\b\u001a\u00020\t2\u0014\b\u0002\u0010\u000e\u001a\u000e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\t0\u000fJ4\u0010\u0010\u001a\u00020\u00072\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0012\u0010\u000e\u001a\u000e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\t0\u000fH\u0002J.\u0010\u0013\u001a\u00020\u00072\b\u0010\u0014\u001a\u0004\u0018\u00010\u00012\u0006\u0010\b\u001a\u00020\t2\u0012\u0010\u000e\u001a\u000e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\t0\u000fH\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0015"}, d2={"Lpl/syntaxdevteam/punisher/common/PunishmentActionExecutor;", "", "plugin", "Lpl/syntaxdevteam/punisher/PunisherX;", "<init>", "(Lpl/syntaxdevteam/punisher/PunisherX;)V", "executeWarnCountActions", "", "player", "", "warnCount", "", "executeAction", "actionKey", "placeholders", "", "executeThresholdCommands", "section", "Lorg/bukkit/configuration/ConfigurationSection;", "dispatchCommands", "value", "PunisherX"})
@SourceDebugExtension(value={"SMAP\nPunishmentActionExecutor.kt\nKotlin\n*S Kotlin\n*F\n+ 1 PunishmentActionExecutor.kt\npl/syntaxdevteam/punisher/common/PunishmentActionExecutor\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n*L\n1#1,83:1\n1869#2,2:84\n808#2,11:86\n1374#2:97\n1460#2,2:98\n808#2,11:100\n1462#2,3:111\n1869#2:114\n1870#2:117\n216#3,2:115\n*S KotlinDebug\n*F\n+ 1 PunishmentActionExecutor.kt\npl/syntaxdevteam/punisher/common/PunishmentActionExecutor\n*L\n42#1:84,2\n53#1:86,11\n54#1:97\n54#1:98,2\n57#1:100,11\n54#1:111,3\n68#1:114\n68#1:117\n70#1:115,2\n*E\n"})
public final class PunishmentActionExecutor {
    @NotNull
    private final PunisherX plugin;

    public PunishmentActionExecutor(@NotNull PunisherX plugin) {
        Intrinsics.checkNotNullParameter((Object)plugin, "plugin");
        this.plugin = plugin;
    }

    public final void executeWarnCountActions(@NotNull String player, int warnCount) {
        Intrinsics.checkNotNullParameter(player, "player");
        Pair[] pairArray = new Pair[]{TuplesKt.to("player", player), TuplesKt.to("warn_no", String.valueOf(warnCount))};
        Map<String, String> placeholders = MapsKt.mapOf(pairArray);
        ConfigurationSection modernSection = this.plugin.getConfig().getConfigurationSection("actions.warn.count");
        if (modernSection != null) {
            this.executeThresholdCommands(modernSection, player, warnCount, placeholders);
            return;
        }
        ConfigurationSection legacySection = this.plugin.getConfig().getConfigurationSection("warn.actions");
        if (legacySection != null) {
            this.executeThresholdCommands(legacySection, player, warnCount, placeholders);
        }
    }

    public final void executeAction(@NotNull String actionKey, @NotNull String player, @NotNull Map<String, String> placeholders) {
        Intrinsics.checkNotNullParameter(actionKey, "actionKey");
        Intrinsics.checkNotNullParameter(player, "player");
        Intrinsics.checkNotNullParameter(placeholders, "placeholders");
        String path = "actions." + actionKey;
        if (!this.plugin.getConfig().contains(path)) {
            return;
        }
        Map<String, String> mergedPlaceholders = MapsKt.plus(placeholders, TuplesKt.to("player", player));
        this.dispatchCommands(this.plugin.getConfig().get(path), player, mergedPlaceholders);
    }

    public static /* synthetic */ void executeAction$default(PunishmentActionExecutor punishmentActionExecutor, String string, String string2, Map map, int n, Object object) {
        if ((n & 4) != 0) {
            map = MapsKt.emptyMap();
        }
        punishmentActionExecutor.executeAction(string, string2, map);
    }

    private final void executeThresholdCommands(ConfigurationSection section, String player, int warnCount, Map<String, String> placeholders) {
        Set set = section.getKeys(false);
        Intrinsics.checkNotNullExpressionValue(set, "getKeys(...)");
        Iterable $this$forEach$iv = set;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            String key = (String)element$iv;
            boolean bl = false;
            Intrinsics.checkNotNull(key);
            Integer n = StringsKt.toIntOrNull(key);
            if (n == null) {
                continue;
            }
            int threshold = n;
            if (warnCount != threshold) continue;
            this.dispatchCommands(section.get(key), player, placeholders);
        }
    }

    /*
     * WARNING - void declaration
     */
    private final void dispatchCommands(Object value, String player, Map<String, String> placeholders) {
        List<Object> commands;
        Object object = value;
        if (object instanceof String) {
            v0 = CollectionsKt.listOf(value);
        } else if (object instanceof Collection) {
            Iterable $this$filterIsInstance$iv = (Iterable)value;
            boolean $i$f$filterIsInstance = false;
            Iterable iterable = $this$filterIsInstance$iv;
            destination$iv$iv = new ArrayList();
            boolean $i$f$filterIsInstanceTo = false;
            for (Object element$iv$iv : $this$filterIsInstanceTo$iv$iv) {
                if (!(element$iv$iv instanceof String)) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            v0 = (List)destination$iv$iv;
        } else if (object instanceof ConfigurationSection) {
            void $this$flatMapTo$iv$iv;
            Set set = ((ConfigurationSection)value).getKeys(false);
            Intrinsics.checkNotNullExpressionValue(set, "getKeys(...)");
            Iterable $this$flatMap$iv = set;
            boolean $i$f$flatMap = false;
            $this$filterIsInstanceTo$iv$iv = $this$flatMap$iv;
            destination$iv$iv = new ArrayList();
            boolean $i$f$flatMapTo = false;
            for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
                List<Object> list;
                String nestedKey = (String)element$iv$iv;
                boolean bl = false;
                Object nestedValue = ((ConfigurationSection)value).get(nestedKey);
                if (nestedValue instanceof String) {
                    list = CollectionsKt.listOf(nestedValue);
                } else if (nestedValue instanceof Collection) {
                    void $this$filterIsInstanceTo$iv$iv;
                    Iterable $this$filterIsInstance$iv = (Iterable)nestedValue;
                    boolean $i$f$filterIsInstance = false;
                    Iterable iterable = $this$filterIsInstance$iv;
                    Collection destination$iv$iv = new ArrayList();
                    boolean $i$f$filterIsInstanceTo = false;
                    for (Object element$iv$iv2 : $this$filterIsInstanceTo$iv$iv) {
                        if (!(element$iv$iv2 instanceof String)) continue;
                        destination$iv$iv.add(element$iv$iv2);
                    }
                    list = (List)destination$iv$iv;
                } else {
                    list = CollectionsKt.emptyList();
                }
                Iterable list$iv$iv = list;
                CollectionsKt.addAll(destination$iv$iv, list$iv$iv);
            }
            v0 = (List)destination$iv$iv;
        } else {
            v0 = commands = CollectionsKt.emptyList();
        }
        if (commands.isEmpty()) {
            return;
        }
        Iterable $this$forEach$iv = commands;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            String template = (String)element$iv;
            boolean bl = false;
            String formattedCommand = null;
            formattedCommand = template;
            Map<String, String> $this$forEach$iv2 = placeholders;
            boolean $i$f$forEach2 = false;
            Iterator<Map.Entry<String, String>> iterator2 = $this$forEach$iv2.entrySet().iterator();
            while (iterator2.hasNext()) {
                Map.Entry<String, String> element$iv2;
                Map.Entry<String, String> entry = element$iv2 = iterator2.next();
                boolean bl2 = false;
                String key = entry.getKey();
                String value2 = entry.getValue();
                formattedCommand = StringsKt.replace$default(formattedCommand, "{" + key + "}", value2, false, 4, null);
            }
            if (StringsKt.isBlank(formattedCommand)) continue;
            String filteredCommand = StringsKt.replace$default(formattedCommand, " --force", "", false, 4, null);
            this.plugin.getServer().dispatchCommand((CommandSender)this.plugin.getServer().getConsoleSender(), formattedCommand);
            this.plugin.getLogger().debug("Executed command for " + player + ": " + filteredCommand);
        }
    }
}

