/*
 * Decompiled with CFR 0.152.
 */
package pl.syntaxdevteam.punisher.common;

import dev.dejvokep.boostedyaml.YamlDocument;
import dev.dejvokep.boostedyaml.block.implementation.Section;
import dev.dejvokep.boostedyaml.settings.Settings;
import dev.dejvokep.boostedyaml.settings.dumper.DumperSettings;
import dev.dejvokep.boostedyaml.settings.general.GeneralSettings;
import dev.dejvokep.boostedyaml.settings.loader.LoaderSettings;
import java.io.BufferedReader;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.StandardCopyOption;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import kotlin.Metadata;
import kotlin.io.CloseableKt;
import kotlin.io.TextStreamsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.Charsets;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import pl.syntaxdevteam.punisher.PunisherX;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u000b\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 '2\u00020\u0001:\u0001'B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0006\u0010\u0011\u001a\u00020\u0012J\u0006\u0010\u0013\u001a\u00020\u0012J\u0012\u0010\u0014\u001a\u00020\u00152\b\u0010\u0016\u001a\u0004\u0018\u00010\u0007H\u0002J\u0010\u0010\u0017\u001a\u00020\u00122\u0006\u0010\u0018\u001a\u00020\u0015H\u0002J\b\u0010\u0019\u001a\u00020\u0012H\u0002J\b\u0010\u001a\u001a\u00020\u0012H\u0002J\u0019\u0010\u001b\u001a\u0004\u0018\u00010\u00152\b\u0010\u001c\u001a\u0004\u0018\u00010\u0001H\u0002\u00a2\u0006\u0002\u0010\u001dJ\u000f\u0010\u001e\u001a\u0004\u0018\u00010\u0015H\u0002\u00a2\u0006\u0002\u0010\u001fJ \u0010 \u001a\u0012\u0012\u0004\u0012\u00020\"\u0012\u0006\u0012\u0004\u0018\u00010\u0001\u0018\u00010!2\u0006\u0010#\u001a\u00020\"H\u0002J*\u0010$\u001a\u0012\u0012\u0004\u0012\u00020\"\u0012\u0006\u0012\u0004\u0018\u00010\u0001\u0018\u00010!2\b\u0010\u0016\u001a\u0004\u0018\u00010\u00072\u0006\u0010#\u001a\u00020\"H\u0002J\u001a\u0010%\u001a\u0010\u0012\u0004\u0012\u00020\"\u0012\u0006\u0012\u0004\u0018\u00010\u00010!*\u00020&H\u0002J\"\u0010%\u001a\u0010\u0012\u0004\u0012\u00020\"\u0012\u0006\u0012\u0004\u0018\u00010\u00010!*\n\u0012\u0002\b\u0003\u0012\u0002\b\u00030!H\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0006\u001a\u00020\u0007X\u0086.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\b\u0010\t\"\u0004\b\n\u0010\u000bR\u0010\u0010\f\u001a\u0004\u0018\u00010\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\r\u001a\u00020\u000e8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000f\u0010\u0010\u00a8\u0006("}, d2={"Lpl/syntaxdevteam/punisher/common/ConfigManager;", "", "plugin", "Lpl/syntaxdevteam/punisher/PunisherX;", "<init>", "(Lpl/syntaxdevteam/punisher/PunisherX;)V", "config", "Ldev/dejvokep/boostedyaml/YamlDocument;", "getConfig", "()Ldev/dejvokep/boostedyaml/YamlDocument;", "setConfig", "(Ldev/dejvokep/boostedyaml/YamlDocument;)V", "rawUserDoc", "dataFile", "Ljava/io/File;", "getDataFile", "()Ljava/io/File;", "load", "", "reload", "detectSourceVersion", "", "doc", "migrateFrom", "sourceVersion", "migrate104to160", "migrate141to160", "parseVersionValue", "raw", "(Ljava/lang/Object;)Ljava/lang/Integer;", "guessVersionFromComment", "()Ljava/lang/Integer;", "readSectionMap", "", "", "path", "readSectionMapRaw", "asLinkedStringMap", "Ldev/dejvokep/boostedyaml/block/implementation/Section;", "Companion", "PunisherX"})
@SourceDebugExtension(value={"SMAP\nConfigManager.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ConfigManager.kt\npl/syntaxdevteam/punisher/common/ConfigManager\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Strings.kt\nkotlin/text/StringsKt___StringsKt\n+ 4 FileReadWrite.kt\nkotlin/io/FilesKt__FileReadWriteKt\n+ 5 _Sequences.kt\nkotlin/sequences/SequencesKt___SequencesKt\n*L\n1#1,285:1\n1#2:286\n1#2:298\n434#3:287\n507#3,5:288\n434#3:301\n507#3,5:302\n284#4,5:293\n183#5,2:299\n*S KotlinDebug\n*F\n+ 1 ConfigManager.kt\npl/syntaxdevteam/punisher/common/ConfigManager\n*L\n225#1:298\n217#1:287\n217#1:288,5\n228#1:301\n228#1:302,5\n225#1:293,5\n226#1:299,2\n*E\n"})
public final class ConfigManager {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final PunisherX plugin;
    public YamlDocument config;
    @Nullable
    private YamlDocument rawUserDoc;
    @NotNull
    private static final String FILE_NAME = "config.yml";
    @NotNull
    private static final String VERSION_KEY = "config-version";
    private static final int V_104 = 104;
    private static final int V_141 = 141;
    private static final int V_160 = 160;

    public ConfigManager(@NotNull PunisherX plugin) {
        Intrinsics.checkNotNullParameter((Object)plugin, "plugin");
        this.plugin = plugin;
    }

    @NotNull
    public final YamlDocument getConfig() {
        YamlDocument yamlDocument = this.config;
        if (yamlDocument != null) {
            return yamlDocument;
        }
        Intrinsics.throwUninitializedPropertyAccessException("config");
        return null;
    }

    public final void setConfig(@NotNull YamlDocument yamlDocument) {
        Intrinsics.checkNotNullParameter(yamlDocument, "<set-?>");
        this.config = yamlDocument;
    }

    private final File getDataFile() {
        return new File(this.plugin.getDataFolder(), FILE_NAME);
    }

    public final void load() {
        Object[] objectArray;
        YamlDocument yamlDocument;
        if (!this.plugin.getDataFolder().exists()) {
            this.plugin.getDataFolder().mkdirs();
        }
        InputStream inputStream = this.plugin.getResource(FILE_NAME);
        if (inputStream == null) {
            throw new IllegalStateException("Missing config.yml in resources (template 1.6.0 with comments required).".toString());
        }
        InputStream defaultsStream = inputStream;
        this.plugin.getLogger().debug("[Config] Loading config.yml (round-trip, auto-update)\u2026");
        if (this.getDataFile().exists()) {
            Settings[] settingsArray = new Settings[]{GeneralSettings.builder().setUseDefaults(false).build(), LoaderSettings.builder().setAutoUpdate(false).build(), DumperSettings.builder().setIndentation(2).build()};
            yamlDocument = YamlDocument.create((File)this.getDataFile(), (Settings[])settingsArray);
        } else {
            yamlDocument = null;
        }
        this.rawUserDoc = yamlDocument;
        int sourceVersion = this.detectSourceVersion(this.rawUserDoc);
        if (sourceVersion < 160 && this.getDataFile().exists()) {
            File bak = new File(this.getDataFile().getParentFile(), "config.yml." + sourceVersion + ".bak");
            try {
                objectArray = new CopyOption[]{StandardCopyOption.REPLACE_EXISTING};
                Files.copy(this.getDataFile().toPath(), bak.toPath(), (CopyOption[])objectArray);
                this.plugin.getLogger().debug("[Config] Backup before migration: " + bak.getName());
            }
            catch (Throwable t) {
                this.plugin.getLogger().warning("[Config] Failed to create backup: " + t.getMessage());
            }
        }
        objectArray = new Settings[]{GeneralSettings.builder().setUseDefaults(true).build(), LoaderSettings.builder().setAutoUpdate(true).build(), DumperSettings.builder().setIndentation(2).build()};
        YamlDocument yamlDocument2 = YamlDocument.create((File)this.getDataFile(), (InputStream)defaultsStream, (Settings[])objectArray);
        Intrinsics.checkNotNullExpressionValue(yamlDocument2, "create(...)");
        this.setConfig(yamlDocument2);
        if (!this.getConfig().contains(VERSION_KEY)) {
            this.plugin.getLogger().debug("[Config] config-version not found \u2013 treating as 1.4.1");
            this.getConfig().set(VERSION_KEY, (Object)141);
        }
        this.migrateFrom(sourceVersion);
        this.getConfig().set(VERSION_KEY, (Object)160);
        this.getConfig().save();
        this.plugin.getLogger().success("[Config] Done. Current version: " + this.getConfig().getInt(VERSION_KEY));
    }

    public final void reload() {
        this.plugin.getLogger().debug("[Config] Reload\u2026");
        this.load();
    }

    private final int detectSourceVersion(YamlDocument doc) {
        Integer fromKey;
        Object object = doc;
        if (object != null && (object = object.get(VERSION_KEY)) != null) {
            Object it = object;
            boolean bl = false;
            v1 = this.parseVersionValue(it);
        } else {
            v1 = fromKey = null;
        }
        if (fromKey != null) {
            return fromKey;
        }
        Integer guessed = this.guessVersionFromComment();
        if (guessed != null) {
            return guessed;
        }
        return doc == null ? 160 : 141;
    }

    private final void migrateFrom(int sourceVersion) {
        if (sourceVersion >= 160) {
            return;
        }
        if (sourceVersion <= 104) {
            this.plugin.getLogger().debug("[Config] Migrating " + sourceVersion + " -> 104 \u2026");
            this.migrate104to160();
        }
        if (sourceVersion <= 141) {
            this.plugin.getLogger().debug("[Config] Migrating " + sourceVersion + " -> 160 \u2026");
            this.migrate141to160();
        }
    }

    private final void migrate104to160() {
        Boolean autoDownloadUpdates;
        Boolean checkForUpdates;
        Object muteCmdRaw;
        Map<String, Object> oldWarn = this.readSectionMapRaw(this.rawUserDoc, "WarnActions");
        if (oldWarn != null && !oldWarn.isEmpty()) {
            String dst = "actions.warn.count";
            for (Map.Entry<String, Object> e : oldWarn.entrySet()) {
                String keyStr = e.getKey();
                this.getConfig().set(dst + "." + keyStr, e.getValue());
            }
            this.getConfig().remove("WarnActions");
            this.plugin.getLogger().debug("[Config] WarnActions \u2192 " + dst + " (server values overwrote defaults)");
        }
        YamlDocument yamlDocument = this.rawUserDoc;
        boolean bl = yamlDocument != null ? yamlDocument.contains("mute_pm") : false;
        if (bl) {
            Object object = this.rawUserDoc;
            boolean mutePm = object != null && (object = object.getBoolean("mute_pm")) != null ? (Boolean)object : false;
            this.getConfig().set("mute.pm", (Object)mutePm);
            this.plugin.getLogger().debug("[Config] mute_pm \u2192 mute.pm = " + mutePm + " (server)");
            this.getConfig().remove("mute_pm");
        }
        YamlDocument yamlDocument2 = this.rawUserDoc;
        Object object = muteCmdRaw = yamlDocument2 != null ? yamlDocument2.get("mute_cmd") : null;
        if (muteCmdRaw instanceof List) {
            this.getConfig().set("mute.cmd", muteCmdRaw);
            this.plugin.getLogger().debug("[Config] mute_cmd \u2192 mute.cmd (server values overwrote defaults)");
            this.getConfig().remove("mute_cmd");
        }
        YamlDocument yamlDocument3 = this.rawUserDoc;
        Boolean bl2 = checkForUpdates = yamlDocument3 != null ? yamlDocument3.getBoolean("checkForUpdates") : null;
        if (checkForUpdates != null) {
            this.getConfig().set("update.check-for-updates", (Object)checkForUpdates);
            this.plugin.getLogger().debug("[Config] checkForUpdates \u2192 update.check-for-updates = " + checkForUpdates + " (server)");
            this.getConfig().remove("checkForUpdates");
        }
        YamlDocument yamlDocument4 = this.rawUserDoc;
        Boolean bl3 = autoDownloadUpdates = yamlDocument4 != null ? yamlDocument4.getBoolean("autoDownloadUpdates") : null;
        if (autoDownloadUpdates != null) {
            this.getConfig().set("update.auto-download", (Object)autoDownloadUpdates);
            this.plugin.getLogger().debug("[Config] autoDownloadUpdates \u2192 update.auto-download = " + autoDownloadUpdates + " (server)");
            this.getConfig().remove("autoDownloadUpdates");
        }
    }

    /*
     * Unable to fully structure code
     */
    private final void migrate141to160() {
        block14: {
            block16: {
                block18: {
                    block17: {
                        block15: {
                            oldWarn = this.readSectionMapRaw(this.rawUserDoc, "warn.actions");
                            if (oldWarn == null || oldWarn.isEmpty()) {
                                oldWarn = this.readSectionMapRaw(this.rawUserDoc, "actions.warn.count");
                            }
                            if (oldWarn != null && oldWarn.isEmpty() == false) {
                                dst = "actions.warn.count";
                                for (Map.Entry<String, Object> e : oldWarn.entrySet()) {
                                    keyStr = e.getKey();
                                    this.getConfig().set(dst + "." + keyStr, e.getValue());
                                }
                                this.plugin.getLogger().debug("[Config] warn/actions \u2192 " + dst + " (server values overwrote defaults)");
                            }
                            if (this.getConfig().contains("warn.actions")) {
                                this.getConfig().set("warn.actions", null);
                            }
                            if ((oldSpawnLoc = this.readSectionMapRaw(this.rawUserDoc, "spawn.location")) != null && oldSpawnLoc.isEmpty() == false) {
                                this.getConfig().set("unjail.unjail_location", oldSpawnLoc);
                                this.plugin.getLogger().debug("[Config] spawn.location \u2192 unjail.unjail_location (server)");
                            }
                            v0 = this.rawUserDoc;
                            if (v0 != null ? v0.contains("spawn.use_external_set.enabled") : false) ** GOTO lbl-1000
                            v1 = this.rawUserDoc;
                            v2 = v1 != null ? v1.contains("spawn.use_external_set.set") : false;
                            if (v2) lbl-1000:
                            // 2 sources

                            {
                                v3 = true;
                            } else {
                                v3 = hadUseExternal = false;
                            }
                            if (!hadUseExternal) break block14;
                            v4 = this.rawUserDoc;
                            enabled = v4 != null && (v4 = v4.getBoolean("spawn.use_external_set.enabled")) != null ? v4.booleanValue() : false;
                            v5 = this.rawUserDoc;
                            v6 = setRaw = v5 != null ? v5.getString("spawn.use_external_set.set") : null;
                            if (enabled) break block15;
                            v7 = "unjail";
                            break block16;
                        }
                        v8 = setRaw;
                        if (v8 == null || (v8 = StringsKt.trim((CharSequence)v8).toString()) == null) break block17;
                        v9 = v8.toLowerCase(Locale.ROOT);
                        Intrinsics.checkNotNullExpressionValue(v9, "toLowerCase(...)");
                        v8 = v9;
                        if (v9 != null) break block18;
                    }
                    v8 = "";
                }
                v7 = Intrinsics.areEqual(var8_10 = (sr = v8), "essx") != false ? "essx" : (Intrinsics.areEqual(var8_10, "world") != false ? "world" : "world");
            }
            mapped = v7;
            this.getConfig().set("unjail.spawn_type_select.set", (Object)mapped);
            this.plugin.getLogger().debug("[Config] spawn.use_external_set \u2192 unjail.spawn_type_select.set = " + mapped + " (server)");
        }
        if (this.getConfig().contains("spawn.location")) {
            this.getConfig().set("spawn.location", null);
        }
        if (this.getConfig().contains("spawn.use_external_set")) {
            this.getConfig().set("spawn.use_external_set", null);
        }
        if ((spawn = this.readSectionMap("spawn")) != null && spawn.isEmpty()) {
            this.getConfig().set("spawn", null);
        }
        if (!this.getConfig().contains("server")) {
            this.getConfig().set("server", (Object)"network");
            this.plugin.getLogger().debug("[Config] server = \"network\" set (default)");
        }
    }

    /*
     * WARNING - void declaration
     */
    private final Integer parseVersionValue(Object raw) {
        Integer n;
        Object object = raw;
        if (object instanceof Number) {
            n = ((Number)raw).intValue();
        } else if (object instanceof String) {
            n = StringsKt.toIntOrNull((String)raw);
            if (n == null) {
                void $this$filterTo$iv$iv;
                String $this$filter$iv = (String)raw;
                boolean $i$f$filter = false;
                CharSequence charSequence = $this$filter$iv;
                Appendable destination$iv$iv = new StringBuilder();
                boolean $i$f$filterTo = false;
                int n2 = $this$filterTo$iv$iv.length();
                for (int index$iv$iv = 0; index$iv$iv < n2; ++index$iv$iv) {
                    char element$iv$iv;
                    char p0 = element$iv$iv = $this$filterTo$iv$iv.charAt(index$iv$iv);
                    boolean bl = false;
                    if (!Character.isDigit(p0)) continue;
                    destination$iv$iv.append(element$iv$iv);
                }
                n = StringsKt.toIntOrNull(((StringBuilder)destination$iv$iv).toString());
            }
        } else {
            n = null;
        }
        return n;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    private final Integer guessVersionFromComment() {
        if (!this.getDataFile().exists()) {
            return null;
        }
        try {
            $this$useLines_u24default$iv = this.getDataFile();
            charset$iv = Charsets.UTF_8;
            $i$f$useLines = false;
            var4_5 = $this$useLines_u24default$iv;
            var5_6 = 8192;
            var6_8 = var4_5;
            var6_8 = new InputStreamReader((InputStream)new FileInputStream((File)var6_8), charset$iv);
            var4_5 = var6_8 instanceof BufferedReader != false ? (BufferedReader)var6_8 : new BufferedReader((Reader)var6_8, var5_6);
            var5_7 = null;
            try {
                block15: {
                    block14: {
                        block12: {
                            it$iv = (BufferedReader)var4_5;
                            $i$a$-use-FilesKt__FileReadWriteKt$useLines$1$iv = false;
                            lines = TextStreamsKt.lineSequence(it$iv);
                            $i$a$-useLines$default-ConfigManager$guessVersionFromComment$1 = false;
                            $this$firstOrNull$iv = lines;
                            $i$f$firstOrNull = false;
                            var12_16 = $this$firstOrNull$iv.iterator();
                            while (var12_16.hasNext()) {
                                it = element$iv = var12_16.next();
                                $i$a$-firstOrNull-ConfigManager$guessVersionFromComment$1$firstMeaningful$1 = false;
                                v0 = !StringsKt.isBlank(it);
                                if (!v0) continue;
                                v1 = element$iv;
                                break block12;
                            }
                            v1 = null;
                        }
                        v2 = v1;
                        if (v2 != null) break block14;
                        v3 = null;
                        break block15;
                    }
                    firstMeaningful = v2;
                    match = Regex.find$default(new Regex("(\\d+\\.(?:\\d+\\.)*\\d+)"), firstMeaningful, 0, 2, null);
                    v4 = match;
                    if (v4 == null || (v4 = v4.getValue()) == null) ** GOTO lbl-1000
                    $this$filter$iv = v4;
                    $i$f$filter = false;
                    $i$a$-firstOrNull-ConfigManager$guessVersionFromComment$1$firstMeaningful$1 = (CharSequence)$this$filter$iv;
                    destination$iv$iv = new StringBuilder();
                    $i$f$filterTo = false;
                    var21_27 = $this$filterTo$iv$iv.length();
                    for (index$iv$iv = 0; index$iv$iv < var21_27; ++index$iv$iv) {
                        p0 = element$iv$iv = $this$filterTo$iv$iv.charAt(index$iv$iv);
                        $i$a$-filter-ConfigManager$guessVersionFromComment$1$number$1 = false;
                        if (!Character.isDigit(p0)) continue;
                        destination$iv$iv.append(element$iv$iv);
                    }
                    v4 = ((StringBuilder)destination$iv$iv).toString();
                    if (v4 == null) lbl-1000:
                    // 2 sources

                    {
                        v3 = null;
                    } else {
                        number = v4;
                        v3 = StringsKt.toIntOrNull((String)number);
                    }
                }
                var6_8 = v3;
            }
            catch (Throwable var7_10) {
                var5_7 = var7_10;
                throw var7_10;
            }
            finally {
                CloseableKt.closeFinally((Closeable)var4_5, var5_7);
            }
            var1_1 = var6_8;
        }
        catch (Throwable <unused var>) {
            var1_1 = null;
        }
        return var1_1;
    }

    private final Map<String, Object> readSectionMap(String path) {
        Section section;
        Object object = this.getConfig().get(path);
        if (object == null) {
            return null;
        }
        Object raw = object;
        if (raw instanceof Map) {
            return this.asLinkedStringMap((Map)raw);
        }
        if (raw instanceof Section) {
            return this.asLinkedStringMap((Section)raw);
        }
        Section section2 = section = (Section)this.getConfig().getOptionalSection(path).orElse(null);
        return section2 != null ? this.asLinkedStringMap(section2) : null;
    }

    private final Map<String, Object> readSectionMapRaw(YamlDocument doc, String path) {
        if (doc == null) {
            return null;
        }
        Section section = doc.getOptionalSection(path).orElse(null);
        if (section != null) {
            return this.asLinkedStringMap(section);
        }
        Object object = doc.get(path);
        if (object == null) {
            return null;
        }
        Object raw = object;
        if (raw instanceof Map) {
            return this.asLinkedStringMap((Map)raw);
        }
        if (raw instanceof Section) {
            return this.asLinkedStringMap((Section)raw);
        }
        return null;
    }

    private final Map<String, Object> asLinkedStringMap(Section $this$asLinkedStringMap) {
        LinkedHashMap out = new LinkedHashMap();
        for (Object key : $this$asLinkedStringMap.getKeys()) {
            if (key == null) continue;
            String keyStr = key.toString();
            ((Map)out).put(keyStr, $this$asLinkedStringMap.get(keyStr));
        }
        return out;
    }

    private final Map<String, Object> asLinkedStringMap(Map<?, ?> $this$asLinkedStringMap) {
        LinkedHashMap out = new LinkedHashMap();
        for (Map.Entry<?, ?> e : $this$asLinkedStringMap.entrySet()) {
            Object k;
            if (e.getKey() == null) continue;
            ((Map)out).put(k.toString(), e.getValue());
        }
        return out;
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\bX\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\bX\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000b"}, d2={"Lpl/syntaxdevteam/punisher/common/ConfigManager$Companion;", "", "<init>", "()V", "FILE_NAME", "", "VERSION_KEY", "V_104", "", "V_141", "V_160", "PunisherX"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

