/*
 * Decompiled with CFR 0.152.
 */
package pl.syntaxdevteam.punisher.commands;

import io.papermc.paper.command.brigadier.BasicCommand;
import io.papermc.paper.command.brigadier.CommandSourceStack;
import io.papermc.paper.plugin.configuration.PluginMeta;
import io.papermc.paper.plugin.lifecycle.event.LifecycleEventOwner;
import java.lang.management.ManagementFactory;
import java.net.HttpURLConnection;
import java.net.URI;
import java.net.URL;
import java.net.URLConnection;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import java.util.concurrent.CompletableFuture;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.Result;
import kotlin.ResultKt;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import kotlin.text.StringsKt;
import org.bukkit.Server;
import org.bukkit.command.CommandSender;
import org.bukkit.plugin.Plugin;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import pl.syntaxdevteam.core.database.DatabaseType;
import pl.syntaxdevteam.message.MessageHandler;
import pl.syntaxdevteam.punisher.PunisherX;
import pl.syntaxdevteam.punisher.commands.ConnectivityCheckResult;
import pl.syntaxdevteam.punisher.databases.DatabaseHandler;
import pl.syntaxdevteam.punisher.databases.DatabaseHealthCheckResult;
import pl.syntaxdevteam.punisher.permissions.PermissionChecker;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000P\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010 \n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J'\u0010\u000b\u001a\u00020\f2\b\b\u0001\u0010\r\u001a\u00020\u000e2\u000e\b\u0001\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00110\u0010H\u0016\u00a2\u0006\u0002\u0010\u0012J\u0010\u0010\u0013\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0002J\b\u0010\u0014\u001a\u00020\u0015H\u0002J\u0018\u0010\u0016\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u0017\u001a\u00020\u0018H\u0002J-\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u00110\u001a2\b\b\u0001\u0010\r\u001a\u00020\u000e2\u000e\b\u0001\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00110\u0010H\u0016\u00a2\u0006\u0002\u0010\u001bR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001c\u0010\b\u001a\u0010\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\n\u0018\u00010\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001c"}, d2={"Lpl/syntaxdevteam/punisher/commands/PunishesXCommands;", "Lio/papermc/paper/command/brigadier/BasicCommand;", "plugin", "Lpl/syntaxdevteam/punisher/PunisherX;", "<init>", "(Lpl/syntaxdevteam/punisher/PunisherX;)V", "mH", "Lpl/syntaxdevteam/message/MessageHandler;", "pendingMigration", "Lkotlin/Pair;", "Lpl/syntaxdevteam/core/database/DatabaseType;", "execute", "", "stack", "Lio/papermc/paper/command/brigadier/CommandSourceStack;", "args", "", "", "(Lio/papermc/paper/command/brigadier/CommandSourceStack;[Ljava/lang/String;)V", "runDiagnostics", "checkExternalConnectivity", "Lpl/syntaxdevteam/punisher/commands/ConnectivityCheckResult;", "sendHelp", "page", "", "suggest", "", "(Lio/papermc/paper/command/brigadier/CommandSourceStack;[Ljava/lang/String;)Ljava/util/List;", "PunisherX"})
@SourceDebugExtension(value={"SMAP\nPunisherXCommands.kt\nKotlin\n*S Kotlin\n*F\n+ 1 PunisherXCommands.kt\npl/syntaxdevteam/punisher/commands/PunishesXCommands\n+ 2 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 4 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,345:1\n12970#2,2:346\n11561#2:351\n11896#2,3:352\n1#3:348\n1869#4,2:349\n774#4:355\n865#4,2:356\n774#4:358\n865#4,2:359\n774#4:361\n865#4,2:362\n774#4:364\n865#4,2:365\n*S KotlinDebug\n*F\n+ 1 PunisherXCommands.kt\npl/syntaxdevteam/punisher/commands/PunishesXCommands\n*L\n82#1:346,2\n316#1:351\n316#1:352,3\n303#1:349,2\n321#1:355\n321#1:356,2\n327#1:358\n327#1:359,2\n329#1:361\n329#1:362,2\n338#1:364\n338#1:365,2\n*E\n"})
public final class PunishesXCommands
implements BasicCommand {
    @NotNull
    private final PunisherX plugin;
    @NotNull
    private final MessageHandler mH;
    @Nullable
    private Pair<? extends DatabaseType, ? extends DatabaseType> pendingMigration;

    public PunishesXCommands(@NotNull PunisherX plugin) {
        Intrinsics.checkNotNullParameter((Object)plugin, "plugin");
        this.plugin = plugin;
        this.mH = this.plugin.getMessageHandler();
    }

    public void execute(@NotNull CommandSourceStack stack, @NotNull String[] args) {
        Intrinsics.checkNotNullParameter(stack, "stack");
        Intrinsics.checkNotNullParameter(args, "args");
        String prefix = this.plugin.getMessageHandler().getPrefix();
        if (!(args.length == 0) && StringsKt.equals(args[0], "help", true)) {
            Object object = ArraysKt.getOrNull(args, 1);
            int page = object != null && (object = StringsKt.toIntOrNull((String)object)) != null ? (Integer)object : 1;
            this.sendHelp(stack, page);
            return;
        }
        CommandSender commandSender = stack.getSender();
        Intrinsics.checkNotNullExpressionValue(commandSender, "getSender(...)");
        if (!PermissionChecker.INSTANCE.hasWithLegacy(commandSender, PermissionChecker.PermissionKey.PUNISHERX_COMMAND)) {
            stack.getSender().sendMessage(MessageHandler.stringMessageToComponent$default((MessageHandler)this.plugin.getMessageHandler(), (String)"error", (String)"no_permission", null, (int)4, null));
            return;
        }
        if (args.length == 0) {
            stack.getSender().sendMessage(this.mH.miniMessageFormat(prefix + " <green>Type </green><gold>/prx help</gold> <green>to see available commands</green>"));
            return;
        }
        PunisherX punisherX = this.plugin;
        Intrinsics.checkNotNull((Object)punisherX, "null cannot be cast to non-null type io.papermc.paper.plugin.lifecycle.event.LifecycleEventOwner");
        PluginMeta pluginMeta = ((LifecycleEventOwner)punisherX).getPluginMeta();
        Intrinsics.checkNotNullExpressionValue(pluginMeta, "getPluginMeta(...)");
        PluginMeta pluginMeta2 = pluginMeta;
        if (StringsKt.equals(args[0], "version", true)) {
            stack.getSender().sendMessage(this.mH.miniMessageFormat("\n<gray>-------------------------------------------------\n <gray>|\n <gray>|   <gold>\u2192 <bold>" + pluginMeta2.getName() + "</bold> \u2190\n <gray>|   <white>Author: <bold><gold>" + pluginMeta2.getAuthors() + "</gold></bold>\n <gray>|   <white>Website: <bold><gold><click:open_url:'" + pluginMeta2.getWebsite() + "'>" + pluginMeta2.getWebsite() + "</click></gold></bold>\n <gray>|   <white>Version: <bold><gold>" + pluginMeta2.getVersion() + "</gold></bold>\n <gray>|\n<gray>-------------------------------------------------"));
        } else if (StringsKt.equals(args[0], "reload", true)) {
            this.plugin.onReload();
            stack.getSender().sendMessage(this.mH.miniMessageFormat(prefix + " <green>PunisherX has been reloaded.</green>"));
        } else if (StringsKt.equals(args[0], "export", true)) {
            this.plugin.getDatabaseHandler().exportDatabase();
        } else if (StringsKt.equals(args[0], "import", true)) {
            this.plugin.getDatabaseHandler().importDatabase();
        } else if (StringsKt.equals(args[0], "diagnostics", true) || StringsKt.equals(args[0], "diag", true)) {
            this.runDiagnostics(stack);
        } else if (StringsKt.equals(args[0], "migrate", true)) {
            Pair<? extends DatabaseType, ? extends DatabaseType> pending;
            Object object;
            Object $this$execute_u24lambda_u241;
            String to;
            boolean bl;
            block23: {
                String[] $this$any$iv = args;
                boolean $i$f$any = false;
                int n = $this$any$iv.length;
                for (int i = 0; i < n; ++i) {
                    String element$iv;
                    String it = element$iv = $this$any$iv[i];
                    boolean bl2 = false;
                    if (!StringsKt.equals(it, "--force", true)) continue;
                    bl = true;
                    break block23;
                }
                bl = false;
            }
            boolean force = bl;
            String from = ArraysKt.getOrNull(args, 1);
            String string = ArraysKt.getOrNull(args, 2);
            String string2 = to = (string != null ? StringsKt.equals(string, "--force", true) : false) ? ArraysKt.getOrNull(args, 3) : ArraysKt.getOrNull(args, 2);
            if (from == null || to == null) {
                stack.getSender().sendMessage(this.mH.miniMessageFormat(prefix + " <red>Usage: /prx migrate <from> <to></red>"));
                return;
            }
            Object object2 = this;
            try {
                $this$execute_u24lambda_u241 = object2;
                boolean bl3 = false;
                String string3 = from.toUpperCase(Locale.ROOT);
                Intrinsics.checkNotNullExpressionValue(string3, "toUpperCase(...)");
                $this$execute_u24lambda_u241 = Result.constructor-impl(DatabaseType.valueOf((String)string3));
            }
            catch (Throwable bl3) {
                $this$execute_u24lambda_u241 = Result.constructor-impl(ResultKt.createFailure(bl3));
            }
            object2 = $this$execute_u24lambda_u241;
            DatabaseType fromType = (DatabaseType)(Result.isFailure-impl(object2) ? null : object2);
            $this$execute_u24lambda_u241 = this;
            try {
                PunishesXCommands $this$execute_u24lambda_u242 = (PunishesXCommands)$this$execute_u24lambda_u241;
                boolean bl4 = false;
                String string4 = to.toUpperCase(Locale.ROOT);
                Intrinsics.checkNotNullExpressionValue(string4, "toUpperCase(...)");
                object = Result.constructor-impl(DatabaseType.valueOf((String)string4));
            }
            catch (Throwable throwable) {
                object = Result.constructor-impl(ResultKt.createFailure(throwable));
            }
            $this$execute_u24lambda_u241 = object;
            DatabaseType toType = (DatabaseType)(Result.isFailure-impl($this$execute_u24lambda_u241) ? null : $this$execute_u24lambda_u241);
            if (fromType == null || toType == null) {
                stack.getSender().sendMessage(this.mH.miniMessageFormat(prefix + " <red>Unknown database type.</red>"));
                return;
            }
            if (!(force || (pending = this.pendingMigration) != null && pending.getFirst() == fromType && pending.getSecond() == toType)) {
                this.pendingMigration = TuplesKt.to(fromType, toType);
                CommandSender commandSender2 = stack.getSender();
                String string5 = toType.name().toLowerCase(Locale.ROOT);
                Intrinsics.checkNotNullExpressionValue(string5, "toLowerCase(...)");
                commandSender2.sendMessage(this.mH.miniMessageFormat(prefix + " <yellow>Update the connection details for <gold>" + string5 + "</gold> in config.yml, then rerun this command. Use <gold>--force</gold> to skip this confirmation."));
                return;
            }
            this.pendingMigration = null;
            CommandSender commandSender3 = stack.getSender();
            String string6 = fromType.name().toLowerCase(Locale.ROOT);
            Intrinsics.checkNotNullExpressionValue(string6, "toLowerCase(...)");
            String string7 = toType.name().toLowerCase(Locale.ROOT);
            Intrinsics.checkNotNullExpressionValue(string7, "toLowerCase(...)");
            commandSender3.sendMessage(this.mH.miniMessageFormat(prefix + " <yellow>Starting migration from <gold>" + string6 + "</gold> to <gold>" + string7 + "</gold>...</yellow>"));
            CompletableFuture<DatabaseHandler.MigrationResult> future = this.plugin.getDatabaseHandler().migrateDatabase(fromType, toType);
            future.whenComplete((arg_0, arg_1) -> PunishesXCommands.execute$lambda$4((arg_0, arg_1) -> PunishesXCommands.execute$lambda$3(prefix, this, stack, arg_0, arg_1), arg_0, arg_1));
        } else {
            stack.getSender().sendMessage(this.mH.miniMessageFormat(prefix + " <green>Type </green><gold>/prx help</gold> <green>to see available commands</green>"));
        }
    }

    private final void runDiagnostics(CommandSourceStack stack) {
        CommandSender commandSender = stack.getSender();
        Intrinsics.checkNotNullExpressionValue(commandSender, "getSender(...)");
        CommandSender sender = commandSender;
        String prefix = this.plugin.getMessageHandler().getPrefix();
        PunisherX punisherX = this.plugin;
        Intrinsics.checkNotNull((Object)punisherX, "null cannot be cast to non-null type io.papermc.paper.plugin.lifecycle.event.LifecycleEventOwner");
        PluginMeta pluginMeta = ((LifecycleEventOwner)punisherX).getPluginMeta();
        Intrinsics.checkNotNullExpressionValue(pluginMeta, "getPluginMeta(...)");
        PluginMeta pluginMeta2 = pluginMeta;
        Server server = this.plugin.getServer();
        Intrinsics.checkNotNullExpressionValue(server, "getServer(...)");
        Server server2 = server;
        String javaVersion = System.getProperty("java.version");
        String osName = System.getProperty("os.name");
        String osArch = System.getProperty("os.arch");
        String osVersion = System.getProperty("os.version");
        sender.sendMessage(this.mH.miniMessageFormat(prefix + " <yellow>Running diagnostics, please wait...</yellow>"));
        this.plugin.getServer().getScheduler().runTaskAsynchronously((Plugin)this.plugin, () -> PunishesXCommands.runDiagnostics$lambda$0(this, pluginMeta2, server2, javaVersion, osName, osVersion, osArch, sender));
    }

    private final ConnectivityCheckResult checkExternalConnectivity() {
        ConnectivityCheckResult connectivityCheckResult;
        URL target = URI.create("https://example.com").toURL();
        long start = System.currentTimeMillis();
        try {
            HttpURLConnection httpURLConnection;
            URLConnection uRLConnection = target.openConnection();
            Intrinsics.checkNotNull(uRLConnection, "null cannot be cast to non-null type java.net.HttpURLConnection");
            HttpURLConnection $this$checkExternalConnectivity_u24lambda_u240 = httpURLConnection = (HttpURLConnection)uRLConnection;
            boolean bl = false;
            $this$checkExternalConnectivity_u24lambda_u240.setRequestMethod("HEAD");
            $this$checkExternalConnectivity_u24lambda_u240.setConnectTimeout(3000);
            $this$checkExternalConnectivity_u24lambda_u240.setReadTimeout(3000);
            HttpURLConnection connection = httpURLConnection;
            int code = connection.getResponseCode();
            long duration = System.currentTimeMillis() - start;
            connection.disconnect();
            connectivityCheckResult = new ConnectivityCheckResult(true, "example.com responded with HTTP " + code, duration);
        }
        catch (Exception exception) {
            long duration = System.currentTimeMillis() - start;
            String string = exception.getMessage();
            if (string == null) {
                string = "Unknown network error";
            }
            connectivityCheckResult = new ConnectivityCheckResult(false, string, duration);
        }
        return connectivityCheckResult;
    }

    private final void sendHelp(CommandSourceStack stack, int page) {
        String[] stringArray = new String[]{"  <gold>/prx help <gray>- <white>Displays this prompt.", "  <gold>/prx version <gray>- <white>Shows plugin info.", "  <gold>/prx reload <gray>- <white>Reloads the configuration file.", "  <gold>/prx diag <gray>- <white>Runs diagnostics and prints results.", "  <gold>/kick <player> <reason> <gray>- <white>Kicks a player from the server", "  <gold>/warn <player> (time) <reason> <gray>- <white>Warns a player.", "  <gold>/unwarn <player> <gray>- <white>Removes a player's warning.", "  <gold>/mute <player> (time) <reason> <gray>- <white>Mutes a player.", "  <gold>/unmute <player> <gray>- <white>Unmutes a player.", "  <gold>/ban <player> (time) <reason> [--force]", "         <gray>- <white>Bans a player, optionally ignoring bypass.", "  <gold>/banip <player/ip> (time) <reason> [--force] ", "         <gray>- <white>Bans a player's IP, optionally ignoring bypass.", "  <gold>/unban <player/ip> <gray>- <white>Unbans a player.", "  <gold>/check <player> <all/warn/mute/ban> ", "    <gray>- <white>Checks and displays the punishments of a given player", "  <gold>/clearall <player> <gray>- <white>Clears all active penalties.", "  <gold>/jail <player> (time) <reason> <gray>- <white>Sends a player to jail.", "  <gold>/unjail <player> <gray>- <white>Releases a player from jail.", "  <gold>/setjail <radius> <gray>- <white>Setting up the jail location.", "  <gold>/setunjail <gray>- <white>Sets the unjail respawn location", "                             <white>after serving a prison sentence.", "  <gold>/change-reason <penalty_id> <new_reason> <gray>", "                - <white>Changes the reason for the penalty.", "  ", "  <gold>/history <player> (page) ", "               <gray>- <white>Displays the player's punishment history.", "  <gold>/banlist <page> --h <gray>- <white>Displays the list of banned players.", "      <white>(Using the <gold>--h</gold> parameter will display the ban history)", "  ", "  <blue>Future:", "  <gold>/panel <gray>- <white>Opens the PunisherX GUI with lots of useful", "                                   <white> information and commands.", "  ", "  ", "  ", " "};
        List<String> commands = CollectionsKt.listOf(stringArray);
        int itemsPerPage = 12;
        int totalPages = (commands.size() + itemsPerPage - 1) / itemsPerPage;
        int currentPage = RangesKt.coerceIn(page, 1, totalPages);
        stack.getSender().sendMessage(this.mH.miniMessageFormat(" <gray>+-------------------------------------------------"));
        stack.getSender().sendMessage(this.mH.miniMessageFormat(" <gray>|    <gold>Available commands for " + this.plugin.getPluginMeta().getName() + ":"));
        stack.getSender().sendMessage(this.mH.miniMessageFormat(" <gray>|"));
        int startIndex = (currentPage - 1) * itemsPerPage;
        int endIndex = RangesKt.coerceAtMost(currentPage * itemsPerPage, commands.size());
        for (int i = startIndex; i < endIndex; ++i) {
            stack.getSender().sendMessage(this.mH.miniMessageFormat(" <gray>|  " + commands.get(i)));
        }
        int prevPage = currentPage > 1 ? currentPage - 1 : totalPages;
        int nextPage = currentPage < totalPages ? currentPage + 1 : 1;
        stack.getSender().sendMessage(this.mH.miniMessageFormat(" <gray>|"));
        stack.getSender().sendMessage(this.mH.miniMessageFormat(" <gray>|"));
        stack.getSender().sendMessage(this.mH.miniMessageFormat(" <gray>| (Page " + currentPage + "/" + totalPages + ") <click:run_command:'/prx help " + prevPage + "'><white>[Previous]</white></click>   <click:run_command:'/prx help " + nextPage + "'><white>[Next]</white></click>"));
        stack.getSender().sendMessage(this.mH.miniMessageFormat(" <gray>|"));
        stack.getSender().sendMessage(this.mH.miniMessageFormat(" <gray>+-------------------------------------------------"));
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public List<String> suggest(@NotNull CommandSourceStack stack, @NotNull String[] args) {
        Intrinsics.checkNotNullParameter(stack, "stack");
        Intrinsics.checkNotNullParameter(args, "args");
        if (args.length == 0) {
            String[] stringArray = new String[]{"help"};
            List<String> baseSuggestions = CollectionsKt.mutableListOf(stringArray);
            CommandSender commandSender = stack.getSender();
            Intrinsics.checkNotNullExpressionValue(commandSender, "getSender(...)");
            if (PermissionChecker.INSTANCE.hasWithLegacy(commandSender, PermissionChecker.PermissionKey.PUNISHERX_COMMAND)) {
                stringArray = new String[]{"version", "reload", "export", "import", "diag", "migrate"};
                baseSuggestions.addAll((Collection<String>)CollectionsKt.listOf(stringArray));
            }
            return baseSuggestions;
        }
        if (args.length == 1) {
            List baseSuggestions = new ArrayList();
            if (StringsKt.startsWith("help", args[0], true)) {
                baseSuggestions.add("help");
            }
            CommandSender commandSender = stack.getSender();
            Intrinsics.checkNotNullExpressionValue(commandSender, "getSender(...)");
            if (PermissionChecker.INSTANCE.hasWithLegacy(commandSender, PermissionChecker.PermissionKey.PUNISHERX_COMMAND)) {
                String[] stringArray = new String[]{"version", "reload", "export", "import", "diag", "diagnostics"};
                Iterable $this$forEach$iv = CollectionsKt.listOf(stringArray);
                boolean $i$f$forEach = false;
                for (Object element$iv : $this$forEach$iv) {
                    String cmd = (String)element$iv;
                    boolean bl = false;
                    if (!StringsKt.startsWith(cmd, args[0], true)) continue;
                    baseSuggestions.add(cmd);
                }
                if (StringsKt.startsWith("migrate", args[0], true)) {
                    baseSuggestions.add("migrate");
                }
            }
            return baseSuggestions;
        }
        if (StringsKt.equals(args[0], "migrate", true)) {
            List list;
            Iterable $this$mapTo$iv$iv;
            Collection destination$iv$iv;
            DatabaseType[] databaseTypeArray = (DatabaseType[])DatabaseType.class.getEnumConstants();
            if (databaseTypeArray != null) {
                void $this$map$iv;
                DatabaseType[] databaseTypeArray2 = databaseTypeArray;
                boolean $i$f$map = false;
                void cmd = $this$map$iv;
                destination$iv$iv = new ArrayList(((void)$this$map$iv).length);
                boolean $i$f$mapTo = false;
                int n = ((Iterable)$this$mapTo$iv$iv).length;
                for (int i = 0; i < n; ++i) {
                    void it;
                    Iterable item$iv$iv;
                    Iterable iterable = item$iv$iv = $this$mapTo$iv$iv[i];
                    Collection collection = destination$iv$iv;
                    boolean bl = false;
                    String string = it.name().toLowerCase(Locale.ROOT);
                    Intrinsics.checkNotNullExpressionValue(string, "toLowerCase(...)");
                    collection.add(string);
                }
                list = (List)destination$iv$iv;
            } else {
                list = CollectionsKt.emptyList();
            }
            List types = list;
            switch (args.length) {
                case 2: {
                    String it;
                    Iterable $this$filterTo$iv$iv;
                    String current = args[1];
                    Iterable $this$filter$iv = types;
                    boolean $i$f$filter = false;
                    $this$mapTo$iv$iv = $this$filter$iv;
                    destination$iv$iv = new ArrayList();
                    boolean $i$f$filterTo = false;
                    for (Object element$iv$iv : $this$filterTo$iv$iv) {
                        it = (String)element$iv$iv;
                        boolean bl = false;
                        String string = current.toLowerCase(Locale.ROOT);
                        Intrinsics.checkNotNullExpressionValue(string, "toLowerCase(...)");
                        if (!StringsKt.startsWith$default(it, string, false, 2, null)) continue;
                        destination$iv$iv.add(element$iv$iv);
                    }
                    return (List)destination$iv$iv;
                }
                case 3: {
                    List list2;
                    String it;
                    Iterable $this$filterTo$iv$iv;
                    boolean $i$f$filterTo;
                    boolean $i$f$filter;
                    Iterable $this$filter$iv;
                    String current = args[2];
                    if (StringsKt.startsWith$default(current, "--", false, 2, null)) {
                        $this$filter$iv = CollectionsKt.listOf("--force");
                        $i$f$filter = false;
                        $this$filterTo$iv$iv = $this$filter$iv;
                        destination$iv$iv = new ArrayList();
                        $i$f$filterTo = false;
                        for (Object element$iv$iv : $this$filterTo$iv$iv) {
                            it = (String)element$iv$iv;
                            boolean bl = false;
                            String string = current.toLowerCase(Locale.ROOT);
                            Intrinsics.checkNotNullExpressionValue(string, "toLowerCase(...)");
                            if (!StringsKt.startsWith$default(it, string, false, 2, null)) continue;
                            destination$iv$iv.add(element$iv$iv);
                        }
                        list2 = (List)destination$iv$iv;
                    } else {
                        $this$filter$iv = types;
                        $i$f$filter = false;
                        $this$filterTo$iv$iv = $this$filter$iv;
                        destination$iv$iv = new ArrayList();
                        $i$f$filterTo = false;
                        for (Object element$iv$iv : $this$filterTo$iv$iv) {
                            it = (String)element$iv$iv;
                            boolean bl = false;
                            String string = current.toLowerCase(Locale.ROOT);
                            Intrinsics.checkNotNullExpressionValue(string, "toLowerCase(...)");
                            if (!StringsKt.startsWith$default(it, string, false, 2, null)) continue;
                            destination$iv$iv.add(element$iv$iv);
                        }
                        list2 = (List)destination$iv$iv;
                    }
                    return list2;
                }
                case 4: {
                    String it;
                    String current = args[3];
                    if (StringsKt.equals(args[2], "--force", true)) {
                        return CollectionsKt.emptyList();
                    }
                    Iterable $this$filter$iv = CollectionsKt.listOf("--force");
                    boolean $i$f$filter = false;
                    Iterable $this$filterTo$iv$iv = $this$filter$iv;
                    destination$iv$iv = new ArrayList();
                    boolean $i$f$filterTo = false;
                    for (Object element$iv$iv : $this$filterTo$iv$iv) {
                        it = (String)element$iv$iv;
                        boolean bl = false;
                        String string = current.toLowerCase(Locale.ROOT);
                        Intrinsics.checkNotNullExpressionValue(string, "toLowerCase(...)");
                        if (!StringsKt.startsWith$default(it, string, false, 2, null)) continue;
                        destination$iv$iv.add(element$iv$iv);
                    }
                    return (List)destination$iv$iv;
                }
            }
        }
        return CollectionsKt.emptyList();
    }

    private static final Unit execute$lambda$3(String $prefix, PunishesXCommands this$0, CommandSourceStack $stack, DatabaseHandler.MigrationResult result, Throwable throwable) {
        String string;
        Throwable throwable2 = throwable;
        if (throwable2 != null) {
            String string2 = throwable2.getMessage();
            if (string2 == null) {
                string2 = "Unknown error";
            }
            string = $prefix + " <red>Failed to migrate database: " + string2 + "</red>";
        } else {
            string = result == null ? $prefix + " <red>Migration finished with an unknown state.</red>" : (result.getSuccess() ? $prefix + " <green>" + result.getMessage() + "</green>" : $prefix + " <red>" + result.getMessage() + "</red>");
        }
        String response = string;
        this$0.plugin.getServer().getScheduler().runTask((Plugin)this$0.plugin, () -> PunishesXCommands.execute$lambda$3$0($stack, this$0, response));
        return Unit.INSTANCE;
    }

    private static final void execute$lambda$3$0(CommandSourceStack $stack, PunishesXCommands this$0, String $response) {
        $stack.getSender().sendMessage(this$0.mH.miniMessageFormat($response));
    }

    private static final void execute$lambda$4(Function2 $tmp0, Object p0, Object p1) {
        $tmp0.invoke(p0, p1);
    }

    private static final void runDiagnostics$lambda$0(PunishesXCommands this$0, PluginMeta $pluginMeta, Server $server, String $javaVersion, String $osName, String $osVersion, String $osArch, CommandSender $sender) {
        DatabaseHealthCheckResult databaseCheck = this$0.plugin.getDatabaseHandler().runHealthCheck();
        ConnectivityCheckResult externalConnectivity = this$0.checkExternalConnectivity();
        Runtime runtime = Runtime.getRuntime();
        long usedMemoryMb = (runtime.totalMemory() - runtime.freeMemory()) / (long)0x100000;
        long maxMemoryMb = runtime.maxMemory() / (long)0x100000;
        long uptime = ManagementFactory.getRuntimeMXBean().getUptime();
        String safeDatabaseMessage = StringsKt.replace$default(StringsKt.replace$default(databaseCheck.getMessage(), '<', '[', false, 4, null), '>', ']', false, 4, null);
        String safeNetworkMessage = StringsKt.replace$default(StringsKt.replace$default(externalConnectivity.getMessage(), '<', '[', false, 4, null), '>', ']', false, 4, null);
        String[] stringArray = new String[18];
        stringArray[0] = " ";
        stringArray[1] = "<gray>-+-----------------------------------------------";
        stringArray[2] = " <gray>| <gold>" + $pluginMeta.getName() + " diagnostics</gold>";
        stringArray[3] = "<gray>-+-----------------------------------------------";
        stringArray[4] = " <gray>| <white>Plugin version: <gold>" + $pluginMeta.getVersion() + "</gold>";
        stringArray[5] = " <gray>| <white>Server brand: <gold>" + $server.getName() + "</gold> <gray>" + $server.getVersion() + "</gray>";
        stringArray[6] = " <gray>| <white>Java: <gold>" + $javaVersion + "</gold>";
        stringArray[7] = " <gray>| <white>OS: <gold>" + $osName + " " + $osVersion + " (" + $osArch + ")</gold>";
        stringArray[8] = " <gray>| <white>Uptime: <gold>" + uptime / (long)1000 + "s</gold>";
        stringArray[9] = " <gray>| <white>Memory: <gold>" + usedMemoryMb + "MB</gold> / <gray>" + maxMemoryMb + "MB max</gray>";
        String string = this$0.plugin.getDatabaseHandler().databaseType().name().toLowerCase(Locale.ROOT);
        Intrinsics.checkNotNullExpressionValue(string, "toLowerCase(...)");
        stringArray[10] = " <gray>| <white>Database: <gold>" + string + "</gold> - " + (databaseCheck.getOk() ? "<green>OK</green>" : "<red>FAILED</red>") + " <gray>" + databaseCheck.getDurationMs() + "ms</gray>";
        stringArray[11] = " <gray>| <white>DB details: <gray>" + safeDatabaseMessage + "</gray>";
        stringArray[12] = " <gray>| <white>External connectivity: " + (externalConnectivity.getOk() ? "<green>OK</green>" : "<red>FAILED</red>") + " <gray>" + externalConnectivity.getDurationMs() + "ms</gray>";
        stringArray[13] = " <gray>| <white>Network details: <gray>" + safeNetworkMessage + "</gray>";
        stringArray[14] = " <gray>| <white>Data folder: <gray>" + this$0.plugin.getDataFolder().getAbsolutePath() + "</gray>";
        stringArray[15] = " <gray>| <white>Share this output with support if an issue occurs.";
        stringArray[16] = "<gray>-+-----------------------------------------------";
        stringArray[17] = " ";
        String report = CollectionsKt.joinToString$default(CollectionsKt.listOf(stringArray), "\n", null, null, 0, null, null, 62, null);
        this$0.plugin.getServer().getScheduler().runTask((Plugin)this$0.plugin, () -> PunishesXCommands.runDiagnostics$lambda$0$0($sender, this$0, report));
    }

    private static final void runDiagnostics$lambda$0$0(CommandSender $sender, PunishesXCommands this$0, String $report) {
        $sender.sendMessage(this$0.mH.miniMessageFormat($report));
    }
}

