/*
 * Decompiled with CFR 0.152.
 */
package pl.syntaxdevteam.punisher.commands;

import io.papermc.paper.command.brigadier.BasicCommand;
import io.papermc.paper.command.brigadier.CommandSourceStack;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.IntIterator;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.IntRange;
import kotlin.ranges.RangesKt;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.minimessage.tag.resolver.TagResolver;
import org.bukkit.Bukkit;
import org.bukkit.GameMode;
import org.bukkit.Location;
import org.bukkit.command.CommandSender;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.entity.Player;
import org.jetbrains.annotations.NotNull;
import pl.syntaxdevteam.message.MessageHandler;
import pl.syntaxdevteam.punisher.PunisherX;
import pl.syntaxdevteam.punisher.basic.JailUtils;
import pl.syntaxdevteam.punisher.databases.DatabaseHandler;
import pl.syntaxdevteam.punisher.permissions.PermissionChecker;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\b\u0003\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J'\u0010\u0006\u001a\u00020\u00072\b\b\u0001\u0010\b\u001a\u00020\t2\u000e\b\u0001\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000bH\u0016\u00a2\u0006\u0002\u0010\rJ-\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\f0\u000f2\b\b\u0001\u0010\b\u001a\u00020\t2\u000e\b\u0001\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000bH\u0016\u00a2\u0006\u0002\u0010\u0010J\u000e\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\f0\u000fH\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0012"}, d2={"Lpl/syntaxdevteam/punisher/commands/JailCommand;", "Lio/papermc/paper/command/brigadier/BasicCommand;", "plugin", "Lpl/syntaxdevteam/punisher/PunisherX;", "<init>", "(Lpl/syntaxdevteam/punisher/PunisherX;)V", "execute", "", "stack", "Lio/papermc/paper/command/brigadier/CommandSourceStack;", "args", "", "", "(Lio/papermc/paper/command/brigadier/CommandSourceStack;[Ljava/lang/String;)V", "suggest", "", "(Lio/papermc/paper/command/brigadier/CommandSourceStack;[Ljava/lang/String;)Ljava/util/List;", "generateTimeSuggestions", "PunisherX"})
@SourceDebugExtension(value={"SMAP\nJailCommand.kt\nKotlin\n*S Kotlin\n*F\n+ 1 JailCommand.kt\npl/syntaxdevteam/punisher/commands/JailCommand\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,144:1\n827#2:145\n855#2,2:146\n827#2:148\n855#2,2:149\n1563#2:151\n1634#2,3:152\n1374#2:155\n1460#2,2:156\n1563#2:158\n1634#2,3:159\n1462#2,3:162\n1869#2:165\n1869#2,2:166\n1870#2:168\n1869#2,2:169\n*S KotlinDebug\n*F\n+ 1 JailCommand.kt\npl/syntaxdevteam/punisher/commands/JailCommand\n*L\n50#1:145\n50#1:146,2\n53#1:148\n53#1:149,2\n132#1:151\n132#1:152,3\n141#1:155\n141#1:156,2\n141#1:158\n141#1:159,3\n141#1:162,3\n88#1:165\n90#1:166,2\n88#1:168\n100#1:169,2\n*E\n"})
public final class JailCommand
implements BasicCommand {
    @NotNull
    private final PunisherX plugin;

    public JailCommand(@NotNull PunisherX plugin) {
        Intrinsics.checkNotNullParameter((Object)plugin, "plugin");
        this.plugin = plugin;
    }

    /*
     * WARNING - void declaration
     */
    public void execute(@NotNull CommandSourceStack stack, @NotNull String[] args) {
        Collection destination$iv$iv;
        Intrinsics.checkNotNullParameter(stack, "stack");
        Intrinsics.checkNotNullParameter(args, "args");
        CommandSender commandSender = stack.getSender();
        Intrinsics.checkNotNullExpressionValue(commandSender, "getSender(...)");
        if (!PermissionChecker.INSTANCE.hasWithLegacy(commandSender, PermissionChecker.PermissionKey.JAIL)) {
            stack.getSender().sendMessage(MessageHandler.stringMessageToComponent$default((MessageHandler)this.plugin.getMessageHandler(), (String)"error", (String)"no_permission", null, (int)4, null));
            return;
        }
        if (args.length == 0 || args.length < 2) {
            stack.getSender().sendMessage(MessageHandler.stringMessageToComponent$default((MessageHandler)this.plugin.getMessageHandler(), (String)"jail", (String)"usage", null, (int)4, null));
            return;
        }
        String playerName = args[0];
        UUID uuid = this.plugin.resolvePlayerUuid(playerName);
        Player targetPlayer = Bukkit.getPlayer((UUID)uuid);
        boolean isForce = ArraysKt.contains(args, "--force");
        if (targetPlayer != null && !isForce && PermissionChecker.INSTANCE.hasWithBypass((CommandSender)targetPlayer, PermissionChecker.PermissionKey.BYPASS_JAIL)) {
            stack.getSender().sendMessage(this.plugin.getMessageHandler().stringMessageToComponent("error", "bypass", MapsKt.mapOf(TuplesKt.to("player", playerName))));
            return;
        }
        String prefix = this.plugin.getMessageHandler().getPrefix();
        if (PermissionChecker.INSTANCE.isAuthor(uuid)) {
            stack.getSender().sendMessage(this.plugin.getMessageHandler().formatMixedTextToMiniMessage(prefix + " <red>You can't punish the plugin author</red>", TagResolver.empty()));
            return;
        }
        String gtime = null;
        Ref.ObjectRef<String> reason = new Ref.ObjectRef<String>();
        try {
            void $this$filterNotTo$iv$iv;
            void $this$filterNot$iv;
            gtime = args[1];
            this.plugin.getTimeHandler().parseTime(gtime);
            Iterable iterable = ArraysKt.slice(args, RangesKt.until(2, args.length));
            Ref.ObjectRef<String> objectRef = reason;
            boolean $i$f$filterNot = false;
            void var12_17 = $this$filterNot$iv;
            destination$iv$iv = new ArrayList();
            boolean $i$f$filterNotTo = false;
            for (Iterator element$iv$iv : $this$filterNotTo$iv$iv) {
                String it = (String)((Object)element$iv$iv);
                boolean bl = false;
                if (Intrinsics.areEqual(it, "--force")) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            objectRef.element = CollectionsKt.joinToString$default((List)destination$iv$iv, " ", null, null, 0, null, null, 62, null);
        }
        catch (NumberFormatException numberFormatException) {
            void $this$filterNotTo$iv$iv;
            void $this$filterNot$iv;
            gtime = null;
            Iterable $i$f$filterNot = ArraysKt.slice(args, RangesKt.until(1, args.length));
            Ref.ObjectRef<String> objectRef = reason;
            boolean $i$f$filterNot2 = false;
            destination$iv$iv = $this$filterNot$iv;
            Collection destination$iv$iv2 = new ArrayList();
            boolean $i$f$filterNotTo = false;
            for (Object element$iv$iv : $this$filterNotTo$iv$iv) {
                String it = (String)element$iv$iv;
                boolean bl = false;
                if (Intrinsics.areEqual(it, "--force")) continue;
                destination$iv$iv2.add(element$iv$iv);
            }
            objectRef.element = CollectionsKt.joinToString$default((List)destination$iv$iv2, " ", null, null, 0, null, null, 62, null);
        }
        String punishmentType = "JAIL";
        long start = System.currentTimeMillis();
        Long end = gtime != null ? Long.valueOf(start + this.plugin.getTimeHandler().parseTime(gtime) * (long)1000) : null;
        Player player = targetPlayer;
        Location previousLocation = player != null && (player = player.getLocation()) != null ? player.clone() : null;
        FileConfiguration fileConfiguration = this.plugin.getConfig();
        Intrinsics.checkNotNullExpressionValue(fileConfiguration, "getConfig(...)");
        Location jailLocation = JailUtils.INSTANCE.getJailLocation(fileConfiguration);
        if (jailLocation == null) {
            this.plugin.getLogger().debug("<red>No jail location found! Teleportation aborted.</red>");
            return;
        }
        this.plugin.getLogger().debug("<yellow>Jail location: " + jailLocation + "</yellow>");
        String formattedTime = this.plugin.getTimeHandler().formatTime(gtime);
        if (targetPlayer != null) {
            this.plugin.getSafeTeleportService().teleportSafely(targetPlayer, jailLocation, arg_0 -> JailCommand.execute$lambda$4(targetPlayer, this, jailLocation, stack, playerName, uuid, reason, punishmentType, start, end, previousLocation, formattedTime, arg_0));
        } else {
            JailCommand.execute$finalizePunishment(this, playerName, uuid, reason, stack, punishmentType, start, end, previousLocation, formattedTime, targetPlayer);
        }
    }

    @NotNull
    public List<String> suggest(@NotNull CommandSourceStack stack, @NotNull String[] args) {
        Intrinsics.checkNotNullParameter(stack, "stack");
        Intrinsics.checkNotNullParameter(args, "args");
        CommandSender commandSender = stack.getSender();
        Intrinsics.checkNotNullExpressionValue(commandSender, "getSender(...)");
        if (!PermissionChecker.INSTANCE.hasWithLegacy(commandSender, PermissionChecker.PermissionKey.JAIL)) {
            return CollectionsKt.emptyList();
        }
        return switch (args.length) {
            case 1 -> {
                void $this$mapTo$iv$iv;
                Collection v1 = this.plugin.getServer().getOnlinePlayers();
                Intrinsics.checkNotNullExpressionValue(v1, "getOnlinePlayers(...)");
                Iterable $this$map$iv = v1;
                boolean $i$f$map = false;
                Iterable var5_5 = $this$map$iv;
                Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
                boolean $i$f$mapTo = false;
                for (Object item$iv$iv : $this$mapTo$iv$iv) {
                    void it;
                    Player var10_10 = (Player)item$iv$iv;
                    Collection var12_12 = destination$iv$iv;
                    boolean $i$a$-map-JailCommand$suggest$1 = false;
                    var12_12.add(it.getName());
                }
                yield (List)destination$iv$iv;
            }
            case 2 -> this.generateTimeSuggestions();
            case 3 -> this.plugin.getMessageHandler().getMessageStringList("jail", "reasons");
            default -> CollectionsKt.emptyList();
        };
    }

    /*
     * WARNING - void declaration
     */
    private final List<String> generateTimeSuggestions() {
        void $this$flatMapTo$iv$iv;
        String[] stringArray = new String[]{"s", "m", "h", "d"};
        List<String> units = CollectionsKt.listOf(stringArray);
        Iterable $this$flatMap$iv = new IntRange(1, 999);
        boolean $i$f$flatMap = false;
        Iterable iterable = $this$flatMap$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$flatMapTo = false;
        Iterator iterator2 = $this$flatMapTo$iv$iv.iterator();
        while (iterator2.hasNext()) {
            void $this$mapTo$iv$iv;
            int element$iv$iv;
            int i = element$iv$iv = ((IntIterator)iterator2).nextInt();
            boolean bl = false;
            Iterable $this$map$iv = units;
            boolean $i$f$map = false;
            Iterable iterable2 = $this$map$iv;
            Collection destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void unit;
                String string = (String)item$iv$iv;
                Collection collection = destination$iv$iv2;
                boolean bl2 = false;
                collection.add(i + (String)unit);
            }
            Iterable list$iv$iv = (List)destination$iv$iv2;
            CollectionsKt.addAll(destination$iv$iv, list$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    private static final void execute$finalizePunishment(JailCommand this$0, String playerName, UUID uuid, Ref.ObjectRef<String> reason, CommandSourceStack $stack, String punishmentType, long start, Long end, Location previousLocation, String formattedTime, Player targetPlayer) {
        DatabaseHandler databaseHandler = this$0.plugin.getDatabaseHandler();
        String string = uuid.toString();
        Intrinsics.checkNotNullExpressionValue(string, "toString(...)");
        String string2 = (String)reason.element;
        String string3 = $stack.getSender().getName();
        Intrinsics.checkNotNullExpressionValue(string3, "getName(...)");
        Long l = end;
        databaseHandler.addPunishment(playerName, string, string2, string3, punishmentType, start, l != null ? l : -1L);
        DatabaseHandler databaseHandler2 = this$0.plugin.getDatabaseHandler();
        String string4 = uuid.toString();
        Intrinsics.checkNotNullExpressionValue(string4, "toString(...)");
        String string5 = (String)reason.element;
        String string6 = $stack.getSender().getName();
        Intrinsics.checkNotNullExpressionValue(string6, "getName(...)");
        Long l2 = end;
        databaseHandler2.addPunishmentHistory(playerName, string4, string5, string6, punishmentType, start, l2 != null ? l2 : -1L);
        Long l3 = end;
        this$0.plugin.getCache().addOrUpdatePunishment(uuid, l3 != null ? l3 : -1L, previousLocation);
        Pair[] pairArray = new Pair[]{TuplesKt.to("reason", reason.element), TuplesKt.to("time", formattedTime)};
        Map<String, String> placeholders = MapsKt.mapOf(pairArray);
        Player player = targetPlayer;
        if (player != null) {
            player.sendMessage(this$0.plugin.getMessageHandler().stringMessageToComponent("jail", "jail_message", placeholders));
        }
        List broadcastMessages = this$0.plugin.getMessageHandler().getSmartMessage("jail", "broadcast", MapsKt.plus(MapsKt.mapOf(TuplesKt.to("player", playerName)), placeholders));
        Collection collection = this$0.plugin.getServer().getOnlinePlayers();
        Intrinsics.checkNotNullExpressionValue(collection, "getOnlinePlayers(...)");
        Iterable $this$forEach$iv = collection;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Player onlinePlayer = (Player)element$iv;
            boolean bl = false;
            Intrinsics.checkNotNull(onlinePlayer);
            if (!PermissionChecker.INSTANCE.hasWithSee((CommandSender)onlinePlayer, PermissionChecker.PermissionKey.SEE_JAIL)) continue;
            Iterable $this$forEach$iv2 = broadcastMessages;
            boolean $i$f$forEach2 = false;
            for (Object element$iv2 : $this$forEach$iv2) {
                Component message = (Component)element$iv2;
                boolean bl2 = false;
                onlinePlayer.sendMessage(message);
            }
        }
        $this$forEach$iv = this$0.plugin.getMessageHandler().getSmartMessage("jail", "jail", MapsKt.plus(MapsKt.mapOf(TuplesKt.to("player", playerName)), placeholders));
        $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Component it = (Component)element$iv;
            boolean bl = false;
            $stack.getSender().sendMessage(it);
        }
        this$0.plugin.getActionExecutor().executeAction("jailed", playerName, placeholders);
    }

    private static final Unit execute$lambda$4(Player $targetPlayer, JailCommand this$0, Location $jailLocation, CommandSourceStack $stack, String $playerName, UUID $uuid, Ref.ObjectRef $reason, String $punishmentType, long $start, Long $end, Location $previousLocation, String $formattedTime, boolean success) {
        if (success) {
            $targetPlayer.setGameMode(GameMode.ADVENTURE);
            this$0.plugin.getLogger().debug("<green>Player successfully teleported to jail.</green>");
            this$0.plugin.getLogger().debug("Changing gamemode (" + $targetPlayer.getGameMode() + ") and teleporting " + $targetPlayer.getName() + " to " + $jailLocation);
            JailCommand.execute$finalizePunishment(this$0, $playerName, $uuid, $reason, $stack, $punishmentType, $start, $end, $previousLocation, $formattedTime, $targetPlayer);
        } else {
            $stack.getSender().sendMessage(this$0.plugin.getMessageHandler().stringMessageToComponent("jail", "teleport_failed", MapsKt.mapOf(TuplesKt.to("player", $playerName))));
            this$0.plugin.getLogger().debug("<red>Failed to teleport player to jail. Command aborted.</red>");
        }
        return Unit.INSTANCE;
    }
}

