/*
 * Decompiled with CFR 0.152.
 */
package pl.syntaxdevteam.punisher.commands;

import io.papermc.paper.command.brigadier.BasicCommand;
import io.papermc.paper.command.brigadier.CommandSourceStack;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import java.util.UUID;
import kotlin.Metadata;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import net.kyori.adventure.text.Component;
import org.bukkit.Bukkit;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.jetbrains.annotations.NotNull;
import pl.syntaxdevteam.message.MessageHandler;
import pl.syntaxdevteam.punisher.PunisherX;
import pl.syntaxdevteam.punisher.databases.DatabaseHandler;
import pl.syntaxdevteam.punisher.databases.PunishmentData;
import pl.syntaxdevteam.punisher.permissions.PermissionChecker;
import pl.syntaxdevteam.punisher.players.PlayerIPManager;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J'\u0010\b\u001a\u00020\t2\b\b\u0001\u0010\n\u001a\u00020\u000b2\u000e\b\u0001\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000e0\rH\u0016\u00a2\u0006\u0002\u0010\u000fJ-\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u000e0\u00112\b\b\u0001\u0010\n\u001a\u00020\u000b2\u000e\b\u0001\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000e0\rH\u0016\u00a2\u0006\u0002\u0010\u0012R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0013"}, d2={"Lpl/syntaxdevteam/punisher/commands/CheckCommand;", "Lio/papermc/paper/command/brigadier/BasicCommand;", "plugin", "Lpl/syntaxdevteam/punisher/PunisherX;", "playerIPManager", "Lpl/syntaxdevteam/punisher/players/PlayerIPManager;", "<init>", "(Lpl/syntaxdevteam/punisher/PunisherX;Lpl/syntaxdevteam/punisher/players/PlayerIPManager;)V", "execute", "", "stack", "Lio/papermc/paper/command/brigadier/CommandSourceStack;", "args", "", "", "(Lio/papermc/paper/command/brigadier/CommandSourceStack;[Ljava/lang/String;)V", "suggest", "", "(Lio/papermc/paper/command/brigadier/CommandSourceStack;[Ljava/lang/String;)Ljava/util/List;", "PunisherX"})
@SourceDebugExtension(value={"SMAP\nCheckCommand.kt\nKotlin\n*S Kotlin\n*F\n+ 1 CheckCommand.kt\npl/syntaxdevteam/punisher/commands/CheckCommand\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,106:1\n774#2:107\n865#2,2:108\n774#2:110\n865#2,2:111\n774#2:113\n865#2,2:114\n774#2:116\n865#2,2:117\n1869#2,2:120\n1563#2:122\n1634#2,3:123\n1#3:119\n*S KotlinDebug\n*F\n+ 1 CheckCommand.kt\npl/syntaxdevteam/punisher/commands/CheckCommand\n*L\n34#1:107\n34#1:108,2\n35#1:110\n35#1:111,2\n36#1:113\n36#1:114,2\n37#1:116\n37#1:117,2\n80#1:120,2\n100#1:122\n100#1:123,3\n*E\n"})
public final class CheckCommand
implements BasicCommand {
    @NotNull
    private final PunisherX plugin;
    @NotNull
    private final PlayerIPManager playerIPManager;

    public CheckCommand(@NotNull PunisherX plugin, @NotNull PlayerIPManager playerIPManager) {
        Intrinsics.checkNotNullParameter((Object)plugin, "plugin");
        Intrinsics.checkNotNullParameter(playerIPManager, "playerIPManager");
        this.plugin = plugin;
        this.playerIPManager = playerIPManager;
    }

    public void execute(@NotNull CommandSourceStack stack, @NotNull String[] args) {
        block37: {
            block35: {
                Object object;
                String title;
                String times;
                String reasons;
                String types;
                String id;
                List filteredPunishments;
                String targetPlayer;
                UUID uuid;
                block44: {
                    Object geoLocation;
                    block42: {
                        block43: {
                            Object object2;
                            String playerIP;
                            block41: {
                                block40: {
                                    Object object3;
                                    String player;
                                    block39: {
                                        List list;
                                        String string;
                                        block36: {
                                            block34: {
                                                Intrinsics.checkNotNullParameter(stack, "stack");
                                                Intrinsics.checkNotNullParameter(args, "args");
                                                if (args.length == 0) {
                                                    stack.getSender().sendMessage(MessageHandler.stringMessageToComponent$default((MessageHandler)this.plugin.getMessageHandler(), (String)"check", (String)"usage", null, (int)4, null));
                                                    return;
                                                }
                                                player = args[0];
                                                if (StringsKt.equals(player, stack.getSender().getName(), true)) break block34;
                                                CommandSender commandSender = stack.getSender();
                                                Intrinsics.checkNotNullExpressionValue(commandSender, "getSender(...)");
                                                if (!PermissionChecker.INSTANCE.hasWithLegacy(commandSender, PermissionChecker.PermissionKey.CHECK)) break block35;
                                            }
                                            if (args.length >= 2) break block36;
                                            stack.getSender().sendMessage(MessageHandler.stringMessageToComponent$default((MessageHandler)this.plugin.getMessageHandler(), (String)"check", (String)"usage", null, (int)4, null));
                                            break block37;
                                        }
                                        String type = args[1];
                                        uuid = this.plugin.resolvePlayerUuid(player);
                                        Player player2 = Bukkit.getPlayer((String)player);
                                        if ((player2 != null ? player2.getName() : null) == null) {
                                            string = Bukkit.getOfflinePlayer((UUID)uuid).getName();
                                        } else {
                                            Player player3 = Bukkit.getPlayer((String)player);
                                            string = player3 != null ? player3.getName() : null;
                                        }
                                        targetPlayer = string;
                                        DatabaseHandler databaseHandler = this.plugin.getDatabaseHandler();
                                        String string2 = uuid.toString();
                                        Intrinsics.checkNotNullExpressionValue(string2, "toString(...)");
                                        List punishments = DatabaseHandler.getPunishments$default(databaseHandler, string2, null, null, 6, null);
                                        String string3 = type.toLowerCase(Locale.ROOT);
                                        Intrinsics.checkNotNullExpressionValue(string3, "toLowerCase(...)");
                                        switch (string3) {
                                            case "all": {
                                                list = punishments;
                                                break;
                                            }
                                            case "ban": {
                                                PunishmentData it;
                                                Iterable $this$filterTo$iv$iv;
                                                Iterable $this$filter$iv = punishments;
                                                boolean $i$f$filter = false;
                                                Iterable iterable = $this$filter$iv;
                                                Collection destination$iv$iv = new ArrayList();
                                                boolean $i$f$filterTo = false;
                                                for (Object element$iv$iv : $this$filterTo$iv$iv) {
                                                    it = (PunishmentData)element$iv$iv;
                                                    boolean bl = false;
                                                    if (!(Intrinsics.areEqual(it.getType(), "BAN") || Intrinsics.areEqual(it.getType(), "BANIP"))) continue;
                                                    destination$iv$iv.add(element$iv$iv);
                                                }
                                                list = (List)destination$iv$iv;
                                                break;
                                            }
                                            case "jail": {
                                                PunishmentData it;
                                                Iterable $this$filter$iv = punishments;
                                                boolean $i$f$filter = false;
                                                Iterable $this$filterTo$iv$iv = $this$filter$iv;
                                                Collection destination$iv$iv = new ArrayList();
                                                boolean $i$f$filterTo = false;
                                                for (Object element$iv$iv : $this$filterTo$iv$iv) {
                                                    it = (PunishmentData)element$iv$iv;
                                                    boolean bl = false;
                                                    if (!Intrinsics.areEqual(it.getType(), "JAIL")) continue;
                                                    destination$iv$iv.add(element$iv$iv);
                                                }
                                                list = (List)destination$iv$iv;
                                                break;
                                            }
                                            case "mute": {
                                                PunishmentData it;
                                                Iterable $this$filter$iv = punishments;
                                                boolean $i$f$filter = false;
                                                Iterable $this$filterTo$iv$iv = $this$filter$iv;
                                                Collection destination$iv$iv = new ArrayList();
                                                boolean $i$f$filterTo = false;
                                                for (Object element$iv$iv : $this$filterTo$iv$iv) {
                                                    it = (PunishmentData)element$iv$iv;
                                                    boolean bl = false;
                                                    if (!Intrinsics.areEqual(it.getType(), "MUTE")) continue;
                                                    destination$iv$iv.add(element$iv$iv);
                                                }
                                                list = (List)destination$iv$iv;
                                                break;
                                            }
                                            case "warn": {
                                                PunishmentData it;
                                                Iterable $this$filter$iv = punishments;
                                                boolean $i$f$filter = false;
                                                Iterable $this$filterTo$iv$iv = $this$filter$iv;
                                                Collection destination$iv$iv = new ArrayList();
                                                boolean $i$f$filterTo = false;
                                                for (Object element$iv$iv : $this$filterTo$iv$iv) {
                                                    it = (PunishmentData)element$iv$iv;
                                                    boolean bl = false;
                                                    if (!Intrinsics.areEqual(it.getType(), "WARN")) continue;
                                                    destination$iv$iv.add(element$iv$iv);
                                                }
                                                list = (List)destination$iv$iv;
                                                break;
                                            }
                                            default: {
                                                stack.getSender().sendMessage(MessageHandler.stringMessageToComponent$default((MessageHandler)this.plugin.getMessageHandler(), (String)"check", (String)"invalid_type", null, (int)4, null));
                                                return;
                                            }
                                        }
                                        filteredPunishments = list;
                                        if (!filteredPunishments.isEmpty()) break block39;
                                        stack.getSender().sendMessage(this.plugin.getMessageHandler().stringMessageToComponent("check", "no_punishments", MapsKt.mapOf(TuplesKt.to("player", player))));
                                        break block37;
                                    }
                                    id = MessageHandler.stringMessageToStringNoPrefix$default((MessageHandler)this.plugin.getMessageHandler(), (String)"check", (String)"id", null, (int)4, null);
                                    types = MessageHandler.stringMessageToStringNoPrefix$default((MessageHandler)this.plugin.getMessageHandler(), (String)"check", (String)"type", null, (int)4, null);
                                    reasons = MessageHandler.stringMessageToStringNoPrefix$default((MessageHandler)this.plugin.getMessageHandler(), (String)"check", (String)"reason", null, (int)4, null);
                                    times = MessageHandler.stringMessageToStringNoPrefix$default((MessageHandler)this.plugin.getMessageHandler(), (String)"check", (String)"time", null, (int)4, null);
                                    title = MessageHandler.stringMessageToStringNoPrefix$default((MessageHandler)this.plugin.getMessageHandler(), (String)"check", (String)"title", null, (int)4, null);
                                    PlayerIPManager.PlayerInfo playerInfo = this.playerIPManager.getPlayerInfoByName(player);
                                    this.plugin.getLogger().debug("Player info: " + playerInfo);
                                    PlayerIPManager.PlayerInfo playerInfo2 = playerInfo;
                                    playerIP = playerInfo2 != null ? playerInfo2.getPlayerIP() : null;
                                    object2 = playerInfo;
                                    if (object2 == null || (object2 = ((PlayerIPManager.PlayerInfo)object2).getGeoLocation()) == null) break block40;
                                    Object it = object3 = object2;
                                    boolean bl = false;
                                    object2 = !StringsKt.isBlank((CharSequence)it) ? object3 : null;
                                    if (object2 != null) break block41;
                                }
                                object2 = "Unknown location";
                            }
                            geoLocation = object2;
                            this.plugin.getLogger().debug("GeoLocation: " + (String)geoLocation);
                            CommandSender commandSender = stack.getSender();
                            Intrinsics.checkNotNullExpressionValue(commandSender, "getSender(...)");
                            if (!PermissionChecker.INSTANCE.hasWithLegacy(commandSender, PermissionChecker.PermissionKey.VIEW_IP)) break block42;
                            object = playerIP;
                            if (object == null) break block43;
                            Object it = object;
                            boolean bl = false;
                            String string = (String)it + " (" + (String)geoLocation + ")";
                            object = string;
                            if (string != null) break block44;
                        }
                        object = geoLocation;
                        break block44;
                    }
                    object = geoLocation;
                }
                Object fullGeoLocation = object;
                String gamer = Intrinsics.areEqual(stack.getSender().getName(), "CONSOLE") ? "<gold>" + targetPlayer + " <gray>[" + uuid + ", " + (String)fullGeoLocation + "]</gray>:</gold>" : "<gold><hover:show_text:'[<white>" + uuid + ", " + (String)fullGeoLocation + "</white>]'>" + targetPlayer + ":</gold>";
                MessageHandler mh = this.plugin.getMessageHandler();
                Component topHeader = mh.miniMessageFormat("<blue>--------------------------------------------------</blue>");
                Component header = mh.miniMessageFormat("<blue>|    " + title + " " + gamer + "</blue>");
                Component tableHeader = mh.miniMessageFormat("<blue>|   " + id + "  |  " + types + "  |  " + reasons + "  |  " + times + "</blue>");
                Component br = mh.miniMessageFormat("<blue> </blue>");
                Component hr = mh.miniMessageFormat("<blue>|</blue>");
                stack.getSender().sendMessage(br);
                stack.getSender().sendMessage(header);
                stack.getSender().sendMessage(topHeader);
                stack.getSender().sendMessage(tableHeader);
                stack.getSender().sendMessage(hr);
                Iterable $this$forEach$iv = filteredPunishments;
                boolean $i$f$forEach = false;
                for (Object element$iv : $this$forEach$iv) {
                    PunishmentData punishment = (PunishmentData)element$iv;
                    boolean bl = false;
                    long endTime = punishment.getEnd();
                    long remainingTime = (endTime - System.currentTimeMillis()) / (long)1000;
                    String duration = endTime == -1L ? "permanent" : this.plugin.getTimeHandler().formatTime(String.valueOf(remainingTime));
                    String reason = punishment.getReason();
                    Component row = mh.miniMessageFormat("<blue>|   <white>#" + punishment.getId() + "</white> <blue>|</blue> <white>" + punishment.getType() + "</white> <blue>|</blue> <white>" + reason + "</white> <blue>|</blue> <white>" + duration + "</white>");
                    stack.getSender().sendMessage(row);
                }
                break block37;
            }
            stack.getSender().sendMessage(MessageHandler.stringMessageToComponent$default((MessageHandler)this.plugin.getMessageHandler(), (String)"error", (String)"no_permission", null, (int)4, null));
        }
    }

    @NotNull
    public List<String> suggest(@NotNull CommandSourceStack stack, @NotNull String[] args) {
        Intrinsics.checkNotNullParameter(stack, "stack");
        Intrinsics.checkNotNullParameter(args, "args");
        return switch (args.length) {
            case 1 -> {
                void $this$mapTo$iv$iv;
                Collection v0 = this.plugin.getServer().getOnlinePlayers();
                Intrinsics.checkNotNullExpressionValue(v0, "getOnlinePlayers(...)");
                Iterable $this$map$iv = v0;
                boolean $i$f$map = false;
                Iterable var5_6 = $this$map$iv;
                Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
                boolean $i$f$mapTo = false;
                for (Object item$iv$iv : $this$mapTo$iv$iv) {
                    void it;
                    Player var10_11 = (Player)item$iv$iv;
                    Collection var12_13 = destination$iv$iv;
                    boolean $i$a$-map-CheckCommand$suggest$1 = false;
                    var12_13.add(it.getName());
                }
                yield (List)destination$iv$iv;
            }
            case 2 -> {
                String[] var3_4 = new String[]{"all", "warn", "mute", "jail", "ban"};
                yield CollectionsKt.listOf(var3_4);
            }
            default -> CollectionsKt.emptyList();
        };
    }
}

