/*
 * Decompiled with CFR 0.152.
 */
package pl.syntaxdevteam.punisher.bridge;

import com.google.common.io.ByteArrayDataOutput;
import com.google.common.io.ByteStreams;
import java.util.Collection;
import java.util.UUID;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;
import org.jetbrains.annotations.NotNull;
import pl.syntaxdevteam.punisher.PunisherX;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\t\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 \u00192\u00020\u0001:\u0001\u0019B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0006\u0010\u0006\u001a\u00020\u0007J\u0006\u0010\b\u001a\u00020\u0007J\u001e\u0010\t\u001a\u00020\u00072\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fJ\u001e\u0010\u0010\u001a\u00020\u00072\u0006\u0010\u0011\u001a\u00020\r2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fJ(\u0010\u0012\u001a\u00020\u00072\u0006\u0010\u0013\u001a\u00020\r2\u0006\u0010\n\u001a\u00020\r2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0002J\u0018\u0010\u0014\u001a\u00020\u00072\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u0018H\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001a"}, d2={"Lpl/syntaxdevteam/punisher/bridge/ProxyBridgeMessenger;", "", "plugin", "Lpl/syntaxdevteam/punisher/PunisherX;", "<init>", "(Lpl/syntaxdevteam/punisher/PunisherX;)V", "registerChannel", "", "unregisterChannel", "notifyBan", "target", "Ljava/util/UUID;", "reason", "", "end", "", "notifyIpBan", "ip", "dispatch", "action", "sendMessage", "output", "Lcom/google/common/io/ByteArrayDataOutput;", "carrier", "Lorg/bukkit/entity/Player;", "Companion", "PunisherX"})
public final class ProxyBridgeMessenger {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final PunisherX plugin;
    @NotNull
    public static final String CHANNEL = "punisherx:bridge";

    public ProxyBridgeMessenger(@NotNull PunisherX plugin) {
        Intrinsics.checkNotNullParameter((Object)plugin, "plugin");
        this.plugin = plugin;
    }

    public final void registerChannel() {
        this.plugin.getServer().getMessenger().registerOutgoingPluginChannel((Plugin)this.plugin, CHANNEL);
    }

    public final void unregisterChannel() {
        this.plugin.getServer().getMessenger().unregisterOutgoingPluginChannel((Plugin)this.plugin);
    }

    public final void notifyBan(@NotNull UUID target, @NotNull String reason, long end) {
        Intrinsics.checkNotNullParameter(target, "target");
        Intrinsics.checkNotNullParameter(reason, "reason");
        String string = target.toString();
        Intrinsics.checkNotNullExpressionValue(string, "toString(...)");
        this.dispatch("BAN", string, reason, end);
    }

    public final void notifyIpBan(@NotNull String ip, @NotNull String reason, long end) {
        Intrinsics.checkNotNullParameter(ip, "ip");
        Intrinsics.checkNotNullParameter(reason, "reason");
        this.dispatch("BANIP", ip, reason, end);
    }

    private final void dispatch(String action, String target, String reason, long end) {
        this.plugin.getDatabaseHandler().enqueueBridgeEvent(action, target, reason, end);
        ByteArrayDataOutput output = ByteStreams.newDataOutput();
        output.writeUTF(action);
        output.writeUTF(target);
        output.writeUTF(reason);
        output.writeLong(end);
        Collection collection = this.plugin.getServer().getOnlinePlayers();
        Intrinsics.checkNotNullExpressionValue(collection, "getOnlinePlayers(...)");
        Player carrier = (Player)CollectionsKt.firstOrNull(collection);
        if (carrier != null) {
            Intrinsics.checkNotNull(output);
            this.sendMessage(output, carrier);
            return;
        }
        this.plugin.getLogger().debug("PunisherX proxy bridge skipped sending " + action + " for " + target + ": no players online to carry the message.");
    }

    private final void sendMessage(ByteArrayDataOutput output, Player carrier) {
        carrier.sendPluginMessage((Plugin)this.plugin, CHANNEL, output.toByteArray());
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lpl/syntaxdevteam/punisher/bridge/ProxyBridgeMessenger$Companion;", "", "<init>", "()V", "CHANNEL", "", "PunisherX"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

