/*
 * Decompiled with CFR 0.152.
 */
package pl.syntaxdevteam.punisher.bridge;

import io.papermc.paper.threadedregions.scheduler.ScheduledTask;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.TimeUnit;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import kotlin.text.StringsKt;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.TextComponent;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitTask;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import pl.syntaxdevteam.core.platform.ServerEnvironment;
import pl.syntaxdevteam.punisher.PunisherX;
import pl.syntaxdevteam.punisher.databases.DatabaseHandler;
import pl.syntaxdevteam.punisher.databases.PunishmentData;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u0000 \u00142\u00020\u0001:\u0001\u0014B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0006\u0010\n\u001a\u00020\u000bJ\u0006\u0010\f\u001a\u00020\u000bJ\b\u0010\r\u001a\u00020\u000bH\u0002J\u0012\u0010\u000e\u001a\u0004\u0018\u00010\u000f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0002J\u0018\u0010\u0012\u001a\u00020\u000b2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0013\u001a\u00020\u000fH\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0006\u001a\u0004\u0018\u00010\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\b\u001a\u0004\u0018\u00010\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0015"}, d2={"Lpl/syntaxdevteam/punisher/bridge/OnlinePunishmentWatcher;", "", "plugin", "Lpl/syntaxdevteam/punisher/PunisherX;", "<init>", "(Lpl/syntaxdevteam/punisher/PunisherX;)V", "asyncTask", "Lorg/bukkit/scheduler/BukkitTask;", "foliaTask", "Lio/papermc/paper/threadedregions/scheduler/ScheduledTask;", "start", "", "stop", "checkOnlinePlayers", "findActiveBan", "Lpl/syntaxdevteam/punisher/databases/PunishmentData;", "player", "Lorg/bukkit/entity/Player;", "kickPlayer", "punishment", "Companion", "PunisherX"})
@SourceDebugExtension(value={"SMAP\nOnlinePunishmentWatcher.kt\nKotlin\n*S Kotlin\n*F\n+ 1 OnlinePunishmentWatcher.kt\npl/syntaxdevteam/punisher/bridge/OnlinePunishmentWatcher\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,100:1\n1869#2,2:101\n774#2:103\n865#2,2:104\n774#2:107\n865#2,2:108\n295#2,2:110\n1878#2,3:112\n1#3:106\n*S KotlinDebug\n*F\n+ 1 OnlinePunishmentWatcher.kt\npl/syntaxdevteam/punisher/bridge/OnlinePunishmentWatcher\n*L\n48#1:101,2\n59#1:103\n59#1:104,2\n60#1:107\n60#1:108,2\n65#1:110,2\n86#1:112,3\n*E\n"})
public final class OnlinePunishmentWatcher {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final PunisherX plugin;
    @Nullable
    private BukkitTask asyncTask;
    @Nullable
    private ScheduledTask foliaTask;
    private static final long DEFAULT_PERIOD_TICKS = 20L;

    public OnlinePunishmentWatcher(@NotNull PunisherX plugin) {
        Intrinsics.checkNotNullParameter((Object)plugin, "plugin");
        this.plugin = plugin;
    }

    public final void start() {
        this.stop();
        long periodTicks = this.plugin.getConfig().getLong("bridge.watchdog_period_ticks", 20L);
        if (ServerEnvironment.INSTANCE.isFoliaBased()) {
            this.foliaTask = this.plugin.getServer().getGlobalRegionScheduler().runAtFixedRate((Plugin)this.plugin, arg_0 -> OnlinePunishmentWatcher.start$lambda$0(this, arg_0), periodTicks, periodTicks);
        } else {
            this.asyncTask = this.plugin.getServer().getScheduler().runTaskTimerAsynchronously((Plugin)this.plugin, () -> OnlinePunishmentWatcher.start$lambda$1(this), periodTicks, periodTicks);
        }
    }

    public final void stop() {
        BukkitTask bukkitTask = this.asyncTask;
        if (bukkitTask != null) {
            bukkitTask.cancel();
        }
        this.asyncTask = null;
        ScheduledTask scheduledTask = this.foliaTask;
        if (scheduledTask != null) {
            scheduledTask.cancel();
        }
        this.foliaTask = null;
    }

    private final void checkOnlinePlayers() {
        Collection collection = this.plugin.getServer().getOnlinePlayers();
        Intrinsics.checkNotNullExpressionValue(collection, "getOnlinePlayers(...)");
        Collection onlinePlayers = collection;
        if (onlinePlayers.isEmpty()) {
            return;
        }
        Iterable $this$forEach$iv = onlinePlayers;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            PunishmentData activeBan;
            Player player = (Player)element$iv;
            boolean bl = false;
            Intrinsics.checkNotNull(player);
            if (this.findActiveBan(player) == null) continue;
            this.kickPlayer(player, activeBan);
        }
    }

    /*
     * Unable to fully structure code
     */
    private final PunishmentData findActiveBan(Player player) {
        block5: {
            v0 = player.getUniqueId().toString();
            Intrinsics.checkNotNullExpressionValue(v0, "toString(...)");
            uuid = v0;
            v1 = player.getAddress();
            ip = v1 != null && (v1 = v1.getAddress()) != null ? v1.getHostAddress() : null;
            var5_4 = DatabaseHandler.getPunishments$default(this.plugin.getDatabaseHandler(), uuid, null, null, 6, null);
            $i$f$filter = false;
            var7_7 = $this$filter$iv;
            destination$iv$iv = new ArrayList<E>();
            $i$f$filterTo = false;
            for (T element$iv$iv : $this$filterTo$iv$iv) {
                it = (PunishmentData)element$iv$iv;
                $i$a$-filter-OnlinePunishmentWatcher$findActiveBan$punishments$1 = false;
                if (!this.plugin.getPunishmentManager().isPunishmentActive(it)) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            punishments = (List)destination$iv$iv;
            v2 = ip;
            if (v2 == null) ** GOTO lbl-1000
            it = v2;
            $i$a$-let-OnlinePunishmentWatcher$findActiveBan$ipPunishments$1 = false;
            v3 = this.plugin.getDatabaseHandler().getPunishmentsByIP(it);
            v2 = v3;
            if (v3 != null) {
                $this$filter$iv = (Iterable)v2;
                $i$f$filter = false;
                var10_12 = $this$filter$iv;
                destination$iv$iv = new ArrayList<E>();
                $i$f$filterTo = false;
                for (T element$iv$iv : $this$filterTo$iv$iv) {
                    it = (PunishmentData)element$iv$iv;
                    $i$a$-filter-OnlinePunishmentWatcher$findActiveBan$ipPunishments$2 = false;
                    if (!this.plugin.getPunishmentManager().isPunishmentActive(it)) continue;
                    destination$iv$iv.add(element$iv$iv);
                }
                v4 = (List)destination$iv$iv;
            } else lbl-1000:
            // 2 sources

            {
                v4 = CollectionsKt.emptyList();
            }
            ipPunishments = v4;
            $i$f$filter = CollectionsKt.plus((Collection)punishments, (Iterable)ipPunishments);
            $i$f$firstOrNull = false;
            for (T element$iv : $this$firstOrNull$iv) {
                it = (PunishmentData)element$iv;
                $i$a$-firstOrNull-OnlinePunishmentWatcher$findActiveBan$1 = false;
                if (!(StringsKt.equals(it.getType(), "BAN", true) != false || StringsKt.equals(it.getType(), "BANIP", true) != false)) continue;
                v5 = element$iv;
                break block5;
            }
            v5 = null;
        }
        return v5;
    }

    /*
     * WARNING - void declaration
     */
    private final void kickPlayer(Player player, PunishmentData punishment) {
        String remainingSeconds = punishment.getEnd() >= 0L ? String.valueOf(TimeUnit.MILLISECONDS.toSeconds(RangesKt.coerceAtLeast(punishment.getEnd() - System.currentTimeMillis(), 0L))) : null;
        Pair[] pairArray = new Pair[]{TuplesKt.to("reason", punishment.getReason()), TuplesKt.to("time", this.plugin.getTimeHandler().formatTime(remainingSeconds))};
        List kickMessages = this.plugin.getMessageHandler().getSmartMessage("ban", "kick_message", MapsKt.mapOf(pairArray));
        TextComponent.Builder builder = Component.text();
        Intrinsics.checkNotNullExpressionValue(builder, "text(...)");
        TextComponent.Builder kickMessage = builder;
        Iterable $this$forEachIndexed$iv = kickMessages;
        boolean $i$f$forEachIndexed = false;
        int index$iv = 0;
        for (Object item$iv : $this$forEachIndexed$iv) {
            void component;
            int n;
            if ((n = index$iv++) < 0) {
                CollectionsKt.throwIndexOverflow();
            }
            Component component2 = (Component)item$iv;
            int index = n;
            boolean bl = false;
            kickMessage.append((Component)component);
            if (index == CollectionsKt.getLastIndex(kickMessages)) continue;
            kickMessage.append((Component)Component.newline());
        }
        this.plugin.getSchedulerAdapter().runSync(() -> OnlinePunishmentWatcher.kickPlayer$lambda$1(player, kickMessage));
    }

    private static final void start$lambda$0(OnlinePunishmentWatcher this$0, ScheduledTask scheduledTask) {
        this$0.checkOnlinePlayers();
    }

    private static final void start$lambda$1(OnlinePunishmentWatcher this$0) {
        this$0.checkOnlinePlayers();
    }

    private static final void kickPlayer$lambda$1(Player $player, TextComponent.Builder $kickMessage) {
        $player.kick((Component)$kickMessage.build());
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\t\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lpl/syntaxdevteam/punisher/bridge/OnlinePunishmentWatcher$Companion;", "", "<init>", "()V", "DEFAULT_PERIOD_TICKS", "", "PunisherX"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

