/*
 * Decompiled with CFR 0.152.
 */
package pl.syntaxdevteam.punisher.basic;

import java.time.LocalDateTime;
import java.time.ZoneId;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import pl.syntaxdevteam.message.MessageHandler;
import pl.syntaxdevteam.punisher.PunisherX;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\t\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\f\u0018\u00002\u00020\u0001B3\b\u0000\u0012\u0018\u0010\u0002\u001a\u0014\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00040\u0003\u0012\u000e\b\u0002\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006\u00a2\u0006\u0004\b\b\u0010\tB\u0011\b\u0016\u0012\u0006\u0010\n\u001a\u00020\u000b\u00a2\u0006\u0004\b\b\u0010\fJ\u000e\u0010\u000f\u001a\u00020\u00072\u0006\u0010\u0010\u001a\u00020\u0004J\u0010\u0010\u0011\u001a\u00020\u00042\b\u0010\u0010\u001a\u0004\u0018\u00010\u0004J\u0015\u0010\u0012\u001a\u0004\u0018\u00010\u00072\u0006\u0010\u0013\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0014J\u000e\u0010\u0015\u001a\u00020\u00042\u0006\u0010\u0016\u001a\u00020\u0004J\u0018\u0010\u0017\u001a\u00020\u00042\u0006\u0010\u0018\u001a\u00020\u00042\u0006\u0010\u0019\u001a\u00020\u0007H\u0002R \u0010\u0002\u001a\u0014\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00040\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001a"}, d2={"Lpl/syntaxdevteam/punisher/basic/TimeHandler;", "", "messageLookup", "Lkotlin/Function2;", "", "currentTime", "Lkotlin/Function0;", "", "<init>", "(Lkotlin/jvm/functions/Function2;Lkotlin/jvm/functions/Function0;)V", "plugin", "Lpl/syntaxdevteam/punisher/PunisherX;", "(Lpl/syntaxdevteam/punisher/PunisherX;)V", "dateFormatter", "Ljava/time/format/DateTimeFormatter;", "parseTime", "time", "formatTime", "parseDate", "date", "(Ljava/lang/String;)Ljava/lang/Long;", "getOfflineDuration", "lastUpdated", "getLocalizedMessage", "unit", "amount", "PunisherX"})
@SourceDebugExtension(value={"SMAP\nTimeHandler.kt\nKotlin\n*S Kotlin\n*F\n+ 1 TimeHandler.kt\npl/syntaxdevteam/punisher/basic/TimeHandler\n+ 2 _Strings.kt\nkotlin/text/StringsKt___StringsKt\n*L\n1#1,114:1\n1069#2,2:115\n*S KotlinDebug\n*F\n+ 1 TimeHandler.kt\npl/syntaxdevteam/punisher/basic/TimeHandler\n*L\n36#1:115,2\n*E\n"})
public final class TimeHandler {
    @NotNull
    private final Function2<String, String, String> messageLookup;
    @NotNull
    private final Function0<Long> currentTime;
    @NotNull
    private final DateTimeFormatter dateFormatter;

    public TimeHandler(@NotNull Function2<? super String, ? super String, String> messageLookup, @NotNull Function0<Long> currentTime) {
        Intrinsics.checkNotNullParameter(messageLookup, "messageLookup");
        Intrinsics.checkNotNullParameter(currentTime, "currentTime");
        this.messageLookup = messageLookup;
        this.currentTime = currentTime;
        DateTimeFormatter dateTimeFormatter = DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss");
        Intrinsics.checkNotNullExpressionValue(dateTimeFormatter, "ofPattern(...)");
        this.dateFormatter = dateTimeFormatter;
    }

    public /* synthetic */ TimeHandler(Function2 function2, Function0 function0, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            function0 = 1.INSTANCE;
        }
        this(function2, function0);
    }

    public TimeHandler(@NotNull PunisherX plugin) {
        Intrinsics.checkNotNullParameter((Object)plugin, "plugin");
        this((arg_0, arg_1) -> TimeHandler._init_$lambda$0(plugin, arg_0, arg_1), 3.INSTANCE);
    }

    public final long parseTime(@NotNull String time) {
        Intrinsics.checkNotNullParameter(time, "time");
        long amount = Long.parseLong(StringsKt.dropLast(time, 1));
        char unit = StringsKt.last(time);
        return switch (unit) {
            case 's' -> amount;
            case 'm' -> amount * (long)60;
            case 'h' -> amount * (long)60 * (long)60;
            case 'd' -> amount * (long)60 * (long)60 * (long)24;
            default -> 0L;
        };
    }

    @NotNull
    public final String formatTime(@Nullable String time) {
        boolean isNumeric;
        block13: {
            boolean bl;
            if (time == null) {
                return this.messageLookup.invoke("formatTime", "undefined");
            }
            CharSequence $this$all$iv = time;
            boolean $i$f$all = false;
            for (int i = 0; i < $this$all$iv.length(); ++i) {
                char element$iv;
                char it = element$iv = $this$all$iv.charAt(i);
                boolean bl2 = false;
                if (Character.isDigit(it)) continue;
                bl = false;
                break block13;
            }
            bl = isNumeric = true;
        }
        if (isNumeric) {
            long totalSeconds = Long.parseLong(time);
            long days = totalSeconds / (long)86400;
            long hours = totalSeconds % (long)86400 / (long)3600;
            long minutes = totalSeconds % (long)3600 / (long)60;
            long seconds = totalSeconds % (long)60;
            String dayMessage = this.getLocalizedMessage("day", days);
            String hourMessage = this.getLocalizedMessage("hour", hours);
            String minuteMessage = this.getLocalizedMessage("minute", minutes);
            String secondMessage = this.getLocalizedMessage("second", seconds);
            List timeComponents = new ArrayList();
            if (days > 0L) {
                timeComponents.add(days + " " + dayMessage);
            }
            if (hours > 0L) {
                timeComponents.add(hours + " " + hourMessage);
            }
            if (minutes > 0L) {
                timeComponents.add(minutes + " " + minuteMessage);
            }
            if (seconds > 0L) {
                timeComponents.add(seconds + " " + secondMessage);
            }
            return CollectionsKt.joinToString$default(timeComponents, ", ", null, null, 0, null, null, 62, null);
        }
        long amount = Long.parseLong(StringsKt.dropLast(time, 1));
        char unit = StringsKt.last(time);
        return switch (unit) {
            case 's' -> amount + " " + this.getLocalizedMessage("second", amount);
            case 'm' -> amount + " " + this.getLocalizedMessage("minute", amount);
            case 'h' -> amount + " " + this.getLocalizedMessage("hour", amount);
            case 'd' -> amount + " " + this.getLocalizedMessage("day", amount);
            default -> this.messageLookup.invoke("formatTime", "undefined");
        };
    }

    @Nullable
    public final Long parseDate(@NotNull String date) {
        Long l;
        Intrinsics.checkNotNullParameter(date, "date");
        try {
            l = LocalDateTime.parse(date, this.dateFormatter).atZone(ZoneId.systemDefault()).toInstant().toEpochMilli();
        }
        catch (Exception exception) {
            l = null;
        }
        return l;
    }

    @NotNull
    public final String getOfflineDuration(@NotNull String lastUpdated) {
        Intrinsics.checkNotNullParameter(lastUpdated, "lastUpdated");
        Long l = this.parseDate(lastUpdated);
        if (l == null) {
            return this.messageLookup.invoke("error", "no_data");
        }
        long ts = l;
        long seconds = RangesKt.coerceAtLeast((((Number)this.currentTime.invoke()).longValue() - ts) / (long)1000, 0L);
        long years = seconds / (long)31536000;
        long months = (seconds %= (long)31536000) / (long)2592000;
        long weeks = (seconds %= (long)2592000) / (long)604800;
        long days = (seconds %= (long)604800) / (long)86400;
        long hours = (seconds %= (long)86400) / (long)3600;
        long minutes = (seconds %= (long)3600) / (long)60;
        seconds %= (long)60;
        List parts = new ArrayList();
        if (years > 0L) {
            parts.add(years + "Y");
        }
        if (months > 0L) {
            parts.add(months + "M");
        }
        if (weeks > 0L) {
            parts.add(weeks + "W");
        }
        if (days > 0L) {
            parts.add(days + "d");
        }
        if (hours > 0L) {
            parts.add(hours + "h");
        }
        if (minutes > 0L) {
            parts.add(minutes + "m");
        }
        if (seconds > 0L || parts.isEmpty()) {
            parts.add(seconds + "s");
        }
        return CollectionsKt.joinToString$default(parts, " ", null, null, 0, null, null, 62, null);
    }

    private final String getLocalizedMessage(String unit, long amount) {
        String unitPath = "formatTime." + unit;
        long l = amount;
        return l == 1L ? this.messageLookup.invoke(unitPath, "one") : ((2L <= l ? l < 5L : false) ? this.messageLookup.invoke(unitPath, "few") : this.messageLookup.invoke(unitPath, "many"));
    }

    private static final String _init_$lambda$0(PunisherX $plugin, String path, String key) {
        Intrinsics.checkNotNullParameter(path, "path");
        Intrinsics.checkNotNullParameter(key, "key");
        return MessageHandler.stringMessageToStringNoPrefix$default((MessageHandler)$plugin.getMessageHandler(), (String)path, (String)key, null, (int)4, null);
    }
}

