/*
 * Decompiled with CFR 0.152.
 */
package pl.syntaxdevteam.punisher.basic;

import io.papermc.paper.event.player.AsyncChatEvent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import java.util.UUID;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.minimessage.tag.resolver.TagResolver;
import net.kyori.adventure.text.serializer.plain.PlainTextComponentSerializer;
import org.bukkit.GameMode;
import org.bukkit.Location;
import org.bukkit.OfflinePlayer;
import org.bukkit.command.CommandSender;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.player.PlayerCommandPreprocessEvent;
import org.bukkit.event.player.PlayerJoinEvent;
import org.bukkit.event.player.PlayerMoveEvent;
import org.jetbrains.annotations.NotNull;
import pl.syntaxdevteam.core.SyntaxCore;
import pl.syntaxdevteam.core.update.UpdateChecker;
import pl.syntaxdevteam.message.MessageHandler;
import pl.syntaxdevteam.punisher.PunisherX;
import pl.syntaxdevteam.punisher.basic.JailUtils;
import pl.syntaxdevteam.punisher.basic.PunishmentCache;
import pl.syntaxdevteam.punisher.databases.DatabaseHandler;
import pl.syntaxdevteam.punisher.databases.PunishmentData;
import pl.syntaxdevteam.punisher.permissions.PermissionChecker;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0006\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u000e\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bJ\u0010\u0010\f\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\rH\u0007J\u0010\u0010\u000e\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000fH\u0007J \u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00132\u0006\u0010\u0015\u001a\u00020\u0016H\u0002J\u0010\u0010\u0017\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u0018H\u0007R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0019"}, d2={"Lpl/syntaxdevteam/punisher/basic/PunishmentChecker;", "Lorg/bukkit/event/Listener;", "plugin", "Lpl/syntaxdevteam/punisher/PunisherX;", "<init>", "(Lpl/syntaxdevteam/punisher/PunisherX;)V", "updateChecker", "Lpl/syntaxdevteam/core/update/UpdateChecker;", "handlePlayerJoin", "", "event", "Lorg/bukkit/event/player/PlayerJoinEvent;", "onPlayerChat", "Lio/papermc/paper/event/player/AsyncChatEvent;", "onPlayerCommand", "Lorg/bukkit/event/player/PlayerCommandPreprocessEvent;", "isPlayerInJail", "", "playerLocation", "Lorg/bukkit/Location;", "jailCenter", "radius", "", "onPlayerMove", "Lorg/bukkit/event/player/PlayerMoveEvent;", "PunisherX"})
@SourceDebugExtension(value={"SMAP\nPunishmentChecker.kt\nKotlin\n*S Kotlin\n*F\n+ 1 PunishmentChecker.kt\npl/syntaxdevteam/punisher/basic/PunishmentChecker\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,258:1\n1869#2,2:259\n1869#2,2:261\n1563#2:263\n1634#2,3:264\n1761#2,3:267\n1761#2,3:270\n*S KotlinDebug\n*F\n+ 1 PunishmentChecker.kt\npl/syntaxdevteam/punisher/basic/PunishmentChecker\n*L\n157#1:259,2\n176#1:261,2\n198#1:263\n198#1:264,3\n207#1:267,3\n48#1:270,3\n*E\n"})
public final class PunishmentChecker
implements Listener {
    @NotNull
    private final PunisherX plugin;
    @NotNull
    private final UpdateChecker updateChecker;

    public PunishmentChecker(@NotNull PunisherX plugin) {
        Intrinsics.checkNotNullParameter((Object)plugin, "plugin");
        this.plugin = plugin;
        this.updateChecker = SyntaxCore.INSTANCE.getUpdateChecker();
    }

    public final void handlePlayerJoin(@NotNull PlayerJoinEvent event) {
        boolean locationsConfigured;
        Intrinsics.checkNotNullParameter(event, "event");
        Player player = event.getPlayer();
        Intrinsics.checkNotNullExpressionValue(player, "getPlayer(...)");
        Player player2 = player;
        String string = player2.getName();
        Intrinsics.checkNotNullExpressionValue(string, "getName(...)");
        String name = string;
        UUID uUID = player2.getUniqueId();
        Intrinsics.checkNotNullExpressionValue(uUID, "getUniqueId(...)");
        UUID uuid = uUID;
        double radius = this.plugin.getConfig().getDouble("jail.radius", 10.0);
        FileConfiguration fileConfiguration = this.plugin.getConfig();
        Intrinsics.checkNotNullExpressionValue(fileConfiguration, "getConfig(...)");
        Location jailLoc = JailUtils.INSTANCE.getJailLocation(fileConfiguration);
        FileConfiguration fileConfiguration2 = this.plugin.getConfig();
        Intrinsics.checkNotNullExpressionValue(fileConfiguration2, "getConfig(...)");
        Location unjailLoc = JailUtils.getUnjailLocation$default(JailUtils.INSTANCE, fileConfiguration2, this.plugin.getHookHandler(), null, (OfflinePlayer)player2, this.plugin.getSafeTeleportService(), 4, null);
        if (PermissionChecker.INSTANCE.isAuthor(uuid)) {
            player2.sendMessage(this.plugin.getMessageHandler().formatMixedTextToMiniMessage(this.plugin.getMessageHandler().getPrefix() + " <green>Witaj, <b>" + name + "</b><newline>    Ten serwer u\u017cywa " + this.plugin.getPluginMeta().getName() + " " + this.plugin.getPluginMeta().getVersion() + " \u2764", TagResolver.empty()));
        }
        boolean bl = locationsConfigured = jailLoc != null && unjailLoc != null;
        if (!locationsConfigured) {
            this.plugin.getLogger().warning("Jail lub unjail location niezdefiniowane!");
        } else {
            this.plugin.getSchedulerAdapter().runAsync(() -> PunishmentChecker.handlePlayerJoin$lambda$0(this, uuid, player2, jailLoc, radius, unjailLoc, name));
        }
        if (PermissionChecker.INSTANCE.hasWithLegacy((CommandSender)player2, PermissionChecker.PermissionKey.SEE_UPDATE)) {
            this.updateChecker.checkForUpdatesForPlayer(player2);
            this.plugin.getLogger().debug("Checking for updates for player: " + name);
        } else {
            this.plugin.getLogger().debug("Player " + name + " does not have permission to see updates.");
        }
    }

    @EventHandler(priority=EventPriority.HIGHEST, ignoreCancelled=true)
    public final void onPlayerChat(@NotNull AsyncChatEvent event) {
        Intrinsics.checkNotNullParameter(event, "event");
        Player player = event.getPlayer();
        Intrinsics.checkNotNullExpressionValue(player, "getPlayer(...)");
        Player player2 = player;
        String string = player2.getName();
        Intrinsics.checkNotNullExpressionValue(string, "getName(...)");
        String playerName = string;
        try {
            String string2 = player2.getUniqueId().toString();
            Intrinsics.checkNotNullExpressionValue(string2, "toString(...)");
            String uuid = string2;
            Component component = event.message();
            Intrinsics.checkNotNullExpressionValue(component, "message(...)");
            Component messageComponent = component;
            String string3 = PlainTextComponentSerializer.plainText().serialize(messageComponent);
            Intrinsics.checkNotNullExpressionValue(string3, "serialize(...)");
            String plainMessage = string3;
            List punishments = DatabaseHandler.getPunishments$default(this.plugin.getDatabaseHandler(), uuid, null, null, 6, null);
            if (punishments.isEmpty()) {
                this.plugin.getLogger().debug("No punishments found for player: " + playerName);
                return;
            }
            for (PunishmentData punishment : punishments) {
                if (!Intrinsics.areEqual(punishment.getType(), "MUTE") && !Intrinsics.areEqual(punishment.getType(), "JAIL")) continue;
                if (this.plugin.getPunishmentManager().isPunishmentActive(punishment)) {
                    event.setCancelled(true);
                    long endTime = punishment.getEnd();
                    String remainingTime = endTime == -1L ? "permanent" : this.plugin.getTimeHandler().formatTime(String.valueOf((endTime - System.currentTimeMillis()) / (long)1000));
                    String reason = punishment.getReason();
                    String messageKey = Intrinsics.areEqual(punishment.getType(), "JAIL") ? "jail" : "mute";
                    Pair[] pairArray = new Pair[]{TuplesKt.to("reason", reason), TuplesKt.to("time", remainingTime)};
                    Component infoMessage = this.plugin.getMessageHandler().stringMessageToComponent(messageKey, "mute_info_message", MapsKt.mapOf(pairArray));
                    Pair[] pairArray2 = new Pair[]{TuplesKt.to("player", playerName), TuplesKt.to("message", plainMessage)};
                    Component logMessage = this.plugin.getMessageHandler().stringMessageToComponentNoPrefix(messageKey, "log", MapsKt.mapOf(pairArray2));
                    this.plugin.getLogger().clearLog(logMessage);
                    player2.sendMessage(infoMessage);
                    return;
                }
                this.plugin.getDatabaseHandler().removePunishment(uuid, punishment.getType(), true);
                this.plugin.getLogger().debug("Punishment for UUID: " + uuid + " has expired and has been removed");
            }
        }
        catch (Exception e) {
            this.plugin.getLogger().severe("Error in onPlayerChat, report it urgently to the plugin author: " + e.getMessage());
            e.printStackTrace();
        }
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @EventHandler(priority=EventPriority.HIGHEST, ignoreCancelled=true)
    public final void onPlayerCommand(@NotNull PlayerCommandPreprocessEvent event) {
        Intrinsics.checkNotNullParameter(event, "event");
        try {
            boolean bl;
            String[] $this$mapTo$iv$iv;
            void $this$map$iv;
            PunishmentData punishment;
            Object element$iv2;
            boolean $i$f$forEach22;
            Iterable $this$forEach$iv;
            String originalCommand;
            Player player = event.getPlayer();
            Intrinsics.checkNotNullExpressionValue(player, "getPlayer(...)");
            Player player2 = player;
            String string = player2.getUniqueId().toString();
            Intrinsics.checkNotNullExpressionValue(string, "toString(...)");
            String uuid = string;
            String string2 = event.getMessage();
            Intrinsics.checkNotNullExpressionValue(string2, "getMessage(...)");
            String[] stringArray = new String[]{" "};
            String string3 = originalCommand = (String)StringsKt.split$default((CharSequence)string2, stringArray, false, 0, 6, null).get(0);
            Locale locale = Locale.getDefault();
            Intrinsics.checkNotNullExpressionValue(locale, "getDefault(...)");
            String string4 = string3.toLowerCase(locale);
            Intrinsics.checkNotNullExpressionValue(string4, "toLowerCase(...)");
            String command = StringsKt.removePrefix(string4, (CharSequence)"/");
            List punishments = DatabaseHandler.getPunishments$default(this.plugin.getDatabaseHandler(), uuid, null, null, 6, null);
            if (this.plugin.getConfig().getBoolean("mute.pm")) {
                List list = this.plugin.getConfig().getStringList("mute.cmd");
                Intrinsics.checkNotNullExpressionValue(list, "getStringList(...)");
                List muteCommands = list;
                if (muteCommands.contains(command)) {
                    $this$forEach$iv = punishments;
                    $i$f$forEach22 = false;
                    for (Object element$iv2 : $this$forEach$iv) {
                        punishment = (PunishmentData)element$iv2;
                        boolean bl2 = false;
                        if (Intrinsics.areEqual(punishment.getType(), "MUTE") && this.plugin.getPunishmentManager().isPunishmentActive(punishment)) {
                            long endTime = punishment.getEnd();
                            long remainingTime = (endTime - System.currentTimeMillis()) / (long)1000;
                            String duration = endTime == -1L ? "permanent" : this.plugin.getTimeHandler().formatTime(String.valueOf(remainingTime));
                            String reason = punishment.getReason();
                            event.setCancelled(true);
                            Pair[] pairArray = new Pair[]{TuplesKt.to("reason", reason), TuplesKt.to("time", duration)};
                            Component muteMessage = this.plugin.getMessageHandler().stringMessageToComponent("mute", "mute_info_message", MapsKt.mapOf(pairArray));
                            player2.sendMessage(muteMessage);
                            continue;
                        }
                        if (!Intrinsics.areEqual(punishment.getType(), "MUTE")) continue;
                        this.plugin.getDatabaseHandler().removePunishment(uuid, "MUTE", true);
                        this.plugin.getLogger().debug("Punishment for UUID: " + uuid + " has expired and has been removed");
                    }
                }
            }
            boolean activeJailFound = false;
            $this$forEach$iv = punishments;
            $i$f$forEach22 = false;
            for (Object element$iv2 : $this$forEach$iv) {
                punishment = (PunishmentData)element$iv2;
                boolean bl3 = false;
                if (!Intrinsics.areEqual(punishment.getType(), "JAIL")) continue;
                if (this.plugin.getPunishmentManager().isPunishmentActive(punishment)) {
                    activeJailFound = true;
                    continue;
                }
                this.plugin.getDatabaseHandler().removePunishment(uuid, "JAIL", true);
                this.plugin.getLogger().debug("Punishment for UUID: " + uuid + " has expired and has been removed");
            }
            if (!activeJailFound) {
                return;
            }
            if (PermissionChecker.INSTANCE.hasWithBypass((CommandSender)player2, PermissionChecker.PermissionKey.BYPASS_JAIL)) {
                return;
            }
            List list = this.plugin.getConfig().getStringList("jail.allowed_commands");
            Intrinsics.checkNotNullExpressionValue(list, "getStringList(...)");
            Iterable $i$f$forEach22 = list;
            boolean $i$f$map = false;
            element$iv2 = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
            boolean $i$f$mapTo = false;
            for (Object t : $this$mapTo$iv$iv) {
                void it;
                String remainingTime = (String)t;
                Collection collection = destination$iv$iv;
                boolean bl4 = false;
                Intrinsics.checkNotNull(it);
                void var18_26 = it;
                Locale locale2 = Locale.getDefault();
                Intrinsics.checkNotNullExpressionValue(locale2, "getDefault(...)");
                String string5 = var18_26.toLowerCase(locale2);
                Intrinsics.checkNotNullExpressionValue(string5, "toLowerCase(...)");
                collection.add(StringsKt.removePrefix(string5, (CharSequence)"/"));
            }
            Set allowedCommands = CollectionsKt.toSet((List)destination$iv$iv);
            boolean allowAllCommands = allowedCommands.contains("*");
            $this$mapTo$iv$iv = new String[]{command};
            Set<String> commandAliases = SetsKt.mutableSetOf($this$mapTo$iv$iv);
            if (StringsKt.contains$default((CharSequence)command, ":", false, 2, null)) {
                commandAliases.add(StringsKt.substringAfter$default(command, ":", null, 2, null));
            }
            if (allowAllCommands) return;
            Iterable $this$any$iv = commandAliases;
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object t : $this$any$iv) {
                    String it = (String)t;
                    boolean bl5 = false;
                    if (!allowedCommands.contains(it)) continue;
                    return;
                }
                bl = false;
            }
            if (bl) {
                return;
            }
            boolean bl6 = false;
            boolean isAllowed = bl6;
            if (isAllowed) return;
            event.setCancelled(true);
            Component message = MessageHandler.stringMessageToComponent$default((MessageHandler)this.plugin.getMessageHandler(), (String)"jail", (String)"command_blocked_message", null, (int)4, null);
            player2.sendMessage(message);
            this.plugin.getLogger().debug("Blocked command '" + originalCommand + "' for jailed player " + player2.getName());
            return;
        }
        catch (Exception e) {
            this.plugin.getLogger().severe("Error in onPlayerCommand, report it urgently to the plugin author with the message: " + event.getPlayer().getName() + ": " + e.getMessage());
            e.printStackTrace();
        }
    }

    private final boolean isPlayerInJail(Location playerLocation, Location jailCenter, double radius) {
        return Intrinsics.areEqual(playerLocation.getWorld(), jailCenter.getWorld()) && playerLocation.distance(jailCenter) <= radius;
    }

    @EventHandler(priority=EventPriority.HIGHEST, ignoreCancelled=true)
    public final void onPlayerMove(@NotNull PlayerMoveEvent event) {
        Intrinsics.checkNotNullParameter(event, "event");
        Player player = event.getPlayer();
        Intrinsics.checkNotNullExpressionValue(player, "getPlayer(...)");
        Player player2 = player;
        UUID uUID = player2.getUniqueId();
        Intrinsics.checkNotNullExpressionValue(uUID, "getUniqueId(...)");
        UUID uuid = uUID;
        FileConfiguration fileConfiguration = this.plugin.getConfig();
        Intrinsics.checkNotNullExpressionValue(fileConfiguration, "getConfig(...)");
        Location location = JailUtils.INSTANCE.getJailLocation(fileConfiguration);
        if (location == null) {
            return;
        }
        Location jailLocation = location;
        Long l = this.plugin.getCache().getPunishmentEnd(uuid);
        if (l == null) {
            return;
        }
        long punishmentEnd = l;
        if (!this.plugin.getCache().isPlayerInCache(uuid)) {
            return;
        }
        if (punishmentEnd != -1L && punishmentEnd < System.currentTimeMillis()) {
            PunishmentCache.removePunishment$default(this.plugin.getCache(), uuid, false, false, 6, null);
            player2.setGameMode(GameMode.SURVIVAL);
            return;
        }
        double radius = this.plugin.getConfig().getDouble("jail.radius", 10.0);
        Location location2 = player2.getLocation();
        Intrinsics.checkNotNullExpressionValue(location2, "getLocation(...)");
        if (this.isPlayerInJail(location2, jailLocation, radius)) {
            return;
        }
        this.plugin.getSafeTeleportService().teleportSafely(player2, jailLocation, arg_0 -> PunishmentChecker.onPlayerMove$lambda$0(this, player2, arg_0));
    }

    private static final void handlePlayerJoin$lambda$0(PunishmentChecker this$0, UUID $uuid, Player $player, Location $jailLoc, double $radius, Location $unjailLoc, String $name) {
        boolean bl;
        block3: {
            DatabaseHandler databaseHandler = this$0.plugin.getDatabaseHandler();
            String string = $uuid.toString();
            Intrinsics.checkNotNullExpressionValue(string, "toString(...)");
            List punishments = DatabaseHandler.getPunishments$default(databaseHandler, string, null, null, 6, null);
            Iterable $this$any$iv = punishments;
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    PunishmentData it = (PunishmentData)element$iv;
                    boolean bl2 = false;
                    if (!(Intrinsics.areEqual(it.getType(), "JAIL") && this$0.plugin.getPunishmentManager().isPunishmentActive(it))) continue;
                    bl = true;
                    break block3;
                }
                bl = false;
            }
        }
        boolean isJailed = bl;
        this$0.plugin.getSchedulerAdapter().runSync(() -> PunishmentChecker.handlePlayerJoin$lambda$0$1($player, this$0, isJailed, $jailLoc, $radius, $unjailLoc, $name));
    }

    private static final void handlePlayerJoin$lambda$0$1(Player $player, PunishmentChecker this$0, boolean $isJailed, Location $jailLoc, double $radius, Location $unjailLoc, String $name) {
        Pair<Location, GameMode> pair;
        if (!$player.isOnline()) {
            this$0.plugin.getLogger().debug("Pomijam teleportacj\u0119 " + $player.getName() + ", gracz jest offline");
            return;
        }
        if ($isJailed) {
            pair = TuplesKt.to($jailLoc, GameMode.ADVENTURE);
        } else {
            Location location = $player.getLocation();
            Intrinsics.checkNotNullExpressionValue(location, "getLocation(...)");
            if (this$0.isPlayerInJail(location, $jailLoc, $radius)) {
                pair = TuplesKt.to($unjailLoc, GameMode.SURVIVAL);
            } else {
                return;
            }
        }
        Pair<Location, GameMode> pair2 = pair;
        Location targetLoc = pair2.component1();
        GameMode targetMode = pair2.component2();
        if (targetLoc.getWorld() == null) {
            this$0.plugin.getLogger().warning("Brak \u015bwiata dla " + targetLoc);
            return;
        }
        this$0.plugin.getSafeTeleportService().teleportSafely($player, targetLoc, arg_0 -> PunishmentChecker.handlePlayerJoin$lambda$0$1$0($player, targetMode, this$0, targetLoc, arg_0));
        this$0.plugin.getLogger().debug("Scheduling teleport of " + $name + " to " + targetLoc + " with gamemode " + targetMode + " (jailed=" + $isJailed + ")");
    }

    private static final Unit handlePlayerJoin$lambda$0$1$0(Player $player, GameMode $targetMode, PunishmentChecker this$0, Location $targetLoc, boolean success) {
        if (success) {
            $player.setGameMode($targetMode);
            this$0.plugin.getLogger().debug("Player " + $player.getName() + " teleported to " + $targetLoc + " and set to " + $targetMode);
        } else {
            this$0.plugin.getLogger().debug("<red>Failed to teleport " + $player.getName() + " to " + $targetLoc + ".</red>");
        }
        return Unit.INSTANCE;
    }

    private static final Unit onPlayerMove$lambda$0(PunishmentChecker this$0, Player $player, boolean success) {
        if (success) {
            Component message = this$0.plugin.getMessageHandler().stringMessageToComponent("jail", "jail_restrict_message", MapsKt.emptyMap());
            $player.sendMessage(message);
        } else {
            this$0.plugin.getLogger().debug("<red>Failed to teleport player back to jail.</red>");
        }
        return Unit.INSTANCE;
    }
}

