/*
 * Decompiled with CFR 0.152.
 */
package pl.syntaxdevteam.punisher.basic;

import io.papermc.paper.threadedregions.scheduler.ScheduledTask;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import kotlin.text.StringsKt;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.TextComponent;
import net.kyori.adventure.text.format.NamedTextColor;
import net.kyori.adventure.text.format.TextColor;
import org.bukkit.Location;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitTask;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import pl.syntaxdevteam.core.platform.ServerEnvironment;
import pl.syntaxdevteam.message.MessageHandler;
import pl.syntaxdevteam.punisher.PunisherX;
import pl.syntaxdevteam.punisher.databases.DatabaseHandler;
import pl.syntaxdevteam.punisher.databases.PunishmentData;
import pl.syntaxdevteam.punisher.platform.SchedulerAdapter;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000N\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\u0018\u0000 \u001d2\u00020\u0001:\u0001\u001dB\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0006\u0010\n\u001a\u00020\u000bJ\u0006\u0010\f\u001a\u00020\u000bJ\b\u0010\r\u001a\u00020\u000bH\u0002J\u0018\u0010\u000e\u001a\u00020\u000b2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012H\u0002J \u0010\u0013\u001a\u0004\u0018\u00010\u00122\f\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00160\u00152\u0006\u0010\u0017\u001a\u00020\u0018H\u0002J0\u0010\u0019\u001a\u0004\u0018\u00010\u00122\f\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00160\u00152\u0006\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u001b2\u0006\u0010\u0017\u001a\u00020\u0018H\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0006\u001a\u0004\u0018\u00010\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\b\u001a\u0004\u0018\u00010\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001e"}, d2={"Lpl/syntaxdevteam/punisher/basic/PunishmentActionBarNotifier;", "", "plugin", "Lpl/syntaxdevteam/punisher/PunisherX;", "<init>", "(Lpl/syntaxdevteam/punisher/PunisherX;)V", "asyncTask", "Lorg/bukkit/scheduler/BukkitTask;", "foliaTask", "Lio/papermc/paper/threadedregions/scheduler/ScheduledTask;", "start", "", "stop", "notifyPlayers", "sendActionBar", "player", "Lorg/bukkit/entity/Player;", "message", "Lnet/kyori/adventure/text/Component;", "buildActionBar", "punishments", "", "Lpl/syntaxdevteam/punisher/databases/PunishmentData;", "now", "", "getRemainingTimeComponent", "type", "", "messageKey", "Companion", "PunisherX"})
@SourceDebugExtension(value={"SMAP\nPunishmentActionBarNotifier.kt\nKotlin\n*S Kotlin\n*F\n+ 1 PunishmentActionBarNotifier.kt\npl/syntaxdevteam/punisher/basic/PunishmentActionBarNotifier\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,107:1\n1869#2:108\n774#2:109\n865#2,2:110\n1870#2:112\n2783#2,7:114\n295#2,2:121\n1#3:113\n*S KotlinDebug\n*F\n+ 1 PunishmentActionBarNotifier.kt\npl/syntaxdevteam/punisher/basic/PunishmentActionBarNotifier\n*L\n53#1:108\n55#1:109\n55#1:110,2\n53#1:112\n80#1:114,7\n91#1:121,2\n*E\n"})
public final class PunishmentActionBarNotifier {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final PunisherX plugin;
    @Nullable
    private BukkitTask asyncTask;
    @Nullable
    private ScheduledTask foliaTask;
    private static final long DEFAULT_PERIOD_TICKS = 20L;
    @NotNull
    private static final String PERMANENT_LABEL = "permanent";
    @NotNull
    private static final TextComponent SEPARATOR_COMPONENT;

    public PunishmentActionBarNotifier(@NotNull PunisherX plugin) {
        Intrinsics.checkNotNullParameter((Object)plugin, "plugin");
        this.plugin = plugin;
    }

    public final void start() {
        this.stop();
        if (!this.plugin.getConfig().getBoolean("notifications.punishment_bar.enabled", true)) {
            return;
        }
        long periodTicks = this.plugin.getConfig().getLong("notifications.punishment_bar.period_ticks", 20L);
        if (ServerEnvironment.INSTANCE.isFoliaBased()) {
            this.foliaTask = this.plugin.getServer().getGlobalRegionScheduler().runAtFixedRate((Plugin)this.plugin, arg_0 -> PunishmentActionBarNotifier.start$lambda$0(this, arg_0), periodTicks, periodTicks);
        } else {
            this.asyncTask = this.plugin.getServer().getScheduler().runTaskTimerAsynchronously((Plugin)this.plugin, () -> PunishmentActionBarNotifier.start$lambda$1(this), periodTicks, periodTicks);
        }
    }

    public final void stop() {
        BukkitTask bukkitTask = this.asyncTask;
        if (bukkitTask != null) {
            bukkitTask.cancel();
        }
        this.asyncTask = null;
        ScheduledTask scheduledTask = this.foliaTask;
        if (scheduledTask != null) {
            scheduledTask.cancel();
        }
        this.foliaTask = null;
    }

    /*
     * WARNING - void declaration
     */
    private final void notifyPlayers() {
        long now = System.currentTimeMillis();
        Collection collection = this.plugin.getServer().getOnlinePlayers();
        Intrinsics.checkNotNullExpressionValue(collection, "getOnlinePlayers(...)");
        Collection onlinePlayers = collection;
        if (onlinePlayers.isEmpty()) {
            return;
        }
        Iterable $this$forEach$iv = onlinePlayers;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Component actionBarMessage;
            void $this$filterTo$iv$iv;
            void $this$filter$iv;
            Player player = (Player)element$iv;
            boolean bl = false;
            DatabaseHandler databaseHandler = this.plugin.getDatabaseHandler();
            String string = player.getUniqueId().toString();
            Intrinsics.checkNotNullExpressionValue(string, "toString(...)");
            Iterable iterable = DatabaseHandler.getPunishments$default(databaseHandler, string, null, null, 6, null);
            boolean $i$f$filter = false;
            void var12_11 = $this$filter$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterTo = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv) {
                PunishmentData it = (PunishmentData)element$iv$iv;
                boolean bl2 = false;
                if (!this.plugin.getPunishmentManager().isPunishmentActive(it)) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            List punishments = (List)destination$iv$iv;
            if (this.buildActionBar(punishments, now) == null) continue;
            Intrinsics.checkNotNull(player);
            this.sendActionBar(player, actionBarMessage);
        }
    }

    private final void sendActionBar(Player player, Component message) {
        SchedulerAdapter schedulerAdapter = this.plugin.getSchedulerAdapter();
        Location location = player.getLocation();
        Intrinsics.checkNotNullExpressionValue(location, "getLocation(...)");
        schedulerAdapter.runRegionally(location, () -> PunishmentActionBarNotifier.sendActionBar$lambda$0(player, message));
    }

    /*
     * WARNING - void declaration
     */
    private final Component buildActionBar(List<PunishmentData> punishments, long now) {
        Component it;
        List components = new ArrayList();
        Component component = this.getRemainingTimeComponent(punishments, "JAIL", "jail_remaining_time", now);
        if (component != null) {
            it = component;
            boolean bl = false;
            components.add(it);
        }
        Component component2 = this.getRemainingTimeComponent(punishments, "MUTE", "mute_remaining_time", now);
        if (component2 != null) {
            it = component2;
            boolean bl = false;
            components.add(it);
        }
        if (components.isEmpty()) {
            return null;
        }
        Iterable $this$reduce$iv = components;
        boolean $i$f$reduce = false;
        Iterator iterator$iv = $this$reduce$iv.iterator();
        if (!iterator$iv.hasNext()) {
            throw new UnsupportedOperationException("Empty collection can't be reduced.");
        }
        Object accumulator$iv = iterator$iv.next();
        while (iterator$iv.hasNext()) {
            void component3;
            Component component4 = (Component)iterator$iv.next();
            Component acc = (Component)accumulator$iv;
            boolean bl = false;
            Intrinsics.checkNotNullExpressionValue(acc.append((Component)SEPARATOR_COMPONENT).append((Component)component3), "append(...)");
        }
        return (Component)accumulator$iv;
    }

    private final Component getRemainingTimeComponent(List<PunishmentData> punishments, String type, String messageKey, long now) {
        String string;
        block7: {
            block6: {
                Object v0;
                block5: {
                    Iterable $this$firstOrNull$iv = punishments;
                    boolean $i$f$firstOrNull = false;
                    for (Object element$iv : $this$firstOrNull$iv) {
                        PunishmentData it = (PunishmentData)element$iv;
                        boolean bl = false;
                        if (!StringsKt.equals(it.getType(), type, true)) continue;
                        v0 = element$iv;
                        break block5;
                    }
                    v0 = null;
                }
                PunishmentData punishmentData = v0;
                if (punishmentData == null) {
                    return null;
                }
                PunishmentData punishment = punishmentData;
                long endTime = punishment.getEnd();
                Object remainingSeconds = endTime == -1L ? null : Long.valueOf(RangesKt.coerceAtLeast((endTime - now) / (long)1000, 0L));
                string = remainingSeconds;
                if (string == null) break block6;
                long it = ((Number)((Object)string)).longValue();
                boolean bl = false;
                String string2 = this.plugin.getTimeHandler().formatTime(String.valueOf(it));
                string = string2;
                if (string2 != null) break block7;
            }
            string = PERMANENT_LABEL;
        }
        String timeText = string;
        Component baseMessage = MessageHandler.stringMessageToComponentNoPrefix$default((MessageHandler)this.plugin.getMessageHandler(), (String)"placeholders", (String)messageKey, null, (int)4, null);
        TextComponent textComponent = Component.text((String)timeText, (TextColor)((TextColor)NamedTextColor.GOLD));
        Intrinsics.checkNotNullExpressionValue(textComponent, "text(...)");
        TextComponent timeComponent = textComponent;
        return baseMessage.append((Component)timeComponent);
    }

    private static final void start$lambda$0(PunishmentActionBarNotifier this$0, ScheduledTask scheduledTask) {
        this$0.notifyPlayers();
    }

    private static final void start$lambda$1(PunishmentActionBarNotifier this$0) {
        this$0.notifyPlayers();
    }

    private static final void sendActionBar$lambda$0(Player $player, Component $message) {
        if ($player.isOnline()) {
            $player.sendActionBar($message);
        }
    }

    static {
        TextComponent textComponent = Component.text((String)" | ", (TextColor)((TextColor)NamedTextColor.DARK_GRAY));
        Intrinsics.checkNotNullExpressionValue(textComponent, "text(...)");
        SEPARATOR_COMPONENT = textComponent;
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\t\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082T\u00a2\u0006\u0002\n\u0000R\u0013\u0010\b\u001a\u00070\t\u00a2\u0006\u0002\b\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000b"}, d2={"Lpl/syntaxdevteam/punisher/basic/PunishmentActionBarNotifier$Companion;", "", "<init>", "()V", "DEFAULT_PERIOD_TICKS", "", "PERMANENT_LABEL", "", "SEPARATOR_COMPONENT", "Lnet/kyori/adventure/text/TextComponent;", "Lorg/jetbrains/annotations/NotNull;", "PunisherX"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

