/*
 * Decompiled with CFR 0.152.
 */
package pl.syntaxdevteam.punisher.basic;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.collections.CollectionsKt;
import kotlin.enums.EnumEntries;
import kotlin.enums.EnumEntriesKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.OfflinePlayer;
import org.bukkit.World;
import org.bukkit.configuration.file.FileConfiguration;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import pl.syntaxdevteam.punisher.hooks.HookHandler;
import pl.syntaxdevteam.punisher.teleport.SafeTeleportService;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000P\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u0006\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0002\b\u0007\b\u00c6\u0002\u0018\u00002\u00020\u0001:\u0001#B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u0006\u001a\u00020\u0007J\u001e\u0010\b\u001a\u00020\t2\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\n\u001a\u00020\u00052\u0006\u0010\u000b\u001a\u00020\fJ\u0016\u0010\r\u001a\u00020\t2\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\n\u001a\u00020\u0005J<\u0010\u000e\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u0006\u001a\u00020\u00072\n\b\u0002\u0010\u000f\u001a\u0004\u0018\u00010\u00102\n\b\u0002\u0010\u0011\u001a\u0004\u0018\u00010\u00052\n\b\u0002\u0010\u0012\u001a\u0004\u0018\u00010\u00132\u0006\u0010\u0014\u001a\u00020\u0015J\u0016\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u00180\u00172\u0006\u0010\u0006\u001a\u00020\u0007H\u0002J\u0016\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u00180\u00172\u0006\u0010\u0006\u001a\u00020\u0007H\u0002J\u001c\u0010\u001b\u001a\u0004\u0018\u00010\u00182\u0006\u0010\u001c\u001a\u00020\u001d2\b\u0010\u001e\u001a\u0004\u0018\u00010\u001dH\u0002J\u0012\u0010\u001f\u001a\u00020\u00182\b\u0010\u001e\u001a\u0004\u0018\u00010\u001dH\u0002J\u0012\u0010 \u001a\u0004\u0018\u00010\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0002J\u0014\u0010!\u001a\u0004\u0018\u00010\u00052\b\u0010\n\u001a\u0004\u0018\u00010\u0005H\u0002J\u0014\u0010\"\u001a\u0004\u0018\u00010\u00052\b\u0010\u0012\u001a\u0004\u0018\u00010\u0013H\u0002R\u0014\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00180\u0017X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006$"}, d2={"Lpl/syntaxdevteam/punisher/basic/JailUtils;", "", "<init>", "()V", "getJailLocation", "Lorg/bukkit/Location;", "config", "Lorg/bukkit/configuration/file/FileConfiguration;", "setJailLocation", "", "location", "radius", "", "setUnjailLocation", "getUnjailLocation", "hookHandler", "Lpl/syntaxdevteam/punisher/hooks/HookHandler;", "lastLocation", "player", "Lorg/bukkit/OfflinePlayer;", "safeTeleportService", "Lpl/syntaxdevteam/punisher/teleport/SafeTeleportService;", "DEFAULT_SOURCE_ORDER", "", "Lpl/syntaxdevteam/punisher/basic/JailUtils$UnjailLocationSource;", "getSpawnTypeSelection", "getLegacySourceOrder", "parseSourceType", "value", "", "provider", "mapExternalProvider", "getConfiguredUnjailLocation", "cloneIfValid", "getBedSpawnLocation", "UnjailLocationSource", "PunisherX"})
@SourceDebugExtension(value={"SMAP\nJailUtils.kt\nKotlin\n*S Kotlin\n*F\n+ 1 JailUtils.kt\npl/syntaxdevteam/punisher/basic/JailUtils\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,229:1\n1617#2,9:230\n1869#2:239\n1870#2:242\n1626#2:243\n1#3:240\n1#3:241\n*S KotlinDebug\n*F\n+ 1 JailUtils.kt\npl/syntaxdevteam/punisher/basic/JailUtils\n*L\n113#1:230,9\n113#1:239\n113#1:242\n113#1:243\n113#1:241\n*E\n"})
public final class JailUtils {
    @NotNull
    public static final JailUtils INSTANCE = new JailUtils();
    @NotNull
    private static final List<UnjailLocationSource> DEFAULT_SOURCE_ORDER;

    private JailUtils() {
    }

    @Nullable
    public final Location getJailLocation(@NotNull FileConfiguration config) {
        Intrinsics.checkNotNullParameter(config, "config");
        String string = config.getString("jail.location.world");
        if (string == null) {
            return null;
        }
        String worldName = string;
        World world = Bukkit.getWorld((String)worldName);
        if (world == null) {
            return null;
        }
        World world2 = world;
        double x = config.getDouble("jail.location.x");
        double y = config.getDouble("jail.location.y");
        double z = config.getDouble("jail.location.z");
        float yaw = (float)config.getDouble("jail.location.yaw", 0.0);
        float pitch = (float)config.getDouble("jail.location.pitch", 0.0);
        return new Location(world2, x, y, z, yaw, pitch);
    }

    public final boolean setJailLocation(@NotNull FileConfiguration config, @NotNull Location location, double radius) {
        Intrinsics.checkNotNullParameter(config, "config");
        Intrinsics.checkNotNullParameter(location, "location");
        Object object = location.getWorld();
        if (object == null || (object = object.getName()) == null) {
            return false;
        }
        Object world = object;
        config.set("jail.location.world", world);
        config.set("jail.location.x", (Object)location.getX());
        config.set("jail.location.y", (Object)location.getY());
        config.set("jail.location.z", (Object)location.getZ());
        config.set("jail.radius", (Object)radius);
        config.set("jail.location.yaw", (Object)location.getYaw());
        config.set("jail.location.pitch", (Object)location.getPitch());
        return true;
    }

    public final boolean setUnjailLocation(@NotNull FileConfiguration config, @NotNull Location location) {
        Intrinsics.checkNotNullParameter(config, "config");
        Intrinsics.checkNotNullParameter(location, "location");
        Object object = location.getWorld();
        if (object == null || (object = object.getName()) == null) {
            return false;
        }
        Object world = object;
        config.set("unjail.unjail_location.world", world);
        config.set("unjail.unjail_location.x", (Object)location.getX());
        config.set("unjail.unjail_location.y", (Object)location.getY());
        config.set("unjail.unjail_location.z", (Object)location.getZ());
        config.set("unjail.unjail_location.yaw", (Object)location.getYaw());
        config.set("unjail.unjail_location.pitch", (Object)location.getPitch());
        config.set("spawn.location.world", world);
        config.set("spawn.location.x", (Object)location.getX());
        config.set("spawn.location.y", (Object)location.getY());
        config.set("spawn.location.z", (Object)location.getZ());
        config.set("spawn.location.yaw", (Object)location.getYaw());
        config.set("spawn.location.pitch", (Object)location.getPitch());
        return true;
    }

    @Nullable
    public final Location getUnjailLocation(@NotNull FileConfiguration config, @Nullable HookHandler hookHandler, @Nullable Location lastLocation, @Nullable OfflinePlayer player, @NotNull SafeTeleportService safeTeleportService) {
        Intrinsics.checkNotNullParameter(config, "config");
        Intrinsics.checkNotNullParameter(safeTeleportService, "safeTeleportService");
        Object object = new LinkedHashSet();
        LinkedHashSet $this$getUnjailLocation_u24lambda_u240 = object;
        boolean bl = false;
        $this$getUnjailLocation_u24lambda_u240.addAll(INSTANCE.getSpawnTypeSelection(config));
        $this$getUnjailLocation_u24lambda_u240.addAll(INSTANCE.getLegacySourceOrder(config));
        $this$getUnjailLocation_u24lambda_u240.addAll(DEFAULT_SOURCE_ORDER);
        LinkedHashSet orderedSources = object;
        Iterator iterator2 = orderedSources.iterator();
        Intrinsics.checkNotNullExpressionValue(iterator2, "iterator(...)");
        object = iterator2;
        while (object.hasNext()) {
            Location safeLocation;
            Location resolved;
            Object e = object.next();
            Intrinsics.checkNotNullExpressionValue(e, "next(...)");
            UnjailLocationSource source = (UnjailLocationSource)((Object)e);
            if ((resolved = (switch (WhenMappings.$EnumSwitchMapping$0[source.ordinal()]) {
                case 1 -> this.getConfiguredUnjailLocation(config);
                case 2 -> this.cloneIfValid(lastLocation);
                case 3 -> this.cloneIfValid(this.getBedSpawnLocation(player));
                case 4 -> {
                    HookHandler v3 = hookHandler;
                    if (v3 != null && (v3 = HookHandler.getEssentialsSpawnLocation$default(v3, null, 1, null)) != null) {
                        yield v3.clone();
                    }
                    yield null;
                }
                case 5 -> {
                    List v4 = Bukkit.getWorlds();
                    Intrinsics.checkNotNullExpressionValue(v4, "getWorlds(...)");
                    World v5 = (World)CollectionsKt.firstOrNull(v4);
                    if (v5 != null && (v5 = v5.getSpawnLocation()) != null) {
                        yield v5.clone();
                    }
                    yield null;
                }
                default -> throw new NoWhenBranchMatchedException();
            })) == null || (safeLocation = SafeTeleportService.findNearestSafeLocation$default(safeTeleportService, resolved, 0, 0, 6, null)) == null) continue;
            return safeLocation;
        }
        return null;
    }

    public static /* synthetic */ Location getUnjailLocation$default(JailUtils jailUtils, FileConfiguration fileConfiguration, HookHandler hookHandler, Location location, OfflinePlayer offlinePlayer, SafeTeleportService safeTeleportService, int n, Object object) {
        if ((n & 2) != 0) {
            hookHandler = null;
        }
        if ((n & 4) != 0) {
            location = null;
        }
        if ((n & 8) != 0) {
            offlinePlayer = null;
        }
        return jailUtils.getUnjailLocation(fileConfiguration, hookHandler, location, offlinePlayer, safeTeleportService);
    }

    /*
     * WARNING - void declaration
     */
    private final List<UnjailLocationSource> getSpawnTypeSelection(FileConfiguration config) {
        List<UnjailLocationSource> list;
        Object object = config.get("unjail.spawn_type_select.set");
        if (object == null) {
            return CollectionsKt.emptyList();
        }
        Object raw = object;
        Object object2 = raw;
        if (object2 instanceof String) {
            list = CollectionsKt.listOfNotNull(this.parseSourceType((String)raw, null));
        } else if (object2 instanceof List) {
            void $this$mapNotNullTo$iv$iv;
            Iterable $this$mapNotNull$iv = (Iterable)raw;
            boolean $i$f$mapNotNull = false;
            Iterable iterable = $this$mapNotNull$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$mapNotNullTo = false;
            void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
            boolean $i$f$forEach = false;
            Iterator iterator2 = $this$forEach$iv$iv$iv.iterator();
            while (iterator2.hasNext()) {
                UnjailLocationSource unjailLocationSource;
                Object element$iv$iv$iv;
                Object element$iv$iv = element$iv$iv$iv = iterator2.next();
                boolean bl = false;
                Object it = element$iv$iv;
                boolean bl2 = false;
                if ((it instanceof String ? (String)it : null) != null) {
                    String value;
                    value = value;
                    boolean bl3 = false;
                    unjailLocationSource = INSTANCE.parseSourceType(value, null);
                } else {
                    unjailLocationSource = null;
                }
                if (unjailLocationSource == null) continue;
                UnjailLocationSource it$iv$iv = unjailLocationSource;
                boolean bl4 = false;
                destination$iv$iv.add(it$iv$iv);
            }
            list = (List)destination$iv$iv;
        } else {
            list = CollectionsKt.emptyList();
        }
        List<UnjailLocationSource> mapped = list;
        return mapped;
    }

    private final List<UnjailLocationSource> getLegacySourceOrder(FileConfiguration config) {
        UnjailLocationSource it;
        LinkedHashSet<UnjailLocationSource> normalized = new LinkedHashSet<UnjailLocationSource>();
        List rawList = config.getList("spawn.release_sources");
        Collection collection = rawList;
        if (!(collection == null || collection.isEmpty())) {
            for (Object entry : rawList) {
                UnjailLocationSource it2;
                Object v;
                String provider;
                String type;
                Object typeKey;
                boolean enabled;
                Object e = entry;
                if (e instanceof String) {
                    if (this.parseSourceType((String)entry, null) != null) {
                        boolean bl = false;
                        normalized.add(it);
                    }
                    continue;
                }
                if (!(e instanceof Map)) continue;
                it = ((Map)entry).get("enabled");
                Boolean bl = it instanceof Boolean ? (Boolean)((Object)it) : null;
                boolean bl2 = enabled = bl != null ? bl : true;
                if (!enabled) continue;
                Object v2 = ((Map)entry).get("type");
                if (v2 == null && (v2 = ((Map)entry).get("source")) == null && (v2 = ((Map)entry).get("name")) == null) {
                    v2 = ((Map)entry).get("id");
                }
                if (((typeKey = v2) instanceof String ? (String)typeKey : null) == null) continue;
                type = type;
                Object v3 = ((Map)entry).get("provider");
                if (v3 == null && (v3 = ((Map)entry).get("set")) == null) {
                    v3 = ((Map)entry).get("id");
                }
                String string = provider = (v = v3) instanceof String ? (String)v : null;
                if (this.parseSourceType(type, provider) == null) continue;
                boolean bl3 = false;
                normalized.add(it2);
            }
            if (!((Collection)normalized).isEmpty()) {
                return CollectionsKt.toList((Iterable)normalized);
            }
        }
        List list = config.getStringList("spawn.release_priority");
        Intrinsics.checkNotNullExpressionValue(list, "getStringList(...)");
        List priorityList = list;
        boolean externalEnabled = config.getBoolean("spawn.use_external_set.enabled");
        String externalProvider = config.getString("spawn.use_external_set.set");
        if (!((Collection)priorityList).isEmpty()) {
            for (String entry : priorityList) {
                UnjailLocationSource mapped;
                Intrinsics.checkNotNull(entry);
                UnjailLocationSource unjailLocationSource = this.parseSourceType(entry, externalProvider);
                if ((mapped = (switch (unjailLocationSource == null ? -1 : WhenMappings.$EnumSwitchMapping$0[unjailLocationSource.ordinal()]) {
                    case 4, 5 -> {
                        if (externalEnabled) {
                            yield this.parseSourceType(entry, externalProvider);
                        }
                        yield null;
                    }
                    default -> this.parseSourceType(entry, externalProvider);
                })) == null) continue;
                normalized.add(mapped);
            }
            if (!((Collection)normalized).isEmpty()) {
                return CollectionsKt.toList((Iterable)normalized);
            }
        }
        if (!externalEnabled) {
            normalized.add(UnjailLocationSource.LAST_LOCATION);
            normalized.add(UnjailLocationSource.CONFIGURED);
            return CollectionsKt.toList((Iterable)normalized);
        }
        CharSequence charSequence = externalProvider;
        if (!(charSequence == null || StringsKt.isBlank(charSequence))) {
            normalized.add(UnjailLocationSource.LAST_LOCATION);
            UnjailLocationSource unjailLocationSource = this.parseSourceType("external", externalProvider);
            if (unjailLocationSource != null) {
                it = unjailLocationSource;
                boolean bl = false;
                normalized.add(it);
            }
            normalized.add(UnjailLocationSource.CONFIGURED);
            return CollectionsKt.toList((Iterable)normalized);
        }
        return CollectionsKt.emptyList();
    }

    private final UnjailLocationSource parseSourceType(String value, String provider) {
        String string = value;
        Locale locale = Locale.ROOT;
        Intrinsics.checkNotNullExpressionValue(locale, "ROOT");
        String string2 = string.toLowerCase(locale);
        Intrinsics.checkNotNullExpressionValue(string2, "toLowerCase(...)");
        return switch (string2) {
            case "configured", "set", "spawn", "unjail", "config" -> UnjailLocationSource.CONFIGURED;
            case "lastlocation", "last_location", "last-location", "player" -> UnjailLocationSource.LAST_LOCATION;
            case "bed", "bed_spawn", "respawn", "bed-spawn" -> UnjailLocationSource.BED;
            case "foliessentials", "essentials", "essx" -> UnjailLocationSource.ESSENTIALS;
            case "default", "world", "default_world" -> UnjailLocationSource.WORLD;
            case "external_set", "external", "external-set", "plugin" -> this.mapExternalProvider(provider);
            default -> null;
        };
    }

    /*
     * Unable to fully structure code
     */
    private final UnjailLocationSource mapExternalProvider(String provider) {
        block10: {
            block9: {
                v0 = provider;
                if (v0 != null) {
                    var3_2 = v0;
                    v1 = Locale.ROOT;
                    Intrinsics.checkNotNullExpressionValue(v1, "ROOT");
                    v2 = var3_2.toLowerCase(v1);
                    v3 = v2;
                    Intrinsics.checkNotNullExpressionValue(v2, "toLowerCase(...)");
                } else {
                    v3 = var2_3 = null;
                }
                if (var2_3 == null) break block9;
                switch (var2_3.hashCode()) {
                    case 15348587: {
                        if (!var2_3.equals("foliessentials")) {
                            break;
                        }
                        ** GOTO lbl23
                    }
                    case 1190983397: {
                        if (!var2_3.equals("essentials")) {
                            break;
                        }
                        ** GOTO lbl23
                    }
                    case 3123091: {
                        if (!var2_3.equals("essx")) break;
lbl23:
                        // 3 sources

                        v4 = UnjailLocationSource.ESSENTIALS;
                        break block10;
                    }
                }
            }
            v4 = UnjailLocationSource.WORLD;
        }
        return v4;
    }

    private final Location getConfiguredUnjailLocation(FileConfiguration config) {
        String basePath = config.contains("unjail.unjail_location.world") ? "unjail.unjail_location" : "spawn.location";
        String string = config.getString(basePath + ".world");
        if (string == null) {
            return null;
        }
        String worldName = string;
        World world = Bukkit.getWorld((String)worldName);
        if (world == null) {
            return null;
        }
        World world2 = world;
        double x = config.getDouble(basePath + ".x");
        double y = config.getDouble(basePath + ".y");
        double z = config.getDouble(basePath + ".z");
        float yaw = (float)config.getDouble(basePath + ".yaw", 0.0);
        float pitch = (float)config.getDouble(basePath + ".pitch", 0.0);
        return new Location(world2, x, y, z, yaw, pitch);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final Location cloneIfValid(Location location) {
        Location location2;
        Location location4 = location;
        location4 = location4;
        if (location3 == null) return null;
        Location it = location2 = location4;
        boolean bl = false;
        if (it.getWorld() == null) return null;
        boolean bl2 = true;
        if (!bl2) return null;
        Location location4 = location2;
        location4 = location4;
        if (location5 == null) return null;
        Location location6 = location4.clone();
        return location6;
    }

    private final Location getBedSpawnLocation(OfflinePlayer player) {
        OfflinePlayer offlinePlayer = player;
        return offlinePlayer != null ? offlinePlayer.getBedSpawnLocation() : null;
    }

    static {
        UnjailLocationSource[] unjailLocationSourceArray = new UnjailLocationSource[]{UnjailLocationSource.CONFIGURED, UnjailLocationSource.LAST_LOCATION, UnjailLocationSource.BED, UnjailLocationSource.ESSENTIALS, UnjailLocationSource.WORLD};
        DEFAULT_SOURCE_ORDER = CollectionsKt.listOf(unjailLocationSourceArray);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\b\b\u0086\u0081\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003j\u0002\b\u0004j\u0002\b\u0005j\u0002\b\u0006j\u0002\b\u0007j\u0002\b\b\u00a8\u0006\t"}, d2={"Lpl/syntaxdevteam/punisher/basic/JailUtils$UnjailLocationSource;", "", "<init>", "(Ljava/lang/String;I)V", "CONFIGURED", "LAST_LOCATION", "BED", "ESSENTIALS", "WORLD", "PunisherX"})
    public static final class UnjailLocationSource
    extends Enum<UnjailLocationSource> {
        public static final /* enum */ UnjailLocationSource CONFIGURED = new UnjailLocationSource();
        public static final /* enum */ UnjailLocationSource LAST_LOCATION = new UnjailLocationSource();
        public static final /* enum */ UnjailLocationSource BED = new UnjailLocationSource();
        public static final /* enum */ UnjailLocationSource ESSENTIALS = new UnjailLocationSource();
        public static final /* enum */ UnjailLocationSource WORLD = new UnjailLocationSource();
        private static final /* synthetic */ UnjailLocationSource[] $VALUES;
        private static final /* synthetic */ EnumEntries $ENTRIES;

        public static UnjailLocationSource[] values() {
            return (UnjailLocationSource[])$VALUES.clone();
        }

        public static UnjailLocationSource valueOf(String value) {
            return Enum.valueOf(UnjailLocationSource.class, value);
        }

        @NotNull
        public static EnumEntries<UnjailLocationSource> getEntries() {
            return $ENTRIES;
        }

        static {
            $VALUES = unjailLocationSourceArray = new UnjailLocationSource[]{UnjailLocationSource.CONFIGURED, UnjailLocationSource.LAST_LOCATION, UnjailLocationSource.BED, UnjailLocationSource.ESSENTIALS, UnjailLocationSource.WORLD};
            $ENTRIES = EnumEntriesKt.enumEntries((Enum[])$VALUES);
        }
    }

    @Metadata(mv={2, 2, 0}, k=3, xi=48)
    public static final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[UnjailLocationSource.values().length];
            try {
                nArray[UnjailLocationSource.CONFIGURED.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[UnjailLocationSource.LAST_LOCATION.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[UnjailLocationSource.BED.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[UnjailLocationSource.ESSENTIALS.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[UnjailLocationSource.WORLD.ordinal()] = 5;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

