/*
 * Decompiled with CFR 0.152.
 */
package pl.syntaxdevteam.punisher.api;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import pl.syntaxdevteam.punisher.api.PunisherXApi;
import pl.syntaxdevteam.punisher.databases.DatabaseHandler;
import pl.syntaxdevteam.punisher.databases.PunishmentData;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0006\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u001c\u0010\u0006\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\t0\b0\u00072\u0006\u0010\n\u001a\u00020\u000bH\u0016J\u001c\u0010\f\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\t0\b0\u00072\u0006\u0010\n\u001a\u00020\u000bH\u0016J&\u0010\r\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\t0\b0\u00072\u0006\u0010\n\u001a\u00020\u000b2\b\u0010\u000e\u001a\u0004\u0018\u00010\u000bH\u0016J&\u0010\u000f\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\t0\b0\u00072\u0006\u0010\n\u001a\u00020\u000b2\b\u0010\u000e\u001a\u0004\u0018\u00010\u000bH\u0016J$\u0010\u0010\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\t0\b0\u00072\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0012H\u0016J$\u0010\u0014\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\t0\b0\u00072\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0012H\u0016J$\u0010\u0015\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\t0\b0\u00072\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0012H\u0016J\u0016\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00170\u00072\u0006\u0010\n\u001a\u00020\u000bH\u0016J\u0016\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u00170\u00072\u0006\u0010\n\u001a\u00020\u000bH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0019"}, d2={"Lpl/syntaxdevteam/punisher/api/PunisherXApiImpl;", "Lpl/syntaxdevteam/punisher/api/PunisherXApi;", "databaseHandler", "Lpl/syntaxdevteam/punisher/databases/DatabaseHandler;", "<init>", "(Lpl/syntaxdevteam/punisher/databases/DatabaseHandler;)V", "getLastTenPunishmentHistory", "Ljava/util/concurrent/CompletableFuture;", "", "Lpl/syntaxdevteam/punisher/databases/PunishmentData;", "uuid", "", "getLastTenActivePunishments", "getActivePunishments", "type", "getPunishmentHistory", "getBannedPlayers", "limit", "", "offset", "getHistoryBannedPlayers", "getJailedPlayers", "isMuted", "", "isJailed", "PunisherX"})
@SourceDebugExtension(value={"SMAP\nPunisherXApiImpl.kt\nKotlin\n*S Kotlin\n*F\n+ 1 PunisherXApiImpl.kt\npl/syntaxdevteam/punisher/api/PunisherXApiImpl\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,73:1\n774#2:74\n865#2,2:75\n774#2:77\n865#2,2:78\n1761#2,3:80\n1761#2,3:83\n*S KotlinDebug\n*F\n+ 1 PunisherXApiImpl.kt\npl/syntaxdevteam/punisher/api/PunisherXApiImpl\n*L\n27#1:74\n27#1:75,2\n38#1:77\n38#1:78,2\n64#1:80,3\n70#1:83,3\n*E\n"})
public final class PunisherXApiImpl
implements PunisherXApi {
    @NotNull
    private final DatabaseHandler databaseHandler;

    public PunisherXApiImpl(@NotNull DatabaseHandler databaseHandler) {
        Intrinsics.checkNotNullParameter(databaseHandler, "databaseHandler");
        this.databaseHandler = databaseHandler;
    }

    @Override
    @NotNull
    public CompletableFuture<List<PunishmentData>> getLastTenPunishmentHistory(@NotNull String uuid) {
        Intrinsics.checkNotNullParameter(uuid, "uuid");
        CompletableFuture<List<PunishmentData>> completableFuture = CompletableFuture.supplyAsync(() -> PunisherXApiImpl.getLastTenPunishmentHistory$lambda$0(this, uuid));
        Intrinsics.checkNotNullExpressionValue(completableFuture, "supplyAsync(...)");
        return completableFuture;
    }

    @Override
    @NotNull
    public CompletableFuture<List<PunishmentData>> getLastTenActivePunishments(@NotNull String uuid) {
        Intrinsics.checkNotNullParameter(uuid, "uuid");
        CompletableFuture<List<PunishmentData>> completableFuture = CompletableFuture.supplyAsync(() -> PunisherXApiImpl.getLastTenActivePunishments$lambda$0(this, uuid));
        Intrinsics.checkNotNullExpressionValue(completableFuture, "supplyAsync(...)");
        return completableFuture;
    }

    @Override
    @NotNull
    public CompletableFuture<List<PunishmentData>> getActivePunishments(@NotNull String uuid, @Nullable String type) {
        Intrinsics.checkNotNullParameter(uuid, "uuid");
        CompletableFuture<List<PunishmentData>> completableFuture = CompletableFuture.supplyAsync(() -> PunisherXApiImpl.getActivePunishments$lambda$0(this, uuid, type));
        Intrinsics.checkNotNullExpressionValue(completableFuture, "supplyAsync(...)");
        return completableFuture;
    }

    @Override
    @NotNull
    public CompletableFuture<List<PunishmentData>> getPunishmentHistory(@NotNull String uuid, @Nullable String type) {
        Intrinsics.checkNotNullParameter(uuid, "uuid");
        CompletableFuture<List<PunishmentData>> completableFuture = CompletableFuture.supplyAsync(() -> PunisherXApiImpl.getPunishmentHistory$lambda$0(this, uuid, type));
        Intrinsics.checkNotNullExpressionValue(completableFuture, "supplyAsync(...)");
        return completableFuture;
    }

    @Override
    @NotNull
    public CompletableFuture<List<PunishmentData>> getBannedPlayers(int limit, int offset) {
        CompletableFuture<List<PunishmentData>> completableFuture = CompletableFuture.supplyAsync(() -> PunisherXApiImpl.getBannedPlayers$lambda$0(this, limit, offset));
        Intrinsics.checkNotNullExpressionValue(completableFuture, "supplyAsync(...)");
        return completableFuture;
    }

    @Override
    @NotNull
    public CompletableFuture<List<PunishmentData>> getHistoryBannedPlayers(int limit, int offset) {
        CompletableFuture<List<PunishmentData>> completableFuture = CompletableFuture.supplyAsync(() -> PunisherXApiImpl.getHistoryBannedPlayers$lambda$0(this, limit, offset));
        Intrinsics.checkNotNullExpressionValue(completableFuture, "supplyAsync(...)");
        return completableFuture;
    }

    @Override
    @NotNull
    public CompletableFuture<List<PunishmentData>> getJailedPlayers(int limit, int offset) {
        CompletableFuture<List<PunishmentData>> completableFuture = CompletableFuture.supplyAsync(() -> PunisherXApiImpl.getJailedPlayers$lambda$0(this, limit, offset));
        Intrinsics.checkNotNullExpressionValue(completableFuture, "supplyAsync(...)");
        return completableFuture;
    }

    @Override
    @NotNull
    public CompletableFuture<Boolean> isMuted(@NotNull String uuid) {
        Intrinsics.checkNotNullParameter(uuid, "uuid");
        CompletableFuture<Boolean> completableFuture = CompletableFuture.supplyAsync(() -> PunisherXApiImpl.isMuted$lambda$0(this, uuid));
        Intrinsics.checkNotNullExpressionValue(completableFuture, "supplyAsync(...)");
        return completableFuture;
    }

    @Override
    @NotNull
    public CompletableFuture<Boolean> isJailed(@NotNull String uuid) {
        Intrinsics.checkNotNullParameter(uuid, "uuid");
        CompletableFuture<Boolean> completableFuture = CompletableFuture.supplyAsync(() -> PunisherXApiImpl.isJailed$lambda$0(this, uuid));
        Intrinsics.checkNotNullExpressionValue(completableFuture, "supplyAsync(...)");
        return completableFuture;
    }

    private static final List getLastTenPunishmentHistory$lambda$0(PunisherXApiImpl this$0, String $uuid) {
        return DatabaseHandler.getPunishmentHistory$default(this$0.databaseHandler, $uuid, 10, null, 4, null);
    }

    private static final List getLastTenActivePunishments$lambda$0(PunisherXApiImpl this$0, String $uuid) {
        return DatabaseHandler.getPunishments$default(this$0.databaseHandler, $uuid, 10, null, 4, null);
    }

    /*
     * WARNING - void declaration
     */
    private static final List getActivePunishments$lambda$0(PunisherXApiImpl this$0, String $uuid, String $type) {
        List list;
        List allPunishments = DatabaseHandler.getPunishments$default(this$0.databaseHandler, $uuid, null, null, 6, null);
        if ($type == null || StringsKt.equals($type, "ALL", true)) {
            list = allPunishments;
        } else {
            void $this$filterTo$iv$iv;
            Iterable $this$filter$iv = allPunishments;
            boolean $i$f$filter = false;
            Iterable iterable = $this$filter$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterTo = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv) {
                PunishmentData it = (PunishmentData)element$iv$iv;
                boolean bl = false;
                if (!StringsKt.equals(it.getType(), $type, true)) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            list = (List)destination$iv$iv;
        }
        return list;
    }

    /*
     * WARNING - void declaration
     */
    private static final List getPunishmentHistory$lambda$0(PunisherXApiImpl this$0, String $uuid, String $type) {
        List list;
        List allPunishmentHistory = DatabaseHandler.getPunishmentHistory$default(this$0.databaseHandler, $uuid, null, null, 6, null);
        if ($type == null || StringsKt.equals($type, "ALL", true)) {
            list = allPunishmentHistory;
        } else {
            void $this$filterTo$iv$iv;
            Iterable $this$filter$iv = allPunishmentHistory;
            boolean $i$f$filter = false;
            Iterable iterable = $this$filter$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterTo = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv) {
                PunishmentData it = (PunishmentData)element$iv$iv;
                boolean bl = false;
                if (!StringsKt.equals(it.getType(), $type, true)) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            list = (List)destination$iv$iv;
        }
        return list;
    }

    private static final List getBannedPlayers$lambda$0(PunisherXApiImpl this$0, int $limit, int $offset) {
        return this$0.databaseHandler.getBannedPlayers($limit, $offset);
    }

    private static final List getHistoryBannedPlayers$lambda$0(PunisherXApiImpl this$0, int $limit, int $offset) {
        return this$0.databaseHandler.getHistoryBannedPlayers($limit, $offset);
    }

    private static final List getJailedPlayers$lambda$0(PunisherXApiImpl this$0, int $limit, int $offset) {
        return this$0.databaseHandler.getJailedPlayers($limit, $offset);
    }

    private static final Boolean isMuted$lambda$0(PunisherXApiImpl this$0, String $uuid) {
        boolean bl;
        block3: {
            Iterable $this$any$iv = DatabaseHandler.getPunishments$default(this$0.databaseHandler, $uuid, null, null, 6, null);
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    PunishmentData it = (PunishmentData)element$iv;
                    boolean bl2 = false;
                    if (!StringsKt.equals(it.getType(), "MUTE", true)) continue;
                    bl = true;
                    break block3;
                }
                bl = false;
            }
        }
        return bl;
    }

    private static final Boolean isJailed$lambda$0(PunisherXApiImpl this$0, String $uuid) {
        boolean bl;
        block3: {
            Iterable $this$any$iv = DatabaseHandler.getPunishments$default(this$0.databaseHandler, $uuid, null, null, 6, null);
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    PunishmentData it = (PunishmentData)element$iv;
                    boolean bl2 = false;
                    if (!StringsKt.equals(it.getType(), "JAIL", true)) continue;
                    bl = true;
                    break block3;
                }
                bl = false;
            }
        }
        return bl;
    }
}

