/*
 * Decompiled with CFR 0.152.
 */
package pl.syntaxdevteam.punisher.common;

import com.google.gson.Gson;
import com.google.gson.JsonObject;
import java.io.InputStreamReader;
import java.net.HttpURLConnection;
import java.net.URI;
import java.net.URLConnection;
import java.time.Duration;
import java.util.Locale;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import kotlin.Metadata;
import kotlin.io.TextStreamsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.Charsets;
import kotlin.text.Regex;
import org.bukkit.Bukkit;
import org.bukkit.OfflinePlayer;
import org.bukkit.entity.Player;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import pl.syntaxdevteam.punisher.PunisherX;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\t\n\u0000\n\u0002\u0010%\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\f\u0018\u00002\u00020\u0001:\u0001\u001aB\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u000e\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\nJ\u0010\u0010\u0011\u001a\u0004\u0018\u00010\u000f2\u0006\u0010\u0010\u001a\u00020\nJ\u0012\u0010\u0012\u001a\u0004\u0018\u00010\u000f2\u0006\u0010\u0010\u001a\u00020\nH\u0002J\u0012\u0010\u0013\u001a\u0004\u0018\u00010\u000f2\u0006\u0010\u0010\u001a\u00020\nH\u0002J\u0012\u0010\u0014\u001a\u0004\u0018\u00010\u000f2\u0006\u0010\u0015\u001a\u00020\nH\u0002J\u0010\u0010\u0016\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\nH\u0002J\u0018\u0010\u0017\u001a\u00020\u000f2\u0006\u0010\u0018\u001a\u00020\n2\u0006\u0010\u0019\u001a\u00020\u000fH\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\b\u001a\u000e\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\u000b0\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001b"}, d2={"Lpl/syntaxdevteam/punisher/common/UUIDManager;", "", "plugin", "Lpl/syntaxdevteam/punisher/PunisherX;", "<init>", "(Lpl/syntaxdevteam/punisher/PunisherX;)V", "cacheTtl", "", "activeUUIDs", "", "", "Lpl/syntaxdevteam/punisher/common/UUIDManager$CachedUuid;", "gson", "Lcom/google/gson/Gson;", "getUUID", "Ljava/util/UUID;", "playerName", "getCachedUUID", "fetchUUIDFromAPI", "fetchUUIDFromPlayerDB", "parseUUIDFromResponse", "response", "generateOfflineUUID", "remember", "key", "uuid", "CachedUuid", "PunisherX"})
@SourceDebugExtension(value={"SMAP\nUUIDManager.kt\nKotlin\n*S Kotlin\n*F\n+ 1 UUIDManager.kt\npl/syntaxdevteam/punisher/common/UUIDManager\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,136:1\n1#2:137\n*E\n"})
public final class UUIDManager {
    @NotNull
    private final PunisherX plugin;
    private final long cacheTtl;
    @NotNull
    private final Map<String, CachedUuid> activeUUIDs;
    @NotNull
    private final Gson gson;

    public UUIDManager(@NotNull PunisherX plugin) {
        Intrinsics.checkNotNullParameter((Object)plugin, "plugin");
        this.plugin = plugin;
        this.cacheTtl = Duration.ofHours(6L).toMillis();
        this.activeUUIDs = new ConcurrentHashMap();
        this.gson = new Gson();
    }

    @NotNull
    public final UUID getUUID(@NotNull String playerName) {
        Player player;
        Intrinsics.checkNotNullParameter(playerName, "playerName");
        long now = System.currentTimeMillis();
        Object object = playerName;
        Locale locale = Locale.ROOT;
        Intrinsics.checkNotNullExpressionValue(locale, "ROOT");
        String string = ((String)object).toLowerCase(locale);
        Intrinsics.checkNotNullExpressionValue(string, "toLowerCase(...)");
        String key = string;
        object = this.activeUUIDs.get(key);
        if (object != null) {
            Object object2;
            Object object3;
            Object it = object3 = object;
            boolean bl = false;
            Object object4 = object2 = !((CachedUuid)it).isExpired(now) ? object3 : null;
            if (object2 != null) {
                it = object2;
                boolean bl2 = false;
                return ((CachedUuid)it).getValue();
            }
        }
        if ((player = Bukkit.getPlayer((String)playerName)) != null) {
            UUID uUID = player.getUniqueId();
            Intrinsics.checkNotNullExpressionValue(uUID, "getUniqueId(...)");
            return this.remember(key, uUID);
        }
        OfflinePlayer offlinePlayer = Bukkit.getOfflinePlayer((String)playerName);
        Intrinsics.checkNotNullExpressionValue(offlinePlayer, "getOfflinePlayer(...)");
        OfflinePlayer offlinePlayer2 = offlinePlayer;
        if (offlinePlayer2.hasPlayedBefore()) {
            UUID uUID = offlinePlayer2.getUniqueId();
            Intrinsics.checkNotNullExpressionValue(uUID, "getUniqueId(...)");
            return this.remember(key, uUID);
        }
        UUID uUID = this.fetchUUIDFromAPI(playerName);
        if (uUID == null && (uUID = this.fetchUUIDFromPlayerDB(playerName)) == null) {
            uUID = this.generateOfflineUUID(playerName);
        }
        UUID uuid = uUID;
        return this.remember(key, uuid);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Nullable
    public final UUID getCachedUUID(@NotNull String playerName) {
        CachedUuid cachedUuid;
        Intrinsics.checkNotNullParameter(playerName, "playerName");
        long now = System.currentTimeMillis();
        String string = playerName;
        Locale locale = Locale.ROOT;
        Intrinsics.checkNotNullExpressionValue(locale, "ROOT");
        String string2 = string.toLowerCase(locale);
        Intrinsics.checkNotNullExpressionValue(string2, "toLowerCase(...)");
        String key = string2;
        CachedUuid cachedUuid2 = this.activeUUIDs.get(key);
        CachedUuid cachedUuid3 = cachedUuid2;
        if (cachedUuid2 == null) return null;
        CachedUuid it = cachedUuid = cachedUuid3;
        boolean bl = false;
        if (it.isExpired(now)) return null;
        CachedUuid cachedUuid4 = cachedUuid;
        cachedUuid3 = cachedUuid4;
        if (cachedUuid4 == null) return null;
        UUID uUID = cachedUuid3.getValue();
        return uUID;
    }

    private final UUID fetchUUIDFromAPI(String playerName) {
        UUID uUID;
        URI uri = new URI("https://api.mojang.com/users/profiles/minecraft/" + playerName);
        byte[] byArray = ("OfflinePlayer:" + playerName).getBytes(Charsets.UTF_8);
        Intrinsics.checkNotNullExpressionValue(byArray, "getBytes(...)");
        UUID uUID2 = UUID.nameUUIDFromBytes(byArray);
        Intrinsics.checkNotNullExpressionValue(uUID2, "nameUUIDFromBytes(...)");
        UUID offlineUUID = uUID2;
        try {
            UUID uUID3;
            URLConnection uRLConnection = uri.toURL().openConnection();
            Intrinsics.checkNotNull(uRLConnection, "null cannot be cast to non-null type java.net.HttpURLConnection");
            HttpURLConnection connection = (HttpURLConnection)uRLConnection;
            connection.setRequestMethod("GET");
            connection.connect();
            this.plugin.getLogger().debug("API Response Code: " + connection.getResponseCode());
            if (connection.getResponseCode() == 200) {
                InputStreamReader reader = new InputStreamReader(connection.getInputStream());
                String response = TextStreamsKt.readText(reader);
                reader.close();
                UUID uuid = this.parseUUIDFromResponse(response);
                this.plugin.getLogger().debug("parseUUIDFromResponse(response): " + uuid);
                uUID3 = uuid;
            } else {
                this.plugin.getLogger().err("Failed to fetch UUID from API. Response code: " + connection.getResponseCode());
                this.plugin.getLogger().debug("Returning offline UUID: " + offlineUUID);
                uUID3 = offlineUUID;
            }
            uUID = uUID3;
        }
        catch (Exception e) {
            this.plugin.getLogger().err("Error: " + e);
            this.plugin.getLogger().debug("Returning offline UUID: " + offlineUUID);
            uUID = offlineUUID;
        }
        return uUID;
    }

    private final UUID fetchUUIDFromPlayerDB(String playerName) {
        UUID uUID;
        URI uri = new URI("https://playerdb.co/api/player/minecraft/" + playerName);
        try {
            UUID uUID2;
            URLConnection uRLConnection = uri.toURL().openConnection();
            Intrinsics.checkNotNull(uRLConnection, "null cannot be cast to non-null type java.net.HttpURLConnection");
            HttpURLConnection connection = (HttpURLConnection)uRLConnection;
            connection.setRequestMethod("GET");
            connection.connect();
            this.plugin.getLogger().debug("API Response Code: " + connection.getResponseCode());
            if (connection.getResponseCode() == 200) {
                UUID uuid;
                InputStreamReader reader = new InputStreamReader(connection.getInputStream());
                String response = TextStreamsKt.readText(reader);
                reader.close();
                JsonObject jsonObject = (JsonObject)this.gson.fromJson(response, JsonObject.class);
                String rawUUID = jsonObject.getAsJsonObject("data").getAsJsonObject("player").get("id").getAsString();
                this.plugin.getLogger().debug("Raw UUID from PlayerDB API: " + rawUUID);
                Intrinsics.checkNotNull(rawUUID);
                CharSequence charSequence = rawUUID;
                Regex regex = new Regex("(\\p{XDigit}{8})(\\p{XDigit}{4})(\\p{XDigit}{4})(\\p{XDigit}{4})(\\p{XDigit}+)");
                String string = "$1-$2-$3-$4-$5";
                uUID2 = uuid = UUID.fromString(regex.replaceFirst(charSequence, string));
            } else {
                this.plugin.getLogger().err("Failed to fetch UUID from PlayerDB API. Response code: " + connection.getResponseCode());
                uUID2 = null;
            }
            uUID = uUID2;
        }
        catch (Exception e) {
            this.plugin.getLogger().err("Error: " + e);
            uUID = null;
        }
        return uUID;
    }

    private final UUID parseUUIDFromResponse(String response) {
        UUID uUID;
        try {
            JsonObject jsonObject = (JsonObject)this.gson.fromJson(response, JsonObject.class);
            String rawUUID = jsonObject.get("id").getAsString();
            this.plugin.getLogger().debug("Raw UUID from API: " + rawUUID);
            Intrinsics.checkNotNull(rawUUID);
            CharSequence charSequence = rawUUID;
            Regex regex = new Regex("(\\p{XDigit}{8})(\\p{XDigit}{4})(\\p{XDigit}{4})(\\p{XDigit}{4})(\\p{XDigit}+)");
            String string = "$1-$2-$3-$4-$5";
            uUID = UUID.fromString(regex.replaceFirst(charSequence, string));
        }
        catch (Exception e) {
            this.plugin.getLogger().err("Error: " + e);
            uUID = null;
        }
        return uUID;
    }

    private final UUID generateOfflineUUID(String playerName) {
        String string = "OfflinePlayer:" + playerName;
        byte[] byArray = string.getBytes(Charsets.UTF_8);
        Intrinsics.checkNotNullExpressionValue(byArray, "getBytes(...)");
        UUID offlineUUID = UUID.nameUUIDFromBytes(byArray);
        this.plugin.getLogger().debug("Generated offline UUID for " + playerName + ": " + offlineUUID);
        Intrinsics.checkNotNull(offlineUUID);
        return offlineUUID;
    }

    private final UUID remember(String key, UUID uuid) {
        this.activeUUIDs.put(key, new CachedUuid(uuid, System.currentTimeMillis() + this.cacheTtl));
        return uuid;
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\u0007\n\u0002\u0010\u000b\n\u0002\b\u0007\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0082\b\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u000e\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u0005J\t\u0010\u000f\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0010\u001a\u00020\u0005H\u00c6\u0003J\u001d\u0010\u0011\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u0005H\u00c6\u0001J\u0013\u0010\u0012\u001a\u00020\r2\b\u0010\u0013\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0014\u001a\u00020\u0015H\u00d6\u0001J\t\u0010\u0016\u001a\u00020\u0017H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\u0018"}, d2={"Lpl/syntaxdevteam/punisher/common/UUIDManager$CachedUuid;", "", "value", "Ljava/util/UUID;", "expiresAt", "", "<init>", "(Ljava/util/UUID;J)V", "getValue", "()Ljava/util/UUID;", "getExpiresAt", "()J", "isExpired", "", "now", "component1", "component2", "copy", "equals", "other", "hashCode", "", "toString", "", "PunisherX"})
    private static final class CachedUuid {
        @NotNull
        private final UUID value;
        private final long expiresAt;

        public CachedUuid(@NotNull UUID value, long expiresAt) {
            Intrinsics.checkNotNullParameter(value, "value");
            this.value = value;
            this.expiresAt = expiresAt;
        }

        @NotNull
        public final UUID getValue() {
            return this.value;
        }

        public final long getExpiresAt() {
            return this.expiresAt;
        }

        public final boolean isExpired(long now) {
            return now > this.expiresAt;
        }

        @NotNull
        public final UUID component1() {
            return this.value;
        }

        public final long component2() {
            return this.expiresAt;
        }

        @NotNull
        public final CachedUuid copy(@NotNull UUID value, long expiresAt) {
            Intrinsics.checkNotNullParameter(value, "value");
            return new CachedUuid(value, expiresAt);
        }

        public static /* synthetic */ CachedUuid copy$default(CachedUuid cachedUuid, UUID uUID, long l, int n, Object object) {
            if ((n & 1) != 0) {
                uUID = cachedUuid.value;
            }
            if ((n & 2) != 0) {
                l = cachedUuid.expiresAt;
            }
            return cachedUuid.copy(uUID, l);
        }

        @NotNull
        public String toString() {
            return "CachedUuid(value=" + this.value + ", expiresAt=" + this.expiresAt + ")";
        }

        public int hashCode() {
            int result = this.value.hashCode();
            result = result * 31 + Long.hashCode(this.expiresAt);
            return result;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof CachedUuid)) {
                return false;
            }
            CachedUuid cachedUuid = (CachedUuid)other;
            if (!Intrinsics.areEqual(this.value, cachedUuid.value)) {
                return false;
            }
            return this.expiresAt == cachedUuid.expiresAt;
        }
    }
}

