/*
 * Decompiled with CFR 0.152.
 */
package pl.syntaxdevteam.punisher.commands;

import io.papermc.paper.command.brigadier.BasicCommand;
import io.papermc.paper.command.brigadier.CommandSourceStack;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.UUID;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import kotlin.text.StringsKt;
import net.kyori.adventure.text.Component;
import org.bukkit.Bukkit;
import org.bukkit.command.CommandSender;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.entity.Player;
import org.jetbrains.annotations.NotNull;
import pl.syntaxdevteam.core.messaging.MessageHandler;
import pl.syntaxdevteam.punisher.PunisherX;
import pl.syntaxdevteam.punisher.databases.DatabaseHandler;
import pl.syntaxdevteam.punisher.permissions.PermissionChecker;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\b\u0005\n\u0002\u0010\b\n\u0000\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J'\u0010\u0006\u001a\u00020\u00072\b\b\u0001\u0010\b\u001a\u00020\t2\u000e\b\u0001\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000bH\u0016\u00a2\u0006\u0002\u0010\rJ-\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\f0\u000f2\b\b\u0001\u0010\b\u001a\u00020\t2\u000e\b\u0001\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000bH\u0016\u00a2\u0006\u0002\u0010\u0010J\u000e\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\f0\u000fH\u0002J\u0018\u0010\u0012\u001a\u00020\u00072\u0006\u0010\u0013\u001a\u00020\f2\u0006\u0010\u0014\u001a\u00020\u0015H\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0016"}, d2={"Lpl/syntaxdevteam/punisher/commands/WarnCommand;", "Lio/papermc/paper/command/brigadier/BasicCommand;", "plugin", "Lpl/syntaxdevteam/punisher/PunisherX;", "<init>", "(Lpl/syntaxdevteam/punisher/PunisherX;)V", "execute", "", "stack", "Lio/papermc/paper/command/brigadier/CommandSourceStack;", "args", "", "", "(Lio/papermc/paper/command/brigadier/CommandSourceStack;[Ljava/lang/String;)V", "suggest", "", "(Lio/papermc/paper/command/brigadier/CommandSourceStack;[Ljava/lang/String;)Ljava/util/List;", "generateTimeSuggestions", "executeWarnAction", "player", "warnCount", "", "PunisherX"})
@SourceDebugExtension(value={"SMAP\nWarnCommand.kt\nKotlin\n*S Kotlin\n*F\n+ 1 WarnCommand.kt\npl/syntaxdevteam/punisher/commands/WarnCommand\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,133:1\n827#2:134\n855#2,2:135\n827#2:137\n855#2,2:138\n1869#2,2:140\n1869#2,2:143\n1869#2:145\n1869#2,2:146\n1870#2:148\n1563#2:149\n1634#2,3:150\n1869#2,2:153\n1#3:142\n*S KotlinDebug\n*F\n+ 1 WarnCommand.kt\npl/syntaxdevteam/punisher/commands/WarnCommand\n*L\n31#1:134\n31#1:135,2\n34#1:137\n34#1:138,2\n54#1:140,2\n65#1:143,2\n77#1:145\n79#1:146,2\n77#1:148\n100#1:149\n100#1:150,3\n120#1:153,2\n*E\n"})
public final class WarnCommand
implements BasicCommand {
    @NotNull
    private final PunisherX plugin;

    public WarnCommand(@NotNull PunisherX plugin) {
        Intrinsics.checkNotNullParameter((Object)plugin, "plugin");
        this.plugin = plugin;
    }

    /*
     * WARNING - void declaration
     */
    public void execute(@NotNull CommandSourceStack stack, @NotNull String[] args) {
        Intrinsics.checkNotNullParameter(stack, "stack");
        Intrinsics.checkNotNullParameter(args, "args");
        CommandSender commandSender = stack.getSender();
        Intrinsics.checkNotNullExpressionValue(commandSender, "getSender(...)");
        if (PermissionChecker.INSTANCE.hasWithLegacy(commandSender, PermissionChecker.PermissionKey.WARN)) {
            if (!(args.length == 0)) {
                if (args.length < 2) {
                    stack.getSender().sendMessage(MessageHandler.getMessage$default((MessageHandler)this.plugin.getMessageHandler(), (String)"warn", (String)"usage", null, (int)4, null));
                } else {
                    Pair[] p;
                    void $this$forEach$iv;
                    Iterable destination$iv$iv;
                    String player = args[0];
                    UUID uuid = this.plugin.resolvePlayerUuid(player);
                    Pair[] targetPlayer = Bukkit.getPlayer((UUID)uuid);
                    boolean isForce = ArraysKt.contains(args, "--force");
                    if (!isForce && targetPlayer != null && PermissionChecker.INSTANCE.hasWithBypass((CommandSender)targetPlayer, PermissionChecker.PermissionKey.BYPASS_WARN)) {
                        stack.getSender().sendMessage(this.plugin.getMessageHandler().getMessage("error", "bypass", MapsKt.mapOf(TuplesKt.to("player", player))));
                        return;
                    }
                    String gtime = null;
                    String reason = null;
                    try {
                        void $this$filterNotTo$iv$iv;
                        gtime = args[1];
                        this.plugin.getTimeHandler().parseTime(gtime);
                        Iterable $this$filterNot$iv = ArraysKt.slice(args, RangesKt.until(2, args.length));
                        boolean $i$f$filterNot = false;
                        Iterable iterable = $this$filterNot$iv;
                        destination$iv$iv = new ArrayList();
                        boolean $i$f$filterNotTo = false;
                        for (Iterator element$iv$iv : $this$filterNotTo$iv$iv) {
                            String it = (String)((Object)element$iv$iv);
                            boolean bl = false;
                            if (Intrinsics.areEqual(it, "--force")) continue;
                            destination$iv$iv.add(element$iv$iv);
                        }
                        reason = CollectionsKt.joinToString$default((List)destination$iv$iv, " ", null, null, 0, null, null, 62, null);
                    }
                    catch (NumberFormatException numberFormatException) {
                        void $this$filterNotTo$iv$iv;
                        gtime = null;
                        Iterable $this$filterNot$iv = ArraysKt.slice(args, RangesKt.until(1, args.length));
                        boolean $i$f$filterNot = false;
                        destination$iv$iv = $this$filterNot$iv;
                        Collection destination$iv$iv2 = new ArrayList();
                        boolean $i$f$filterNotTo = false;
                        for (Object element$iv$iv : $this$filterNotTo$iv$iv) {
                            String it = (String)element$iv$iv;
                            boolean bl = false;
                            if (Intrinsics.areEqual(it, "--force")) continue;
                            destination$iv$iv2.add(element$iv$iv);
                        }
                        reason = CollectionsKt.joinToString$default((List)destination$iv$iv2, " ", null, null, 0, null, null, 62, null);
                    }
                    String punishmentType = "WARN";
                    long start = System.currentTimeMillis();
                    Long end = gtime != null ? Long.valueOf(System.currentTimeMillis() + this.plugin.getTimeHandler().parseTime(gtime) * (long)1000) : null;
                    DatabaseHandler databaseHandler = this.plugin.getDatabaseHandler();
                    String string = uuid.toString();
                    Intrinsics.checkNotNullExpressionValue(string, "toString(...)");
                    String string2 = stack.getSender().getName();
                    Intrinsics.checkNotNullExpressionValue(string2, "getName(...)");
                    Long l = end;
                    databaseHandler.addPunishment(player, string, reason, string2, punishmentType, start, l != null ? l : -1L);
                    DatabaseHandler databaseHandler2 = this.plugin.getDatabaseHandler();
                    String string3 = uuid.toString();
                    Intrinsics.checkNotNullExpressionValue(string3, "toString(...)");
                    String string4 = stack.getSender().getName();
                    Intrinsics.checkNotNullExpressionValue(string4, "getName(...)");
                    Long l2 = end;
                    databaseHandler2.addPunishmentHistory(player, string3, reason, string4, punishmentType, start, l2 != null ? l2 : -1L);
                    DatabaseHandler databaseHandler3 = this.plugin.getDatabaseHandler();
                    String string5 = uuid.toString();
                    Intrinsics.checkNotNullExpressionValue(string5, "toString(...)");
                    int warnCount = databaseHandler3.getActiveWarnCount(string5);
                    Object $i$f$filterNotTo = new Pair[]{TuplesKt.to("player", player), TuplesKt.to("reason", reason), TuplesKt.to("time", this.plugin.getTimeHandler().formatTime(gtime)), TuplesKt.to("warn_no", String.valueOf(warnCount))};
                    $i$f$filterNotTo = this.plugin.getMessageHandler().getSmartMessage("warn", "warn", MapsKt.mapOf($i$f$filterNotTo));
                    boolean $i$f$forEach22 = false;
                    for (Object element$iv : $this$forEach$iv) {
                        Component it = (Component)element$iv;
                        boolean bl = false;
                        stack.getSender().sendMessage(it);
                    }
                    Pair[] $i$f$forEach22 = new Pair[]{TuplesKt.to("reason", reason), TuplesKt.to("time", this.plugin.getTimeHandler().formatTime(gtime)), TuplesKt.to("warn_no", String.valueOf(warnCount))};
                    List warnMessages = this.plugin.getMessageHandler().getSmartMessage("warn", "warn_message", MapsKt.mapOf($i$f$forEach22));
                    if (targetPlayer != null) {
                        p = targetPlayer;
                        boolean bl = false;
                        Iterable $this$forEach$iv2 = warnMessages;
                        boolean $i$f$forEach = false;
                        for (Object element$iv : $this$forEach$iv2) {
                            Component it = (Component)element$iv;
                            boolean bl2 = false;
                            p.sendMessage(it);
                        }
                    }
                    p = new Pair[]{TuplesKt.to("player", player), TuplesKt.to("reason", reason), TuplesKt.to("time", this.plugin.getTimeHandler().formatTime(gtime)), TuplesKt.to("warn_no", String.valueOf(warnCount))};
                    List broadcastMessages = this.plugin.getMessageHandler().getSmartMessage("warn", "broadcast", MapsKt.mapOf(p));
                    Collection collection = this.plugin.getServer().getOnlinePlayers();
                    Intrinsics.checkNotNullExpressionValue(collection, "getOnlinePlayers(...)");
                    Iterable $this$forEach$iv3 = collection;
                    boolean $i$f$forEach = false;
                    for (Object element$iv : $this$forEach$iv3) {
                        Player onlinePlayer = (Player)element$iv;
                        boolean bl = false;
                        Intrinsics.checkNotNull(onlinePlayer);
                        if (!PermissionChecker.INSTANCE.hasWithSee((CommandSender)onlinePlayer, PermissionChecker.PermissionKey.SEE_WARN)) continue;
                        Iterable $this$forEach$iv4 = broadcastMessages;
                        boolean $i$f$forEach3 = false;
                        for (Object element$iv2 : $this$forEach$iv4) {
                            Component it = (Component)element$iv2;
                            boolean bl3 = false;
                            onlinePlayer.sendMessage(it);
                        }
                    }
                    if (isForce) {
                        this.plugin.getLogger().warning("Force-warned by " + stack.getSender().getName() + " on " + player);
                    }
                    this.executeWarnAction(player, warnCount);
                }
            } else {
                stack.getSender().sendMessage(MessageHandler.getMessage$default((MessageHandler)this.plugin.getMessageHandler(), (String)"warn", (String)"usage", null, (int)4, null));
            }
        } else {
            stack.getSender().sendMessage(MessageHandler.getMessage$default((MessageHandler)this.plugin.getMessageHandler(), (String)"error", (String)"no_permission", null, (int)4, null));
        }
    }

    @NotNull
    public List<String> suggest(@NotNull CommandSourceStack stack, @NotNull String[] args) {
        Intrinsics.checkNotNullParameter(stack, "stack");
        Intrinsics.checkNotNullParameter(args, "args");
        CommandSender commandSender = stack.getSender();
        Intrinsics.checkNotNullExpressionValue(commandSender, "getSender(...)");
        if (!PermissionChecker.INSTANCE.hasWithLegacy(commandSender, PermissionChecker.PermissionKey.WARN)) {
            return CollectionsKt.emptyList();
        }
        return switch (args.length) {
            case 1 -> {
                void $this$mapTo$iv$iv;
                Collection v1 = this.plugin.getServer().getOnlinePlayers();
                Intrinsics.checkNotNullExpressionValue(v1, "getOnlinePlayers(...)");
                Iterable $this$map$iv = v1;
                boolean $i$f$map = false;
                Iterable var5_5 = $this$map$iv;
                Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
                boolean $i$f$mapTo = false;
                for (Object item$iv$iv : $this$mapTo$iv$iv) {
                    void it;
                    Player var10_10 = (Player)item$iv$iv;
                    Collection var12_12 = destination$iv$iv;
                    boolean $i$a$-map-WarnCommand$suggest$1 = false;
                    var12_12.add(it.getName());
                }
                yield (List)destination$iv$iv;
            }
            case 2 -> this.generateTimeSuggestions();
            case 3 -> this.plugin.getMessageHandler().getReasons("warn", "reasons");
            default -> CollectionsKt.emptyList();
        };
    }

    private final List<String> generateTimeSuggestions() {
        String[] stringArray = new String[]{"s", "m", "h", "d"};
        List<String> units = CollectionsKt.listOf(stringArray);
        List suggestions = new ArrayList();
        for (int i = 1; i < 1000; ++i) {
            for (String unit : units) {
                suggestions.add(i + unit);
            }
        }
        return suggestions;
    }

    private final void executeWarnAction(String player, int warnCount) {
        block1: {
            Set warnActions;
            ConfigurationSection configurationSection = this.plugin.getConfig().getConfigurationSection("warn.actions");
            Set set = warnActions = configurationSection != null ? configurationSection.getKeys(false) : null;
            if (set == null) break block1;
            Iterable $this$forEach$iv = set;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                String command;
                String key = (String)element$iv;
                boolean bl = false;
                Intrinsics.checkNotNull(key);
                Integer warnThreshold = StringsKt.toIntOrNull(key);
                if (warnThreshold == null || warnCount != warnThreshold || (command = this.plugin.getConfig().getString("warn.actions." + key)) == null) continue;
                String formattedCommand = StringsKt.replace$default(StringsKt.replace$default(command, "{player}", player, false, 4, null), "{warn_no}", String.valueOf(warnCount), false, 4, null);
                String filtredCommand = StringsKt.replace$default(formattedCommand, " --force", "", false, 4, null);
                this.plugin.getServer().dispatchCommand((CommandSender)this.plugin.getServer().getConsoleSender(), formattedCommand);
                this.plugin.getLogger().debug("Executed command for " + player + ": " + filtredCommand);
            }
        }
    }
}

