/*
 * Decompiled with CFR 0.152.
 */
package pl.syntaxdevteam.punisher.commands;

import io.papermc.paper.command.brigadier.BasicCommand;
import io.papermc.paper.command.brigadier.CommandSourceStack;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.IntIterator;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.IntRange;
import kotlin.text.StringsKt;
import net.kyori.adventure.text.Component;
import org.bukkit.command.CommandSender;
import org.jetbrains.annotations.NotNull;
import pl.syntaxdevteam.core.messaging.MessageHandler;
import pl.syntaxdevteam.punisher.PunisherX;
import pl.syntaxdevteam.punisher.databases.PunishmentData;
import pl.syntaxdevteam.punisher.permissions.PermissionChecker;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J'\u0010\n\u001a\u00020\u000b2\b\b\u0001\u0010\f\u001a\u00020\r2\u000e\b\u0001\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00100\u000fH\u0016\u00a2\u0006\u0002\u0010\u0011J-\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00100\u00132\b\b\u0001\u0010\f\u001a\u00020\r2\u000e\b\u0001\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00100\u000fH\u0016\u00a2\u0006\u0002\u0010\u0014R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0015"}, d2={"Lpl/syntaxdevteam/punisher/commands/BanListCommand;", "Lio/papermc/paper/command/brigadier/BasicCommand;", "plugin", "Lpl/syntaxdevteam/punisher/PunisherX;", "<init>", "(Lpl/syntaxdevteam/punisher/PunisherX;)V", "dateFormat", "Ljava/text/SimpleDateFormat;", "mh", "Lpl/syntaxdevteam/core/messaging/MessageHandler;", "execute", "", "stack", "Lio/papermc/paper/command/brigadier/CommandSourceStack;", "args", "", "", "(Lio/papermc/paper/command/brigadier/CommandSourceStack;[Ljava/lang/String;)V", "suggest", "", "(Lio/papermc/paper/command/brigadier/CommandSourceStack;[Ljava/lang/String;)Ljava/util/List;", "PunisherX"})
@SourceDebugExtension(value={"SMAP\nBanListCommand.kt\nKotlin\n*S Kotlin\n*F\n+ 1 BanListCommand.kt\npl/syntaxdevteam/punisher/commands/BanListCommand\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,95:1\n1869#2,2:96\n1563#2:98\n1634#2,3:99\n*S KotlinDebug\n*F\n+ 1 BanListCommand.kt\npl/syntaxdevteam/punisher/commands/BanListCommand\n*L\n59#1:96,2\n90#1:98\n90#1:99,3\n*E\n"})
public final class BanListCommand
implements BasicCommand {
    @NotNull
    private final PunisherX plugin;
    @NotNull
    private final SimpleDateFormat dateFormat;
    @NotNull
    private final MessageHandler mh;

    public BanListCommand(@NotNull PunisherX plugin) {
        Intrinsics.checkNotNullParameter((Object)plugin, "plugin");
        this.plugin = plugin;
        this.dateFormat = new SimpleDateFormat("yy-MM-dd HH:mm:ss");
        this.mh = this.plugin.getMessageHandler();
    }

    public void execute(@NotNull CommandSourceStack stack, @NotNull String[] args) {
        List<PunishmentData> punishments;
        Intrinsics.checkNotNullParameter(stack, "stack");
        Intrinsics.checkNotNullParameter(args, "args");
        CommandSender commandSender = stack.getSender();
        Intrinsics.checkNotNullExpressionValue(commandSender, "getSender(...)");
        if (!PermissionChecker.INSTANCE.hasWithLegacy(commandSender, PermissionChecker.PermissionKey.BAN_LIST)) {
            stack.getSender().sendMessage(MessageHandler.getMessage$default((MessageHandler)this.mh, (String)"error", (String)"no_permission", null, (int)4, null));
            return;
        }
        int page = 1;
        boolean historyMode = false;
        for (String arg : args) {
            if (StringsKt.equals(arg, "--h", true)) {
                historyMode = true;
                continue;
            }
            if (StringsKt.toIntOrNull(arg) == null) continue;
            page = Integer.parseInt(arg);
        }
        int limit = 10;
        int offset = (page - 1) * limit;
        List<PunishmentData> list = punishments = historyMode ? this.plugin.getDatabaseHandler().getHistoryBannedPlayers(limit, offset) : this.plugin.getDatabaseHandler().getBannedPlayers(limit, offset);
        if (punishments.isEmpty()) {
            stack.getSender().sendMessage(MessageHandler.getMessage$default((MessageHandler)this.mh, (String)"banlist", (String)"no_punishments", null, (int)4, null));
            this.plugin.getLogger().success(MessageHandler.getSimpleMessage$default((MessageHandler)this.mh, (String)"banlist", (String)"no_punishments", null, (int)4, null));
            return;
        }
        Component title = MessageHandler.getLogMessage$default((MessageHandler)this.mh, (String)"banlist", (String)"title", null, (int)4, null);
        Component topHeader = MessageHandler.getLogMessage$default((MessageHandler)this.mh, (String)"banlist", (String)"top_header", null, (int)4, null);
        Component tableHeader = MessageHandler.getLogMessage$default((MessageHandler)this.mh, (String)"banlist", (String)"table_header", null, (int)4, null);
        Component br = this.mh.miniMessageFormat("<blue> </blue>");
        Component hr = this.mh.miniMessageFormat("<blue>|</blue>");
        stack.getSender().sendMessage(br);
        stack.getSender().sendMessage(title);
        stack.getSender().sendMessage(topHeader);
        stack.getSender().sendMessage(tableHeader);
        stack.getSender().sendMessage(hr);
        Iterable $this$forEach$iv = punishments;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            PunishmentData punishment = (PunishmentData)element$iv;
            boolean bl = false;
            String formattedDate = this.dateFormat.format(new Date(punishment.getStart()));
            Pair[] pairArray = new Pair[]{TuplesKt.to("uuid", punishment.getUuid()), TuplesKt.to("id", String.valueOf(punishment.getId())), TuplesKt.to("player", punishment.getName()), TuplesKt.to("type", punishment.getType()), TuplesKt.to("reason", punishment.getReason()), TuplesKt.to("time", formattedDate), TuplesKt.to("operator", punishment.getOperator())};
            Component punishmentMessage = this.mh.getLogMessage("banlist", "ban_list", MapsKt.mapOf(pairArray));
            stack.getSender().sendMessage(punishmentMessage);
        }
        stack.getSender().sendMessage(hr);
        stack.getSender().sendMessage(hr);
        int nextPage = page + 1;
        int prevPage = page > 1 ? page - 1 : 1;
        Component navigation = this.mh.miniMessageFormat("<blue>| <click:run_command:'/banlist " + prevPage + "'>[Previous]</click> <click:run_command:'/banlist " + nextPage + "'>[Next]</click> </blue>");
        stack.getSender().sendMessage(navigation);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public List<String> suggest(@NotNull CommandSourceStack stack, @NotNull String[] args) {
        List<String> list;
        Intrinsics.checkNotNullParameter(stack, "stack");
        Intrinsics.checkNotNullParameter(args, "args");
        CommandSender commandSender = stack.getSender();
        Intrinsics.checkNotNullExpressionValue(commandSender, "getSender(...)");
        if (PermissionChecker.INSTANCE.hasWithLegacy(commandSender, PermissionChecker.PermissionKey.BAN_LIST)) {
            return CollectionsKt.emptyList();
        }
        if (args.length == 1) {
            void $this$mapTo$iv$iv;
            void $this$map$iv;
            Iterable iterable = new IntRange(1, 5);
            Collection collection = CollectionsKt.listOf("--h");
            boolean $i$f$map = false;
            void var5_6 = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
            boolean $i$f$mapTo = false;
            Iterator iterator2 = $this$mapTo$iv$iv.iterator();
            while (iterator2.hasNext()) {
                void it;
                int item$iv$iv;
                int n = item$iv$iv = ((IntIterator)iterator2).nextInt();
                Collection collection2 = destination$iv$iv;
                boolean bl = false;
                collection2.add(String.valueOf((int)it));
            }
            list = CollectionsKt.plus(collection, (Iterable)((List)destination$iv$iv));
        } else {
            list = CollectionsKt.emptyList();
        }
        return list;
    }
}

