/*
 * Decompiled with CFR 0.152.
 */
package pl.syntaxdevteam.punisher.players;

import com.maxmind.geoip2.DatabaseReader;
import com.maxmind.geoip2.exception.AddressNotFoundException;
import com.maxmind.geoip2.model.CityResponse;
import java.io.Closeable;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.InetAddress;
import java.net.URI;
import java.net.URLConnection;
import java.net.UnknownHostException;
import java.util.zip.GZIPInputStream;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.io.ByteStreamsKt;
import kotlin.io.CloseableKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.apache.tools.tar.TarEntry;
import org.apache.tools.tar.TarInputStream;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import pl.syntaxdevteam.punisher.PunisherX;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0004\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\b\u0010\f\u001a\u00020\rH\u0002J\u0010\u0010\u000e\u001a\u0004\u0018\u00010\u00072\u0006\u0010\u000f\u001a\u00020\u0007J\u0010\u0010\u0010\u001a\u0004\u0018\u00010\u00072\u0006\u0010\u000f\u001a\u00020\u0007R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0013\u0010\u0006\u001a\u00070\u0007\u00a2\u0006\u0002\b\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0011"}, d2={"Lpl/syntaxdevteam/punisher/players/GeoIPHandler;", "", "plugin", "Lpl/syntaxdevteam/punisher/PunisherX;", "<init>", "(Lpl/syntaxdevteam/punisher/PunisherX;)V", "licenseKey", "", "Lorg/jetbrains/annotations/Nullable;", "pluginFolder", "cityDatabaseFile", "Ljava/io/File;", "downloadAndExtractDatabase", "", "getCountry", "ip", "getCity", "PunisherX"})
public final class GeoIPHandler {
    @NotNull
    private final PunisherX plugin;
    @NotNull
    private final String licenseKey;
    @NotNull
    private final String pluginFolder;
    @NotNull
    private final File cityDatabaseFile;

    public GeoIPHandler(@NotNull PunisherX plugin) {
        Intrinsics.checkNotNullParameter((Object)plugin, "plugin");
        this.plugin = plugin;
        String string = this.plugin.getConfig().getString("geoDatabase.licenseKey");
        if (string == null) {
            throw new IllegalArgumentException("License key not found in config.yml. GeoIP functionality will be disabled.");
        }
        this.licenseKey = string;
        this.pluginFolder = this.plugin.getDataFolder().getPath() + "/geodata/";
        this.cityDatabaseFile = new File(this.pluginFolder, "GeoLite2-City.mmdb");
        File folder = new File(this.pluginFolder);
        if (!folder.exists()) {
            folder.mkdirs();
        }
        try {
            this.downloadAndExtractDatabase();
        }
        catch (IOException e) {
            this.plugin.getLogger().severe("Failed to download GeoIP database: " + e.getMessage());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void downloadAndExtractDatabase() {
        if (this.cityDatabaseFile.exists()) {
            this.plugin.getLogger().info("GeoIP database already exists. Skipping download.");
            return;
        }
        URI cityUri = new URI("https://download.maxmind.com/app/geoip_download?edition_id=GeoLite2-City&license_key=" + this.licenseKey + "&suffix=tar.gz");
        URLConnection uRLConnection = cityUri.toURL().openConnection();
        Intrinsics.checkNotNull(uRLConnection, "null cannot be cast to non-null type java.net.HttpURLConnection");
        HttpURLConnection connection = (HttpURLConnection)uRLConnection;
        try {
            Closeable closeable = connection.getInputStream();
            Throwable throwable = null;
            try {
                InputStream input = (InputStream)closeable;
                boolean bl = false;
                Closeable closeable2 = new GZIPInputStream(input);
                Throwable throwable2 = null;
                try {
                    GZIPInputStream gzip = (GZIPInputStream)closeable2;
                    boolean bl2 = false;
                    Closeable closeable3 = (Closeable)new TarInputStream((InputStream)gzip);
                    Throwable throwable3 = null;
                    try {
                        TarInputStream tar = (TarInputStream)closeable3;
                        boolean bl3 = false;
                        TarEntry entry = tar.getNextEntry();
                        while (entry != null) {
                            this.plugin.getLogger().debug("Found entry: " + entry.getName());
                            String string = entry.getName();
                            Intrinsics.checkNotNullExpressionValue(string, "getName(...)");
                            if (StringsKt.endsWith$default(string, ".mmdb", false, 2, null)) {
                                this.plugin.getLogger().debug("Extracting MMDB file: " + entry.getName());
                                if (!this.cityDatabaseFile.getParentFile().exists()) {
                                    this.plugin.getLogger().debug("Creating directories: " + this.cityDatabaseFile.getParentFile().getAbsolutePath());
                                    this.cityDatabaseFile.getParentFile().mkdirs();
                                }
                                try {
                                    Closeable closeable4 = new FileOutputStream(this.cityDatabaseFile);
                                    Throwable throwable4 = null;
                                    try {
                                        FileOutputStream output = (FileOutputStream)closeable4;
                                        boolean bl4 = false;
                                        long l = ByteStreamsKt.copyTo$default((InputStream)tar, output, 0, 2, null);
                                    }
                                    catch (Throwable throwable5) {
                                        throwable4 = throwable5;
                                        throw throwable5;
                                    }
                                    finally {
                                        CloseableKt.closeFinally(closeable4, throwable4);
                                    }
                                    this.plugin.getLogger().debug("Extracted file size: " + this.cityDatabaseFile.length() + " bytes");
                                    if (this.cityDatabaseFile.length() == 0L) {
                                        this.plugin.getLogger().severe("[GeoLite2] Extracted MMDB file is empty!");
                                    } else {
                                        this.plugin.getLogger().debug("MMDB file saved successfully.");
                                    }
                                }
                                catch (IOException e) {
                                    this.plugin.getLogger().severe("[GeoLite2] Failed to write MMDB file: " + e.getMessage());
                                    throw e;
                                }
                            }
                            entry = tar.getNextEntry();
                        }
                        Unit unit = Unit.INSTANCE;
                    }
                    catch (Throwable throwable6) {
                        throwable3 = throwable6;
                        throw throwable6;
                    }
                    finally {
                        CloseableKt.closeFinally(closeable3, throwable3);
                    }
                    Unit unit = Unit.INSTANCE;
                }
                catch (Throwable throwable7) {
                    throwable2 = throwable7;
                    throw throwable7;
                }
                finally {
                    CloseableKt.closeFinally(closeable2, throwable2);
                }
                Unit unit = Unit.INSTANCE;
            }
            catch (Throwable throwable8) {
                throwable = throwable8;
                throw throwable8;
            }
            finally {
                CloseableKt.closeFinally(closeable, throwable);
            }
        }
        catch (IOException e) {
            if (connection.getResponseCode() == 401) {
                this.plugin.getLogger().severe("[GeoLite2] Unauthorized access. Please check your license key.");
            }
            this.plugin.getLogger().severe("[GeoLite2] Failed to download GeoIP database: " + e.getMessage());
            throw e;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public final String getCountry(@NotNull String ip) {
        Object object;
        Intrinsics.checkNotNullParameter(ip, "ip");
        if (!this.cityDatabaseFile.exists()) {
            return "Unknown country";
        }
        try {
            String string;
            object = (Closeable)new DatabaseReader.Builder(this.cityDatabaseFile).build();
            Throwable throwable = null;
            try {
                DatabaseReader reader = (DatabaseReader)object;
                boolean bl = false;
                CityResponse response = reader.city(InetAddress.getByName(ip));
                string = response.getCountry().getName();
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                CloseableKt.closeFinally((Closeable)object, throwable);
            }
            object = string;
        }
        catch (AddressNotFoundException e) {
            object = "Unknown country";
        }
        catch (Exception e) {
            this.plugin.getLogger().severe("Failed to get country for IP " + ip + ": " + e.getMessage() + " [Exception]");
            object = "Unknown country";
        }
        catch (UnknownHostException e) {
            this.plugin.getLogger().severe("Failed to get country for IP " + ip + ": " + e.getMessage() + " [UnknownHostException]");
            object = "Unknown country";
        }
        return object;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public final String getCity(@NotNull String ip) {
        Object object;
        Intrinsics.checkNotNullParameter(ip, "ip");
        if (!this.cityDatabaseFile.exists()) {
            return "Unknown city";
        }
        try {
            String string;
            object = (Closeable)new DatabaseReader.Builder(this.cityDatabaseFile).build();
            Throwable throwable = null;
            try {
                DatabaseReader reader = (DatabaseReader)object;
                boolean bl = false;
                CityResponse response = reader.city(InetAddress.getByName(ip));
                string = response.getCity().getName();
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                CloseableKt.closeFinally((Closeable)object, throwable);
            }
            object = string;
        }
        catch (AddressNotFoundException e) {
            object = "Unknown city";
        }
        catch (Exception e) {
            this.plugin.getLogger().severe("Failed to get city for IP " + ip + ": " + e.getMessage() + " [Exception]");
            object = "Unknown city";
        }
        catch (UnknownHostException e) {
            this.plugin.getLogger().severe("Failed to get city for IP " + ip + ": " + e.getMessage() + " [UnknownHostException]");
            object = "Unknown city";
        }
        return object;
    }
}

