/*
 * Decompiled with CFR 0.152.
 */
package pl.syntaxdevteam.punisher.common;

import java.io.File;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.Charset;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.text.Charsets;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.configuration.file.YamlConfiguration;
import org.jetbrains.annotations.NotNull;
import pl.syntaxdevteam.punisher.PunisherX;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0006\u0010\u0006\u001a\u00020\u0007R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\b"}, d2={"Lpl/syntaxdevteam/punisher/common/ConfigHandler;", "", "plugin", "Lpl/syntaxdevteam/punisher/PunisherX;", "<init>", "(Lpl/syntaxdevteam/punisher/PunisherX;)V", "verifyAndUpdateConfig", "", "PunisherX"})
public final class ConfigHandler {
    @NotNull
    private final PunisherX plugin;

    public ConfigHandler(@NotNull PunisherX plugin) {
        Intrinsics.checkNotNullParameter((Object)plugin, "plugin");
        this.plugin = plugin;
    }

    public final void verifyAndUpdateConfig() {
        File confFile = new File(this.plugin.getDataFolder(), "config.yml");
        InputStream defaultConfStream = this.plugin.getResource("config.yml");
        if (defaultConfStream == null) {
            this.plugin.getLogger().err("Default " + confFile + " file not found in plugin resources!");
            return;
        }
        InputStream inputStream = defaultConfStream;
        Charset charset = Charsets.UTF_8;
        YamlConfiguration yamlConfiguration = YamlConfiguration.loadConfiguration((Reader)new InputStreamReader(inputStream, charset));
        Intrinsics.checkNotNullExpressionValue(yamlConfiguration, "loadConfiguration(...)");
        YamlConfiguration defaultConfig = yamlConfiguration;
        YamlConfiguration yamlConfiguration2 = YamlConfiguration.loadConfiguration((File)confFile);
        Intrinsics.checkNotNullExpressionValue(yamlConfiguration2, "loadConfiguration(...)");
        YamlConfiguration currentConfig = yamlConfiguration2;
        Ref.BooleanRef updated = new Ref.BooleanRef();
        ConfigHandler.verifyAndUpdateConfig$synchronizeSections(updated, (ConfigurationSection)defaultConfig, (ConfigurationSection)currentConfig);
        if (updated.element) {
            this.plugin.getLogger().success("Updating " + confFile + " file with missing entries.");
            currentConfig.save(confFile);
        }
    }

    private static final void verifyAndUpdateConfig$synchronizeSections(Ref.BooleanRef updated, ConfigurationSection defaultSection, ConfigurationSection currentSection) {
        for (String key : defaultSection.getKeys(false)) {
            if (!currentSection.contains(key)) {
                currentSection.set(key, defaultSection.get(key));
                updated.element = true;
                continue;
            }
            if (!defaultSection.isConfigurationSection(key)) continue;
            ConfigurationSection configurationSection = defaultSection.getConfigurationSection(key);
            Intrinsics.checkNotNull(configurationSection);
            ConfigurationSection configurationSection2 = currentSection.getConfigurationSection(key);
            Intrinsics.checkNotNull(configurationSection2);
            ConfigHandler.verifyAndUpdateConfig$synchronizeSections(updated, configurationSection, configurationSection2);
        }
    }
}

