/*
 * Decompiled with CFR 0.152.
 */
package pl.syntaxdevteam.punisher.commands;

import io.papermc.paper.command.brigadier.BasicCommand;
import io.papermc.paper.command.brigadier.CommandSourceStack;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.UUID;
import kotlin.Metadata;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import net.kyori.adventure.text.Component;
import org.bukkit.Bukkit;
import org.bukkit.GameMode;
import org.bukkit.Location;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;
import org.jetbrains.annotations.NotNull;
import pl.syntaxdevteam.core.messaging.MessageHandler;
import pl.syntaxdevteam.punisher.PunisherX;
import pl.syntaxdevteam.punisher.common.TeleportUtils;
import pl.syntaxdevteam.punisher.permissions.PermissionChecker;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J'\u0010\u0006\u001a\u00020\u00072\b\b\u0001\u0010\b\u001a\u00020\t2\u000e\b\u0001\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000bH\u0016\u00a2\u0006\u0002\u0010\rJ-\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\f0\u000f2\b\b\u0001\u0010\b\u001a\u00020\t2\u000e\b\u0001\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000bH\u0016\u00a2\u0006\u0002\u0010\u0010R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0011"}, d2={"Lpl/syntaxdevteam/punisher/commands/UnjailCommand;", "Lio/papermc/paper/command/brigadier/BasicCommand;", "plugin", "Lpl/syntaxdevteam/punisher/PunisherX;", "<init>", "(Lpl/syntaxdevteam/punisher/PunisherX;)V", "execute", "", "stack", "Lio/papermc/paper/command/brigadier/CommandSourceStack;", "args", "", "", "(Lio/papermc/paper/command/brigadier/CommandSourceStack;[Ljava/lang/String;)V", "suggest", "", "(Lio/papermc/paper/command/brigadier/CommandSourceStack;[Ljava/lang/String;)Ljava/util/List;", "PunisherX"})
@SourceDebugExtension(value={"SMAP\nUnjailCommand.kt\nKotlin\n*S Kotlin\n*F\n+ 1 UnjailCommand.kt\npl/syntaxdevteam/punisher/commands/UnjailCommand\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,102:1\n1563#2:103\n1634#2,3:104\n1869#2:107\n1869#2,2:108\n1870#2:110\n1869#2,2:111\n1869#2,2:113\n*S KotlinDebug\n*F\n+ 1 UnjailCommand.kt\npl/syntaxdevteam/punisher/commands/UnjailCommand\n*L\n97#1:103\n97#1:104,3\n53#1:107\n55#1:108,2\n53#1:110\n63#1:111,2\n73#1:113,2\n*E\n"})
public final class UnjailCommand
implements BasicCommand {
    @NotNull
    private final PunisherX plugin;

    public UnjailCommand(@NotNull PunisherX plugin) {
        Intrinsics.checkNotNullParameter((Object)plugin, "plugin");
        this.plugin = plugin;
    }

    public void execute(@NotNull CommandSourceStack stack, @NotNull String[] args) {
        Intrinsics.checkNotNullParameter(stack, "stack");
        Intrinsics.checkNotNullParameter(args, "args");
        CommandSender commandSender = stack.getSender();
        Intrinsics.checkNotNullExpressionValue(commandSender, "getSender(...)");
        if (!PermissionChecker.INSTANCE.hasWithLegacy(commandSender, PermissionChecker.PermissionKey.UNJAIL)) {
            stack.getSender().sendMessage(MessageHandler.getMessage$default((MessageHandler)this.plugin.getMessageHandler(), (String)"error", (String)"no_permission", null, (int)4, null));
            return;
        }
        if (args.length == 0) {
            stack.getSender().sendMessage(MessageHandler.getMessage$default((MessageHandler)this.plugin.getMessageHandler(), (String)"unjail", (String)"usage", null, (int)4, null));
            return;
        }
        String playerName = args[0];
        UUID uuid = this.plugin.resolvePlayerUuid(playerName);
        if (!this.plugin.getCache().isPlayerInCache(uuid)) {
            stack.getSender().sendMessage(this.plugin.getMessageHandler().getMessage("error", "player_not_punished", MapsKt.mapOf(TuplesKt.to("player", playerName))));
            return;
        }
        Player player = Bukkit.getPlayer((UUID)uuid);
        Location releaseLocation = this.plugin.getCache().getReleaseLocation(uuid);
        if (player != null && releaseLocation == null) {
            stack.getSender().sendMessage(MessageHandler.getMessage$default((MessageHandler)this.plugin.getMessageHandler(), (String)"setspawn", (String)"set_error", null, (int)4, null));
            return;
        }
        if (player != null && releaseLocation != null) {
            TeleportUtils.INSTANCE.teleportSafely((Plugin)this.plugin, player, releaseLocation, arg_0 -> UnjailCommand.execute$lambda$2(player, this, playerName, stack, uuid, arg_0));
        } else {
            UnjailCommand.execute$completeUnjail(this, uuid, playerName, stack);
        }
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public List<String> suggest(@NotNull CommandSourceStack stack, @NotNull String[] args) {
        List list;
        Intrinsics.checkNotNullParameter(stack, "stack");
        Intrinsics.checkNotNullParameter(args, "args");
        CommandSender commandSender = stack.getSender();
        Intrinsics.checkNotNullExpressionValue(commandSender, "getSender(...)");
        if (!PermissionChecker.INSTANCE.hasWithLegacy(commandSender, PermissionChecker.PermissionKey.UNJAIL)) {
            return CollectionsKt.emptyList();
        }
        if (args.length == 1) {
            void $this$mapTo$iv$iv;
            Collection collection = this.plugin.getServer().getOnlinePlayers();
            Intrinsics.checkNotNullExpressionValue(collection, "getOnlinePlayers(...)");
            Iterable $this$map$iv = collection;
            boolean $i$f$map = false;
            Iterable iterable = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                Player player = (Player)item$iv$iv;
                Collection collection2 = destination$iv$iv;
                boolean bl = false;
                collection2.add(it.getName());
            }
            list = (List)destination$iv$iv;
        } else {
            list = CollectionsKt.emptyList();
        }
        return list;
    }

    private static final void execute$completeUnjail(UnjailCommand this$0, UUID uuid, String playerName, CommandSourceStack $stack) {
        this$0.plugin.getCache().removePunishment(uuid, false, false);
        List broadcastMessages = this$0.plugin.getMessageHandler().getSmartMessage("unjail", "broadcast", MapsKt.mapOf(TuplesKt.to("player", playerName)));
        Collection collection = this$0.plugin.getServer().getOnlinePlayers();
        Intrinsics.checkNotNullExpressionValue(collection, "getOnlinePlayers(...)");
        Iterable $this$forEach$iv = collection;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Player onlinePlayer = (Player)element$iv;
            boolean bl = false;
            Intrinsics.checkNotNull(onlinePlayer);
            if (!PermissionChecker.INSTANCE.hasWithSee((CommandSender)onlinePlayer, PermissionChecker.PermissionKey.SEE_UNJAIL)) continue;
            Iterable $this$forEach$iv2 = broadcastMessages;
            boolean $i$f$forEach2 = false;
            for (Object element$iv2 : $this$forEach$iv2) {
                Component msg = (Component)element$iv2;
                boolean bl2 = false;
                onlinePlayer.sendMessage(msg);
            }
        }
        $this$forEach$iv = this$0.plugin.getMessageHandler().getSmartMessage("unjail", "success", MapsKt.mapOf(TuplesKt.to("player", playerName)));
        $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Component it = (Component)element$iv;
            boolean bl = false;
            $stack.getSender().sendMessage(it);
        }
    }

    /*
     * WARNING - void declaration
     */
    private static final Unit execute$lambda$2(Player $player, UnjailCommand this$0, String $playerName, CommandSourceStack $stack, UUID $uuid, boolean success) {
        if (success) {
            void $this$forEach$iv;
            $player.setGameMode(GameMode.SURVIVAL);
            Iterable iterable = MessageHandler.getSmartMessage$default((MessageHandler)this$0.plugin.getMessageHandler(), (String)"unjail", (String)"unjail_message", null, (int)4, null);
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                Component msg = (Component)element$iv;
                boolean bl = false;
                $player.sendMessage(msg);
            }
            this$0.plugin.getLogger().debug("<green>Player " + $playerName + " successfully unjailed.</green>");
            UnjailCommand.execute$completeUnjail(this$0, $uuid, $playerName, $stack);
        } else {
            Component failureMessage = this$0.plugin.getMessageHandler().getMessage("unjail", "teleport_failed", MapsKt.mapOf(TuplesKt.to("player", $playerName)));
            $stack.getSender().sendMessage(failureMessage);
            $player.sendMessage(failureMessage);
            this$0.plugin.getLogger().debug("<red>Failed to teleport player " + $playerName + " during unjail.</red>");
        }
        return Unit.INSTANCE;
    }
}

