/*
 * Decompiled with CFR 0.152.
 */
package pl.syntaxdevteam.punisher.commands;

import io.papermc.paper.command.brigadier.BasicCommand;
import io.papermc.paper.command.brigadier.CommandSourceStack;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.Regex;
import net.kyori.adventure.text.Component;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.jetbrains.annotations.NotNull;
import pl.syntaxdevteam.core.messaging.MessageHandler;
import pl.syntaxdevteam.punisher.PunisherX;
import pl.syntaxdevteam.punisher.common.CommandLoggerPlugin;
import pl.syntaxdevteam.punisher.databases.DatabaseHandler;
import pl.syntaxdevteam.punisher.databases.PunishmentData;
import pl.syntaxdevteam.punisher.permissions.PermissionChecker;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0007\n\u0002\u0010 \n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J'\u0010\u0006\u001a\u00020\u00072\b\b\u0001\u0010\b\u001a\u00020\t2\u000e\b\u0001\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000bH\u0016\u00a2\u0006\u0002\u0010\rJ \u0010\u000e\u001a\u00020\u000f2\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\u0010\u001a\u00020\f2\u0006\u0010\u0011\u001a\u00020\fH\u0002J\u0018\u0010\u0012\u001a\u00020\u000f2\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\u0013\u001a\u00020\fH\u0002J\u0010\u0010\u0014\u001a\u00020\u00072\u0006\u0010\u0015\u001a\u00020\fH\u0002J-\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\f0\u00172\b\b\u0001\u0010\b\u001a\u00020\t2\u000e\b\u0001\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000bH\u0016\u00a2\u0006\u0002\u0010\u0018R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0019"}, d2={"Lpl/syntaxdevteam/punisher/commands/UnBanCommand;", "Lio/papermc/paper/command/brigadier/BasicCommand;", "plugin", "Lpl/syntaxdevteam/punisher/PunisherX;", "<init>", "(Lpl/syntaxdevteam/punisher/PunisherX;)V", "execute", "", "stack", "Lio/papermc/paper/command/brigadier/CommandSourceStack;", "args", "", "", "(Lio/papermc/paper/command/brigadier/CommandSourceStack;[Ljava/lang/String;)V", "unbanPlayer", "", "playerName", "uuid", "unbanIP", "ip", "broadcastUnban", "playerOrIp", "suggest", "", "(Lio/papermc/paper/command/brigadier/CommandSourceStack;[Ljava/lang/String;)Ljava/util/List;", "PunisherX"})
@SourceDebugExtension(value={"SMAP\nUnBanComman.kt\nKotlin\n*S Kotlin\n*F\n+ 1 UnBanComman.kt\npl/syntaxdevteam/punisher/commands/UnBanCommand\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,132:1\n1869#2,2:133\n1869#2,2:135\n1869#2,2:137\n1869#2,2:139\n1869#2,2:141\n774#2:143\n865#2,2:144\n1869#2,2:146\n1563#2:148\n1634#2,3:149\n*S KotlinDebug\n*F\n+ 1 UnBanComman.kt\npl/syntaxdevteam/punisher/commands/UnBanCommand\n*L\n46#1:133,2\n64#1:135,2\n78#1:137,2\n95#1:139,2\n109#1:141,2\n120#1:143\n120#1:144,2\n121#1:146,2\n126#1:148\n126#1:149,3\n*E\n"})
public final class UnBanCommand
implements BasicCommand {
    @NotNull
    private final PunisherX plugin;

    public UnBanCommand(@NotNull PunisherX plugin) {
        Intrinsics.checkNotNullParameter((Object)plugin, "plugin");
        this.plugin = plugin;
    }

    public void execute(@NotNull CommandSourceStack stack, @NotNull String[] args) {
        Intrinsics.checkNotNullParameter(stack, "stack");
        Intrinsics.checkNotNullParameter(args, "args");
        CommandSender commandSender = stack.getSender();
        Intrinsics.checkNotNullExpressionValue(commandSender, "getSender(...)");
        if (!PermissionChecker.INSTANCE.hasWithLegacy(commandSender, PermissionChecker.PermissionKey.UNBAN)) {
            stack.getSender().sendMessage(MessageHandler.getMessage$default((MessageHandler)this.plugin.getMessageHandler(), (String)"error", (String)"no_permission", null, (int)4, null));
            return;
        }
        if (args.length == 0) {
            stack.getSender().sendMessage(MessageHandler.getMessage$default((MessageHandler)this.plugin.getMessageHandler(), (String)"unban", (String)"usage", null, (int)4, null));
            return;
        }
        String playerOrIpOrUUID = args[0];
        CharSequence charSequence = playerOrIpOrUUID;
        if (new Regex("\\d+\\.\\d+\\.\\d+\\.\\d+").matches(charSequence)) {
            this.unbanIP(stack, playerOrIpOrUUID);
            return;
        }
        String string = this.plugin.resolvePlayerUuid(playerOrIpOrUUID).toString();
        Intrinsics.checkNotNullExpressionValue(string, "toString(...)");
        String uuid = string;
        this.plugin.getLogger().debug("UUID for player " + playerOrIpOrUUID + ": [" + uuid + "]");
        if (this.unbanPlayer(stack, playerOrIpOrUUID, uuid)) {
            return;
        }
        List<String> ips = this.plugin.getPlayerIPManager().getPlayerIPsByName(playerOrIpOrUUID);
        if (ips.isEmpty()) {
            stack.getSender().sendMessage(this.plugin.getMessageHandler().getMessage("error", "player_not_found", MapsKt.mapOf(TuplesKt.to("player", playerOrIpOrUUID))));
            return;
        }
        this.plugin.getLogger().debug("Assigned IPs for player " + playerOrIpOrUUID + ": " + ips);
        boolean anyUnbanned = false;
        Iterable $this$forEach$iv = ips;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            String ip = (String)element$iv;
            boolean bl = false;
            if (!this.unbanIP(stack, ip)) continue;
            anyUnbanned = true;
        }
        if (!anyUnbanned) {
            stack.getSender().sendMessage(this.plugin.getMessageHandler().getMessage("error", "player_not_found", MapsKt.mapOf(TuplesKt.to("player", playerOrIpOrUUID))));
        }
    }

    private final boolean unbanPlayer(CommandSourceStack stack, String playerName, String uuid) {
        List punishments = DatabaseHandler.getPunishments$default(this.plugin.getDatabaseHandler(), uuid, null, null, 6, null);
        if (punishments.isEmpty()) {
            this.plugin.getLogger().debug("Player " + playerName + " (" + uuid + ") has no ban");
            stack.getSender().sendMessage(this.plugin.getMessageHandler().getMessage("error", "player_not_punished", MapsKt.mapOf(TuplesKt.to("player", playerName))));
            return false;
        }
        boolean unbanned = false;
        Iterable $this$forEach$iv = punishments;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            PunishmentData punishment = (PunishmentData)element$iv;
            boolean bl = false;
            if (!Intrinsics.areEqual(punishment.getType(), "BAN")) continue;
            CommandLoggerPlugin commandLoggerPlugin = this.plugin.getCommandLoggerPlugin();
            String string = stack.getSender().getName();
            Intrinsics.checkNotNullExpressionValue(string, "getName(...)");
            commandLoggerPlugin.logCommand(string, "UNBAN", playerName, "");
            this.plugin.getDatabaseHandler().removePunishment(uuid, punishment.getType(), false);
            this.plugin.getLogger().info("Player " + playerName + " (" + uuid + ") has been unbanned");
            unbanned = true;
        }
        if (unbanned) {
            $this$forEach$iv = this.plugin.getMessageHandler().getSmartMessage("unban", "unban", MapsKt.mapOf(TuplesKt.to("player", playerName)));
            $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                Component it = (Component)element$iv;
                boolean bl = false;
                stack.getSender().sendMessage(it);
            }
            this.broadcastUnban(playerName);
        }
        return unbanned;
    }

    private final boolean unbanIP(CommandSourceStack stack, String ip) {
        List<PunishmentData> punishments = this.plugin.getDatabaseHandler().getPunishmentsByIP(ip);
        if (punishments.isEmpty()) {
            this.plugin.getLogger().debug("No punishments found for IP " + ip);
            stack.getSender().sendMessage(this.plugin.getMessageHandler().getMessage("error", "ip_not_found", MapsKt.mapOf(TuplesKt.to("ip", ip))));
            return false;
        }
        boolean unbanned = false;
        Iterable $this$forEach$iv = punishments;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            PunishmentData punishment = (PunishmentData)element$iv;
            boolean bl = false;
            if (!Intrinsics.areEqual(punishment.getType(), "BANIP")) continue;
            CommandLoggerPlugin commandLoggerPlugin = this.plugin.getCommandLoggerPlugin();
            String string = stack.getSender().getName();
            Intrinsics.checkNotNullExpressionValue(string, "getName(...)");
            commandLoggerPlugin.logCommand(string, "UNBAN (IP)", ip, "");
            DatabaseHandler.removePunishment$default(this.plugin.getDatabaseHandler(), ip, punishment.getType(), false, 4, null);
            this.plugin.getLogger().info("IP " + ip + " has been unbanned");
            unbanned = true;
        }
        if (unbanned) {
            $this$forEach$iv = this.plugin.getMessageHandler().getSmartMessage("unban", "unban", MapsKt.mapOf(TuplesKt.to("player", ip)));
            $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                Component it = (Component)element$iv;
                boolean bl = false;
                stack.getSender().sendMessage(it);
            }
            this.broadcastUnban(ip);
        }
        return unbanned;
    }

    /*
     * WARNING - void declaration
     */
    private final void broadcastUnban(String playerOrIp) {
        void $this$filterTo$iv$iv;
        List messages = this.plugin.getMessageHandler().getSmartMessage("unban", "unban", MapsKt.mapOf(TuplesKt.to("player", playerOrIp)));
        Collection collection = this.plugin.getServer().getOnlinePlayers();
        Intrinsics.checkNotNullExpressionValue(collection, "getOnlinePlayers(...)");
        Iterable $this$filter$iv = collection;
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            Player it = (Player)element$iv$iv;
            boolean bl = false;
            Intrinsics.checkNotNull(it);
            if (!PermissionChecker.INSTANCE.hasWithSee((CommandSender)it, PermissionChecker.PermissionKey.SEE_UNBAN)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        Iterable $this$forEach$iv = (List)destination$iv$iv;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Player player = (Player)element$iv;
            boolean bl = false;
            Iterable $this$forEach$iv2 = messages;
            boolean $i$f$forEach2 = false;
            for (Object element$iv2 : $this$forEach$iv2) {
                Component it = (Component)element$iv2;
                boolean bl2 = false;
                player.sendMessage(it);
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public List<String> suggest(@NotNull CommandSourceStack stack, @NotNull String[] args) {
        List list;
        Intrinsics.checkNotNullParameter(stack, "stack");
        Intrinsics.checkNotNullParameter(args, "args");
        CommandSender commandSender = stack.getSender();
        Intrinsics.checkNotNullExpressionValue(commandSender, "getSender(...)");
        if (PermissionChecker.INSTANCE.hasWithLegacy(commandSender, PermissionChecker.PermissionKey.UNBAN) && args.length == 1) {
            void $this$mapTo$iv$iv;
            Collection collection = this.plugin.getServer().getOnlinePlayers();
            Intrinsics.checkNotNullExpressionValue(collection, "getOnlinePlayers(...)");
            Iterable $this$map$iv = collection;
            boolean $i$f$map = false;
            Iterable iterable = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                Player player = (Player)item$iv$iv;
                Collection collection2 = destination$iv$iv;
                boolean bl = false;
                collection2.add(it.getName());
            }
            list = (List)destination$iv$iv;
        } else {
            list = CollectionsKt.emptyList();
        }
        return list;
    }
}

