/*
 * Decompiled with CFR 0.152.
 */
package pl.syntaxdevteam.punisher.commands;

import io.papermc.paper.command.brigadier.BasicCommand;
import io.papermc.paper.command.brigadier.CommandSourceStack;
import io.papermc.paper.plugin.configuration.PluginMeta;
import io.papermc.paper.plugin.lifecycle.event.LifecycleEventOwner;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import kotlin.Metadata;
import kotlin.Result;
import kotlin.ResultKt;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import kotlin.text.StringsKt;
import org.bukkit.command.CommandSender;
import org.jetbrains.annotations.NotNull;
import pl.syntaxdevteam.core.database.DatabaseType;
import pl.syntaxdevteam.core.messaging.MessageHandler;
import pl.syntaxdevteam.punisher.PunisherX;
import pl.syntaxdevteam.punisher.permissions.PermissionChecker;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\n\u0002\u0010 \n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J'\u0010\b\u001a\u00020\t2\b\b\u0001\u0010\n\u001a\u00020\u000b2\u000e\b\u0001\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000e0\rH\u0016\u00a2\u0006\u0002\u0010\u000fJ\u0018\u0010\u0010\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\u0011\u001a\u00020\u0012H\u0002J-\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u000e0\u00142\b\b\u0001\u0010\n\u001a\u00020\u000b2\u000e\b\u0001\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000e0\rH\u0016\u00a2\u0006\u0002\u0010\u0015R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0016"}, d2={"Lpl/syntaxdevteam/punisher/commands/PunishesXCommands;", "Lio/papermc/paper/command/brigadier/BasicCommand;", "plugin", "Lpl/syntaxdevteam/punisher/PunisherX;", "<init>", "(Lpl/syntaxdevteam/punisher/PunisherX;)V", "mH", "Lpl/syntaxdevteam/core/messaging/MessageHandler;", "execute", "", "stack", "Lio/papermc/paper/command/brigadier/CommandSourceStack;", "args", "", "", "(Lio/papermc/paper/command/brigadier/CommandSourceStack;[Ljava/lang/String;)V", "sendHelp", "page", "", "suggest", "", "(Lio/papermc/paper/command/brigadier/CommandSourceStack;[Ljava/lang/String;)Ljava/util/List;", "PunisherX"})
@SourceDebugExtension(value={"SMAP\nPunisherXCommands.kt\nKotlin\n*S Kotlin\n*F\n+ 1 PunisherXCommands.kt\npl/syntaxdevteam/punisher/commands/PunishesXCommands\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 4 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n*L\n1#1,198:1\n1#2:199\n1869#3,2:200\n774#3:206\n865#3,2:207\n11561#4:202\n11896#4,3:203\n*S KotlinDebug\n*F\n+ 1 PunisherXCommands.kt\npl/syntaxdevteam/punisher/commands/PunishesXCommands\n*L\n176#1:200,2\n193#1:206\n193#1:207,2\n190#1:202\n190#1:203,3\n*E\n"})
public final class PunishesXCommands
implements BasicCommand {
    @NotNull
    private final PunisherX plugin;
    @NotNull
    private final MessageHandler mH;

    public PunishesXCommands(@NotNull PunisherX plugin) {
        Intrinsics.checkNotNullParameter((Object)plugin, "plugin");
        this.plugin = plugin;
        this.mH = this.plugin.getMessageHandler();
    }

    public void execute(@NotNull CommandSourceStack stack, @NotNull String[] args) {
        Intrinsics.checkNotNullParameter(stack, "stack");
        Intrinsics.checkNotNullParameter(args, "args");
        String prefix = this.plugin.getMessageHandler().getPrefix();
        if (!(args.length == 0) && StringsKt.equals(args[0], "help", true)) {
            Object object = ArraysKt.getOrNull(args, 1);
            int page = object != null && (object = StringsKt.toIntOrNull((String)object)) != null ? (Integer)object : 1;
            this.sendHelp(stack, page);
            return;
        }
        CommandSender commandSender = stack.getSender();
        Intrinsics.checkNotNullExpressionValue(commandSender, "getSender(...)");
        if (!PermissionChecker.INSTANCE.hasWithLegacy(commandSender, PermissionChecker.PermissionKey.PUNISHERX_COMMAND)) {
            stack.getSender().sendMessage(MessageHandler.getMessage$default((MessageHandler)this.plugin.getMessageHandler(), (String)"error", (String)"no_permission", null, (int)4, null));
            return;
        }
        if (args.length == 0) {
            stack.getSender().sendMessage(this.mH.miniMessageFormat(prefix + " <green>Type </green><gold>/prx help</gold> <green>to see available commands</green>"));
            return;
        }
        PunisherX punisherX = this.plugin;
        Intrinsics.checkNotNull((Object)punisherX, "null cannot be cast to non-null type io.papermc.paper.plugin.lifecycle.event.LifecycleEventOwner");
        PluginMeta pluginMeta = ((LifecycleEventOwner)punisherX).getPluginMeta();
        Intrinsics.checkNotNullExpressionValue(pluginMeta, "getPluginMeta(...)");
        PluginMeta pluginMeta2 = pluginMeta;
        if (StringsKt.equals(args[0], "version", true)) {
            stack.getSender().sendMessage(this.mH.miniMessageFormat("\n<gray>-------------------------------------------------\n <gray>|\n <gray>|   <gold>\u2192 <bold>" + pluginMeta2.getName() + "</bold> \u2190\n <gray>|   <white>Author: <bold><gold>" + pluginMeta2.getAuthors() + "</gold></bold>\n <gray>|   <white>Website: <bold><gold><click:open_url:'" + pluginMeta2.getWebsite() + "'>" + pluginMeta2.getWebsite() + "</click></gold></bold>\n <gray>|   <white>Version: <bold><gold>" + pluginMeta2.getVersion() + "</gold></bold>\n <gray>|\n<gray>-------------------------------------------------"));
        } else if (StringsKt.equals(args[0], "reload", true)) {
            this.plugin.onReload();
            stack.getSender().sendMessage(this.mH.miniMessageFormat(prefix + " <green>PunisherX has been reloaded.</green>"));
        } else if (StringsKt.equals(args[0], "export", true)) {
            this.plugin.getDatabaseHandler().exportDatabase();
        } else if (StringsKt.equals(args[0], "import", true)) {
            this.plugin.getDatabaseHandler().importDatabase();
        } else if (StringsKt.equals(args[0], "migrate", true)) {
            Object object;
            Object object2;
            String from = ArraysKt.getOrNull(args, 1);
            String to = ArraysKt.getOrNull(args, 2);
            if (from == null || to == null) {
                stack.getSender().sendMessage(this.mH.miniMessageFormat(prefix + " <red>Usage: /prx migrate <from> <to></red>"));
                return;
            }
            Object object3 = this;
            try {
                PunishesXCommands $this$execute_u24lambda_u240 = object3;
                boolean bl = false;
                String string = from.toUpperCase(Locale.ROOT);
                Intrinsics.checkNotNullExpressionValue(string, "toUpperCase(...)");
                object2 = Result.constructor-impl(DatabaseType.valueOf((String)string));
            }
            catch (Throwable bl) {
                object2 = Result.constructor-impl(ResultKt.createFailure(bl));
            }
            object3 = object2;
            DatabaseType fromType = (DatabaseType)(Result.isFailure-impl(object3) ? null : object3);
            object2 = this;
            try {
                PunishesXCommands $this$execute_u24lambda_u241 = (PunishesXCommands)object2;
                boolean bl = false;
                String string = to.toUpperCase(Locale.ROOT);
                Intrinsics.checkNotNullExpressionValue(string, "toUpperCase(...)");
                object = Result.constructor-impl(DatabaseType.valueOf((String)string));
            }
            catch (Throwable throwable) {
                object = Result.constructor-impl(ResultKt.createFailure(throwable));
            }
            object2 = object;
            DatabaseType toType = (DatabaseType)(Result.isFailure-impl(object2) ? null : object2);
            if (fromType == null || toType == null) {
                stack.getSender().sendMessage(this.mH.miniMessageFormat(prefix + " <red>Unknown database type.</red>"));
                return;
            }
            this.plugin.getDatabaseHandler().migrateDatabase(fromType, toType);
        } else {
            stack.getSender().sendMessage(this.mH.miniMessageFormat(prefix + " <green>Type </green><gold>/prx help</gold> <green>to see available commands</green>"));
        }
    }

    private final void sendHelp(CommandSourceStack stack, int page) {
        String[] stringArray = new String[]{"  <gold>/prx help <gray>- <white>Displays this prompt.", "  <gold>/prx version <gray>- <white>Shows plugin info.", "  <gold>/prx reload <gray>- <white>Reloads the configuration file.", "  <gold>/kick <player> <reason> <gray>- <white>Kicks a player from the server", "  <gold>/warn <player> (time) <reason> <gray>- <white>Warns a player.", "  <gold>/unwarn <player> <gray>- <white>Removes a player's warning.", "  <gold>/mute <player> (time) <reason> <gray>- <white>Mutes a player.", "  <gold>/unmute <player> <gray>- <white>Unmutes a player.", "  <gold>/ban <player> (time) <reason> [--force]", "         <gray>- <white>Bans a player, optionally ignoring bypass.", "  <gold>/banip <player/ip> (time) <reason> [--force] ", "         <gray>- <white>Bans a player's IP, optionally ignoring bypass.", "  <gold>/unban <player/ip> <gray>- <white>Unbans a player.", "  <gold>/check <player> <all/warn/mute/ban> ", "    <gray>- <white>Checks and displays the punishments of a given player", "  <gold>/clearall <player> <gray>- <white>Clears all active penalties.", "  <gold>/jail <player> (time) <reason> <gray>- <white>Sends a player to jail.", "  <gold>/unjail <player> <gray>- <white>Releases a player from jail.", "  <gold>/setjail <radius> <gray>- <white>Setting up the jail location.", "  <gold>/setspawn <gray>- <white>Sets the respawn location", "                             <white>after serving a prison sentence.", "  <gold>/change-reason <penalty_id> <new_reason> <gray>", "                - <white>Changes the reason for the penalty.", "  ", "  <gold>/history <player> (page) ", "               <gray>- <white>Displays the player's punishment history.", "  <gold>/banlist <page> --h <gray>- <white>Displays the list of banned players.", "      <white>(Using the <gold>--h</gold> parameter will display the ban history)", "  ", "  <blue>Future:", "  <gold>/panel <gray>- <white>Opens the PunisherX GUI with lots of useful", "                                   <white> information and commands.", "  ", "  ", "  ", " "};
        List<String> commands = CollectionsKt.listOf(stringArray);
        int itemsPerPage = 12;
        int totalPages = (commands.size() + itemsPerPage - 1) / itemsPerPage;
        int currentPage = RangesKt.coerceIn(page, 1, totalPages);
        stack.getSender().sendMessage(this.mH.miniMessageFormat(" <gray>+-------------------------------------------------"));
        stack.getSender().sendMessage(this.mH.miniMessageFormat(" <gray>|    <gold>Available commands for " + this.plugin.getPluginMeta().getName() + ":"));
        stack.getSender().sendMessage(this.mH.miniMessageFormat(" <gray>|"));
        int startIndex = (currentPage - 1) * itemsPerPage;
        int endIndex = RangesKt.coerceAtMost(currentPage * itemsPerPage, commands.size());
        for (int i = startIndex; i < endIndex; ++i) {
            stack.getSender().sendMessage(this.mH.miniMessageFormat(" <gray>|  " + commands.get(i)));
        }
        int prevPage = currentPage > 1 ? currentPage - 1 : totalPages;
        int nextPage = currentPage < totalPages ? currentPage + 1 : 1;
        stack.getSender().sendMessage(this.mH.miniMessageFormat(" <gray>|"));
        stack.getSender().sendMessage(this.mH.miniMessageFormat(" <gray>|"));
        stack.getSender().sendMessage(this.mH.miniMessageFormat(" <gray>| (Page " + currentPage + "/" + totalPages + ") <click:run_command:'/prx help " + prevPage + "'><white>[Previous]</white></click>   <click:run_command:'/prx help " + nextPage + "'><white>[Next]</white></click>"));
        stack.getSender().sendMessage(this.mH.miniMessageFormat(" <gray>|"));
        stack.getSender().sendMessage(this.mH.miniMessageFormat(" <gray>+-------------------------------------------------"));
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public List<String> suggest(@NotNull CommandSourceStack stack, @NotNull String[] args) {
        Intrinsics.checkNotNullParameter(stack, "stack");
        Intrinsics.checkNotNullParameter(args, "args");
        if (args.length == 1) {
            List baseSuggestions = new ArrayList();
            if (StringsKt.startsWith("help", args[0], true)) {
                baseSuggestions.add("help");
            }
            CommandSender commandSender = stack.getSender();
            Intrinsics.checkNotNullExpressionValue(commandSender, "getSender(...)");
            if (PermissionChecker.INSTANCE.hasWithLegacy(commandSender, PermissionChecker.PermissionKey.PUNISHERX_COMMAND)) {
                String[] stringArray = new String[]{"version", "reload", "export", "import"};
                Iterable $this$forEach$iv = CollectionsKt.listOf(stringArray);
                boolean $i$f$forEach = false;
                for (Object element$iv : $this$forEach$iv) {
                    String cmd = (String)element$iv;
                    boolean bl = false;
                    if (!StringsKt.startsWith(cmd, args[0], true)) continue;
                    baseSuggestions.add(cmd);
                }
                if (StringsKt.startsWith("migrate", args[0], true)) {
                    baseSuggestions.add("migrate");
                }
            }
            return baseSuggestions;
        }
        int baseSuggestions = args.length;
        boolean bl = 2 <= baseSuggestions ? baseSuggestions < 4 : false;
        if (bl && StringsKt.equals(args[0], "migrate", true)) {
            void $this$filterTo$iv$iv;
            List list;
            DatabaseType[] $this$forEach$iv = (DatabaseType[])DatabaseType.class.getEnumConstants();
            if ($this$forEach$iv != null) {
                void $this$mapTo$iv$iv;
                void $this$map$iv;
                DatabaseType[] databaseTypeArray = $this$forEach$iv;
                boolean $i$f$map = false;
                void cmd = $this$map$iv;
                Collection destination$iv$iv = new ArrayList(((void)$this$map$iv).length);
                boolean $i$f$mapTo = false;
                int n = ((void)$this$mapTo$iv$iv).length;
                for (int i = 0; i < n; ++i) {
                    void it;
                    void item$iv$iv;
                    void var14_29 = item$iv$iv = $this$mapTo$iv$iv[i];
                    Collection collection = destination$iv$iv;
                    boolean bl2 = false;
                    String string = it.name().toLowerCase(Locale.ROOT);
                    Intrinsics.checkNotNullExpressionValue(string, "toLowerCase(...)");
                    collection.add(string);
                }
                list = (List)destination$iv$iv;
            } else {
                list = CollectionsKt.emptyList();
            }
            List types = list;
            String current = args[args.length - 1];
            Iterable $this$filter$iv = types;
            boolean $i$f$filter = false;
            Iterable $i$f$map = $this$filter$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterTo = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv) {
                String it = (String)element$iv$iv;
                boolean bl3 = false;
                String string = current.toLowerCase(Locale.ROOT);
                Intrinsics.checkNotNullExpressionValue(string, "toLowerCase(...)");
                if (!StringsKt.startsWith$default(it, string, false, 2, null)) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            return (List)destination$iv$iv;
        }
        return CollectionsKt.emptyList();
    }
}

