/*
 * Decompiled with CFR 0.152.
 */
package pl.syntaxdevteam.punisher.basic;

import java.util.List;
import java.util.Locale;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.World;
import org.bukkit.configuration.file.FileConfiguration;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u0006\n\u0002\b\u0003\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u0006\u001a\u00020\u0007J\u001e\u0010\b\u001a\u00020\t2\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\n\u001a\u00020\u00052\u0006\u0010\u000b\u001a\u00020\fJ\u0016\u0010\r\u001a\u00020\t2\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\n\u001a\u00020\u0005J\u0010\u0010\u000e\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u0006\u001a\u00020\u0007\u00a8\u0006\u000f"}, d2={"Lpl/syntaxdevteam/punisher/basic/JailUtils;", "", "<init>", "()V", "getJailLocation", "Lorg/bukkit/Location;", "config", "Lorg/bukkit/configuration/file/FileConfiguration;", "setJailLocation", "", "location", "radius", "", "setUnjailLocation", "getUnjailLocation", "PunisherX"})
public final class JailUtils {
    @NotNull
    public static final JailUtils INSTANCE = new JailUtils();

    private JailUtils() {
    }

    @Nullable
    public final Location getJailLocation(@NotNull FileConfiguration config) {
        Intrinsics.checkNotNullParameter(config, "config");
        String string = config.getString("jail.location.world");
        if (string == null) {
            return null;
        }
        String worldName = string;
        World world = Bukkit.getWorld((String)worldName);
        if (world == null) {
            return null;
        }
        World world2 = world;
        double x = config.getDouble("jail.location.x");
        double y = config.getDouble("jail.location.y");
        double z = config.getDouble("jail.location.z");
        float yaw = (float)config.getDouble("jail.location.yaw", 0.0);
        float pitch = (float)config.getDouble("jail.location.pitch", 0.0);
        return new Location(world2, x, y, z, yaw, pitch);
    }

    public final boolean setJailLocation(@NotNull FileConfiguration config, @NotNull Location location, double radius) {
        Intrinsics.checkNotNullParameter(config, "config");
        Intrinsics.checkNotNullParameter(location, "location");
        Object object = location.getWorld();
        if (object == null || (object = object.getName()) == null) {
            return false;
        }
        Object world = object;
        config.set("jail.location.world", world);
        config.set("jail.location.x", (Object)location.getX());
        config.set("jail.location.y", (Object)location.getY());
        config.set("jail.location.z", (Object)location.getZ());
        config.set("jail.radius", (Object)radius);
        config.set("jail.location.yaw", (Object)location.getYaw());
        config.set("jail.location.pitch", (Object)location.getPitch());
        return true;
    }

    public final boolean setUnjailLocation(@NotNull FileConfiguration config, @NotNull Location location) {
        Intrinsics.checkNotNullParameter(config, "config");
        Intrinsics.checkNotNullParameter(location, "location");
        Object object = location.getWorld();
        if (object == null || (object = object.getName()) == null) {
            return false;
        }
        Object world = object;
        config.set("spawn.location.world", world);
        config.set("spawn.location.x", (Object)location.getX());
        config.set("spawn.location.y", (Object)location.getY());
        config.set("spawn.location.z", (Object)location.getZ());
        config.set("spawn.location.yaw", (Object)location.getYaw());
        config.set("spawn.location.pitch", (Object)location.getPitch());
        return true;
    }

    @Nullable
    public final Location getUnjailLocation(@NotNull FileConfiguration config) {
        Intrinsics.checkNotNullParameter(config, "config");
        if (config.getBoolean("spawn.use_external_set.enabled")) {
            String string;
            String string2 = config.getString("spawn.use_external_set.set");
            if (string2 != null) {
                String string3 = string2.toLowerCase(Locale.ROOT);
                string = string3;
                Intrinsics.checkNotNullExpressionValue(string3, "toLowerCase(...)");
            } else {
                string = null;
            }
            if (Intrinsics.areEqual(string, "world")) {
                List list = Bukkit.getWorlds();
                Intrinsics.checkNotNullExpressionValue(list, "getWorlds(...)");
                World world = (World)CollectionsKt.firstOrNull(list);
                if (world == null) {
                    return null;
                }
                World defaultWorld = world;
                return defaultWorld.getSpawnLocation().clone();
            }
        }
        String string = config.getString("spawn.location.world");
        if (string == null) {
            return null;
        }
        String worldName = string;
        World world = Bukkit.getWorld((String)worldName);
        if (world == null) {
            return null;
        }
        World world2 = world;
        double x = config.getDouble("spawn.location.x");
        double y = config.getDouble("spawn.location.y");
        double z = config.getDouble("spawn.location.z");
        float yaw = (float)config.getDouble("spawn.location.yaw", 0.0);
        float pitch = (float)config.getDouble("spawn.location.pitch", 0.0);
        return new Location(world2, x, y, z, yaw, pitch);
    }
}

