/*
 * Decompiled with CFR 0.152.
 */
package pl.syntaxdevteam.punisher.commands;

import io.papermc.paper.command.brigadier.BasicCommand;
import io.papermc.paper.command.brigadier.CommandSourceStack;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.UUID;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import kotlin.text.StringsKt;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.TextComponent;
import net.kyori.adventure.text.minimessage.tag.resolver.TagResolver;
import org.bukkit.Bukkit;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.jetbrains.annotations.NotNull;
import pl.syntaxdevteam.core.messaging.MessageHandler;
import pl.syntaxdevteam.punisher.PunisherX;
import pl.syntaxdevteam.punisher.databases.DatabaseHandler;
import pl.syntaxdevteam.punisher.permissions.PermissionChecker;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J'\u0010\u0006\u001a\u00020\u00072\b\b\u0001\u0010\b\u001a\u00020\t2\u000e\b\u0001\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000bH\u0016\u00a2\u0006\u0002\u0010\rJ-\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\f0\u000f2\b\b\u0001\u0010\b\u001a\u00020\t2\u000e\b\u0001\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000bH\u0016\u00a2\u0006\u0002\u0010\u0010R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0011"}, d2={"Lpl/syntaxdevteam/punisher/commands/KickCommand;", "Lio/papermc/paper/command/brigadier/BasicCommand;", "plugin", "Lpl/syntaxdevteam/punisher/PunisherX;", "<init>", "(Lpl/syntaxdevteam/punisher/PunisherX;)V", "execute", "", "stack", "Lio/papermc/paper/command/brigadier/CommandSourceStack;", "args", "", "", "(Lio/papermc/paper/command/brigadier/CommandSourceStack;[Ljava/lang/String;)V", "suggest", "", "(Lio/papermc/paper/command/brigadier/CommandSourceStack;[Ljava/lang/String;)Ljava/util/List;", "PunisherX"})
@SourceDebugExtension(value={"SMAP\nKickCommand.kt\nKotlin\n*S Kotlin\n*F\n+ 1 KickCommand.kt\npl/syntaxdevteam/punisher/commands/KickCommand\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,171:1\n827#2:172\n855#2,2:173\n1869#2:175\n1869#2,2:176\n1869#2,2:178\n1870#2:180\n1869#2:181\n1869#2,2:182\n1870#2:184\n1869#2,2:185\n1869#2,2:187\n1869#2:189\n1869#2,2:190\n1870#2:192\n1563#2:193\n1634#2,3:194\n*S KotlinDebug\n*F\n+ 1 KickCommand.kt\npl/syntaxdevteam/punisher/commands/KickCommand\n*L\n28#1:172\n28#1:173,2\n33#1:175\n69#1:176,2\n78#1:178,2\n33#1:180\n87#1:181\n89#1:182,2\n87#1:184\n136#1:185,2\n146#1:187,2\n153#1:189\n155#1:190,2\n153#1:192\n165#1:193\n165#1:194,3\n*E\n"})
public final class KickCommand
implements BasicCommand {
    @NotNull
    private final PunisherX plugin;

    public KickCommand(@NotNull PunisherX plugin) {
        Intrinsics.checkNotNullParameter((Object)plugin, "plugin");
        this.plugin = plugin;
    }

    /*
     * WARNING - void declaration
     */
    public void execute(@NotNull CommandSourceStack stack, @NotNull String[] args) {
        void $this$forEach$iv;
        Object kickMessages;
        void $this$filterNotTo$iv$iv;
        Intrinsics.checkNotNullParameter(stack, "stack");
        Intrinsics.checkNotNullParameter(args, "args");
        boolean history = this.plugin.getConfig().getBoolean("kick.history", false);
        CommandSender commandSender = stack.getSender();
        Intrinsics.checkNotNullExpressionValue(commandSender, "getSender(...)");
        if (!PermissionChecker.INSTANCE.hasWithLegacy(commandSender, PermissionChecker.PermissionKey.KICK)) {
            stack.getSender().sendMessage(MessageHandler.getMessage$default((MessageHandler)this.plugin.getMessageHandler(), (String)"error", (String)"no_permission", null, (int)4, null));
            return;
        }
        if (args.length == 0) {
            stack.getSender().sendMessage(MessageHandler.getMessage$default((MessageHandler)this.plugin.getMessageHandler(), (String)"kick", (String)"usage", null, (int)4, null));
            return;
        }
        String targetArg = args[0];
        boolean isForce = ArraysKt.contains(args, "--force");
        Iterable $this$filterNot$iv = ArraysKt.slice(args, RangesKt.until(1, args.length));
        boolean $i$f$filterNot = false;
        Iterable iterable = $this$filterNot$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterNotTo = false;
        for (Object element$iv$iv : $this$filterNotTo$iv$iv) {
            String it = (String)element$iv$iv;
            boolean bl = false;
            if (Intrinsics.areEqual(it, "--force")) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        String reason = CollectionsKt.joinToString$default((List)destination$iv$iv, " ", null, null, 0, null, null, 62, null);
        String punishmentType = "KICK";
        long start = System.currentTimeMillis();
        if (StringsKt.equals(targetArg, "all", true)) {
            Collection collection = Bukkit.getOnlinePlayers();
            Intrinsics.checkNotNullExpressionValue(collection, "getOnlinePlayers(...)");
            Iterable $this$forEach$iv2 = collection;
            boolean $i$f$forEach22 = false;
            for (Object element$iv : $this$forEach$iv2) {
                TextComponent.Builder kickMessageBuilder;
                Object element$iv2;
                UUID uuid;
                Player target = (Player)element$iv;
                boolean bl = false;
                if (Intrinsics.areEqual(target.getName(), stack.getSender().getName())) continue;
                Intrinsics.checkNotNullExpressionValue(target.getUniqueId(), "getUniqueId(...)");
                if (!isForce) {
                    Intrinsics.checkNotNull(target);
                    if (PermissionChecker.INSTANCE.hasWithBypass((CommandSender)target, PermissionChecker.PermissionKey.BYPASS_KICK)) {
                        stack.getSender().sendMessage(this.plugin.getMessageHandler().getMessage("error", "bypass", MapsKt.mapOf(TuplesKt.to("player", target.getName()))));
                        continue;
                    }
                }
                if (PermissionChecker.INSTANCE.isAuthor(uuid)) continue;
                if (history) {
                    DatabaseHandler databaseHandler = this.plugin.getDatabaseHandler();
                    String string = target.getName();
                    Intrinsics.checkNotNullExpressionValue(string, "getName(...)");
                    String string2 = uuid.toString();
                    Intrinsics.checkNotNullExpressionValue(string2, "toString(...)");
                    String string3 = stack.getSender().getName();
                    Intrinsics.checkNotNullExpressionValue(string3, "getName(...)");
                    databaseHandler.addPunishmentHistory(string, string2, reason, string3, punishmentType, start, start);
                }
                List kickMessages2 = this.plugin.getMessageHandler().getSmartMessage("kick", "kick_message", MapsKt.mapOf(TuplesKt.to("reason", reason)));
                Intrinsics.checkNotNullExpressionValue(Component.text(), "text(...)");
                Object $this$forEach$iv3 = kickMessages2;
                boolean $i$f$forEach = false;
                Iterator iterator2 = $this$forEach$iv3.iterator();
                while (iterator2.hasNext()) {
                    element$iv2 = iterator2.next();
                    Component line = (Component)element$iv2;
                    boolean bl2 = false;
                    ((TextComponent.Builder)kickMessageBuilder.append(line)).append((Component)Component.newline());
                }
                target.kick((Component)kickMessageBuilder.build());
                $this$forEach$iv3 = new Pair[]{TuplesKt.to("player", target.getName()), TuplesKt.to("reason", reason)};
                $this$forEach$iv3 = this.plugin.getMessageHandler().getSmartMessage("kick", "kick", MapsKt.mapOf($this$forEach$iv3));
                $i$f$forEach = false;
                iterator2 = $this$forEach$iv3.iterator();
                while (iterator2.hasNext()) {
                    element$iv2 = iterator2.next();
                    Component it = (Component)element$iv2;
                    boolean bl3 = false;
                    stack.getSender().sendMessage(it);
                }
            }
            Pair[] $i$f$forEach22 = new Pair[]{TuplesKt.to("player", "all"), TuplesKt.to("reason", reason)};
            List broadcastMessages = this.plugin.getMessageHandler().getSmartMessage("kick", "broadcast", MapsKt.mapOf($i$f$forEach22));
            Collection collection2 = this.plugin.getServer().getOnlinePlayers();
            Intrinsics.checkNotNullExpressionValue(collection2, "getOnlinePlayers(...)");
            Iterable $this$forEach$iv4 = collection2;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv4) {
                Player onlinePlayer = (Player)element$iv;
                boolean bl = false;
                Intrinsics.checkNotNull(onlinePlayer);
                if (!PermissionChecker.INSTANCE.hasWithSee((CommandSender)onlinePlayer, PermissionChecker.PermissionKey.SEE_KICK)) continue;
                Iterable $this$forEach$iv5 = broadcastMessages;
                boolean $i$f$forEach3 = false;
                for (Object element$iv3 : $this$forEach$iv5) {
                    Component it = (Component)element$iv3;
                    boolean bl4 = false;
                    onlinePlayer.sendMessage(it);
                }
            }
            return;
        }
        UUID uuid = this.plugin.resolvePlayerUuid(targetArg);
        Player targetPlayer = Bukkit.getPlayer((UUID)uuid);
        if (targetPlayer != null && !isForce && PermissionChecker.INSTANCE.hasWithBypass((CommandSender)targetPlayer, PermissionChecker.PermissionKey.BYPASS_KICK)) {
            stack.getSender().sendMessage(this.plugin.getMessageHandler().getMessage("error", "bypass", MapsKt.mapOf(TuplesKt.to("player", targetArg))));
            return;
        }
        String prefix = this.plugin.getMessageHandler().getPrefix();
        if (PermissionChecker.INSTANCE.isAuthor(uuid)) {
            stack.getSender().sendMessage(this.plugin.getMessageHandler().formatMixedTextToMiniMessage(prefix + " <red>You can't punish the plugin author</red>", TagResolver.empty()));
            return;
        }
        if (history) {
            DatabaseHandler databaseHandler = this.plugin.getDatabaseHandler();
            String string = uuid.toString();
            Intrinsics.checkNotNullExpressionValue(string, "toString(...)");
            String string4 = stack.getSender().getName();
            Intrinsics.checkNotNullExpressionValue(string4, "getName(...)");
            databaseHandler.addPunishmentHistory(targetArg, string, reason, string4, punishmentType, start, start);
        }
        if (targetPlayer != null) {
            kickMessages = this.plugin.getMessageHandler().getSmartMessage("kick", "kick_message", MapsKt.mapOf(TuplesKt.to("reason", reason)));
            TextComponent.Builder builder = Component.text();
            Intrinsics.checkNotNullExpressionValue(builder, "text(...)");
            TextComponent.Builder kickMessageBuilder = builder;
            Iterable $this$forEach$iv6 = (Iterable)kickMessages;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv6) {
                Component line = (Component)element$iv;
                boolean bl = false;
                ((TextComponent.Builder)kickMessageBuilder.append(line)).append((Component)Component.newline());
            }
            targetPlayer.kick((Component)kickMessageBuilder.build());
        }
        kickMessages = new Pair[]{TuplesKt.to("player", targetArg), TuplesKt.to("reason", reason)};
        kickMessages = this.plugin.getMessageHandler().getSmartMessage("kick", "kick", MapsKt.mapOf(kickMessages));
        boolean $i$f$forEach32 = false;
        for (Object element$iv : $this$forEach$iv) {
            Component it = (Component)element$iv;
            boolean bl = false;
            stack.getSender().sendMessage(it);
        }
        Pair[] $i$f$forEach32 = new Pair[]{TuplesKt.to("player", targetArg), TuplesKt.to("reason", reason)};
        List broadcastMessages = this.plugin.getMessageHandler().getSmartMessage("kick", "broadcast", MapsKt.mapOf($i$f$forEach32));
        Collection collection = this.plugin.getServer().getOnlinePlayers();
        Intrinsics.checkNotNullExpressionValue(collection, "getOnlinePlayers(...)");
        Iterable $this$forEach$iv7 = collection;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv7) {
            Player onlinePlayer = (Player)element$iv;
            boolean bl = false;
            Intrinsics.checkNotNull(onlinePlayer);
            if (!PermissionChecker.INSTANCE.hasWithSee((CommandSender)onlinePlayer, PermissionChecker.PermissionKey.SEE_KICK)) continue;
            Iterable $this$forEach$iv8 = broadcastMessages;
            boolean $i$f$forEach4 = false;
            for (Object element$iv4 : $this$forEach$iv8) {
                Component it = (Component)element$iv4;
                boolean bl5 = false;
                onlinePlayer.sendMessage(it);
            }
        }
    }

    @NotNull
    public List<String> suggest(@NotNull CommandSourceStack stack, @NotNull String[] args) {
        Intrinsics.checkNotNullParameter(stack, "stack");
        Intrinsics.checkNotNullParameter(args, "args");
        CommandSender commandSender = stack.getSender();
        Intrinsics.checkNotNullExpressionValue(commandSender, "getSender(...)");
        if (!PermissionChecker.INSTANCE.hasWithLegacy(commandSender, PermissionChecker.PermissionKey.KICK)) {
            return CollectionsKt.emptyList();
        }
        return switch (args.length) {
            case 1 -> {
                void $this$mapTo$iv$iv;
                void $this$map$iv;
                Collection v1 = CollectionsKt.listOf("all");
                Collection v2 = this.plugin.getServer().getOnlinePlayers();
                Intrinsics.checkNotNullExpressionValue(v2, "getOnlinePlayers(...)");
                Iterable var3_3 = v2;
                Collection var12_4 = v1;
                boolean $i$f$map = false;
                void var5_6 = $this$map$iv;
                Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
                boolean $i$f$mapTo = false;
                for (Object item$iv$iv : $this$mapTo$iv$iv) {
                    void it;
                    Player var10_11 = (Player)item$iv$iv;
                    Collection var13_13 = destination$iv$iv;
                    boolean $i$a$-map-KickCommand$suggest$1 = false;
                    String v3 = it.getName();
                    Intrinsics.checkNotNullExpressionValue(v3, "getName(...)");
                    var13_13.add(v3);
                }
                yield CollectionsKt.plus(var12_4, (Iterable)((List)destination$iv$iv));
            }
            case 2 -> this.plugin.getMessageHandler().getReasons("kick", "reasons");
            default -> CollectionsKt.emptyList();
        };
    }
}

