/*
 * Decompiled with CFR 0.152.
 */
package pl.syntaxdevteam.punisher.players;

import java.io.File;
import java.io.Serializable;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.nio.charset.Charset;
import java.security.Key;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import javax.crypto.Cipher;
import javax.crypto.spec.SecretKeySpec;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.io.FilesKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.CharsKt;
import kotlin.text.Charsets;
import kotlin.text.StringsKt;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.player.PlayerJoinEvent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import pl.syntaxdevteam.punisher.PunisherX;
import pl.syntaxdevteam.punisher.players.GeoIPHandler;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\f\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0010\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0007J \u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u00152\u0006\u0010\u0017\u001a\u00020\u0015H\u0002J*\u0010\u0018\u001a\u00020\u000f2\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u00152\u0006\u0010\u0017\u001a\u00020\u00152\b\u0010\u0019\u001a\u0004\u0018\u00010\u0015H\u0002J\b\u0010\u001a\u001a\u00020\rH\u0002J\u0010\u0010\u001b\u001a\u00020\u00152\u0006\u0010\u001c\u001a\u00020\u0015H\u0002J\u0010\u0010\u001d\u001a\u00020\u00152\u0006\u0010\u001c\u001a\u00020\u0015H\u0002J\u0010\u0010\u001e\u001a\u0004\u0018\u00010\u00152\u0006\u0010\u0014\u001a\u00020\u0015J\u0010\u0010\u001f\u001a\u0004\u0018\u00010\u00152\u0006\u0010\u0016\u001a\u00020\u0015J\"\u0010 \u001a\u0004\u0018\u00010\u00152\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u00152\u0006\u0010\u0017\u001a\u00020\u0015H\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006!"}, d2={"Lpl/syntaxdevteam/punisher/players/PlayerIPManager;", "Lorg/bukkit/event/Listener;", "plugin", "Lpl/syntaxdevteam/punisher/PunisherX;", "geoIPHandler", "Lpl/syntaxdevteam/punisher/players/GeoIPHandler;", "<init>", "(Lpl/syntaxdevteam/punisher/PunisherX;Lpl/syntaxdevteam/punisher/players/GeoIPHandler;)V", "getGeoIPHandler", "()Lpl/syntaxdevteam/punisher/players/GeoIPHandler;", "cacheFile", "Ljava/io/File;", "secretKey", "Ljava/security/Key;", "onPlayerJoin", "", "event", "Lorg/bukkit/event/player/PlayerJoinEvent;", "isPlayerInfoExists", "", "playerName", "", "playerUUID", "playerIP", "savePlayerInfo", "geoLocation", "generateKey", "encrypt", "data", "decrypt", "getPlayerIPByName", "getPlayerIPByUUID", "searchCache", "PunisherX"})
@SourceDebugExtension(value={"SMAP\nPlayerIPManager.kt\nKotlin\n*S Kotlin\n*F\n+ 1 PlayerIPManager.kt\npl/syntaxdevteam/punisher/players/PlayerIPManager\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,121:1\n1557#2:122\n1628#2,3:123\n1557#2:126\n1628#2,3:127\n*S KotlinDebug\n*F\n+ 1 PlayerIPManager.kt\npl/syntaxdevteam/punisher/players/PlayerIPManager\n*L\n68#1:122\n68#1:123,3\n99#1:126\n99#1:127,3\n*E\n"})
public final class PlayerIPManager
implements Listener {
    @NotNull
    private final PunisherX plugin;
    @NotNull
    private final GeoIPHandler geoIPHandler;
    @NotNull
    private final File cacheFile;
    @NotNull
    private final Key secretKey;

    public PlayerIPManager(@NotNull PunisherX plugin, @NotNull GeoIPHandler geoIPHandler) {
        Intrinsics.checkNotNullParameter((Object)plugin, "plugin");
        Intrinsics.checkNotNullParameter(geoIPHandler, "geoIPHandler");
        this.plugin = plugin;
        this.geoIPHandler = geoIPHandler;
        this.cacheFile = new File(this.plugin.getDataFolder(), "cache");
        this.secretKey = this.generateKey();
        if (!this.cacheFile.exists()) {
            this.cacheFile.getParentFile().mkdirs();
            this.cacheFile.createNewFile();
        }
    }

    @NotNull
    public final GeoIPHandler getGeoIPHandler() {
        return this.geoIPHandler;
    }

    @EventHandler
    public final void onPlayerJoin(@NotNull PlayerJoinEvent event) {
        String playerIP;
        Intrinsics.checkNotNullParameter(event, "event");
        Player player = event.getPlayer();
        Intrinsics.checkNotNullExpressionValue(player, "getPlayer(...)");
        Player player2 = player;
        String string = player2.getName();
        Intrinsics.checkNotNullExpressionValue(string, "getName(...)");
        String playerName = string;
        String string2 = player2.getUniqueId().toString();
        Intrinsics.checkNotNullExpressionValue(string2, "toString(...)");
        String playerUUID = string2;
        Serializable serializable = player2.getAddress();
        String string3 = serializable != null && (serializable = ((InetSocketAddress)serializable).getAddress()) != null ? ((InetAddress)serializable).getHostAddress() : (playerIP = null);
        if (playerIP != null) {
            String country = this.geoIPHandler.getCountry(playerIP);
            String city = this.geoIPHandler.getCity(playerIP);
            String geoLocation = city + ", " + country;
            if (!this.isPlayerInfoExists(playerName, playerUUID, playerIP)) {
                this.savePlayerInfo(playerName, playerUUID, playerIP, geoLocation);
                this.plugin.getLogger().debug("Saved player info -> playerName: " + playerName + ", playerUUID: " + playerUUID + ", playerIP: " + playerIP + ", geoLocation: " + geoLocation);
            } else {
                this.plugin.getLogger().debug("Player info already exists -> playerName: " + playerName + ", playerUUID: " + playerUUID + ", playerIP: " + playerIP + ", geoLocation: " + geoLocation);
            }
        }
    }

    private final boolean isPlayerInfoExists(String playerName, String playerUUID, String playerIP) {
        return this.searchCache(playerName, playerUUID, playerIP) != null;
    }

    private final void savePlayerInfo(String playerName, String playerUUID, String playerIP, String geoLocation) {
        String encryptedData = this.encrypt(playerName + "," + playerUUID + "," + playerIP + "," + geoLocation);
        FilesKt.appendText$default(this.cacheFile, encryptedData + "\n", null, 2, null);
        this.plugin.getLogger().debug("Encrypted data saved -> playerName: " + playerName + ", playerUUID: " + playerUUID + ", playerIP: " + playerIP + ", geoLocation: " + geoLocation);
    }

    private final Key generateKey() {
        String keyString = "M424PmX84WlDDXLb";
        byte[] byArray = keyString.getBytes(Charsets.UTF_8);
        Intrinsics.checkNotNullExpressionValue(byArray, "getBytes(...)");
        return new SecretKeySpec(byArray, "AES");
    }

    private final String encrypt(String data) {
        Cipher cipher = Cipher.getInstance("AES");
        cipher.init(1, this.secretKey);
        byte[] byArray = data.getBytes(Charsets.UTF_8);
        Intrinsics.checkNotNullExpressionValue(byArray, "getBytes(...)");
        byte[] byArray2 = cipher.doFinal(byArray);
        Intrinsics.checkNotNullExpressionValue(byArray2, "doFinal(...)");
        return ArraysKt.joinToString$default(byArray2, (CharSequence)"", null, null, 0, null, PlayerIPManager::encrypt$lambda$0, 30, null);
    }

    /*
     * WARNING - void declaration
     */
    private final String decrypt(String data) {
        String string;
        try {
            void $this$mapTo$iv$iv;
            Iterable $this$map$iv = StringsKt.chunked(data, 2);
            boolean $i$f$map = false;
            Object object = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                String string2 = (String)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl = false;
                collection.add((byte)Integer.parseInt((String)it, CharsKt.checkRadix(16)));
            }
            byte[] bytes = CollectionsKt.toByteArray((List)destination$iv$iv);
            Cipher cipher = Cipher.getInstance("AES");
            cipher.init(2, this.secretKey);
            byte[] byArray = cipher.doFinal(bytes);
            Intrinsics.checkNotNullExpressionValue(byArray, "doFinal(...)");
            byte[] byArray2 = byArray;
            object = Charsets.UTF_8;
            string = new String(byArray2, (Charset)object);
        }
        catch (NumberFormatException e) {
            this.plugin.getLogger().err("Failed to decrypt data: " + data + " -> " + e);
            string = "";
        }
        return string;
    }

    @Nullable
    public final String getPlayerIPByName(@NotNull String playerName) {
        Intrinsics.checkNotNullParameter(playerName, "playerName");
        this.plugin.getLogger().debug("Fetching IP for player: " + playerName);
        String ip = this.searchCache(playerName, "", "");
        this.plugin.getLogger().debug("Found IP for player " + playerName + ": " + ip);
        return ip;
    }

    @Nullable
    public final String getPlayerIPByUUID(@NotNull String playerUUID) {
        Intrinsics.checkNotNullParameter(playerUUID, "playerUUID");
        this.plugin.getLogger().debug("Fetching IP for UUID: " + playerUUID);
        String ip = this.searchCache("", playerUUID, "");
        this.plugin.getLogger().debug("Found IP for UUID " + playerUUID + ": " + ip);
        return ip;
    }

    /*
     * WARNING - void declaration
     */
    private final String searchCache(String playerName, String playerUUID, String playerIP) {
        this.plugin.getLogger().debug("Searching cache");
        List lines = FilesKt.readLines$default(this.cacheFile, null, 1, null);
        this.plugin.getLogger().debug("Number of lines in cache: " + lines.size());
        for (String line : lines) {
            void $this$mapTo$iv$iv;
            String decryptedLine = this.decrypt(line);
            this.plugin.getLogger().debug("Decrypted line: " + decryptedLine);
            String[] stringArray = new String[]{","};
            Iterable $this$map$iv = StringsKt.split$default((CharSequence)decryptedLine, stringArray, false, 0, 6, null);
            boolean $i$f$map = false;
            Iterable iterable = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                String string = (String)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl = false;
                String string2 = ((Object)StringsKt.trim((CharSequence)it)).toString().toLowerCase(Locale.ROOT);
                Intrinsics.checkNotNullExpressionValue(string2, "toLowerCase(...)");
                collection.add(string2);
            }
            List parts = (List)destination$iv$iv;
            this.plugin.getLogger().debug("Split parts: " + parts);
            if (!(((CharSequence)playerName).length() == 0)) {
                Object e = parts.get(0);
                String string = playerName.toLowerCase(Locale.ROOT);
                Intrinsics.checkNotNullExpressionValue(string, "toLowerCase(...)");
                if (!Intrinsics.areEqual(e, string)) continue;
            }
            if (!(((CharSequence)playerUUID).length() == 0)) {
                Object e = parts.get(1);
                String string = playerUUID.toLowerCase(Locale.ROOT);
                Intrinsics.checkNotNullExpressionValue(string, "toLowerCase(...)");
                if (!Intrinsics.areEqual(e, string)) continue;
            }
            if (!(((CharSequence)playerIP).length() == 0)) {
                Object e = parts.get(2);
                String string = playerIP.toLowerCase(Locale.ROOT);
                Intrinsics.checkNotNullExpressionValue(string, "toLowerCase(...)");
                if (!Intrinsics.areEqual(e, string)) continue;
            }
            this.plugin.getLogger().debug("Match found: " + parts.get(2));
            return (String)parts.get(2);
        }
        this.plugin.getLogger().debug("No match found in cache");
        return null;
    }

    private static final CharSequence encrypt$lambda$0(byte it) {
        String string = "%02x";
        Object[] objectArray = new Object[]{it};
        String string2 = String.format(string, Arrays.copyOf(objectArray, objectArray.length));
        Intrinsics.checkNotNullExpressionValue(string2, "format(...)");
        return string2;
    }
}

