/*
 * Decompiled with CFR 0.152.
 */
package pl.syntaxdevteam.punisher.common;

import com.google.gson.Gson;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.io.BufferedReader;
import java.io.Closeable;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.HttpURLConnection;
import java.net.URI;
import java.net.URL;
import java.net.URLConnection;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.collections.CollectionsKt;
import kotlin.io.CloseableKt;
import kotlin.io.TextStreamsKt;
import kotlin.jvm.internal.ArrayIteratorKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.bukkit.plugin.Plugin;
import org.jetbrains.annotations.NotNull;
import pl.syntaxdevteam.punisher.PunisherX;
import pl.syntaxdevteam.punisher.common.PluginInfo;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\b\u0004\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u000e\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\tH\u0002J\u001a\u0010\u000b\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\r\u0012\u0004\u0012\u00020\r0\f0\tH\u0002J2\u0010\u000e\u001a\u0004\u0018\u00010\r2\f\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\n0\t2\u0018\u0010\u0010\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\r\u0012\u0004\u0012\u00020\r0\f0\tH\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0011"}, d2={"Lpl/syntaxdevteam/punisher/common/PluginManager;", "", "plugin", "Lpl/syntaxdevteam/punisher/PunisherX;", "<init>", "(Lpl/syntaxdevteam/punisher/PunisherX;)V", "gson", "Lcom/google/gson/Gson;", "fetchPluginsFromExternalSource", "", "Lpl/syntaxdevteam/punisher/common/PluginInfo;", "fetchLoadedPlugins", "Lkotlin/Pair;", "", "getHighestPriorityPlugin", "externalPlugins", "loadedPlugins", "PunisherX"})
@SourceDebugExtension(value={"SMAP\nPluginManager.kt\nKotlin\n*S Kotlin\n*F\n+ 1 PluginManager.kt\npl/syntaxdevteam/punisher/common/PluginManager\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,72:1\n774#2:73\n865#2,2:74\n1557#2:77\n1628#2,3:78\n774#2:81\n865#2:82\n1755#2,3:83\n866#2:86\n1971#2,14:87\n1#3:76\n*S KotlinDebug\n*F\n+ 1 PluginManager.kt\npl/syntaxdevteam/punisher/common/PluginManager\n*L\n21#1:73\n21#1:74,2\n38#1:77\n38#1:78,3\n66#1:81\n66#1:82\n67#1:83,3\n66#1:86\n69#1:87,14\n*E\n"})
public final class PluginManager {
    @NotNull
    private final PunisherX plugin;
    @NotNull
    private final Gson gson;

    /*
     * WARNING - void declaration
     */
    public PluginManager(@NotNull PunisherX plugin) {
        Intrinsics.checkNotNullParameter((Object)plugin, "plugin");
        this.plugin = plugin;
        this.gson = new Gson();
        List<PluginInfo> externalPlugins = this.fetchPluginsFromExternalSource();
        List<Pair<String, String>> loadedPlugins = this.fetchLoadedPlugins();
        String highestPriorityPlugin = this.getHighestPriorityPlugin(externalPlugins, loadedPlugins);
        if (Intrinsics.areEqual(highestPriorityPlugin, this.plugin.getPluginMetas().getName())) {
            void $this$filterTo$iv$iv;
            Iterable $this$filter$iv = loadedPlugins;
            boolean $i$f$filter = false;
            Iterable iterable = $this$filter$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterTo = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv) {
                Pair it = (Pair)element$iv$iv;
                boolean bl = false;
                if (!(!Intrinsics.areEqual(it.getFirst(), this.plugin.getPluginMetas().getName()))) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            List syntaxDevTeamPlugins = (List)destination$iv$iv;
            this.plugin.getLogger().pluginStart(syntaxDevTeamPlugins);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    private final List<PluginInfo> fetchPluginsFromExternalSource() {
        List<PluginInfo> list;
        try {
            List list2;
            URI uri = new URI("https://raw.githubusercontent.com/SyntaxDevTeam/plugins-list/main/plugins.json");
            URL url = uri.toURL();
            URLConnection uRLConnection = url.openConnection();
            Intrinsics.checkNotNull(uRLConnection, "null cannot be cast to non-null type java.net.HttpURLConnection");
            HttpURLConnection connection = (HttpURLConnection)uRLConnection;
            connection.setRequestMethod("GET");
            connection.setConnectTimeout(5000);
            int responseCode = connection.getResponseCode();
            if (responseCode == 200) {
                void $this$mapTo$iv$iv;
                Object it;
                Closeable closeable = new BufferedReader(new InputStreamReader(connection.getInputStream()));
                Throwable throwable = null;
                try {
                    it = (BufferedReader)closeable;
                    boolean bl = false;
                    it = TextStreamsKt.readText((Reader)it);
                }
                catch (Throwable bl) {
                    throwable = bl;
                    throw bl;
                }
                finally {
                    CloseableKt.closeFinally(closeable, throwable);
                }
                Object responseBody = it;
                JsonArray jsonArray = (JsonArray)this.gson.fromJson((String)responseBody, JsonArray.class);
                Intrinsics.checkNotNull(jsonArray);
                Iterable $this$map$iv = (Iterable)jsonArray;
                boolean $i$f$map = false;
                Iterable bl = $this$map$iv;
                Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
                boolean $i$f$mapTo = false;
                for (Object item$iv$iv : $this$mapTo$iv$iv) {
                    void jsonElement;
                    JsonElement jsonElement2 = (JsonElement)item$iv$iv;
                    Collection collection = destination$iv$iv;
                    boolean bl2 = false;
                    JsonObject json = jsonElement.getAsJsonObject();
                    String string = json.get("name").getAsString();
                    Intrinsics.checkNotNullExpressionValue(string, "getAsString(...)");
                    String string2 = json.get("uuid").getAsString();
                    Intrinsics.checkNotNullExpressionValue(string2, "getAsString(...)");
                    collection.add(new PluginInfo(string, string2, json.get("prior").getAsInt()));
                }
                list2 = (List)destination$iv$iv;
            } else {
                list2 = CollectionsKt.emptyList();
            }
            list = list2;
        }
        catch (Exception e) {
            this.plugin.getLogger().warning("An error occurred while fetching plugins: " + e.getMessage());
            list = CollectionsKt.emptyList();
        }
        return list;
    }

    private final List<Pair<String, String>> fetchLoadedPlugins() {
        List plugins = new ArrayList();
        Iterator<Plugin> iterator2 = ArrayIteratorKt.iterator(this.plugin.getServer().getPluginManager().getPlugins());
        while (iterator2.hasNext()) {
            Plugin plugin;
            Intrinsics.checkNotNullExpressionValue(iterator2.next(), "next(...)");
            if (!plugin.getPluginMeta().getAuthors().contains("SyntaxDevTeam")) continue;
            plugins.add(new Pair<String, String>(plugin.getPluginMeta().getName(), plugin.getPluginMeta().getVersion()));
        }
        return plugins;
    }

    /*
     * WARNING - void declaration
     */
    private final String getHighestPriorityPlugin(List<PluginInfo> externalPlugins, List<Pair<String, String>> loadedPlugins) {
        Object v1;
        void $this$filterTo$iv$iv;
        Iterable $this$filter$iv = externalPlugins;
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            boolean bl;
            block9: {
                PluginInfo externalPlugin = (PluginInfo)element$iv$iv;
                boolean bl2 = false;
                Iterable $this$any$iv = loadedPlugins;
                boolean $i$f$any = false;
                if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                    bl = false;
                } else {
                    for (Object element$iv : $this$any$iv) {
                        Pair it = (Pair)element$iv;
                        boolean bl3 = false;
                        if (!Intrinsics.areEqual(it.getFirst(), externalPlugin.getName())) continue;
                        bl = true;
                        break block9;
                    }
                    bl = false;
                }
            }
            if (!bl) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        List matchedPlugins = (List)destination$iv$iv;
        Iterable $this$maxByOrNull$iv = matchedPlugins;
        boolean $i$f$maxByOrNull = false;
        Iterator iterator$iv = $this$maxByOrNull$iv.iterator();
        if (!iterator$iv.hasNext()) {
            v1 = null;
        } else {
            Object maxElem$iv = iterator$iv.next();
            if (!iterator$iv.hasNext()) {
                v1 = maxElem$iv;
            } else {
                PluginInfo it = (PluginInfo)maxElem$iv;
                boolean bl = false;
                int maxValue$iv = it.getPrior();
                do {
                    Object e$iv = iterator$iv.next();
                    PluginInfo it2 = (PluginInfo)e$iv;
                    $i$a$-maxByOrNull-PluginManager$getHighestPriorityPlugin$1 = false;
                    int v$iv = it2.getPrior();
                    if (maxValue$iv >= v$iv) continue;
                    maxElem$iv = e$iv;
                    maxValue$iv = v$iv;
                } while (iterator$iv.hasNext());
                v1 = maxElem$iv;
            }
        }
        PluginInfo pluginInfo = v1;
        return pluginInfo != null ? pluginInfo.getName() : null;
    }
}

