/*
 * Decompiled with CFR 0.152.
 */
package pl.syntaxdevteam.punisher.common;

import io.papermc.paper.plugin.configuration.PluginMeta;
import java.io.File;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.Charsets;
import kotlin.text.StringsKt;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.minimessage.MiniMessage;
import net.kyori.adventure.text.serializer.legacy.LegacyComponentSerializer;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.configuration.file.YamlConfiguration;
import org.jetbrains.annotations.NotNull;
import pl.syntaxdevteam.punisher.PunisherX;
import pl.syntaxdevteam.punisher.common.Logger;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000V\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\t\n\u0002\u0010$\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0006\u0010\u0013\u001a\u00020\u0014J\b\u0010\u0015\u001a\u00020\u0014H\u0002J\b\u0010\u0016\u001a\u00020\u0014H\u0002J\b\u0010\u0017\u001a\u00020\fH\u0002J\u0006\u0010\u0018\u001a\u00020\u0014J\b\u0010\u0019\u001a\u00020\tH\u0002J,\u0010\u001a\u001a\u00020\t2\u0006\u0010\u001b\u001a\u00020\t2\u0006\u0010\u001c\u001a\u00020\t2\u0014\b\u0002\u0010\u001d\u001a\u000e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\t0\u001eJ,\u0010\u001f\u001a\u00020\t2\u0006\u0010\u001b\u001a\u00020\t2\u0006\u0010\u001c\u001a\u00020\t2\u0014\b\u0002\u0010\u001d\u001a\u000e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\t0\u001eJ2\u0010 \u001a\b\u0012\u0004\u0012\u00020\"0!2\u0006\u0010\u001b\u001a\u00020\t2\u0006\u0010\u001c\u001a\u00020\t2\u0014\b\u0002\u0010\u001d\u001a\u000e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\t0\u001eJ\u001c\u0010#\u001a\b\u0012\u0004\u0012\u00020\t0!2\u0006\u0010\u001b\u001a\u00020\t2\u0006\u0010\u001c\u001a\u00020\tR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0013\u0010\b\u001a\u00070\t\u00a2\u0006\u0002\b\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0013\u0010\r\u001a\u00070\f\u00a2\u0006\u0002\b\u000eX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0010X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\u0012X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006$"}, d2={"Lpl/syntaxdevteam/punisher/common/MessageHandler;", "", "plugin", "Lpl/syntaxdevteam/punisher/PunisherX;", "pluginMetas", "Lio/papermc/paper/plugin/configuration/PluginMeta;", "<init>", "(Lpl/syntaxdevteam/punisher/PunisherX;Lio/papermc/paper/plugin/configuration/PluginMeta;)V", "language", "", "Lorg/jetbrains/annotations/Nullable;", "messages", "Lorg/bukkit/configuration/file/FileConfiguration;", "config", "Lorg/jetbrains/annotations/NotNull;", "debugMode", "", "logger", "Lpl/syntaxdevteam/punisher/common/Logger;", "initial", "", "copyDefaultMessages", "updateLanguageFile", "loadMessages", "reloadMessages", "getPrefix", "getMessage", "category", "key", "placeholders", "", "getLogMessage", "getComplexMessage", "", "Lnet/kyori/adventure/text/Component;", "getReasons", "PunisherX"})
@SourceDebugExtension(value={"SMAP\nMessageHandler.kt\nKotlin\n*S Kotlin\n*F\n+ 1 MessageHandler.kt\npl/syntaxdevteam/punisher/common/MessageHandler\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,142:1\n1797#2,3:143\n1797#2,3:146\n1557#2:149\n1628#2,2:150\n1797#2,3:152\n1630#2:155\n*S KotlinDebug\n*F\n+ 1 MessageHandler.kt\npl/syntaxdevteam/punisher/common/MessageHandler\n*L\n103#1:143,3\n114#1:146,3\n126#1:149\n126#1:150,2\n127#1:152,3\n126#1:155\n*E\n"})
public final class MessageHandler {
    @NotNull
    private final PunisherX plugin;
    @NotNull
    private final String language;
    @NotNull
    private FileConfiguration messages;
    @NotNull
    private FileConfiguration config;
    private boolean debugMode;
    @NotNull
    private final Logger logger;

    public MessageHandler(@NotNull PunisherX plugin, @NotNull PluginMeta pluginMetas) {
        Intrinsics.checkNotNullParameter((Object)plugin, "plugin");
        Intrinsics.checkNotNullParameter(pluginMetas, "pluginMetas");
        this.plugin = plugin;
        String string = this.plugin.getConfig().getString("language");
        if (string == null) {
            string = "EN";
        }
        this.language = string;
        FileConfiguration fileConfiguration = this.plugin.getConfig();
        Intrinsics.checkNotNullExpressionValue(fileConfiguration, "getConfig(...)");
        this.config = fileConfiguration;
        this.debugMode = this.config.getBoolean("debug");
        this.logger = new Logger(pluginMetas, this.debugMode);
        this.copyDefaultMessages();
        this.updateLanguageFile();
        this.messages = this.loadMessages();
    }

    public final void initial() {
        String string = this.language.toLowerCase(Locale.ROOT);
        Intrinsics.checkNotNullExpressionValue(string, "toLowerCase(...)");
        String author = switch (string) {
            case "pl" -> "WieszczY";
            case "en" -> "Syntaxerr";
            case "fr" -> "OpenAI Chat GPT-3.5";
            case "es" -> "OpenAI Chat GPT-3.5";
            case "de" -> "OpenAI Chat GPT-3.5";
            default -> this.plugin.getServerName();
        };
        this.logger.log("<gray>Loaded \"" + this.language + "\" language file by: <white><b>" + author + "</b></white>");
    }

    private final void copyDefaultMessages() {
        File file = this.plugin.getDataFolder();
        String string = this.language.toLowerCase(Locale.ROOT);
        Intrinsics.checkNotNullExpressionValue(string, "toLowerCase(...)");
        File messageFile = new File(file, "lang/messages_" + string + ".yml");
        if (!messageFile.exists()) {
            messageFile.getParentFile().mkdirs();
            String string2 = this.language.toLowerCase(Locale.ROOT);
            Intrinsics.checkNotNullExpressionValue(string2, "toLowerCase(...)");
            this.plugin.saveResource("lang/messages_" + string2 + ".yml", false);
        }
    }

    private final void updateLanguageFile() {
        File file = this.plugin.getDataFolder();
        String string = this.language.toLowerCase(Locale.ROOT);
        Intrinsics.checkNotNullExpressionValue(string, "toLowerCase(...)");
        File langFile = new File(file, "lang/messages_" + string + ".yml");
        String string2 = this.language.toLowerCase(Locale.ROOT);
        Intrinsics.checkNotNullExpressionValue(string2, "toLowerCase(...)");
        InputStream defaultLangStream = this.plugin.getResource("lang/messages_" + string2 + ".yml");
        if (defaultLangStream == null) {
            this.logger.err("Default language file for " + this.language + " not found in plugin resources!");
            return;
        }
        InputStream inputStream = defaultLangStream;
        Charset charset = Charsets.UTF_8;
        YamlConfiguration yamlConfiguration = YamlConfiguration.loadConfiguration((Reader)new InputStreamReader(inputStream, charset));
        Intrinsics.checkNotNullExpressionValue(yamlConfiguration, "loadConfiguration(...)");
        YamlConfiguration defaultConfig = yamlConfiguration;
        YamlConfiguration yamlConfiguration2 = YamlConfiguration.loadConfiguration((File)langFile);
        Intrinsics.checkNotNullExpressionValue(yamlConfiguration2, "loadConfiguration(...)");
        YamlConfiguration currentConfig = yamlConfiguration2;
        Ref.BooleanRef updated = new Ref.BooleanRef();
        MessageHandler.updateLanguageFile$synchronizeSections(updated, (ConfigurationSection)defaultConfig, (ConfigurationSection)currentConfig);
        if (updated.element) {
            String string3 = this.language.toLowerCase(Locale.ROOT);
            Intrinsics.checkNotNullExpressionValue(string3, "toLowerCase(...)");
            this.logger.success("Updating language file: messages_" + string3 + ".yml with missing entries.");
            currentConfig.save(langFile);
        }
    }

    private final FileConfiguration loadMessages() {
        File file = this.plugin.getDataFolder();
        String string = this.language.toLowerCase(Locale.ROOT);
        Intrinsics.checkNotNullExpressionValue(string, "toLowerCase(...)");
        File langFile = new File(file, "lang/messages_" + string + ".yml");
        YamlConfiguration yamlConfiguration = YamlConfiguration.loadConfiguration((File)langFile);
        Intrinsics.checkNotNullExpressionValue(yamlConfiguration, "loadConfiguration(...)");
        return (FileConfiguration)yamlConfiguration;
    }

    public final void reloadMessages() {
        this.messages = this.loadMessages();
    }

    private final String getPrefix() {
        String string = this.messages.getString("prefix");
        if (string == null) {
            string = "[PunisherX] ";
        }
        return string;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final String getMessage(@NotNull String category, @NotNull String key, @NotNull Map<String, String> placeholders) {
        Intrinsics.checkNotNullParameter(category, "category");
        Intrinsics.checkNotNullParameter(key, "key");
        Intrinsics.checkNotNullParameter(placeholders, "placeholders");
        String prefix = this.getPrefix();
        String string = this.messages.getString(category + "." + key);
        if (string == null) {
            MessageHandler $this$getMessage_u24lambda_u240 = this;
            boolean bl = false;
            $this$getMessage_u24lambda_u240.logger.err("There was an error loading the message " + key + " from category " + category);
            string = "Message not found. Check console...";
        }
        String message = string;
        Iterable $this$fold$iv = placeholders.entrySet();
        boolean $i$f$fold = false;
        String accumulator$iv = message;
        for (Object element$iv : $this$fold$iv) {
            void entry;
            Map.Entry entry2 = (Map.Entry)element$iv;
            String acc = accumulator$iv;
            boolean bl = false;
            accumulator$iv = StringsKt.replace$default(acc, "{" + entry.getKey() + "}", (String)entry.getValue(), false, 4, null);
        }
        String formattedMessage = accumulator$iv;
        return prefix + " " + formattedMessage;
    }

    public static /* synthetic */ String getMessage$default(MessageHandler messageHandler, String string, String string2, Map map, int n, Object object) {
        if ((n & 4) != 0) {
            map = MapsKt.emptyMap();
        }
        return messageHandler.getMessage(string, string2, map);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final String getLogMessage(@NotNull String category, @NotNull String key, @NotNull Map<String, String> placeholders) {
        Intrinsics.checkNotNullParameter(category, "category");
        Intrinsics.checkNotNullParameter(key, "key");
        Intrinsics.checkNotNullParameter(placeholders, "placeholders");
        String string = this.messages.getString(category + "." + key);
        if (string == null) {
            MessageHandler $this$getLogMessage_u24lambda_u242 = this;
            boolean bl = false;
            $this$getLogMessage_u24lambda_u242.logger.err("There was an error loading the message " + key + " from category " + category);
            string = "Message not found. Check console...";
        }
        String message = string;
        Iterable $this$fold$iv = placeholders.entrySet();
        boolean $i$f$fold = false;
        String accumulator$iv = message;
        for (Object element$iv : $this$fold$iv) {
            void entry;
            Map.Entry entry2 = (Map.Entry)element$iv;
            String acc = accumulator$iv;
            boolean bl = false;
            accumulator$iv = StringsKt.replace$default(acc, "{" + entry.getKey() + "}", (String)entry.getValue(), false, 4, null);
        }
        String formattedMessage = accumulator$iv;
        return formattedMessage;
    }

    public static /* synthetic */ String getLogMessage$default(MessageHandler messageHandler, String string, String string2, Map map, int n, Object object) {
        if ((n & 4) != 0) {
            map = MapsKt.emptyMap();
        }
        return messageHandler.getLogMessage(string, string2, map);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final List<Component> getComplexMessage(@NotNull String category, @NotNull String key, @NotNull Map<String, String> placeholders) {
        void $this$mapTo$iv$iv;
        Intrinsics.checkNotNullParameter(category, "category");
        Intrinsics.checkNotNullParameter(key, "key");
        Intrinsics.checkNotNullParameter(placeholders, "placeholders");
        List list = this.messages.getStringList(category + "." + key);
        Intrinsics.checkNotNullExpressionValue(list, "getStringList(...)");
        List messageList = list;
        if (messageList.isEmpty()) {
            this.logger.err("There was an error loading the message list " + key + " from category " + category);
            return CollectionsKt.listOf(Component.text((String)"Message list not found. Check console..."));
        }
        Iterable $this$map$iv = messageList;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void message;
            String string = (String)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            Iterable $this$fold$iv = placeholders.entrySet();
            boolean $i$f$fold = false;
            String accumulator$iv = message;
            for (Object element$iv : $this$fold$iv) {
                void entry;
                Map.Entry entry2 = (Map.Entry)element$iv;
                void acc = accumulator$iv;
                boolean bl2 = false;
                Intrinsics.checkNotNull(acc);
                accumulator$iv = StringsKt.replace$default((String)acc, "{" + entry.getKey() + "}", (String)entry.getValue(), false, 4, null);
            }
            void formattedMessage = accumulator$iv;
            Intrinsics.checkNotNull(formattedMessage);
            collection.add(StringsKt.contains$default((CharSequence)formattedMessage, "<", false, 2, null) ? MiniMessage.miniMessage().deserialize((Object)formattedMessage) : (Component)LegacyComponentSerializer.legacyAmpersand().deserialize((String)formattedMessage));
        }
        return (List)destination$iv$iv;
    }

    public static /* synthetic */ List getComplexMessage$default(MessageHandler messageHandler, String string, String string2, Map map, int n, Object object) {
        if ((n & 4) != 0) {
            map = MapsKt.emptyMap();
        }
        return messageHandler.getComplexMessage(string, string2, map);
    }

    @NotNull
    public final List<String> getReasons(@NotNull String category, @NotNull String key) {
        Intrinsics.checkNotNullParameter(category, "category");
        Intrinsics.checkNotNullParameter(key, "key");
        List list = this.messages.getStringList(category + "." + key);
        Intrinsics.checkNotNullExpressionValue(list, "getStringList(...)");
        return list;
    }

    private static final void updateLanguageFile$synchronizeSections(Ref.BooleanRef updated, ConfigurationSection defaultSection, ConfigurationSection currentSection) {
        for (String key : defaultSection.getKeys(false)) {
            if (!currentSection.contains(key)) {
                currentSection.set(key, defaultSection.get(key));
                updated.element = true;
                continue;
            }
            if (!defaultSection.isConfigurationSection(key)) continue;
            ConfigurationSection configurationSection = defaultSection.getConfigurationSection(key);
            Intrinsics.checkNotNull(configurationSection);
            ConfigurationSection configurationSection2 = currentSection.getConfigurationSection(key);
            Intrinsics.checkNotNull(configurationSection2);
            MessageHandler.updateLanguageFile$synchronizeSections(updated, configurationSection, configurationSection2);
        }
    }
}

