/*
 * Decompiled with CFR 0.152.
 */
package pl.syntaxdevteam.punisher.common;

import java.io.File;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.configuration.file.YamlConfiguration;
import org.jetbrains.annotations.NotNull;
import pl.syntaxdevteam.punisher.PunisherX;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0005\n\u0002\u0010\"\n\u0002\u0010\u000e\n\u0002\b\u0005\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\b\u0010\u000b\u001a\u00020\fH\u0002J\b\u0010\r\u001a\u00020\fH\u0002J(\u0010\u000e\u001a\u00020\f2\u0006\u0010\u000f\u001a\u00020\t2\u0006\u0010\u0010\u001a\u00020\t2\u000e\b\u0002\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00130\u0012H\u0002J\b\u0010\u0014\u001a\u00020\fH\u0002J\u0006\u0010\u0015\u001a\u00020\tJ\u0006\u0010\u0016\u001a\u00020\fJ\u0006\u0010\u0017\u001a\u00020\fR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0018"}, d2={"Lpl/syntaxdevteam/punisher/common/ConfigHandler;", "", "plugin", "Lpl/syntaxdevteam/punisher/PunisherX;", "<init>", "(Lpl/syntaxdevteam/punisher/PunisherX;)V", "configFile", "Ljava/io/File;", "config", "Lorg/bukkit/configuration/file/FileConfiguration;", "defaultConfig", "copyDefaultConfig", "", "synchronizeConfig", "synchronizeSections", "defaultSection", "currentSection", "exclusions", "", "", "saveConfig", "getConfig", "reloadConfig", "updateConfig", "PunisherX"})
@SourceDebugExtension(value={"SMAP\nConfigHandler.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ConfigHandler.kt\npl/syntaxdevteam/punisher/common/ConfigHandler\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,113:1\n827#2:114\n855#2,2:115\n1557#2:117\n1628#2,3:118\n*S KotlinDebug\n*F\n+ 1 ConfigHandler.kt\npl/syntaxdevteam/punisher/common/ConfigHandler\n*L\n64#1:114\n64#1:115,2\n66#1:117\n66#1:118,3\n*E\n"})
public final class ConfigHandler {
    @NotNull
    private final PunisherX plugin;
    @NotNull
    private final File configFile;
    @NotNull
    private FileConfiguration config;
    @NotNull
    private final FileConfiguration defaultConfig;

    public ConfigHandler(@NotNull PunisherX plugin) {
        Intrinsics.checkNotNullParameter((Object)plugin, "plugin");
        this.plugin = plugin;
        this.configFile = new File(this.plugin.getDataFolder(), "config.yml");
        YamlConfiguration yamlConfiguration = YamlConfiguration.loadConfiguration((File)this.configFile);
        Intrinsics.checkNotNullExpressionValue(yamlConfiguration, "loadConfiguration(...)");
        this.config = (FileConfiguration)yamlConfiguration;
        InputStream inputStream = this.plugin.getResource("config.yml");
        Intrinsics.checkNotNull(inputStream);
        YamlConfiguration yamlConfiguration2 = YamlConfiguration.loadConfiguration((Reader)new InputStreamReader(inputStream));
        Intrinsics.checkNotNullExpressionValue(yamlConfiguration2, "loadConfiguration(...)");
        this.defaultConfig = (FileConfiguration)yamlConfiguration2;
        this.copyDefaultConfig();
        this.synchronizeConfig();
    }

    private final void copyDefaultConfig() {
        if (!this.configFile.exists()) {
            this.plugin.saveResource("config.yml", false);
        }
    }

    private final void synchronizeConfig() {
        String[] stringArray = new String[]{"mute_cmd", "database"};
        Set<String> exclusions = SetsKt.setOf(stringArray);
        this.synchronizeSections(this.defaultConfig, this.config, exclusions);
        this.saveConfig();
    }

    /*
     * WARNING - void declaration
     */
    private final void synchronizeSections(FileConfiguration defaultSection, FileConfiguration currentSection, Set<String> exclusions) {
        for (String key : defaultSection.getKeys(true)) {
            if (exclusions.contains(key)) continue;
            Object defaultValue = defaultSection.get(key);
            if (defaultValue instanceof List) {
                void $this$mapTo$iv$iv;
                void $this$map$iv;
                Object it;
                void $this$filterNotTo$iv$iv;
                List currentList;
                Intrinsics.checkNotNullExpressionValue(currentSection.getStringList(key), "getStringList(...)");
                if (currentList.isEmpty()) {
                    currentSection.set(key, defaultValue);
                    continue;
                }
                Iterable $this$filterNot$iv = (Iterable)defaultValue;
                boolean $i$f$filterNot = false;
                Iterable iterable = $this$filterNot$iv;
                Collection destination$iv$iv = new ArrayList();
                boolean $i$f$filterNotTo = false;
                Iterator iterator2 = $this$filterNotTo$iv$iv.iterator();
                while (iterator2.hasNext()) {
                    Object element$iv$iv;
                    it = element$iv$iv = iterator2.next();
                    boolean bl = false;
                    if (CollectionsKt.contains(currentList, it)) continue;
                    destination$iv$iv.add(element$iv$iv);
                }
                List missingItems = (List)destination$iv$iv;
                if (!(!((Collection)missingItems).isEmpty())) continue;
                $this$filterNot$iv = missingItems;
                List list = currentList;
                boolean $i$f$map = false;
                $this$filterNotTo$iv$iv = $this$map$iv;
                destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
                boolean $i$f$mapTo = false;
                iterator2 = $this$mapTo$iv$iv.iterator();
                while (iterator2.hasNext()) {
                    Object item$iv$iv;
                    it = item$iv$iv = iterator2.next();
                    Collection collection = destination$iv$iv;
                    boolean bl = false;
                    collection.add(String.valueOf(it));
                }
                list.addAll((List)destination$iv$iv);
                currentSection.set(key, (Object)currentList);
                continue;
            }
            if (currentSection.contains(key)) continue;
            currentSection.set(key, defaultValue);
        }
    }

    static /* synthetic */ void synchronizeSections$default(ConfigHandler configHandler, FileConfiguration fileConfiguration, FileConfiguration fileConfiguration2, Set set, int n, Object object) {
        if ((n & 4) != 0) {
            set = SetsKt.emptySet();
        }
        configHandler.synchronizeSections(fileConfiguration, fileConfiguration2, set);
    }

    private final void saveConfig() {
        this.config.save(this.configFile);
    }

    @NotNull
    public final FileConfiguration getConfig() {
        return this.config;
    }

    public final void reloadConfig() {
        this.config = (FileConfiguration)YamlConfiguration.loadConfiguration((File)this.configFile);
        this.synchronizeConfig();
    }

    public final void updateConfig() {
        String[] stringArray = new String[]{"mute_cmd", "database"};
        Set<String> exclusions = SetsKt.setOf(stringArray);
        this.synchronizeSections(this.defaultConfig, this.config, exclusions);
        this.saveConfig();
    }
}

