/*
 * Decompiled with CFR 0.152.
 */
package pl.syntaxdevteam.punisher.commands;

import io.papermc.paper.command.brigadier.BasicCommand;
import io.papermc.paper.command.brigadier.CommandSourceStack;
import io.papermc.paper.plugin.configuration.PluginMeta;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.Regex;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.minimessage.MiniMessage;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.entity.Player;
import org.jetbrains.annotations.NotNull;
import pl.syntaxdevteam.punisher.PunisherX;
import pl.syntaxdevteam.punisher.common.Logger;
import pl.syntaxdevteam.punisher.common.MessageHandler;
import pl.syntaxdevteam.punisher.common.UUIDManager;
import pl.syntaxdevteam.punisher.databases.DatabaseHandler;
import pl.syntaxdevteam.punisher.databases.PunishmentData;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000Z\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J'\u0010\u0013\u001a\u00020\u00142\b\b\u0001\u0010\u0015\u001a\u00020\u00162\u000e\b\u0001\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00190\u0018H\u0016\u00a2\u0006\u0002\u0010\u001aJ-\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\u00190\u001c2\b\b\u0001\u0010\u0015\u001a\u00020\u00162\u000e\b\u0001\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00190\u0018H\u0016\u00a2\u0006\u0002\u0010\u001dR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0013\u0010\b\u001a\u00070\t\u00a2\u0006\u0002\b\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\u0012X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001e"}, d2={"Lpl/syntaxdevteam/punisher/commands/UnBanCommand;", "Lio/papermc/paper/command/brigadier/BasicCommand;", "plugin", "Lpl/syntaxdevteam/punisher/PunisherX;", "pluginMetas", "Lio/papermc/paper/plugin/configuration/PluginMeta;", "<init>", "(Lpl/syntaxdevteam/punisher/PunisherX;Lio/papermc/paper/plugin/configuration/PluginMeta;)V", "config", "Lorg/bukkit/configuration/file/FileConfiguration;", "Lorg/jetbrains/annotations/NotNull;", "debugMode", "", "logger", "Lpl/syntaxdevteam/punisher/common/Logger;", "uuidManager", "Lpl/syntaxdevteam/punisher/common/UUIDManager;", "messageHandler", "Lpl/syntaxdevteam/punisher/common/MessageHandler;", "execute", "", "stack", "Lio/papermc/paper/command/brigadier/CommandSourceStack;", "args", "", "", "(Lio/papermc/paper/command/brigadier/CommandSourceStack;[Ljava/lang/String;)V", "suggest", "", "(Lio/papermc/paper/command/brigadier/CommandSourceStack;[Ljava/lang/String;)Ljava/util/List;", "PunisherX"})
@SourceDebugExtension(value={"SMAP\nUnBanComman.kt\nKotlin\n*S Kotlin\n*F\n+ 1 UnBanComman.kt\npl/syntaxdevteam/punisher/commands/UnBanCommand\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,95:1\n1863#2,2:96\n1863#2,2:98\n1863#2,2:100\n1863#2,2:102\n1557#2:104\n1628#2,3:105\n*S KotlinDebug\n*F\n+ 1 UnBanComman.kt\npl/syntaxdevteam/punisher/commands/UnBanCommand\n*L\n29#1:96,2\n44#1:98,2\n58#1:100,2\n74#1:102,2\n90#1:104\n90#1:105,3\n*E\n"})
public final class UnBanCommand
implements BasicCommand {
    @NotNull
    private final PunisherX plugin;
    @NotNull
    private FileConfiguration config;
    private boolean debugMode;
    @NotNull
    private final Logger logger;
    @NotNull
    private final UUIDManager uuidManager;
    @NotNull
    private final MessageHandler messageHandler;

    public UnBanCommand(@NotNull PunisherX plugin, @NotNull PluginMeta pluginMetas) {
        Intrinsics.checkNotNullParameter((Object)plugin, "plugin");
        Intrinsics.checkNotNullParameter(pluginMetas, "pluginMetas");
        this.plugin = plugin;
        FileConfiguration fileConfiguration = this.plugin.getConfig();
        Intrinsics.checkNotNullExpressionValue(fileConfiguration, "getConfig(...)");
        this.config = fileConfiguration;
        this.debugMode = this.config.getBoolean("debug");
        this.logger = new Logger(pluginMetas, this.debugMode);
        this.uuidManager = new UUIDManager(this.plugin);
        this.messageHandler = new MessageHandler(this.plugin, pluginMetas);
    }

    public void execute(@NotNull CommandSourceStack stack, @NotNull String[] args) {
        Intrinsics.checkNotNullParameter(stack, "stack");
        Intrinsics.checkNotNullParameter(args, "args");
        if (!(args.length == 0)) {
            if (stack.getSender().hasPermission("punisherx.unban")) {
                String playerOrIpOrUUID = args[0];
                Component component = MiniMessage.miniMessage().deserialize((Object)this.messageHandler.getMessage("unban", "unban", MapsKt.mapOf(TuplesKt.to("player", playerOrIpOrUUID))));
                Intrinsics.checkNotNullExpressionValue(component, "deserialize(...)");
                Component broadcastMessage = component;
                CharSequence charSequence = playerOrIpOrUUID;
                if (new Regex("\\d+\\.\\d+\\.\\d+\\.\\d+").matches(charSequence)) {
                    List<PunishmentData> punishments = this.plugin.getDatabaseHandler().getPunishmentsByIP(playerOrIpOrUUID);
                    if (!((Collection)punishments).isEmpty()) {
                        Iterable $this$forEach$iv = punishments;
                        boolean $i$f$forEach = false;
                        for (Object element$iv : $this$forEach$iv) {
                            PunishmentData punishment = (PunishmentData)element$iv;
                            boolean bl = false;
                            if (!Intrinsics.areEqual(punishment.getType(), "BANIP")) continue;
                            DatabaseHandler.removePunishment$default(this.plugin.getDatabaseHandler(), playerOrIpOrUUID, punishment.getType(), false, 4, null);
                        }
                        stack.getSender().sendRichMessage(this.messageHandler.getMessage("unban", "unban", MapsKt.mapOf(TuplesKt.to("player", playerOrIpOrUUID))));
                        this.logger.info("IP " + playerOrIpOrUUID + " has been unbanned");
                    } else {
                        stack.getSender().sendRichMessage(this.messageHandler.getMessage("error", "player_not_found", MapsKt.mapOf(TuplesKt.to("player", playerOrIpOrUUID))));
                    }
                } else {
                    String string = this.uuidManager.getUUID(playerOrIpOrUUID).toString();
                    Intrinsics.checkNotNullExpressionValue(string, "toString(...)");
                    String uuid = string;
                    this.logger.debug("UUID for player " + playerOrIpOrUUID + ": [" + uuid + "]");
                    List<PunishmentData> punishments = this.plugin.getDatabaseHandler().getPunishments(uuid);
                    if (!((Collection)punishments).isEmpty()) {
                        Iterable $this$forEach$iv = punishments;
                        boolean $i$f$forEach = false;
                        for (Object element$iv : $this$forEach$iv) {
                            PunishmentData punishment = (PunishmentData)element$iv;
                            boolean bl = false;
                            if (!Intrinsics.areEqual(punishment.getType(), "BAN")) continue;
                            DatabaseHandler.removePunishment$default(this.plugin.getDatabaseHandler(), uuid, punishment.getType(), false, 4, null);
                            this.logger.info("Player " + playerOrIpOrUUID + " (" + uuid + ") has been unbanned");
                        }
                        stack.getSender().sendRichMessage(this.messageHandler.getMessage("unban", "unban", MapsKt.mapOf(TuplesKt.to("player", playerOrIpOrUUID))));
                    } else {
                        String ip = this.plugin.getPlayerIPManager().getPlayerIPByName(playerOrIpOrUUID);
                        this.logger.debug("Assigned IP for player " + playerOrIpOrUUID + ": [" + ip + "]");
                        if (ip != null) {
                            List<PunishmentData> punishmentsByIP = this.plugin.getDatabaseHandler().getPunishmentsByIP(ip);
                            if (!((Collection)punishmentsByIP).isEmpty()) {
                                Iterable $this$forEach$iv = punishmentsByIP;
                                boolean $i$f$forEach = false;
                                for (Object element$iv : $this$forEach$iv) {
                                    PunishmentData punishment = (PunishmentData)element$iv;
                                    boolean bl = false;
                                    if (!Intrinsics.areEqual(punishment.getType(), "BANIP")) continue;
                                    DatabaseHandler.removePunishment$default(this.plugin.getDatabaseHandler(), ip, punishment.getType(), false, 4, null);
                                    this.logger.info("Player " + playerOrIpOrUUID + " (" + uuid + ") has been unbanned");
                                }
                                stack.getSender().sendRichMessage(this.messageHandler.getMessage("unban", "unban", MapsKt.mapOf(TuplesKt.to("player", playerOrIpOrUUID))));
                            } else {
                                stack.getSender().sendRichMessage(this.messageHandler.getMessage("error", "player_not_found", MapsKt.mapOf(TuplesKt.to("player", playerOrIpOrUUID))));
                            }
                        } else {
                            stack.getSender().sendRichMessage(this.messageHandler.getMessage("error", "player_not_found", MapsKt.mapOf(TuplesKt.to("player", playerOrIpOrUUID))));
                        }
                    }
                    String permission = "punisherx.see.unban";
                    Collection collection = this.plugin.getServer().getOnlinePlayers();
                    Intrinsics.checkNotNullExpressionValue(collection, "getOnlinePlayers(...)");
                    Iterable $this$forEach$iv = collection;
                    boolean $i$f$forEach = false;
                    for (Object element$iv : $this$forEach$iv) {
                        Player onlinePlayer = (Player)element$iv;
                        boolean bl = false;
                        if (!onlinePlayer.hasPermission(permission)) continue;
                        onlinePlayer.sendMessage(broadcastMessage);
                    }
                }
            } else {
                stack.getSender().sendRichMessage(MessageHandler.getMessage$default(this.messageHandler, "error", "no_permission", null, 4, null));
            }
        } else {
            stack.getSender().sendRichMessage(MessageHandler.getMessage$default(this.messageHandler, "ban", "usage_unban", null, 4, null));
        }
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public List<String> suggest(@NotNull CommandSourceStack stack, @NotNull String[] args) {
        List list;
        Intrinsics.checkNotNullParameter(stack, "stack");
        Intrinsics.checkNotNullParameter(args, "args");
        if (args.length == 1) {
            void $this$mapTo$iv$iv;
            Collection collection = this.plugin.getServer().getOnlinePlayers();
            Intrinsics.checkNotNullExpressionValue(collection, "getOnlinePlayers(...)");
            Iterable $this$map$iv = collection;
            boolean $i$f$map = false;
            Iterable iterable = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                Player player = (Player)item$iv$iv;
                Collection collection2 = destination$iv$iv;
                boolean bl = false;
                collection2.add(it.getName());
            }
            list = (List)destination$iv$iv;
        } else {
            list = CollectionsKt.emptyList();
        }
        return list;
    }
}

