/*
 * Decompiled with CFR 0.152.
 */
package pl.syntaxdevteam.punisher.commands;

import io.papermc.paper.command.brigadier.BasicCommand;
import io.papermc.paper.command.brigadier.CommandSourceStack;
import io.papermc.paper.plugin.configuration.PluginMeta;
import io.papermc.paper.plugin.lifecycle.event.LifecycleEventOwner;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.bukkit.plugin.PluginDescriptionFile;
import org.jetbrains.annotations.NotNull;
import pl.syntaxdevteam.punisher.PunisherX;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J'\u0010\u0006\u001a\u00020\u00072\b\b\u0001\u0010\b\u001a\u00020\t2\u000e\b\u0001\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000bH\u0016\u00a2\u0006\u0002\u0010\rJ-\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\f0\u000f2\b\b\u0001\u0010\b\u001a\u00020\t2\u000e\b\u0001\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000bH\u0016\u00a2\u0006\u0002\u0010\u0010R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0011"}, d2={"Lpl/syntaxdevteam/punisher/commands/PunishesXCommands;", "Lio/papermc/paper/command/brigadier/BasicCommand;", "plugin", "Lpl/syntaxdevteam/punisher/PunisherX;", "<init>", "(Lpl/syntaxdevteam/punisher/PunisherX;)V", "execute", "", "stack", "Lio/papermc/paper/command/brigadier/CommandSourceStack;", "args", "", "", "(Lio/papermc/paper/command/brigadier/CommandSourceStack;[Ljava/lang/String;)V", "suggest", "", "(Lio/papermc/paper/command/brigadier/CommandSourceStack;[Ljava/lang/String;)Ljava/util/List;", "PunisherX"})
public final class PunishesXCommands
implements BasicCommand {
    @NotNull
    private final PunisherX plugin;

    public PunishesXCommands(@NotNull PunisherX plugin) {
        Intrinsics.checkNotNullParameter((Object)plugin, "plugin");
        this.plugin = plugin;
    }

    public void execute(@NotNull CommandSourceStack stack, @NotNull String[] args) {
        Intrinsics.checkNotNullParameter(stack, "stack");
        Intrinsics.checkNotNullParameter(args, "args");
        PunisherX punisherX = this.plugin;
        Intrinsics.checkNotNull((Object)punisherX, "null cannot be cast to non-null type io.papermc.paper.plugin.lifecycle.event.LifecycleEventOwner");
        PluginMeta pluginMeta = ((LifecycleEventOwner)punisherX).getPluginMeta();
        Intrinsics.checkNotNullExpressionValue(pluginMeta, "getPluginMeta(...)");
        PluginMeta pluginMeta2 = pluginMeta;
        PluginDescriptionFile pluginDescriptionFile = this.plugin.getDescription();
        Intrinsics.checkNotNullExpressionValue(pluginDescriptionFile, "getDescription(...)");
        PluginDescriptionFile pdf = pluginDescriptionFile;
        if (!(args.length == 0)) {
            if (StringsKt.equals(args[0], "help", true)) {
                if (stack.getSender().hasPermission("punisherx.help")) {
                    stack.getSender().sendRichMessage("\n<gray>-------------------------------------------------\n|\n|  <gold>Available commands for " + pluginMeta2.getName() + ":\n <gray>|\n <gray>|  <gold>/punisherx help <gray>- <white>Displays this prompt. \n <gray>|  <gold>/punisherx version <gray>- <white>Shows plugin info. \n <gray>|  <gold>/punisherx reload <gray>- <white>Reloads the configuration file\n <gray>|  <gold>/warn <player> (time) <reason> <gray>- <white>Warns a player\n <gray>|  <gold>/unwarn <player> <gray>- <white>Removes a player's warning\n <gray>|  <gold>/mute <player> (time) <reason> <gray>- <white>Mutes a player\n <gray>|  <gold>/unmute <player> <gray>- <white>Unmutes a player\n <gray>|  <gold>/ban <player> (time) <reason> <gray>- <white>Bans a player \n <gray>|  <gold>/banip <player/ip> (time) <reason> <gray>- <white>Bans a player's IP\n <gray>|  <gold>/unban <player/ip> <gray>- <white>Unbans a player\n <gray>|  <gold>/check <player> <all/warn/mute/ban>\n <gray>|      - <white>Checks and displays the punishments of a given player\n <gray>|  <gold>/clearall <player> - Clears all active penalties\n <gray>|\n <gray>|\n-------------------------------------------------");
                } else {
                    stack.getSender().sendRichMessage("<red>You do not have permission to use this command.</red>");
                }
            } else if (StringsKt.equals(args[0], "version", true)) {
                if (stack.getSender().hasPermission("punisherx.version")) {
                    stack.getSender().sendRichMessage("\n<gray>-------------------------------------------------\n <gray>|\n <gray>|   <gold>\u2192 <bold>" + pluginMeta2.getName() + "</bold> \u2190\n <gray>|   <white>Author: <bold><gold>" + pdf.getAuthors() + "</gold></bold>\n <gray>|   <white>Website: <bold><gold><click:open_url:'" + pdf.getWebsite() + "'>" + pdf.getWebsite() + "</click></gold></bold>\n <gray>|   <white>Version: <bold><gold>" + pluginMeta2.getVersion() + "</gold></bold>\n <gray>|\n-------------------------------------------------");
                } else {
                    stack.getSender().sendRichMessage("<red>You do not have permission to use this command.</red>");
                }
            } else if (StringsKt.equals(args[0], "reload", true)) {
                if (stack.getSender().hasPermission("punisherx.reload")) {
                    this.plugin.reloadMyConfig();
                    stack.getSender().sendRichMessage("<green>The configuration file has been reloaded.</green>");
                } else {
                    stack.getSender().sendRichMessage("<red>You do not have permission to use this command.</red>");
                }
            } else if (StringsKt.equals(args[0], "export", true)) {
                if (stack.getSender().hasPermission("punisherx.export")) {
                    this.plugin.getDatabaseHandler().exportDatabase();
                } else {
                    stack.getSender().sendRichMessage("<red>You do not have permission to use this command.</red>");
                }
            } else if (StringsKt.equals(args[0], "import", true)) {
                if (stack.getSender().hasPermission("punisherx.import")) {
                    this.plugin.getDatabaseHandler().importDatabase();
                } else {
                    stack.getSender().sendRichMessage("<red>You do not have permission to use this command.</red>");
                }
            }
        } else {
            stack.getSender().sendRichMessage("<green>Type </green><gold>/punisherx help</gold> <green>to see available commands</green>");
        }
    }

    @NotNull
    public List<String> suggest(@NotNull CommandSourceStack stack, @NotNull String[] args) {
        List<String> list;
        Intrinsics.checkNotNullParameter(stack, "stack");
        Intrinsics.checkNotNullParameter(args, "args");
        if (args.length == 1) {
            String[] stringArray = new String[]{"help", "version", "reload", "export", "import"};
            list = CollectionsKt.listOf(stringArray);
        } else {
            list = CollectionsKt.emptyList();
        }
        return list;
    }
}

