/*
 * Decompiled with CFR 0.152.
 */
package pl.syntaxdevteam.punisher.commands;

import io.papermc.paper.command.brigadier.BasicCommand;
import io.papermc.paper.command.brigadier.CommandSourceStack;
import io.papermc.paper.plugin.configuration.PluginMeta;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.minimessage.MiniMessage;
import org.bukkit.Bukkit;
import org.bukkit.entity.Player;
import org.jetbrains.annotations.NotNull;
import pl.syntaxdevteam.punisher.PunisherX;
import pl.syntaxdevteam.punisher.basic.TimeHandler;
import pl.syntaxdevteam.punisher.common.MessageHandler;
import pl.syntaxdevteam.punisher.common.UUIDManager;
import pl.syntaxdevteam.punisher.databases.DatabaseHandler;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\b\u0003\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J'\u0010\u000e\u001a\u00020\u000f2\b\b\u0001\u0010\u0010\u001a\u00020\u00112\u000e\b\u0001\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00140\u0013H\u0016\u00a2\u0006\u0002\u0010\u0015J-\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00140\u00172\b\b\u0001\u0010\u0010\u001a\u00020\u00112\u000e\b\u0001\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00140\u0013H\u0016\u00a2\u0006\u0002\u0010\u0018J\u000e\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u00140\u0017H\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001a"}, d2={"Lpl/syntaxdevteam/punisher/commands/MuteCommand;", "Lio/papermc/paper/command/brigadier/BasicCommand;", "plugin", "Lpl/syntaxdevteam/punisher/PunisherX;", "pluginMetas", "Lio/papermc/paper/plugin/configuration/PluginMeta;", "<init>", "(Lpl/syntaxdevteam/punisher/PunisherX;Lio/papermc/paper/plugin/configuration/PluginMeta;)V", "uuidManager", "Lpl/syntaxdevteam/punisher/common/UUIDManager;", "messageHandler", "Lpl/syntaxdevteam/punisher/common/MessageHandler;", "timeHandler", "Lpl/syntaxdevteam/punisher/basic/TimeHandler;", "execute", "", "stack", "Lio/papermc/paper/command/brigadier/CommandSourceStack;", "args", "", "", "(Lio/papermc/paper/command/brigadier/CommandSourceStack;[Ljava/lang/String;)V", "suggest", "", "(Lio/papermc/paper/command/brigadier/CommandSourceStack;[Ljava/lang/String;)Ljava/util/List;", "generateTimeSuggestions", "PunisherX"})
@SourceDebugExtension(value={"SMAP\nMuteCommand.kt\nKotlin\n*S Kotlin\n*F\n+ 1 MuteCommand.kt\npl/syntaxdevteam/punisher/commands/MuteCommand\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,93:1\n1863#2,2:94\n1557#2:96\n1628#2,3:97\n*S KotlinDebug\n*F\n+ 1 MuteCommand.kt\npl/syntaxdevteam/punisher/commands/MuteCommand\n*L\n59#1:94,2\n75#1:96\n75#1:97,3\n*E\n"})
public final class MuteCommand
implements BasicCommand {
    @NotNull
    private final PunisherX plugin;
    @NotNull
    private final UUIDManager uuidManager;
    @NotNull
    private final MessageHandler messageHandler;
    @NotNull
    private final TimeHandler timeHandler;

    public MuteCommand(@NotNull PunisherX plugin, @NotNull PluginMeta pluginMetas) {
        Intrinsics.checkNotNullParameter((Object)plugin, "plugin");
        Intrinsics.checkNotNullParameter(pluginMetas, "pluginMetas");
        this.plugin = plugin;
        this.uuidManager = new UUIDManager(this.plugin);
        this.messageHandler = new MessageHandler(this.plugin, pluginMetas);
        this.timeHandler = new TimeHandler(this.plugin, pluginMetas);
    }

    public void execute(@NotNull CommandSourceStack stack, @NotNull String[] args) {
        Intrinsics.checkNotNullParameter(stack, "stack");
        Intrinsics.checkNotNullParameter(args, "args");
        if (!(args.length == 0)) {
            if (stack.getSender().hasPermission("punisherx.mute")) {
                if (args.length < 2) {
                    stack.getSender().sendRichMessage(MessageHandler.getMessage$default(this.messageHandler, "mute", "usage", null, 4, null));
                } else {
                    String player = args[0];
                    Player targetPlayer = Bukkit.getPlayer((String)player);
                    if (targetPlayer != null && targetPlayer.hasPermission("punisherx.bypass.mute")) {
                        stack.getSender().sendRichMessage(this.messageHandler.getMessage("error", "bypass", MapsKt.mapOf(TuplesKt.to("player", player))));
                        return;
                    }
                    String string = this.uuidManager.getUUID(player).toString();
                    Intrinsics.checkNotNullExpressionValue(string, "toString(...)");
                    String uuid = string;
                    String gtime = null;
                    String reason = null;
                    try {
                        gtime = args[1];
                        this.timeHandler.parseTime(gtime);
                        reason = CollectionsKt.joinToString$default(ArraysKt.slice(args, RangesKt.until(2, args.length)), " ", null, null, 0, null, null, 62, null);
                    }
                    catch (NumberFormatException e) {
                        gtime = null;
                        reason = CollectionsKt.joinToString$default(ArraysKt.slice(args, RangesKt.until(1, args.length)), " ", null, null, 0, null, null, 62, null);
                    }
                    String punishmentType = "MUTE";
                    long start = System.currentTimeMillis();
                    Long end = gtime != null ? Long.valueOf(System.currentTimeMillis() + this.timeHandler.parseTime(gtime) * (long)1000) : null;
                    DatabaseHandler databaseHandler = this.plugin.getDatabaseHandler();
                    String string2 = stack.getSender().getName();
                    Intrinsics.checkNotNullExpressionValue(string2, "getName(...)");
                    Long l = end;
                    databaseHandler.addPunishment(player, uuid, reason, string2, punishmentType, start, l != null ? l : -1L);
                    DatabaseHandler databaseHandler2 = this.plugin.getDatabaseHandler();
                    String string3 = stack.getSender().getName();
                    Intrinsics.checkNotNullExpressionValue(string3, "getName(...)");
                    Long l2 = end;
                    databaseHandler2.addPunishmentHistory(player, uuid, reason, string3, punishmentType, start, l2 != null ? l2 : -1L);
                    Pair[] pairArray = new Pair[]{TuplesKt.to("player", player), TuplesKt.to("reason", reason), TuplesKt.to("time", this.timeHandler.formatTime(gtime))};
                    stack.getSender().sendRichMessage(this.messageHandler.getMessage("mute", "mute", MapsKt.mapOf(pairArray)));
                    Pair[] pairArray2 = new Pair[]{TuplesKt.to("reason", reason), TuplesKt.to("time", this.timeHandler.formatTime(gtime))};
                    String muteMessage = this.messageHandler.getMessage("mute", "mute_message", MapsKt.mapOf(pairArray2));
                    Component component = MiniMessage.miniMessage().deserialize((Object)muteMessage);
                    Intrinsics.checkNotNullExpressionValue(component, "deserialize(...)");
                    Component formattedMessage = component;
                    Player player2 = targetPlayer;
                    if (player2 != null) {
                        player2.sendMessage(formattedMessage);
                    }
                    String permission = "punisherx.see.mute";
                    Pair[] pairArray3 = new Pair[]{TuplesKt.to("player", player), TuplesKt.to("reason", reason), TuplesKt.to("time", this.timeHandler.formatTime(gtime))};
                    Component component2 = MiniMessage.miniMessage().deserialize((Object)this.messageHandler.getMessage("mute", "broadcast", MapsKt.mapOf(pairArray3)));
                    Intrinsics.checkNotNullExpressionValue(component2, "deserialize(...)");
                    Component broadcastMessage = component2;
                    Collection collection = this.plugin.getServer().getOnlinePlayers();
                    Intrinsics.checkNotNullExpressionValue(collection, "getOnlinePlayers(...)");
                    Iterable $this$forEach$iv = collection;
                    boolean $i$f$forEach = false;
                    for (Object element$iv : $this$forEach$iv) {
                        Player onlinePlayer = (Player)element$iv;
                        boolean bl = false;
                        if (!onlinePlayer.hasPermission(permission)) continue;
                        onlinePlayer.sendMessage(broadcastMessage);
                    }
                }
            } else {
                stack.getSender().sendRichMessage(MessageHandler.getMessage$default(this.messageHandler, "error", "no_permission", null, 4, null));
            }
        } else {
            stack.getSender().sendRichMessage(MessageHandler.getMessage$default(this.messageHandler, "mute", "usage", null, 4, null));
        }
    }

    @NotNull
    public List<String> suggest(@NotNull CommandSourceStack stack, @NotNull String[] args) {
        Intrinsics.checkNotNullParameter(stack, "stack");
        Intrinsics.checkNotNullParameter(args, "args");
        return switch (args.length) {
            case 1 -> {
                void $this$mapTo$iv$iv;
                Collection v0 = this.plugin.getServer().getOnlinePlayers();
                Intrinsics.checkNotNullExpressionValue(v0, "getOnlinePlayers(...)");
                Iterable $this$map$iv = v0;
                boolean $i$f$map = false;
                Iterable var5_5 = $this$map$iv;
                Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
                boolean $i$f$mapTo = false;
                for (Object item$iv$iv : $this$mapTo$iv$iv) {
                    void it;
                    Player var10_10 = (Player)item$iv$iv;
                    Collection var12_12 = destination$iv$iv;
                    boolean $i$a$-map-MuteCommand$suggest$1 = false;
                    var12_12.add(it.getName());
                }
                yield (List)destination$iv$iv;
            }
            case 2 -> this.generateTimeSuggestions();
            case 3 -> this.messageHandler.getReasons("mute", "reasons");
            default -> CollectionsKt.emptyList();
        };
    }

    private final List<String> generateTimeSuggestions() {
        String[] stringArray = new String[]{"s", "m", "h", "d"};
        List<String> units = CollectionsKt.listOf(stringArray);
        List suggestions = new ArrayList();
        for (int i = 1; i < 1000; ++i) {
            for (String unit : units) {
                suggestions.add(i + unit);
            }
        }
        return suggestions;
    }
}

