/*
 * Decompiled with CFR 0.152.
 */
package pl.syntaxdevteam.punisher.commands;

import io.papermc.paper.command.brigadier.BasicCommand;
import io.papermc.paper.command.brigadier.CommandSourceStack;
import io.papermc.paper.plugin.configuration.PluginMeta;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.UUID;
import kotlin.Metadata;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.minimessage.MiniMessage;
import org.bukkit.Bukkit;
import org.bukkit.entity.Player;
import org.jetbrains.annotations.NotNull;
import pl.syntaxdevteam.punisher.PunisherX;
import pl.syntaxdevteam.punisher.common.MessageHandler;
import pl.syntaxdevteam.punisher.common.UUIDManager;
import pl.syntaxdevteam.punisher.databases.DatabaseHandler;
import pl.syntaxdevteam.punisher.databases.PunishmentData;
import pl.syntaxdevteam.punisher.players.PlayerIPManager;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000P\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\b\u0010\tJ'\u0010\u0010\u001a\u00020\u00112\b\b\u0001\u0010\u0012\u001a\u00020\u00132\u000e\b\u0001\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00160\u0015H\u0016\u00a2\u0006\u0002\u0010\u0017J-\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u00160\u00192\b\b\u0001\u0010\u0012\u001a\u00020\u00132\u000e\b\u0001\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00160\u0015H\u0016\u00a2\u0006\u0002\u0010\u001aR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001b"}, d2={"Lpl/syntaxdevteam/punisher/commands/HistoryCommand;", "Lio/papermc/paper/command/brigadier/BasicCommand;", "plugin", "Lpl/syntaxdevteam/punisher/PunisherX;", "pluginMetas", "Lio/papermc/paper/plugin/configuration/PluginMeta;", "playerIPManager", "Lpl/syntaxdevteam/punisher/players/PlayerIPManager;", "<init>", "(Lpl/syntaxdevteam/punisher/PunisherX;Lio/papermc/paper/plugin/configuration/PluginMeta;Lpl/syntaxdevteam/punisher/players/PlayerIPManager;)V", "uuidManager", "Lpl/syntaxdevteam/punisher/common/UUIDManager;", "messageHandler", "Lpl/syntaxdevteam/punisher/common/MessageHandler;", "dateFormat", "Ljava/text/SimpleDateFormat;", "execute", "", "stack", "Lio/papermc/paper/command/brigadier/CommandSourceStack;", "args", "", "", "(Lio/papermc/paper/command/brigadier/CommandSourceStack;[Ljava/lang/String;)V", "suggest", "", "(Lio/papermc/paper/command/brigadier/CommandSourceStack;[Ljava/lang/String;)Ljava/util/List;", "PunisherX"})
@SourceDebugExtension(value={"SMAP\nHistoryCommand.kt\nKotlin\n*S Kotlin\n*F\n+ 1 HistoryCommand.kt\npl/syntaxdevteam/punisher/commands/HistoryCommand\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,105:1\n1863#2,2:106\n1557#2:108\n1628#2,3:109\n*S KotlinDebug\n*F\n+ 1 HistoryCommand.kt\npl/syntaxdevteam/punisher/commands/HistoryCommand\n*L\n78#1:106,2\n100#1:108\n100#1:109,3\n*E\n"})
public final class HistoryCommand
implements BasicCommand {
    @NotNull
    private final PunisherX plugin;
    @NotNull
    private final PlayerIPManager playerIPManager;
    @NotNull
    private final UUIDManager uuidManager;
    @NotNull
    private final MessageHandler messageHandler;
    @NotNull
    private final SimpleDateFormat dateFormat;

    public HistoryCommand(@NotNull PunisherX plugin, @NotNull PluginMeta pluginMetas, @NotNull PlayerIPManager playerIPManager) {
        Intrinsics.checkNotNullParameter((Object)plugin, "plugin");
        Intrinsics.checkNotNullParameter(pluginMetas, "pluginMetas");
        Intrinsics.checkNotNullParameter(playerIPManager, "playerIPManager");
        this.plugin = plugin;
        this.playerIPManager = playerIPManager;
        this.uuidManager = new UUIDManager(this.plugin);
        this.messageHandler = new MessageHandler(this.plugin, pluginMetas);
        this.dateFormat = new SimpleDateFormat("yy-MM-dd HH:mm:ss");
    }

    public void execute(@NotNull CommandSourceStack stack, @NotNull String[] args) {
        block11: {
            block8: {
                block9: {
                    Object object;
                    String playerIP;
                    String title;
                    String times;
                    String reasons;
                    String types;
                    String id;
                    List<PunishmentData> punishments;
                    String targetPlayer;
                    UUID uuid;
                    int page;
                    String player;
                    block13: {
                        block12: {
                            block10: {
                                String string;
                                int n;
                                Intrinsics.checkNotNullParameter(stack, "stack");
                                Intrinsics.checkNotNullParameter(args, "args");
                                if (!(!(args.length == 0))) break block8;
                                player = args[0];
                                if (args.length > 1) {
                                    Integer n2 = StringsKt.toIntOrNull(args[1]);
                                    n = n2 != null ? n2 : 1;
                                } else {
                                    n = 1;
                                }
                                page = n;
                                String string2 = stack.getSender().getName();
                                Intrinsics.checkNotNullExpressionValue(string2, "getName(...)");
                                String senderName = string2;
                                int limit = 10;
                                int offset = (page - 1) * limit;
                                if (!StringsKt.equals(player, senderName, true) && !stack.getSender().hasPermission("punisherx.history")) break block9;
                                uuid = this.uuidManager.getUUID(player);
                                Player player2 = Bukkit.getPlayer((String)player);
                                if ((player2 != null ? player2.getName() : null) == null) {
                                    string = Bukkit.getOfflinePlayer((UUID)uuid).getName();
                                } else {
                                    Player player3 = Bukkit.getPlayer((String)player);
                                    string = player3 != null ? player3.getName() : null;
                                }
                                targetPlayer = string;
                                DatabaseHandler databaseHandler = this.plugin.getDatabaseHandler();
                                String string3 = uuid.toString();
                                Intrinsics.checkNotNullExpressionValue(string3, "toString(...)");
                                punishments = databaseHandler.getPunishmentHistory(string3, limit, offset);
                                if (!punishments.isEmpty()) break block10;
                                stack.getSender().sendRichMessage(this.messageHandler.getMessage("history", "no_punishments", MapsKt.mapOf(TuplesKt.to("player", player))));
                                break block11;
                            }
                            id = MessageHandler.getLogMessage$default(this.messageHandler, "history", "id", null, 4, null);
                            types = MessageHandler.getLogMessage$default(this.messageHandler, "history", "type", null, 4, null);
                            reasons = MessageHandler.getLogMessage$default(this.messageHandler, "history", "reason", null, 4, null);
                            times = MessageHandler.getLogMessage$default(this.messageHandler, "history", "time", null, 4, null);
                            title = MessageHandler.getLogMessage$default(this.messageHandler, "history", "title", null, 4, null);
                            playerIP = this.playerIPManager.getPlayerIPByName(player);
                            this.plugin.getLogger().debug("Player IP: " + playerIP);
                            object = playerIP;
                            if (object == null) break block12;
                            String ip = object;
                            boolean bl = false;
                            String country = this.playerIPManager.getGeoIPHandler().getCountry(ip);
                            String city = this.playerIPManager.getGeoIPHandler().getCity(ip);
                            this.plugin.getLogger().debug("Country: " + country + ", City: " + city);
                            String string = city + ", " + country;
                            object = string;
                            if (string != null) break block13;
                        }
                        object = "Unknown location";
                    }
                    String geoLocation = object;
                    this.plugin.getLogger().debug("GeoLocation: " + geoLocation);
                    String fullGeoLocation = stack.getSender().hasPermission("punisherx.view_ip") ? playerIP + " (" + geoLocation + ")" : geoLocation;
                    String gamer = Intrinsics.areEqual(stack.getSender().getName(), "CONSOLE") ? "<gold>" + targetPlayer + " <gray>[" + uuid + ", " + fullGeoLocation + "]</gray>:</gold>" : "<gold><hover:show_text:'[<white>" + uuid + ", " + fullGeoLocation + "</white>]'>" + targetPlayer + ":</gold>";
                    MiniMessage miniMessage = MiniMessage.miniMessage();
                    Intrinsics.checkNotNullExpressionValue(miniMessage, "miniMessage(...)");
                    MiniMessage miniMessage2 = miniMessage;
                    Component component = miniMessage2.deserialize((Object)"<blue>--------------------------------------------------</blue>");
                    Intrinsics.checkNotNullExpressionValue(component, "deserialize(...)");
                    Component topHeader = component;
                    Component component2 = miniMessage2.deserialize((Object)("<blue>|    " + title + " " + gamer + "</blue>"));
                    Intrinsics.checkNotNullExpressionValue(component2, "deserialize(...)");
                    Component header = component2;
                    Component component3 = miniMessage2.deserialize((Object)("<blue>|   " + id + "  |  " + types + "  |  " + reasons + "  |  " + times + "</blue>"));
                    Intrinsics.checkNotNullExpressionValue(component3, "deserialize(...)");
                    Component tableHeader = component3;
                    Component component4 = miniMessage2.deserialize((Object)"<blue> </blue>");
                    Intrinsics.checkNotNullExpressionValue(component4, "deserialize(...)");
                    Component br = component4;
                    Component component5 = miniMessage2.deserialize((Object)"<blue>|</blue>");
                    Intrinsics.checkNotNullExpressionValue(component5, "deserialize(...)");
                    Component hr = component5;
                    stack.getSender().sendMessage(br);
                    stack.getSender().sendMessage(header);
                    stack.getSender().sendMessage(topHeader);
                    stack.getSender().sendMessage(tableHeader);
                    stack.getSender().sendMessage(hr);
                    Iterable $this$forEach$iv = punishments;
                    boolean $i$f$forEach = false;
                    for (Object element$iv : $this$forEach$iv) {
                        Component punishmentMessage;
                        PunishmentData punishment = (PunishmentData)element$iv;
                        boolean bl = false;
                        String formattedDate = this.dateFormat.format(new Date(punishment.getStart()));
                        Intrinsics.checkNotNullExpressionValue(miniMessage2.deserialize((Object)("<blue>|   <white>#" + punishment.getId() + "</white> <blue>|</blue> <white>" + punishment.getType() + "</white> <blue>|</blue> <white>" + punishment.getReason() + "</white> <blue>|</blue> <white>" + formattedDate + "</blue>")), "deserialize(...)");
                        stack.getSender().sendMessage(punishmentMessage);
                    }
                    stack.getSender().sendMessage(hr);
                    int nextPage = page + 1;
                    int prevPage = page > 1 ? page - 1 : 1;
                    Component component6 = miniMessage2.deserialize((Object)("<blue>| <click:run_command:'/history " + player + " " + prevPage + "'>[Previous]</click>   <click:run_command:'/history " + player + " " + nextPage + "'>[Next]</click> </blue>"));
                    Intrinsics.checkNotNullExpressionValue(component6, "deserialize(...)");
                    Component navigation = component6;
                    stack.getSender().sendMessage(navigation);
                    break block11;
                }
                stack.getSender().sendRichMessage(MessageHandler.getMessage$default(this.messageHandler, "history", "no_permission", null, 4, null));
                break block11;
            }
            stack.getSender().sendRichMessage(MessageHandler.getMessage$default(this.messageHandler, "history", "usage", null, 4, null));
        }
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public List<String> suggest(@NotNull CommandSourceStack stack, @NotNull String[] args) {
        List list;
        Intrinsics.checkNotNullParameter(stack, "stack");
        Intrinsics.checkNotNullParameter(args, "args");
        if (args.length == 1) {
            void $this$mapTo$iv$iv;
            Collection collection = this.plugin.getServer().getOnlinePlayers();
            Intrinsics.checkNotNullExpressionValue(collection, "getOnlinePlayers(...)");
            Iterable $this$map$iv = collection;
            boolean $i$f$map = false;
            Iterable iterable = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                Player player = (Player)item$iv$iv;
                Collection collection2 = destination$iv$iv;
                boolean bl = false;
                collection2.add(it.getName());
            }
            list = (List)destination$iv$iv;
        } else {
            list = CollectionsKt.emptyList();
        }
        return list;
    }
}

