/*
 * Decompiled with CFR 0.152.
 */
package pl.syntaxdevteam.punisher.commands;

import io.papermc.paper.command.brigadier.BasicCommand;
import io.papermc.paper.command.brigadier.CommandSourceStack;
import io.papermc.paper.plugin.configuration.PluginMeta;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import java.util.UUID;
import kotlin.Metadata;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.minimessage.MiniMessage;
import org.bukkit.Bukkit;
import org.bukkit.entity.Player;
import org.jetbrains.annotations.NotNull;
import pl.syntaxdevteam.punisher.PunisherX;
import pl.syntaxdevteam.punisher.basic.TimeHandler;
import pl.syntaxdevteam.punisher.common.MessageHandler;
import pl.syntaxdevteam.punisher.common.UUIDManager;
import pl.syntaxdevteam.punisher.databases.DatabaseHandler;
import pl.syntaxdevteam.punisher.databases.PunishmentData;
import pl.syntaxdevteam.punisher.players.PlayerIPManager;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000P\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\b\u0010\tJ'\u0010\u0010\u001a\u00020\u00112\b\b\u0001\u0010\u0012\u001a\u00020\u00132\u000e\b\u0001\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00160\u0015H\u0016\u00a2\u0006\u0002\u0010\u0017J-\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u00160\u00192\b\b\u0001\u0010\u0012\u001a\u00020\u00132\u000e\b\u0001\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00160\u0015H\u0016\u00a2\u0006\u0002\u0010\u001aR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001b"}, d2={"Lpl/syntaxdevteam/punisher/commands/CheckCommand;", "Lio/papermc/paper/command/brigadier/BasicCommand;", "plugin", "Lpl/syntaxdevteam/punisher/PunisherX;", "pluginMetas", "Lio/papermc/paper/plugin/configuration/PluginMeta;", "playerIPManager", "Lpl/syntaxdevteam/punisher/players/PlayerIPManager;", "<init>", "(Lpl/syntaxdevteam/punisher/PunisherX;Lio/papermc/paper/plugin/configuration/PluginMeta;Lpl/syntaxdevteam/punisher/players/PlayerIPManager;)V", "uuidManager", "Lpl/syntaxdevteam/punisher/common/UUIDManager;", "messageHandler", "Lpl/syntaxdevteam/punisher/common/MessageHandler;", "timeHandler", "Lpl/syntaxdevteam/punisher/basic/TimeHandler;", "execute", "", "stack", "Lio/papermc/paper/command/brigadier/CommandSourceStack;", "args", "", "", "(Lio/papermc/paper/command/brigadier/CommandSourceStack;[Ljava/lang/String;)V", "suggest", "", "(Lio/papermc/paper/command/brigadier/CommandSourceStack;[Ljava/lang/String;)Ljava/util/List;", "PunisherX"})
@SourceDebugExtension(value={"SMAP\nCheckCommand.kt\nKotlin\n*S Kotlin\n*F\n+ 1 CheckCommand.kt\npl/syntaxdevteam/punisher/commands/CheckCommand\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,113:1\n774#2:114\n865#2,2:115\n774#2:117\n865#2,2:118\n774#2:120\n865#2,2:121\n1863#2,2:123\n1557#2:125\n1628#2,3:126\n*S KotlinDebug\n*F\n+ 1 CheckCommand.kt\npl/syntaxdevteam/punisher/commands/CheckCommand\n*L\n40#1:114\n40#1:115,2\n41#1:117\n41#1:118,2\n42#1:120\n42#1:121,2\n87#1:123,2\n107#1:125\n107#1:126,3\n*E\n"})
public final class CheckCommand
implements BasicCommand {
    @NotNull
    private final PunisherX plugin;
    @NotNull
    private final PlayerIPManager playerIPManager;
    @NotNull
    private final UUIDManager uuidManager;
    @NotNull
    private final MessageHandler messageHandler;
    @NotNull
    private final TimeHandler timeHandler;

    public CheckCommand(@NotNull PunisherX plugin, @NotNull PluginMeta pluginMetas, @NotNull PlayerIPManager playerIPManager) {
        Intrinsics.checkNotNullParameter((Object)plugin, "plugin");
        Intrinsics.checkNotNullParameter(pluginMetas, "pluginMetas");
        Intrinsics.checkNotNullParameter(playerIPManager, "playerIPManager");
        this.plugin = plugin;
        this.playerIPManager = playerIPManager;
        this.uuidManager = new UUIDManager(this.plugin);
        this.messageHandler = new MessageHandler(this.plugin, pluginMetas);
        this.timeHandler = new TimeHandler(this.plugin, pluginMetas);
    }

    public void execute(@NotNull CommandSourceStack stack, @NotNull String[] args) {
        block29: {
            block26: {
                block27: {
                    Object object;
                    String playerIP;
                    String title;
                    String times;
                    String reasons;
                    String types;
                    String id;
                    List filteredPunishments;
                    String targetPlayer;
                    UUID uuid;
                    block33: {
                        block32: {
                            String player;
                            block31: {
                                List list;
                                String string;
                                block28: {
                                    Intrinsics.checkNotNullParameter(stack, "stack");
                                    Intrinsics.checkNotNullParameter(args, "args");
                                    if (!(!(args.length == 0))) break block26;
                                    player = args[0];
                                    String string2 = stack.getSender().getName();
                                    Intrinsics.checkNotNullExpressionValue(string2, "getName(...)");
                                    String senderName = string2;
                                    if (!StringsKt.equals(player, senderName, true) && !stack.getSender().hasPermission("punisherx.check")) break block27;
                                    if (args.length >= 2) break block28;
                                    stack.getSender().sendRichMessage(MessageHandler.getMessage$default(this.messageHandler, "check", "usage", null, 4, null));
                                    break block29;
                                }
                                String type = args[1];
                                uuid = this.uuidManager.getUUID(player);
                                Player player2 = Bukkit.getPlayer((String)player);
                                if ((player2 != null ? player2.getName() : null) == null) {
                                    string = Bukkit.getOfflinePlayer((UUID)uuid).getName();
                                } else {
                                    Player player3 = Bukkit.getPlayer((String)player);
                                    string = player3 != null ? player3.getName() : null;
                                }
                                targetPlayer = string;
                                DatabaseHandler databaseHandler = this.plugin.getDatabaseHandler();
                                String string3 = uuid.toString();
                                Intrinsics.checkNotNullExpressionValue(string3, "toString(...)");
                                List punishments = databaseHandler.getPunishments(string3);
                                String string4 = type.toLowerCase(Locale.ROOT);
                                Intrinsics.checkNotNullExpressionValue(string4, "toLowerCase(...)");
                                switch (string4) {
                                    case "all": {
                                        list = punishments;
                                        break;
                                    }
                                    case "ban": {
                                        PunishmentData it;
                                        Iterable $this$filterTo$iv$iv;
                                        Iterable $this$filter$iv = punishments;
                                        boolean $i$f$filter = false;
                                        Iterable iterable = $this$filter$iv;
                                        Collection destination$iv$iv = new ArrayList();
                                        boolean $i$f$filterTo = false;
                                        for (Object element$iv$iv : $this$filterTo$iv$iv) {
                                            it = (PunishmentData)element$iv$iv;
                                            boolean bl = false;
                                            if (!(Intrinsics.areEqual(it.getType(), "BAN") || Intrinsics.areEqual(it.getType(), "BANIP"))) continue;
                                            destination$iv$iv.add(element$iv$iv);
                                        }
                                        list = (List)destination$iv$iv;
                                        break;
                                    }
                                    case "mute": {
                                        PunishmentData it;
                                        Iterable $this$filter$iv = punishments;
                                        boolean $i$f$filter = false;
                                        Iterable $this$filterTo$iv$iv = $this$filter$iv;
                                        Collection destination$iv$iv = new ArrayList();
                                        boolean $i$f$filterTo = false;
                                        for (Object element$iv$iv : $this$filterTo$iv$iv) {
                                            it = (PunishmentData)element$iv$iv;
                                            boolean bl = false;
                                            if (!Intrinsics.areEqual(it.getType(), "MUTE")) continue;
                                            destination$iv$iv.add(element$iv$iv);
                                        }
                                        list = (List)destination$iv$iv;
                                        break;
                                    }
                                    case "warn": {
                                        PunishmentData it;
                                        Iterable $this$filter$iv = punishments;
                                        boolean $i$f$filter = false;
                                        Iterable $this$filterTo$iv$iv = $this$filter$iv;
                                        Collection destination$iv$iv = new ArrayList();
                                        boolean $i$f$filterTo = false;
                                        for (Object element$iv$iv : $this$filterTo$iv$iv) {
                                            it = (PunishmentData)element$iv$iv;
                                            boolean bl = false;
                                            if (!Intrinsics.areEqual(it.getType(), "WARN")) continue;
                                            destination$iv$iv.add(element$iv$iv);
                                        }
                                        list = (List)destination$iv$iv;
                                        break;
                                    }
                                    default: {
                                        stack.getSender().sendRichMessage(MessageHandler.getMessage$default(this.messageHandler, "check", "invalid_type", null, 4, null));
                                        return;
                                    }
                                }
                                filteredPunishments = list;
                                if (!filteredPunishments.isEmpty()) break block31;
                                stack.getSender().sendRichMessage(this.messageHandler.getMessage("check", "no_punishments", MapsKt.mapOf(TuplesKt.to("player", player))));
                                break block29;
                            }
                            id = MessageHandler.getLogMessage$default(this.messageHandler, "check", "id", null, 4, null);
                            types = MessageHandler.getLogMessage$default(this.messageHandler, "check", "type", null, 4, null);
                            reasons = MessageHandler.getLogMessage$default(this.messageHandler, "check", "reason", null, 4, null);
                            times = MessageHandler.getLogMessage$default(this.messageHandler, "check", "time", null, 4, null);
                            title = MessageHandler.getLogMessage$default(this.messageHandler, "check", "title", null, 4, null);
                            playerIP = this.playerIPManager.getPlayerIPByName(player);
                            this.plugin.getLogger().debug("Player IP: " + playerIP);
                            object = playerIP;
                            if (object == null) break block32;
                            String ip = object;
                            boolean bl = false;
                            String country = this.playerIPManager.getGeoIPHandler().getCountry(ip);
                            String city = this.playerIPManager.getGeoIPHandler().getCity(ip);
                            this.plugin.getLogger().debug("Country: " + country + ", City: " + city);
                            String string = city + ", " + country;
                            object = string;
                            if (string != null) break block33;
                        }
                        object = "Unknown location";
                    }
                    String geoLocation = object;
                    this.plugin.getLogger().debug("GeoLocation: " + geoLocation);
                    String fullGeoLocation = stack.getSender().hasPermission("punisherx.view_ip") ? playerIP + " (" + geoLocation + ")" : geoLocation;
                    String gamer = Intrinsics.areEqual(stack.getSender().getName(), "CONSOLE") ? "<gold>" + targetPlayer + " <gray>[" + uuid + ", " + fullGeoLocation + "]</gray>:</gold>" : "<gold><hover:show_text:'[<white>" + uuid + ", " + fullGeoLocation + "</white>]'>" + targetPlayer + ":</gold>";
                    MiniMessage miniMessage = MiniMessage.miniMessage();
                    Intrinsics.checkNotNullExpressionValue(miniMessage, "miniMessage(...)");
                    MiniMessage miniMessage2 = miniMessage;
                    Component component = miniMessage2.deserialize((Object)"<blue>--------------------------------------------------</blue>");
                    Intrinsics.checkNotNullExpressionValue(component, "deserialize(...)");
                    Component topHeader = component;
                    Component component2 = miniMessage2.deserialize((Object)("<blue>|    " + title + " " + gamer + "</blue>"));
                    Intrinsics.checkNotNullExpressionValue(component2, "deserialize(...)");
                    Component header = component2;
                    Component component3 = miniMessage2.deserialize((Object)("<blue>|   " + id + "  |  " + types + "  |  " + reasons + "  |  " + times + "</blue>"));
                    Intrinsics.checkNotNullExpressionValue(component3, "deserialize(...)");
                    Component tableHeader = component3;
                    Component component4 = miniMessage2.deserialize((Object)"<blue> </blue>");
                    Intrinsics.checkNotNullExpressionValue(component4, "deserialize(...)");
                    Component br = component4;
                    Component component5 = miniMessage2.deserialize((Object)"<blue>|</blue>");
                    Intrinsics.checkNotNullExpressionValue(component5, "deserialize(...)");
                    Component hr = component5;
                    stack.getSender().sendMessage(br);
                    stack.getSender().sendMessage(header);
                    stack.getSender().sendMessage(topHeader);
                    stack.getSender().sendMessage(tableHeader);
                    stack.getSender().sendMessage(hr);
                    Iterable $this$forEach$iv = filteredPunishments;
                    boolean $i$f$forEach = false;
                    for (Object element$iv : $this$forEach$iv) {
                        Component row;
                        PunishmentData punishment = (PunishmentData)element$iv;
                        boolean bl = false;
                        long endTime = punishment.getEnd();
                        long remainingTime = (endTime - System.currentTimeMillis()) / (long)1000;
                        String duration = endTime == -1L ? "permanent" : this.timeHandler.formatTime(String.valueOf(remainingTime));
                        String reason = punishment.getReason();
                        Intrinsics.checkNotNullExpressionValue(miniMessage2.deserialize((Object)("<blue>|   <white>#" + punishment.getId() + "</white> <blue>|</blue> <white>" + punishment.getType() + "</white> <blue>|</blue> <white>" + reason + "</white> <blue>|</blue> <white>" + duration + "</white>")), "deserialize(...)");
                        stack.getSender().sendMessage(row);
                    }
                    break block29;
                }
                stack.getSender().sendRichMessage(MessageHandler.getMessage$default(this.messageHandler, "error", "no_permission", null, 4, null));
                break block29;
            }
            stack.getSender().sendRichMessage(MessageHandler.getMessage$default(this.messageHandler, "check", "usage", null, 4, null));
        }
    }

    @NotNull
    public List<String> suggest(@NotNull CommandSourceStack stack, @NotNull String[] args) {
        Intrinsics.checkNotNullParameter(stack, "stack");
        Intrinsics.checkNotNullParameter(args, "args");
        return switch (args.length) {
            case 1 -> {
                void $this$mapTo$iv$iv;
                Collection v0 = this.plugin.getServer().getOnlinePlayers();
                Intrinsics.checkNotNullExpressionValue(v0, "getOnlinePlayers(...)");
                Iterable $this$map$iv = v0;
                boolean $i$f$map = false;
                Iterable var5_6 = $this$map$iv;
                Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
                boolean $i$f$mapTo = false;
                for (Object item$iv$iv : $this$mapTo$iv$iv) {
                    void it;
                    Player var10_11 = (Player)item$iv$iv;
                    Collection var12_13 = destination$iv$iv;
                    boolean $i$a$-map-CheckCommand$suggest$1 = false;
                    var12_13.add(it.getName());
                }
                yield (List)destination$iv$iv;
            }
            case 2 -> {
                String[] var3_4 = new String[]{"all", "warn", "mute", "ban"};
                yield CollectionsKt.listOf(var3_4);
            }
            default -> CollectionsKt.emptyList();
        };
    }
}

