/*
 * Decompiled with CFR 0.152.
 */
package pl.syntaxdevteam.punisher.commands;

import io.papermc.paper.command.brigadier.BasicCommand;
import io.papermc.paper.command.brigadier.CommandSourceStack;
import io.papermc.paper.plugin.configuration.PluginMeta;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.bukkit.entity.Player;
import org.jetbrains.annotations.NotNull;
import pl.syntaxdevteam.punisher.PunisherX;
import pl.syntaxdevteam.punisher.common.MessageHandler;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\b\u0003\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J'\u0010\n\u001a\u00020\u000b2\b\b\u0001\u0010\f\u001a\u00020\r2\u000e\b\u0001\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00100\u000fH\u0016\u00a2\u0006\u0002\u0010\u0011J-\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00100\u00132\b\b\u0001\u0010\f\u001a\u00020\r2\u000e\b\u0001\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00100\u000fH\u0016\u00a2\u0006\u0002\u0010\u0014J\u000e\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00100\u0013H\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0016"}, d2={"Lpl/syntaxdevteam/punisher/commands/ChangeReasonCommand;", "Lio/papermc/paper/command/brigadier/BasicCommand;", "plugin", "Lpl/syntaxdevteam/punisher/PunisherX;", "pluginMetas", "Lio/papermc/paper/plugin/configuration/PluginMeta;", "<init>", "(Lpl/syntaxdevteam/punisher/PunisherX;Lio/papermc/paper/plugin/configuration/PluginMeta;)V", "messageHandler", "Lpl/syntaxdevteam/punisher/common/MessageHandler;", "execute", "", "stack", "Lio/papermc/paper/command/brigadier/CommandSourceStack;", "args", "", "", "(Lio/papermc/paper/command/brigadier/CommandSourceStack;[Ljava/lang/String;)V", "suggest", "", "(Lio/papermc/paper/command/brigadier/CommandSourceStack;[Ljava/lang/String;)Ljava/util/List;", "generateTimeSuggestions", "PunisherX"})
@SourceDebugExtension(value={"SMAP\nChangeReasonCommand.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ChangeReasonCommand.kt\npl/syntaxdevteam/punisher/commands/ChangeReasonCommand\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,73:1\n1557#2:74\n1628#2,3:75\n*S KotlinDebug\n*F\n+ 1 ChangeReasonCommand.kt\npl/syntaxdevteam/punisher/commands/ChangeReasonCommand\n*L\n56#1:74\n56#1:75,3\n*E\n"})
public final class ChangeReasonCommand
implements BasicCommand {
    @NotNull
    private final PunisherX plugin;
    @NotNull
    private final MessageHandler messageHandler;

    public ChangeReasonCommand(@NotNull PunisherX plugin, @NotNull PluginMeta pluginMetas) {
        Intrinsics.checkNotNullParameter((Object)plugin, "plugin");
        Intrinsics.checkNotNullParameter(pluginMetas, "pluginMetas");
        this.plugin = plugin;
        this.messageHandler = new MessageHandler(this.plugin, pluginMetas);
    }

    public void execute(@NotNull CommandSourceStack stack, @NotNull String[] args) {
        Intrinsics.checkNotNullParameter(stack, "stack");
        Intrinsics.checkNotNullParameter(args, "args");
        if (!(args.length == 0)) {
            if (stack.getSender().hasPermission("punisherx.change_reason")) {
                if (args.length < 2) {
                    stack.getSender().sendRichMessage(MessageHandler.getMessage$default(this.messageHandler, "change-reason", "usage", null, 4, null));
                    return;
                }
                Integer id = StringsKt.toIntOrNull(args[0]);
                String newReason = CollectionsKt.joinToString$default(ArraysKt.drop(args, 1), " ", null, null, 0, null, null, 62, null);
                if (id == null) {
                    stack.getSender().sendRichMessage(MessageHandler.getMessage$default(this.messageHandler, "change-reason", "invalid_id", null, 4, null));
                    return;
                }
                boolean success = this.plugin.getDatabaseHandler().updatePunishmentReason(id, newReason);
                if (success) {
                    Pair[] pairArray = new Pair[]{TuplesKt.to("id", id.toString()), TuplesKt.to("reason", newReason)};
                    stack.getSender().sendRichMessage(this.messageHandler.getMessage("change-reason", "success", MapsKt.mapOf(pairArray)));
                } else {
                    stack.getSender().sendRichMessage(this.messageHandler.getMessage("change-reason", "failure", MapsKt.mapOf(TuplesKt.to("id", id.toString()))));
                }
            } else {
                stack.getSender().sendRichMessage(MessageHandler.getMessage$default(this.messageHandler, "error", "no_permission", null, 4, null));
            }
        } else {
            stack.getSender().sendRichMessage(MessageHandler.getMessage$default(this.messageHandler, "ban", "usage", null, 4, null));
        }
    }

    @NotNull
    public List<String> suggest(@NotNull CommandSourceStack stack, @NotNull String[] args) {
        Intrinsics.checkNotNullParameter(stack, "stack");
        Intrinsics.checkNotNullParameter(args, "args");
        return switch (args.length) {
            case 1 -> {
                void $this$mapTo$iv$iv;
                Collection v0 = this.plugin.getServer().getOnlinePlayers();
                Intrinsics.checkNotNullExpressionValue(v0, "getOnlinePlayers(...)");
                Iterable $this$map$iv = v0;
                boolean $i$f$map = false;
                Iterable var5_5 = $this$map$iv;
                Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
                boolean $i$f$mapTo = false;
                for (Object item$iv$iv : $this$mapTo$iv$iv) {
                    void it;
                    Player var10_10 = (Player)item$iv$iv;
                    Collection var12_12 = destination$iv$iv;
                    boolean $i$a$-map-ChangeReasonCommand$suggest$1 = false;
                    var12_12.add(it.getName());
                }
                yield (List)destination$iv$iv;
            }
            case 2 -> this.generateTimeSuggestions();
            default -> CollectionsKt.emptyList();
        };
    }

    private final List<String> generateTimeSuggestions() {
        String[] stringArray = new String[]{"s", "m", "h", "d"};
        List<String> units = CollectionsKt.listOf(stringArray);
        List suggestions = new ArrayList();
        for (int i = 1; i < 1000; ++i) {
            for (String unit : units) {
                suggestions.add(i + unit);
            }
        }
        return suggestions;
    }
}

