/*
 * Decompiled with CFR 0.152.
 */
package pl.syntaxdevteam.punisher.commands;

import io.papermc.paper.command.brigadier.BasicCommand;
import io.papermc.paper.command.brigadier.CommandSourceStack;
import io.papermc.paper.plugin.configuration.PluginMeta;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import kotlin.text.Regex;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.TextComponent;
import net.kyori.adventure.text.minimessage.MiniMessage;
import org.bukkit.Bukkit;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.jetbrains.annotations.NotNull;
import pl.syntaxdevteam.punisher.PunisherX;
import pl.syntaxdevteam.punisher.basic.TimeHandler;
import pl.syntaxdevteam.punisher.common.MessageHandler;
import pl.syntaxdevteam.punisher.databases.DatabaseHandler;
import pl.syntaxdevteam.punisher.players.PlayerIPManager;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\b\u0003\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J'\u0010\f\u001a\u00020\r2\b\b\u0001\u0010\u000e\u001a\u00020\u000f2\u000e\b\u0001\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00120\u0011H\u0016\u00a2\u0006\u0002\u0010\u0013J-\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00120\u00152\b\b\u0001\u0010\u000e\u001a\u00020\u000f2\u000e\b\u0001\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00120\u0011H\u0016\u00a2\u0006\u0002\u0010\u0016J\u000e\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00120\u0015H\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0018"}, d2={"Lpl/syntaxdevteam/punisher/commands/BanIpCommand;", "Lio/papermc/paper/command/brigadier/BasicCommand;", "plugin", "Lpl/syntaxdevteam/punisher/PunisherX;", "pluginMetas", "Lio/papermc/paper/plugin/configuration/PluginMeta;", "<init>", "(Lpl/syntaxdevteam/punisher/PunisherX;Lio/papermc/paper/plugin/configuration/PluginMeta;)V", "messageHandler", "Lpl/syntaxdevteam/punisher/common/MessageHandler;", "timeHandler", "Lpl/syntaxdevteam/punisher/basic/TimeHandler;", "execute", "", "stack", "Lio/papermc/paper/command/brigadier/CommandSourceStack;", "args", "", "", "(Lio/papermc/paper/command/brigadier/CommandSourceStack;[Ljava/lang/String;)V", "suggest", "", "(Lio/papermc/paper/command/brigadier/CommandSourceStack;[Ljava/lang/String;)Ljava/util/List;", "generateTimeSuggestions", "PunisherX"})
@SourceDebugExtension(value={"SMAP\nBanIpCommand.kt\nKotlin\n*S Kotlin\n*F\n+ 1 BanIpCommand.kt\npl/syntaxdevteam/punisher/commands/BanIpCommand\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,111:1\n1863#2,2:112\n1863#2,2:114\n1557#2:116\n1628#2,3:117\n*S KotlinDebug\n*F\n+ 1 BanIpCommand.kt\npl/syntaxdevteam/punisher/commands/BanIpCommand\n*L\n67#1:112,2\n77#1:114,2\n93#1:116\n93#1:117,3\n*E\n"})
public final class BanIpCommand
implements BasicCommand {
    @NotNull
    private final PunisherX plugin;
    @NotNull
    private final MessageHandler messageHandler;
    @NotNull
    private final TimeHandler timeHandler;

    public BanIpCommand(@NotNull PunisherX plugin, @NotNull PluginMeta pluginMetas) {
        Intrinsics.checkNotNullParameter((Object)plugin, "plugin");
        Intrinsics.checkNotNullParameter(pluginMetas, "pluginMetas");
        this.plugin = plugin;
        this.messageHandler = new MessageHandler(this.plugin, pluginMetas);
        this.timeHandler = new TimeHandler(this.plugin, pluginMetas);
    }

    public void execute(@NotNull CommandSourceStack stack, @NotNull String[] args) {
        Intrinsics.checkNotNullParameter(stack, "stack");
        Intrinsics.checkNotNullParameter(args, "args");
        if (!(args.length == 0)) {
            if (stack.getSender().hasPermission("punisherx.banip")) {
                if (args.length < 2) {
                    stack.getSender().sendRichMessage(MessageHandler.getMessage$default(this.messageHandler, "banip", "usage", null, 4, null));
                } else {
                    Iterable $this$forEach$iv;
                    Object kickMessages;
                    String playerIP;
                    String playerOrIpOrUUID = args[0];
                    CharSequence charSequence = playerOrIpOrUUID;
                    if (new Regex("\\d+\\.\\d+\\.\\d+\\.\\d+").matches(charSequence)) {
                        v0 = playerOrIpOrUUID;
                    } else {
                        charSequence = playerOrIpOrUUID;
                        if (new Regex("[0-9a-fA-F]{8}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{12}").matches(charSequence)) {
                            v0 = this.plugin.getPlayerIPManager().getPlayerIPByUUID(playerOrIpOrUUID);
                        } else {
                            PlayerIPManager playerIPManager = this.plugin.getPlayerIPManager();
                            String string = playerOrIpOrUUID.toLowerCase(Locale.ROOT);
                            Intrinsics.checkNotNullExpressionValue(string, "toLowerCase(...)");
                            v0 = playerIP = playerIPManager.getPlayerIPByName(string);
                        }
                    }
                    if (playerIP == null) {
                        stack.getSender().sendRichMessage(MessageHandler.getMessage$default(this.messageHandler, "banip", "not_found", null, 4, null));
                        return;
                    }
                    Player targetPlayer = Bukkit.getPlayer((String)playerOrIpOrUUID);
                    if (targetPlayer != null && targetPlayer.hasPermission("punisherx.bypass.banip")) {
                        stack.getSender().sendRichMessage(this.messageHandler.getMessage("error", "bypass", MapsKt.mapOf(TuplesKt.to("player", playerOrIpOrUUID))));
                        return;
                    }
                    String gtime = null;
                    String reason = null;
                    try {
                        gtime = args[1];
                        this.timeHandler.parseTime(gtime);
                        reason = CollectionsKt.joinToString$default(ArraysKt.slice(args, RangesKt.until(2, args.length)), " ", null, null, 0, null, null, 62, null);
                    }
                    catch (NumberFormatException e) {
                        gtime = null;
                        reason = CollectionsKt.joinToString$default(ArraysKt.slice(args, RangesKt.until(1, args.length)), " ", null, null, 0, null, null, 62, null);
                    }
                    String punishmentType = "BANIP";
                    long start = System.currentTimeMillis();
                    Long end = gtime != null ? Long.valueOf(System.currentTimeMillis() + this.timeHandler.parseTime(gtime) * (long)1000) : null;
                    DatabaseHandler databaseHandler = this.plugin.getDatabaseHandler();
                    String string = stack.getSender().getName();
                    Intrinsics.checkNotNullExpressionValue(string, "getName(...)");
                    Long l = end;
                    boolean success = databaseHandler.addPunishment(playerOrIpOrUUID, playerIP, reason, string, punishmentType, start, l != null ? l : -1L);
                    if (!success) {
                        Bukkit.dispatchCommand((CommandSender)((CommandSender)Bukkit.getConsoleSender()), (String)("ban-ip " + playerOrIpOrUUID));
                    }
                    DatabaseHandler databaseHandler2 = this.plugin.getDatabaseHandler();
                    String string2 = stack.getSender().getName();
                    Intrinsics.checkNotNullExpressionValue(string2, "getName(...)");
                    Long l2 = end;
                    databaseHandler2.addPunishmentHistory(playerOrIpOrUUID, playerIP, reason, string2, punishmentType, start, l2 != null ? l2 : -1L);
                    if (targetPlayer != null) {
                        Pair[] pairArray = new Pair[]{TuplesKt.to("reason", reason), TuplesKt.to("time", this.timeHandler.formatTime(gtime))};
                        kickMessages = this.messageHandler.getComplexMessage("banip", "kick_message", MapsKt.mapOf(pairArray));
                        TextComponent.Builder builder = Component.text();
                        Intrinsics.checkNotNullExpressionValue(builder, "text(...)");
                        TextComponent.Builder kickMessage = builder;
                        $this$forEach$iv = (Iterable)kickMessages;
                        boolean $i$f$forEach = false;
                        for (Object element$iv : $this$forEach$iv) {
                            Component line = (Component)element$iv;
                            boolean bl = false;
                            kickMessage.append(line);
                            kickMessage.append((Component)Component.newline());
                        }
                        targetPlayer.kick((Component)kickMessage.build());
                    }
                    kickMessages = new Pair[]{TuplesKt.to("player", playerOrIpOrUUID), TuplesKt.to("reason", reason), TuplesKt.to("time", this.timeHandler.formatTime(gtime))};
                    stack.getSender().sendRichMessage(this.messageHandler.getMessage("banip", "ban", MapsKt.mapOf(kickMessages)));
                    String permission = "punisherx.see.banip";
                    Pair[] $i$f$forEach = new Pair[]{TuplesKt.to("player", playerOrIpOrUUID), TuplesKt.to("reason", reason), TuplesKt.to("time", this.timeHandler.formatTime(gtime))};
                    Component component = MiniMessage.miniMessage().deserialize((Object)this.messageHandler.getMessage("banip", "ban", MapsKt.mapOf($i$f$forEach)));
                    Intrinsics.checkNotNullExpressionValue(component, "deserialize(...)");
                    Component broadcastMessage = component;
                    Collection collection = this.plugin.getServer().getOnlinePlayers();
                    Intrinsics.checkNotNullExpressionValue(collection, "getOnlinePlayers(...)");
                    $this$forEach$iv = collection;
                    boolean $i$f$forEach2 = false;
                    for (Object element$iv : $this$forEach$iv) {
                        Player onlinePlayer = (Player)element$iv;
                        boolean bl = false;
                        if (!onlinePlayer.hasPermission(permission)) continue;
                        onlinePlayer.sendMessage(broadcastMessage);
                    }
                }
            } else {
                stack.getSender().sendRichMessage(MessageHandler.getMessage$default(this.messageHandler, "error", "no_permission", null, 4, null));
            }
        } else {
            stack.getSender().sendRichMessage(MessageHandler.getMessage$default(this.messageHandler, "banip", "usage", null, 4, null));
        }
    }

    @NotNull
    public List<String> suggest(@NotNull CommandSourceStack stack, @NotNull String[] args) {
        Intrinsics.checkNotNullParameter(stack, "stack");
        Intrinsics.checkNotNullParameter(args, "args");
        return switch (args.length) {
            case 1 -> {
                void $this$mapTo$iv$iv;
                Collection v0 = this.plugin.getServer().getOnlinePlayers();
                Intrinsics.checkNotNullExpressionValue(v0, "getOnlinePlayers(...)");
                Iterable $this$map$iv = v0;
                boolean $i$f$map = false;
                Iterable var5_5 = $this$map$iv;
                Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
                boolean $i$f$mapTo = false;
                for (Object item$iv$iv : $this$mapTo$iv$iv) {
                    void it;
                    Player var10_10 = (Player)item$iv$iv;
                    Collection var12_12 = destination$iv$iv;
                    boolean $i$a$-map-BanIpCommand$suggest$1 = false;
                    var12_12.add(it.getName());
                }
                yield (List)destination$iv$iv;
            }
            case 2 -> this.generateTimeSuggestions();
            case 3 -> this.messageHandler.getReasons("banip", "reasons");
            default -> CollectionsKt.emptyList();
        };
    }

    private final List<String> generateTimeSuggestions() {
        String[] stringArray = new String[]{"s", "m", "h", "d"};
        List<String> units = CollectionsKt.listOf(stringArray);
        List suggestions = new ArrayList();
        for (int i = 1; i < 1000; ++i) {
            for (String unit : units) {
                suggestions.add(i + unit);
            }
        }
        return suggestions;
    }
}

