/*
 * Decompiled with CFR 0.152.
 */
package pl.syntaxdevteam.punisher.basic;

import io.papermc.paper.plugin.configuration.PluginMeta;
import java.util.ArrayList;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import pl.syntaxdevteam.punisher.PunisherX;
import pl.syntaxdevteam.punisher.common.MessageHandler;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0005\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u000e\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rJ\u0010\u0010\u000e\u001a\u00020\r2\b\u0010\f\u001a\u0004\u0018\u00010\rJ\u0018\u0010\u000f\u001a\u00020\r2\u0006\u0010\u0010\u001a\u00020\r2\u0006\u0010\u0011\u001a\u00020\u000bH\u0002R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0012"}, d2={"Lpl/syntaxdevteam/punisher/basic/TimeHandler;", "", "plugin", "Lpl/syntaxdevteam/punisher/PunisherX;", "pluginMetas", "Lio/papermc/paper/plugin/configuration/PluginMeta;", "<init>", "(Lpl/syntaxdevteam/punisher/PunisherX;Lio/papermc/paper/plugin/configuration/PluginMeta;)V", "messageHandler", "Lpl/syntaxdevteam/punisher/common/MessageHandler;", "parseTime", "", "time", "", "formatTime", "getLocalizedMessage", "unit", "amount", "PunisherX"})
@SourceDebugExtension(value={"SMAP\nTimeHandler.kt\nKotlin\n*S Kotlin\n*F\n+ 1 TimeHandler.kt\npl/syntaxdevteam/punisher/basic/TimeHandler\n+ 2 _Strings.kt\nkotlin/text/StringsKt___StringsKt\n*L\n1#1,70:1\n1069#2,2:71\n*S KotlinDebug\n*F\n+ 1 TimeHandler.kt\npl/syntaxdevteam/punisher/basic/TimeHandler\n*L\n27#1:71,2\n*E\n"})
public final class TimeHandler {
    @NotNull
    private final MessageHandler messageHandler;

    public TimeHandler(@NotNull PunisherX plugin, @NotNull PluginMeta pluginMetas) {
        Intrinsics.checkNotNullParameter((Object)plugin, "plugin");
        Intrinsics.checkNotNullParameter(pluginMetas, "pluginMetas");
        this.messageHandler = new MessageHandler(plugin, pluginMetas);
    }

    public final long parseTime(@NotNull String time) {
        Intrinsics.checkNotNullParameter(time, "time");
        String string = time.substring(0, time.length() - 1);
        Intrinsics.checkNotNullExpressionValue(string, "substring(...)");
        long amount = Long.parseLong(string);
        char unit = StringsKt.last(time);
        return switch (unit) {
            case 's' -> amount;
            case 'm' -> amount * (long)60;
            case 'h' -> amount * (long)60 * (long)60;
            case 'd' -> amount * (long)60 * (long)60 * (long)24;
            default -> 0L;
        };
    }

    @NotNull
    public final String formatTime(@Nullable String time) {
        boolean isNumeric;
        block13: {
            boolean bl;
            if (time == null) {
                return MessageHandler.getLogMessage$default(this.messageHandler, "formatTime", "undefined", null, 4, null);
            }
            CharSequence $this$all$iv = time;
            boolean $i$f$all = false;
            for (int i = 0; i < $this$all$iv.length(); ++i) {
                char element$iv;
                char it = element$iv = $this$all$iv.charAt(i);
                boolean bl2 = false;
                if (Character.isDigit(it)) continue;
                bl = false;
                break block13;
            }
            bl = isNumeric = true;
        }
        if (isNumeric) {
            long totalSeconds = Long.parseLong(time);
            long days = totalSeconds / (long)86400;
            long hours = totalSeconds % (long)86400 / (long)3600;
            long minutes = totalSeconds % (long)3600 / (long)60;
            long seconds = totalSeconds % (long)60;
            String dayMessage = this.getLocalizedMessage("day", days);
            String hourMessage = this.getLocalizedMessage("hour", hours);
            String minuteMessage = this.getLocalizedMessage("minute", minutes);
            String secondMessage = this.getLocalizedMessage("second", seconds);
            List timeComponents = new ArrayList();
            if (days > 0L) {
                timeComponents.add(days + " " + dayMessage);
            }
            if (hours > 0L) {
                timeComponents.add(hours + " " + hourMessage);
            }
            if (minutes > 0L) {
                timeComponents.add(minutes + " " + minuteMessage);
            }
            if (seconds > 0L) {
                timeComponents.add(seconds + " " + secondMessage);
            }
            return CollectionsKt.joinToString$default(timeComponents, ", ", null, null, 0, null, null, 62, null);
        }
        String string = time.substring(0, time.length() - 1);
        Intrinsics.checkNotNullExpressionValue(string, "substring(...)");
        long amount = Long.parseLong(string);
        char unit = StringsKt.last(time);
        return switch (unit) {
            case 's' -> amount + " " + this.getLocalizedMessage("second", amount);
            case 'm' -> amount + " " + this.getLocalizedMessage("minute", amount);
            case 'h' -> amount + " " + this.getLocalizedMessage("hour", amount);
            case 'd' -> amount + " " + this.getLocalizedMessage("day", amount);
            default -> MessageHandler.getLogMessage$default(this.messageHandler, "formatTime", "undefined", null, 4, null);
        };
    }

    private final String getLocalizedMessage(String unit, long amount) {
        String unitPath = "formatTime." + unit;
        long l = amount;
        return l == 1L ? MessageHandler.getLogMessage$default(this.messageHandler, unitPath, "one", null, 4, null) : ((2L <= l ? l < 5L : false) ? MessageHandler.getLogMessage$default(this.messageHandler, unitPath, "few", null, 4, null) : MessageHandler.getLogMessage$default(this.messageHandler, unitPath, "many", null, 4, null));
    }
}

