/*
 * Decompiled with CFR 0.152.
 */
package pl.syntaxdevteam.punisher.basic;

import io.papermc.paper.event.player.AsyncChatEvent;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.TextComponent;
import net.kyori.adventure.text.minimessage.MiniMessage;
import net.kyori.adventure.text.serializer.plain.PlainTextComponentSerializer;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.player.AsyncPlayerPreLoginEvent;
import org.bukkit.event.player.PlayerCommandPreprocessEvent;
import org.jetbrains.annotations.NotNull;
import pl.syntaxdevteam.punisher.PunisherX;
import pl.syntaxdevteam.punisher.common.UUIDManager;
import pl.syntaxdevteam.punisher.databases.DatabaseHandler;
import pl.syntaxdevteam.punisher.databases.PunishmentData;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0010\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0007J\u0010\u0010\n\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u000bH\u0007J\u0010\u0010\f\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\rH\u0007R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000e"}, d2={"Lpl/syntaxdevteam/punisher/basic/PunishmentChecker;", "Lorg/bukkit/event/Listener;", "plugin", "Lpl/syntaxdevteam/punisher/PunisherX;", "<init>", "(Lpl/syntaxdevteam/punisher/PunisherX;)V", "onPlayerPreLogin", "", "event", "Lorg/bukkit/event/player/AsyncPlayerPreLoginEvent;", "onPlayerChat", "Lio/papermc/paper/event/player/AsyncChatEvent;", "onPlayerCommand", "Lorg/bukkit/event/player/PlayerCommandPreprocessEvent;", "PunisherX"})
@SourceDebugExtension(value={"SMAP\nPunishmentChecker.kt\nKotlin\n*S Kotlin\n*F\n+ 1 PunishmentChecker.kt\npl/syntaxdevteam/punisher/basic/PunishmentChecker\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,147:1\n1863#2:148\n1863#2,2:149\n1864#2:151\n1863#2,2:152\n*S KotlinDebug\n*F\n+ 1 PunishmentChecker.kt\npl/syntaxdevteam/punisher/basic/PunishmentChecker\n*L\n32#1:148\n45#1:149,2\n32#1:151\n124#1:152,2\n*E\n"})
public final class PunishmentChecker
implements Listener {
    @NotNull
    private final PunisherX plugin;

    public PunishmentChecker(@NotNull PunisherX plugin) {
        Intrinsics.checkNotNullParameter((Object)plugin, "plugin");
        this.plugin = plugin;
    }

    @EventHandler(priority=EventPriority.HIGHEST, ignoreCancelled=true)
    public final void onPlayerPreLogin(@NotNull AsyncPlayerPreLoginEvent event) {
        Intrinsics.checkNotNullParameter(event, "event");
        try {
            this.plugin.getLogger().debug("Checking punishment for player: " + event.getName());
            UUIDManager uUIDManager = this.plugin.getUuidManager();
            String string = event.getName();
            Intrinsics.checkNotNullExpressionValue(string, "getName(...)");
            String string2 = uUIDManager.getUUID(string).toString();
            Intrinsics.checkNotNullExpressionValue(string2, "toString(...)");
            String uuid = string2;
            String ip = event.getAddress().getHostAddress();
            Collection collection = this.plugin.getDatabaseHandler().getPunishments(uuid);
            DatabaseHandler databaseHandler = this.plugin.getDatabaseHandler();
            Intrinsics.checkNotNull(ip);
            List punishments = CollectionsKt.plus(collection, (Iterable)databaseHandler.getPunishmentsByIP(ip));
            if (punishments.isEmpty()) {
                this.plugin.getLogger().debug("No punishments found for player: " + event.getName());
                return;
            }
            Iterable $this$forEach$iv = punishments;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                PunishmentData punishment = (PunishmentData)element$iv;
                boolean bl = false;
                if (this.plugin.getPunishmentManager().isPunishmentActive(punishment)) {
                    TextComponent.Builder kickMessage;
                    List<Object> list;
                    if (!Intrinsics.areEqual(punishment.getType(), "BAN") && !Intrinsics.areEqual(punishment.getType(), "BANIP")) continue;
                    long endTime = punishment.getEnd();
                    long remainingTime = (endTime - System.currentTimeMillis()) / (long)1000;
                    String duration = endTime == -1L ? "permanent" : this.plugin.getTimeHandler().formatTime(String.valueOf(remainingTime));
                    String reason = punishment.getReason();
                    String string3 = punishment.getType();
                    if (Intrinsics.areEqual(string3, "BAN")) {
                        var18_17 = new Pair[]{TuplesKt.to("reason", reason), TuplesKt.to("time", duration)};
                        list = this.plugin.getMessageHandler().getComplexMessage("ban", "kick_message", MapsKt.mapOf(var18_17));
                    } else if (Intrinsics.areEqual(string3, "BANIP")) {
                        var18_17 = new Pair[]{TuplesKt.to("reason", reason), TuplesKt.to("time", duration)};
                        list = this.plugin.getMessageHandler().getComplexMessage("banip", "kick_message", MapsKt.mapOf(var18_17));
                    } else {
                        list = CollectionsKt.emptyList();
                    }
                    List kickMessages = list;
                    Intrinsics.checkNotNullExpressionValue(Component.text(), "text(...)");
                    Iterable $this$forEach$iv2 = kickMessages;
                    boolean $i$f$forEach2 = false;
                    for (Object element$iv2 : $this$forEach$iv2) {
                        Component line = (Component)element$iv2;
                        boolean bl2 = false;
                        kickMessage.append(line);
                        kickMessage.append((Component)Component.newline());
                    }
                    event.setLoginResult(AsyncPlayerPreLoginEvent.Result.KICK_BANNED);
                    event.kickMessage((Component)kickMessage.build());
                    this.plugin.getLogger().debug("Player " + event.getName() + " was kicked for: " + reason);
                    continue;
                }
                this.plugin.getDatabaseHandler().removePunishment(uuid, punishment.getType(), true);
                this.plugin.getLogger().debug("Punishment for UUID: " + uuid + " has expired and has been removed");
            }
        }
        catch (Exception e) {
            this.plugin.getLogger().severe("Error in onPlayerPreLogin, report it urgently to the plugin author with the message: " + event.getName() + ": " + e.getMessage());
            e.printStackTrace();
        }
    }

    @EventHandler(priority=EventPriority.HIGHEST, ignoreCancelled=true)
    public final void onPlayerChat(@NotNull AsyncChatEvent event) {
        Intrinsics.checkNotNullParameter(event, "event");
        Player player = event.getPlayer();
        Intrinsics.checkNotNullExpressionValue(player, "getPlayer(...)");
        Player player2 = player;
        String string = player2.getName();
        Intrinsics.checkNotNullExpressionValue(string, "getName(...)");
        String playerName = string;
        try {
            String string2 = this.plugin.getUuidManager().getUUID(playerName).toString();
            Intrinsics.checkNotNullExpressionValue(string2, "toString(...)");
            String uuid = string2;
            Component component = event.message();
            Intrinsics.checkNotNullExpressionValue(component, "message(...)");
            Component messageComponent = component;
            String string3 = PlainTextComponentSerializer.plainText().serialize(messageComponent);
            Intrinsics.checkNotNullExpressionValue(string3, "serialize(...)");
            String plainMessage = string3;
            List<PunishmentData> punishments = this.plugin.getDatabaseHandler().getPunishments(uuid);
            if (punishments.isEmpty()) {
                this.plugin.getLogger().debug("No punishments found for player: " + playerName);
                return;
            }
            for (PunishmentData punishment : punishments) {
                if ((Intrinsics.areEqual(punishment.getType(), "MUTE") || Intrinsics.areEqual(punishment.getType(), "JAIL")) && this.plugin.getPunishmentManager().isPunishmentActive(punishment)) {
                    event.setCancelled(true);
                    long endTime = punishment.getEnd();
                    String remainingTime = endTime == -1L ? "permanent" : this.plugin.getTimeHandler().formatTime(String.valueOf((endTime - System.currentTimeMillis()) / (long)1000));
                    String reason = punishment.getReason();
                    String messageKey = Intrinsics.areEqual(punishment.getType(), "JAIL") ? "jail" : "mute";
                    Pair[] pairArray = new Pair[]{TuplesKt.to("reason", reason), TuplesKt.to("time", remainingTime)};
                    String infoMessage = this.plugin.getMessageHandler().getMessage(messageKey, "mute_info_message", MapsKt.mapOf(pairArray));
                    Component component2 = MiniMessage.miniMessage().deserialize((Object)infoMessage);
                    Intrinsics.checkNotNullExpressionValue(component2, "deserialize(...)");
                    Component formattedMessage = component2;
                    Pair[] pairArray2 = new Pair[]{TuplesKt.to("player", playerName), TuplesKt.to("message", plainMessage)};
                    String logMessage = this.plugin.getMessageHandler().getLogMessage(messageKey, "log", MapsKt.mapOf(pairArray2));
                    Component component3 = MiniMessage.miniMessage().deserialize((Object)logMessage);
                    Intrinsics.checkNotNullExpressionValue(component3, "deserialize(...)");
                    Component logFormattedMessage = component3;
                    this.plugin.getLogger().clearLog(logFormattedMessage);
                    player2.sendMessage(formattedMessage);
                    return;
                }
                this.plugin.getDatabaseHandler().removePunishment(uuid, punishment.getType(), true);
                this.plugin.getLogger().debug("Punishment for UUID: " + uuid + " has expired and has been removed");
            }
        }
        catch (Exception e) {
            this.plugin.getLogger().severe("Error in onPlayerChat, report it urgently to the plugin author: " + e.getMessage());
            e.printStackTrace();
        }
    }

    @EventHandler(priority=EventPriority.HIGHEST, ignoreCancelled=true)
    public final void onPlayerCommand(@NotNull PlayerCommandPreprocessEvent event) {
        Intrinsics.checkNotNullParameter(event, "event");
        try {
            Player player = event.getPlayer();
            Intrinsics.checkNotNullExpressionValue(player, "getPlayer(...)");
            Player player2 = player;
            String string = player2.getUniqueId().toString();
            Intrinsics.checkNotNullExpressionValue(string, "toString(...)");
            String uuid = string;
            String string2 = event.getMessage();
            Intrinsics.checkNotNullExpressionValue(string2, "getMessage(...)");
            Object object = new String[]{" "};
            object = (String)StringsKt.split$default((CharSequence)string2, (String[])object, false, 0, 6, null).get(0);
            Locale locale = Locale.getDefault();
            Intrinsics.checkNotNullExpressionValue(locale, "getDefault(...)");
            String string3 = ((String)object).toLowerCase(locale);
            Intrinsics.checkNotNullExpressionValue(string3, "toLowerCase(...)");
            String command = StringsKt.removePrefix(string3, (CharSequence)"/");
            if (this.plugin.getConfig().getBoolean("mute_pm")) {
                List list = this.plugin.getConfig().getStringList("mute_cmd");
                Intrinsics.checkNotNullExpressionValue(list, "getStringList(...)");
                List muteCommands = list;
                if (muteCommands.contains(command)) {
                    List<PunishmentData> punishments = this.plugin.getDatabaseHandler().getPunishments(uuid);
                    Iterable $this$forEach$iv = punishments;
                    boolean $i$f$forEach = false;
                    for (Object element$iv : $this$forEach$iv) {
                        PunishmentData punishment = (PunishmentData)element$iv;
                        boolean bl = false;
                        if (Intrinsics.areEqual(punishment.getType(), "MUTE") && this.plugin.getPunishmentManager().isPunishmentActive(punishment)) {
                            Component formattedMessage;
                            long endTime = punishment.getEnd();
                            long remainingTime = (endTime - System.currentTimeMillis()) / (long)1000;
                            String duration = endTime == -1L ? "permanent" : this.plugin.getTimeHandler().formatTime(String.valueOf(remainingTime));
                            String reason = punishment.getReason();
                            event.setCancelled(true);
                            Pair[] pairArray = new Pair[]{TuplesKt.to("reason", reason), TuplesKt.to("time", duration)};
                            String muteMessage = this.plugin.getMessageHandler().getMessage("mute", "mute_message", MapsKt.mapOf(pairArray));
                            Intrinsics.checkNotNullExpressionValue(MiniMessage.miniMessage().deserialize((Object)muteMessage), "deserialize(...)");
                            player2.sendMessage(formattedMessage);
                            continue;
                        }
                        this.plugin.getDatabaseHandler().removePunishment(uuid, punishment.getType(), true);
                        this.plugin.getLogger().debug("Punishment for UUID: " + uuid + " has expired and has been removed");
                    }
                }
            }
        }
        catch (Exception e) {
            this.plugin.getLogger().severe("Error in onPlayerCommand, report it urgently to the plugin author with the message: " + event.getPlayer().getName() + ": " + e.getMessage());
            e.printStackTrace();
        }
    }
}

