/*
 * Decompiled with CFR 0.152.
 */
package pl.syntaxdevteam.punisher;

import io.papermc.paper.event.player.AsyncChatEvent;
import io.papermc.paper.plugin.configuration.PluginMeta;
import java.io.File;
import java.io.FileInputStream;
import java.util.List;
import java.util.Properties;
import java.util.UUID;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.entity.Player;
import org.bukkit.event.HandlerList;
import org.bukkit.event.Listener;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;
import org.jetbrains.annotations.NotNull;
import pl.syntaxdevteam.punisher.basic.PunishmentChecker;
import pl.syntaxdevteam.punisher.basic.PunishmentManager;
import pl.syntaxdevteam.punisher.basic.TimeHandler;
import pl.syntaxdevteam.punisher.commands.CommandManager;
import pl.syntaxdevteam.punisher.common.ConfigHandler;
import pl.syntaxdevteam.punisher.common.Logger;
import pl.syntaxdevteam.punisher.common.MessageHandler;
import pl.syntaxdevteam.punisher.common.PluginManager;
import pl.syntaxdevteam.punisher.common.StatsCollector;
import pl.syntaxdevteam.punisher.common.UUIDManager;
import pl.syntaxdevteam.punisher.common.UpdateChecker;
import pl.syntaxdevteam.punisher.databases.DatabaseHandler;
import pl.syntaxdevteam.punisher.databases.PunishmentData;
import pl.syntaxdevteam.punisher.players.GeoIPHandler;
import pl.syntaxdevteam.punisher.players.PlayerIPManager;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u00b0\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u00012\u00020\u0002B\u0007\u00a2\u0006\u0004\b\u0003\u0010\u0004J\b\u0010I\u001a\u00020JH\u0016J\u0006\u0010K\u001a\u00020JJ\b\u0010L\u001a\u00020JH\u0016J\b\u0010M\u001a\u00020JH\u0002J\b\u0010N\u001a\u00020JH\u0002J\b\u0010O\u001a\u00020JH\u0002J\b\u0010P\u001a\u00020JH\u0002J\b\u0010Q\u001a\u00020JH\u0002J\b\u0010R\u001a\u00020JH\u0002J\u0006\u0010S\u001a\u00020TJ\u0006\u0010U\u001a\u00020JJ\u0006\u0010V\u001a\u00020\u001bJ\u0014\u0010W\u001a\b\u0012\u0004\u0012\u00020Y0X2\u0006\u0010Z\u001a\u00020[R\u0016\u0010\u0005\u001a\u00070\u0006\u00a2\u0006\u0002\b\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u001b\u0010\n\u001a\u00020\u000b8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u000e\u0010\u000f\u001a\u0004\b\f\u0010\rR\u000e\u0010\u0010\u001a\u00020\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\u0013X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0014\u001a\u00020\u0015X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0016\u0010\u0017\"\u0004\b\u0018\u0010\u0019R\u0013\u0010\u001a\u001a\u00070\u001b\u00a2\u0006\u0002\b\u001cX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001d\u001a\u00020\u001eX\u0082.\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001f\u001a\u00020 X\u0082.\u00a2\u0006\u0002\n\u0000R\u001a\u0010!\u001a\u00020\"X\u0086.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b#\u0010$\"\u0004\b%\u0010&R\u001a\u0010'\u001a\u00020(X\u0086.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b)\u0010*\"\u0004\b+\u0010,R\u001a\u0010-\u001a\u00020.X\u0086.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b/\u00100\"\u0004\b1\u00102R\u001a\u00103\u001a\u000204X\u0086.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b5\u00106\"\u0004\b7\u00108R\u000e\u00109\u001a\u00020:X\u0082.\u00a2\u0006\u0002\n\u0000R\u000e\u0010;\u001a\u00020<X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001a\u0010=\u001a\u00020>X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b?\u0010@\"\u0004\bA\u0010BR\u0011\u0010C\u001a\u00020D\u00a2\u0006\b\n\u0000\u001a\u0004\bE\u0010FR\u000e\u0010G\u001a\u00020HX\u0082.\u00a2\u0006\u0002\n\u0000\u00a8\u0006\\"}, d2={"Lpl/syntaxdevteam/punisher/PunisherX;", "Lorg/bukkit/plugin/java/JavaPlugin;", "Lorg/bukkit/event/Listener;", "<init>", "()V", "pluginMetas", "Lio/papermc/paper/plugin/configuration/PluginMeta;", "Lorg/jetbrains/annotations/NotNull;", "getPluginMetas", "()Lio/papermc/paper/plugin/configuration/PluginMeta;", "configHandler", "Lpl/syntaxdevteam/punisher/common/ConfigHandler;", "getConfigHandler", "()Lpl/syntaxdevteam/punisher/common/ConfigHandler;", "configHandler$delegate", "Lkotlin/Lazy;", "config", "Lorg/bukkit/configuration/file/FileConfiguration;", "debugMode", "", "logger", "Lpl/syntaxdevteam/punisher/common/Logger;", "getLogger", "()Lpl/syntaxdevteam/punisher/common/Logger;", "setLogger", "(Lpl/syntaxdevteam/punisher/common/Logger;)V", "language", "", "Lorg/jetbrains/annotations/Nullable;", "pluginsManager", "Lpl/syntaxdevteam/punisher/common/PluginManager;", "statsCollector", "Lpl/syntaxdevteam/punisher/common/StatsCollector;", "databaseHandler", "Lpl/syntaxdevteam/punisher/databases/DatabaseHandler;", "getDatabaseHandler", "()Lpl/syntaxdevteam/punisher/databases/DatabaseHandler;", "setDatabaseHandler", "(Lpl/syntaxdevteam/punisher/databases/DatabaseHandler;)V", "messageHandler", "Lpl/syntaxdevteam/punisher/common/MessageHandler;", "getMessageHandler", "()Lpl/syntaxdevteam/punisher/common/MessageHandler;", "setMessageHandler", "(Lpl/syntaxdevteam/punisher/common/MessageHandler;)V", "timeHandler", "Lpl/syntaxdevteam/punisher/basic/TimeHandler;", "getTimeHandler", "()Lpl/syntaxdevteam/punisher/basic/TimeHandler;", "setTimeHandler", "(Lpl/syntaxdevteam/punisher/basic/TimeHandler;)V", "punishmentManager", "Lpl/syntaxdevteam/punisher/basic/PunishmentManager;", "getPunishmentManager", "()Lpl/syntaxdevteam/punisher/basic/PunishmentManager;", "setPunishmentManager", "(Lpl/syntaxdevteam/punisher/basic/PunishmentManager;)V", "updateChecker", "Lpl/syntaxdevteam/punisher/common/UpdateChecker;", "geoIPHandler", "Lpl/syntaxdevteam/punisher/players/GeoIPHandler;", "playerIPManager", "Lpl/syntaxdevteam/punisher/players/PlayerIPManager;", "getPlayerIPManager", "()Lpl/syntaxdevteam/punisher/players/PlayerIPManager;", "setPlayerIPManager", "(Lpl/syntaxdevteam/punisher/players/PlayerIPManager;)V", "uuidManager", "Lpl/syntaxdevteam/punisher/common/UUIDManager;", "getUuidManager", "()Lpl/syntaxdevteam/punisher/common/UUIDManager;", "commandManager", "Lpl/syntaxdevteam/punisher/commands/CommandManager;", "onEnable", "", "onReload", "onDisable", "setupConfig", "setupDatabase", "setupHandlers", "registerCommands", "registerEvents", "checkForUpdates", "getPluginFile", "Ljava/io/File;", "reloadMyConfig", "getServerName", "getPunishmentHistory", "", "Lpl/syntaxdevteam/punisher/databases/PunishmentData;", "player", "Lorg/bukkit/entity/Player;", "PunisherX"})
@SourceDebugExtension(value={"SMAP\nPunisherX.kt\nKotlin\n*S Kotlin\n*F\n+ 1 PunisherX.kt\npl/syntaxdevteam/punisher/PunisherX\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,132:1\n1#2:133\n*E\n"})
public final class PunisherX
extends JavaPlugin
implements Listener {
    @NotNull
    private final PluginMeta pluginMetas;
    @NotNull
    private final Lazy configHandler$delegate;
    @NotNull
    private final FileConfiguration config;
    private boolean debugMode;
    @NotNull
    private Logger logger;
    @NotNull
    private final String language;
    private PluginManager pluginsManager;
    private StatsCollector statsCollector;
    public DatabaseHandler databaseHandler;
    public MessageHandler messageHandler;
    public TimeHandler timeHandler;
    public PunishmentManager punishmentManager;
    private UpdateChecker updateChecker;
    @NotNull
    private GeoIPHandler geoIPHandler;
    @NotNull
    private PlayerIPManager playerIPManager;
    @NotNull
    private final UUIDManager uuidManager;
    private CommandManager commandManager;

    public PunisherX() {
        PluginMeta pluginMeta = this.getPluginMeta();
        Intrinsics.checkNotNullExpressionValue(pluginMeta, "getPluginMeta(...)");
        this.pluginMetas = pluginMeta;
        this.configHandler$delegate = LazyKt.lazy(() -> PunisherX.configHandler_delegate$lambda$0(this));
        this.config = this.getConfigHandler().getConfig();
        this.debugMode = this.config.getBoolean("debug");
        this.logger = new Logger(this.pluginMetas, this.debugMode);
        String string = this.config.getString("language");
        if (string == null) {
            string = "EN";
        }
        this.language = string;
        this.geoIPHandler = new GeoIPHandler(this);
        this.playerIPManager = new PlayerIPManager(this, this.geoIPHandler);
        this.uuidManager = new UUIDManager(this);
    }

    @NotNull
    public final PluginMeta getPluginMetas() {
        return this.pluginMetas;
    }

    private final ConfigHandler getConfigHandler() {
        Lazy lazy = this.configHandler$delegate;
        return (ConfigHandler)lazy.getValue();
    }

    @NotNull
    public final Logger getLogger() {
        return this.logger;
    }

    public final void setLogger(@NotNull Logger logger) {
        Intrinsics.checkNotNullParameter(logger, "<set-?>");
        this.logger = logger;
    }

    @NotNull
    public final DatabaseHandler getDatabaseHandler() {
        DatabaseHandler databaseHandler = this.databaseHandler;
        if (databaseHandler != null) {
            return databaseHandler;
        }
        Intrinsics.throwUninitializedPropertyAccessException("databaseHandler");
        return null;
    }

    public final void setDatabaseHandler(@NotNull DatabaseHandler databaseHandler) {
        Intrinsics.checkNotNullParameter(databaseHandler, "<set-?>");
        this.databaseHandler = databaseHandler;
    }

    @NotNull
    public final MessageHandler getMessageHandler() {
        MessageHandler messageHandler = this.messageHandler;
        if (messageHandler != null) {
            return messageHandler;
        }
        Intrinsics.throwUninitializedPropertyAccessException("messageHandler");
        return null;
    }

    public final void setMessageHandler(@NotNull MessageHandler messageHandler) {
        Intrinsics.checkNotNullParameter(messageHandler, "<set-?>");
        this.messageHandler = messageHandler;
    }

    @NotNull
    public final TimeHandler getTimeHandler() {
        TimeHandler timeHandler = this.timeHandler;
        if (timeHandler != null) {
            return timeHandler;
        }
        Intrinsics.throwUninitializedPropertyAccessException("timeHandler");
        return null;
    }

    public final void setTimeHandler(@NotNull TimeHandler timeHandler) {
        Intrinsics.checkNotNullParameter(timeHandler, "<set-?>");
        this.timeHandler = timeHandler;
    }

    @NotNull
    public final PunishmentManager getPunishmentManager() {
        PunishmentManager punishmentManager = this.punishmentManager;
        if (punishmentManager != null) {
            return punishmentManager;
        }
        Intrinsics.throwUninitializedPropertyAccessException("punishmentManager");
        return null;
    }

    public final void setPunishmentManager(@NotNull PunishmentManager punishmentManager) {
        Intrinsics.checkNotNullParameter(punishmentManager, "<set-?>");
        this.punishmentManager = punishmentManager;
    }

    @NotNull
    public final PlayerIPManager getPlayerIPManager() {
        return this.playerIPManager;
    }

    public final void setPlayerIPManager(@NotNull PlayerIPManager playerIPManager) {
        Intrinsics.checkNotNullParameter(playerIPManager, "<set-?>");
        this.playerIPManager = playerIPManager;
    }

    @NotNull
    public final UUIDManager getUuidManager() {
        return this.uuidManager;
    }

    public void onEnable() {
        this.setupConfig();
        this.setupDatabase();
        this.setupHandlers();
        this.registerEvents();
        this.registerCommands();
        this.checkForUpdates();
    }

    public final void onReload() {
        this.reloadMyConfig();
    }

    public void onDisable() {
        this.getDatabaseHandler().closeConnection();
        HandlerList handlerList = AsyncChatEvent.getHandlerList();
        Intrinsics.checkNotNull((Object)this, "null cannot be cast to non-null type org.bukkit.plugin.Plugin");
        handlerList.unregister((Plugin)this);
        this.logger.err(this.pluginMetas.getName() + " " + this.pluginMetas.getVersion() + " has been disabled \u2639\ufe0f");
    }

    private final void setupConfig() {
        this.getConfigHandler().updateConfig();
    }

    private final void setupDatabase() {
        this.setDatabaseHandler(new DatabaseHandler(this, this.config));
        this.getDatabaseHandler().openConnection();
        this.getDatabaseHandler().createTables();
    }

    /*
     * WARNING - void declaration
     */
    private final void setupHandlers() {
        void $this$setupHandlers_u24lambda_u241;
        MessageHandler messageHandler;
        MessageHandler messageHandler2 = messageHandler = new MessageHandler(this, this.pluginMetas);
        PunisherX punisherX = this;
        boolean bl = false;
        $this$setupHandlers_u24lambda_u241.initial();
        punisherX.setMessageHandler(messageHandler);
        this.setTimeHandler(new TimeHandler(this, this.pluginMetas));
        this.setPunishmentManager(new PunishmentManager());
        this.geoIPHandler = new GeoIPHandler(this);
        this.pluginsManager = new PluginManager(this);
    }

    private final void registerCommands() {
        this.commandManager = new CommandManager(this);
        CommandManager commandManager = this.commandManager;
        if (commandManager == null) {
            Intrinsics.throwUninitializedPropertyAccessException("commandManager");
            commandManager = null;
        }
        commandManager.registerCommands();
    }

    private final void registerEvents() {
        this.getServer().getPluginManager().registerEvents((Listener)this.playerIPManager, (Plugin)this);
        this.getServer().getPluginManager().registerEvents((Listener)new PunishmentChecker(this), (Plugin)this);
    }

    private final void checkForUpdates() {
        this.statsCollector = new StatsCollector(this);
        this.updateChecker = new UpdateChecker(this, this.pluginMetas, this.config);
        UpdateChecker updateChecker = this.updateChecker;
        if (updateChecker == null) {
            Intrinsics.throwUninitializedPropertyAccessException("updateChecker");
            updateChecker = null;
        }
        updateChecker.checkForUpdates();
    }

    @NotNull
    public final File getPluginFile() {
        File file = this.getFile();
        Intrinsics.checkNotNullExpressionValue(file, "getFile(...)");
        return file;
    }

    public final void reloadMyConfig() {
        this.getDatabaseHandler().closeConnection();
        try {
            this.getConfigHandler().reloadConfig();
            this.getMessageHandler().reloadMessages();
        }
        catch (Exception e) {
            this.logger.err(MessageHandler.getMessage$default(this.getMessageHandler(), "error", "reload", null, 4, null) + e.getMessage());
        }
        this.setDatabaseHandler(new DatabaseHandler(this, this.config));
        this.getDatabaseHandler().openConnection();
        this.getDatabaseHandler().createTables();
    }

    @NotNull
    public final String getServerName() {
        Properties properties = new Properties();
        File file = new File("server.properties");
        if (file.exists()) {
            properties.load(new FileInputStream(file));
            String serverName = properties.getProperty("server-name");
            if (serverName != null) {
                return serverName;
            }
            this.logger.debug("W\u0142a\u015bciwo\u015b\u0107 'server-name' nie zosta\u0142a znaleziona w pliku server.properties.");
        } else {
            this.logger.debug("Plik server.properties nie istnieje.");
        }
        return "Unknown Server";
    }

    @NotNull
    public final List<PunishmentData> getPunishmentHistory(@NotNull Player player) {
        Intrinsics.checkNotNullParameter(player, "player");
        String string = player.getName();
        Intrinsics.checkNotNullExpressionValue(string, "getName(...)");
        UUID uuid = this.uuidManager.getUUID(string);
        DatabaseHandler databaseHandler = this.getDatabaseHandler();
        String string2 = uuid.toString();
        Intrinsics.checkNotNullExpressionValue(string2, "toString(...)");
        return databaseHandler.getLastTenPunishments(string2);
    }

    private static final ConfigHandler configHandler_delegate$lambda$0(PunisherX this$0) {
        return new ConfigHandler(this$0);
    }
}

