/*
 * Decompiled with CFR 0.152.
 */
package pl.syntaxdevteam.gravediggerx.spirits;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.UUID;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.bukkit.Location;
import org.bukkit.NamespacedKey;
import org.bukkit.Particle;
import org.bukkit.World;
import org.bukkit.entity.Allay;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.persistence.PersistentDataType;
import org.bukkit.plugin.Plugin;
import org.bukkit.util.Vector;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import pl.syntaxdevteam.gravediggerx.GraveDiggerX;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\u0018\u0000 \u001e2\u00020\u0001:\u0001\u001eB\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\b\u0010\tJ\u0006\u0010\u001b\u001a\u00020\u001cJ\u0006\u0010\u001d\u001a\u00020\u001cR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u001c\u0010\u000e\u001a\u0004\u0018\u00010\u000fX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0010\u0010\u0011\"\u0004\b\u0012\u0010\u0013R\u001a\u0010\u0014\u001a\u00020\u0015X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0014\u0010\u0016\"\u0004\b\u0017\u0010\u0018R\u000e\u0010\u0019\u001a\u00020\u001aX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001f"}, d2={"Lpl/syntaxdevteam/gravediggerx/spirits/GhostSpirit;", "", "plugin", "Lpl/syntaxdevteam/gravediggerx/GraveDiggerX;", "graveOwnerId", "Ljava/util/UUID;", "graveLocation", "Lorg/bukkit/Location;", "<init>", "(Lpl/syntaxdevteam/gravediggerx/GraveDiggerX;Ljava/util/UUID;Lorg/bukkit/Location;)V", "getGraveOwnerId", "()Ljava/util/UUID;", "getGraveLocation", "()Lorg/bukkit/Location;", "entity", "Lorg/bukkit/entity/Entity;", "getEntity", "()Lorg/bukkit/entity/Entity;", "setEntity", "(Lorg/bukkit/entity/Entity;)V", "isAlive", "", "()Z", "setAlive", "(Z)V", "taskId", "", "spawn", "", "despawn", "Companion", "GraveDiggerX"})
@SourceDebugExtension(value={"SMAP\nGhostSpirit.kt\nKotlin\n*S Kotlin\n*F\n+ 1 GhostSpirit.kt\npl/syntaxdevteam/gravediggerx/spirits/GhostSpirit\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,96:1\n774#2:97\n865#2,2:98\n2423#2,14:100\n1#3:114\n*S KotlinDebug\n*F\n+ 1 GhostSpirit.kt\npl/syntaxdevteam/gravediggerx/spirits/GhostSpirit\n*L\n75#1:97\n75#1:98,2\n76#1:100,14\n*E\n"})
public final class GhostSpirit {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final GraveDiggerX plugin;
    @NotNull
    private final UUID graveOwnerId;
    @NotNull
    private final Location graveLocation;
    @Nullable
    private Entity entity;
    private boolean isAlive;
    private int taskId;
    @NotNull
    private static final NamespacedKey GHOST_KEY;

    public GhostSpirit(@NotNull GraveDiggerX plugin, @NotNull UUID graveOwnerId, @NotNull Location graveLocation) {
        Intrinsics.checkNotNullParameter((Object)plugin, "plugin");
        Intrinsics.checkNotNullParameter(graveOwnerId, "graveOwnerId");
        Intrinsics.checkNotNullParameter(graveLocation, "graveLocation");
        this.plugin = plugin;
        this.graveOwnerId = graveOwnerId;
        this.graveLocation = graveLocation;
        this.isAlive = true;
        this.taskId = -1;
    }

    @NotNull
    public final UUID getGraveOwnerId() {
        return this.graveOwnerId;
    }

    @NotNull
    public final Location getGraveLocation() {
        return this.graveLocation;
    }

    @Nullable
    public final Entity getEntity() {
        return this.entity;
    }

    public final void setEntity(@Nullable Entity entity) {
        this.entity = entity;
    }

    public final boolean isAlive() {
        return this.isAlive;
    }

    public final void setAlive(boolean bl) {
        this.isAlive = bl;
    }

    public final void spawn() {
        World world = this.graveLocation.getWorld();
        if (world == null) {
            return;
        }
        World world2 = world;
        Location exactLoc = new Location(world2, (double)this.graveLocation.getBlockX() + 0.5, (double)this.graveLocation.getBlockY() + 2.7, (double)this.graveLocation.getBlockZ() + 0.5);
        Entity entity = world2.spawn(exactLoc, Allay.class, arg_0 -> GhostSpirit.spawn$lambda$1(arg_0 -> GhostSpirit.spawn$lambda$0(this, arg_0), arg_0));
        Intrinsics.checkNotNullExpressionValue(entity, "spawn(...)");
        Allay ghost = (Allay)entity;
        this.entity = (Entity)ghost;
        this.taskId = this.plugin.getServer().getScheduler().scheduleSyncRepeatingTask((Plugin)this.plugin, () -> GhostSpirit.spawn$lambda$2(this), 1L, 1L);
    }

    public final void despawn() {
        block0: {
            Entity entity = this.entity;
            if (entity == null) break block0;
            entity.remove();
        }
    }

    private static final Unit spawn$lambda$0(GhostSpirit this$0, Allay allay) {
        allay.setInvulnerable(true);
        allay.setCollidable(false);
        allay.setGravity(false);
        allay.setAI(false);
        allay.setCanPickupItems(false);
        allay.setRemoveWhenFarAway(false);
        allay.getPersistentDataContainer().set(GHOST_KEY, PersistentDataType.STRING, (Object)this$0.graveOwnerId.toString());
        allay.setVelocity(new Vector(0, 0, 0));
        return Unit.INSTANCE;
    }

    private static final void spawn$lambda$1(Function1 $tmp0, Object p0) {
        $tmp0.invoke(p0);
    }

    /*
     * WARNING - void declaration
     */
    private static final void spawn$lambda$2(GhostSpirit this$0) {
        Object v7;
        void $this$minByOrNull$iv;
        void $this$filterTo$iv$iv;
        Iterable $this$filter$iv;
        block13: {
            block12: {
                if (!this$0.isAlive || this$0.entity == null) break block12;
                Entity entity = this$0.entity;
                Intrinsics.checkNotNull(entity);
                if (!entity.isDead()) break block13;
            }
            if (this$0.taskId >= 0) {
                this$0.plugin.getServer().getScheduler().cancelTask(this$0.taskId);
                this$0.taskId = -1;
            }
            return;
        }
        Entity entity = this$0.entity;
        Intrinsics.checkNotNull(entity);
        World world = entity.getWorld();
        Intrinsics.checkNotNullExpressionValue(world, "getWorld(...)");
        World w = world;
        Location strictLoc = new Location(w, (double)this$0.graveLocation.getBlockX() + 0.5, (double)this$0.graveLocation.getBlockY() + 2.7, (double)this$0.graveLocation.getBlockZ() + 0.5);
        Entity entity2 = this$0.entity;
        Intrinsics.checkNotNull(entity2);
        entity2.setVelocity(new Vector(0, 0, 0));
        Entity entity3 = this$0.entity;
        Intrinsics.checkNotNull(entity3);
        entity3.teleport(strictLoc);
        w.spawnParticle(Particle.SOUL, strictLoc, 2, 0.2, 0.2, 0.2, 0.05);
        Object object = this$0.entity;
        Allay allay = object instanceof Allay ? (Allay)object : null;
        if (allay == null) {
            return;
        }
        Allay allay2 = allay;
        List list = w.getPlayers();
        Intrinsics.checkNotNullExpressionValue(list, "getPlayers(...)");
        object = list;
        boolean $i$f$filter = false;
        void var7_7 = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            Player it = (Player)element$iv$iv;
            boolean bl = false;
            if (!Intrinsics.areEqual(it.getWorld(), w)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        $this$filter$iv = (List)destination$iv$iv;
        boolean $i$f$minByOrNull2 = false;
        Iterator iterator$iv = $this$minByOrNull$iv.iterator();
        if (!iterator$iv.hasNext()) {
            v7 = null;
        } else {
            Object minElem$iv = iterator$iv.next();
            if (!iterator$iv.hasNext()) {
                v7 = minElem$iv;
            } else {
                Player it = (Player)minElem$iv;
                boolean bl = false;
                double minValue$iv = it.getLocation().distance(strictLoc);
                do {
                    Object e$iv = iterator$iv.next();
                    Player it2 = (Player)e$iv;
                    $i$a$-minByOrNull-GhostSpirit$spawn$1$closestPlayer$2 = false;
                    double v$iv = it2.getLocation().distance(strictLoc);
                    if (Double.compare(minValue$iv, v$iv) <= 0) continue;
                    minElem$iv = e$iv;
                    minValue$iv = v$iv;
                } while (iterator$iv.hasNext());
                v7 = minElem$iv;
            }
        }
        Player closestPlayer = v7;
        if (closestPlayer != null && strictLoc.distance(closestPlayer.getLocation()) < 50.0) {
            Location location;
            Vector $i$f$minByOrNull2 = closestPlayer.getEyeLocation().clone().subtract(strictLoc).toVector().normalize();
            Intrinsics.checkNotNullExpressionValue($i$f$minByOrNull2, "normalize(...)");
            Vector direction = $i$f$minByOrNull2;
            Location $this$spawn_u24lambda_u242_u242 = location = strictLoc.clone();
            boolean bl = false;
            $this$spawn_u24lambda_u242_u242.setDirection(direction);
            Location location2 = location;
            Intrinsics.checkNotNullExpressionValue(location2, "apply(...)");
            Location lookLoc = location2;
            allay2.teleport(lookLoc);
        }
    }

    static {
        NamespacedKey namespacedKey = NamespacedKey.fromString((String)"grave_ghost");
        Intrinsics.checkNotNull(namespacedKey);
        GHOST_KEY = namespacedKey;
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\b"}, d2={"Lpl/syntaxdevteam/gravediggerx/spirits/GhostSpirit$Companion;", "", "<init>", "()V", "GHOST_KEY", "Lorg/bukkit/NamespacedKey;", "getGHOST_KEY", "()Lorg/bukkit/NamespacedKey;", "GraveDiggerX"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final NamespacedKey getGHOST_KEY() {
            return GHOST_KEY;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

